    DEFINT A-Z
    DECLARE FUNCTION BackInstr% (Start%, searchString$, subString$)
    DECLARE SUB Copyright ()
    DECLARE SUB DisplayReport ()
    DECLARE SUB Editor (Ed$, ActiveLenght%, ScanCode%, NumOnly%, CapsOn%, NormalColor%, EditColor%, Row%, Column%)
    DECLARE FUNCTION ErrorCode$ (Code%)
    DECLARE FUNCTION Exist% (filename$)
    DECLARE SUB ErrorMessage (message$)
    DECLARE FUNCTION ExeName$
    DECLARE FUNCTION FindLast% (BYVAL Address, Size)
    DECLARE SUB Help ()
    DECLARE SUB InputLine (IOCHAN%, BUFSIZE%, STATUS%, TEXT$)
    DECLARE FUNCTION ItsMail% (Work$)
    DECLARE SUB LocRowCol (X%, Y%)
    DECLARE FUNCTION LineCount% (filename$, BUFFER$)
    DECLARE SUB ParseLine (X$, sep$, a$())
    DECLARE SUB ParseWord (a$, sep$, word$)
    DECLARE FUNCTION ParseString$ (CurPos%, Work$, Delimit$)
    DECLARE SUB PrtCtrDisp (PrtRec%)
    DECLARE FUNCTION QInstrB (Start%, Source$, Search$)
    DECLARE SUB ReportTPLs (TPL%, Fhandle%)
    DECLARE SUB ScrnRest (ULRow%, ULCol%, LRRow%, LRCol%, SEG Element%, Page%)
    DECLARE SUB ScrnSave (ULRow%, ULCol%, LRRow%, LRCol%, SEG Element%, Page%)
    DECLARE SUB SetLevel (ErrVal%)
    DECLARE SUB YesNo (YN$, Prompt$, ScanCode, NormalColr, EditColr, Row, Column)
  
  'Front Door 2.01 Log Analyzer program FDLA
  'Copyright by RJ Ross 1991
  'Requires Quick Pack Pro Library
  'Program Started September 8th, 1991
  'Beta Ver .001 released 21 Oct 91
  'Version 1.00 released 11 Dec 91
  'Version 1.01b beta 29 Nov 92 - increased print positions in CallsOut column Pt 1
  '                             - modified parsing to Calling record to parse forward
  'Version 1.01c beta    Jul 93 - added 16,800 & 14,400 BBS caller stats
  'Version 1.01d beta           - changed BBS caller stats var from integer to
  '                             - long to prevent lockup.
  '                             - corrected BBS caller totals to include BBS14 and
  '                             - BBS16 connects.

  '******************
  'Some declarations
  '******************
  
    COMMON SHARED CR$, LF$, CRLF$
    CONST FDLAVersion$ = "1.01e" 'current version number
    CONST Copyright1$ = "Front Door Log Analyzer - FDLA Version "
    CONST Copyright2$ = "Copyright 1991 by RJ (Bob) Ross - ALL RIGHTS RESERVED"
    CONST Copyright3$ = "SysOp - RJ's Byteline BBS - FidoNet 1:134/75"
  
    CONST False = 0
    CONST True = NOT False
    CONST Comma = ","
  
    SysName$ = "P^Not Defined@^&^&^&^&^&^&^&^&^&^&^&^&^&^&^&"
  
  'For debugging
  ' SysName$ = "P^RJ's Byteline BBS@^&^&^&^&^&^&^&^&^&^&^&^&"

    CR$ = CHR$(13)
    LF$ = CHR$(10)
    CRLF$ = CR$ + LF$
  
    REDIM SHARED Scrn%(2000)
    CALL ScrnSave(1, 1, 25, 80, SEG Scrn%(1), -1)
  
    LogFile$ = "FD.LOG"
    Ctr% = 0
  
    DIM SHARED HighAscii%
    DIM ExcludNet$(11)
    DIM ExcludFiles$(11)
    HighAscii% = True
    DispRpt% = False
  
    RptPtI% = False
    RptPtII% = False
    RptPtIII% = False
    RptPtIV% = False
    RptPtV% = False
    SortFlag% = False
    DelTempFiles% = True
    ExFil% = False
    ExNet% = False
    ChopFile% = False
    ChopNet% = False
    NoResponse% = False
    MkDataFile% = False
    SysName% = False
  
    DIM ParsWrd$(1 TO 10)
    DIM CallingNode$(1 TO 2)     'to parse calling node number  1.01b
  
    IF HighAscii% THEN
        Bar$ = ""
    ELSE
        Bar$ = "|"
    END IF
  
  '********************
  ' Global error trap
  '********************
  
   ON ERROR GOTO ErrHandler
  
  '**********************
  'Command line switches
  '**********************
  
  'Add System Name to the Exe file
    IF INSTR(COMMAND$, "-SN") THEN
        CALL Copyright
        PRINT STRING$(80, "")
        EditColor% = 112
        NormColor% = 112
        CALL LocRowCol(6, 1)
        Temp1$ = SPACE$(40)
        PRINT "This option will allow you to configure FDLA.EXE to automatically place"
        PRINT "the name of your BBS system at the top of FDLA output report."
        PRINT
        PRINT "You may press Esc to abort this function, if desired, and return to DOS."
        DO
            CALL LocRowCol(11, 1)
            PRINT "Your System Name: ";
            Editor Temp1$, Length%, ScanCode%, 0, 0, NormColor%, EditColor%, 11, 18
            IF ScanCode% = 27 THEN
                CALL LocRowCol(14, 1)
                PRINT "Aborted - System Name not changed."
                END
            END IF
            Msg$ = "OK?  "
            YN$ = "N"
            YesNo YN$, Msg$, ScanCode%, 7, EditColor%, 12, 1
            IF ScanCode% = 27 THEN
                CALL LocRowCol(14, 1)
                PRINT "Aborted - System Name not changed."
                END
            END IF
        LOOP UNTIL UCASE$(YN$) = "Y"
      
        IF UCASE$(YN$) = "Y" THEN
            Temp1$ = LTRIM$(RTRIM$(Temp1$))
            Temp1$ = Temp1$ + "@"
            LookingFor$ = "P^"
            filename$ = ExeName$
          ' filename$ = "FDLA.EXE"    'to run in the QB Environment
            FilePointer& = 1
            OurHandle% = FREEFILE
            OPEN filename$ FOR BINARY AS #OurHandle%
            DO WHILE NOT EOF(OurHandle%)
                SEEK OurHandle%, FilePointer&
                a$ = INPUT$(4096, OurHandle%)
                Result% = INSTR(a$, LookingFor$)
                IF Result% THEN
                    FilePos& = (SEEK(OurHandle%)) - ((LEN(a$) - Result% + 1))
                    EXIT DO
                END IF
                FilePointer& = SEEK(OurHandle%) - LEN(LookingFor$)
            LOOP
            IF Result% THEN
                FilePos& = (SEEK(OurHandle%)) - ((LEN(a$) - Result% + 1))
                PUT OurHandle%, FilePos& + 2, Temp1$
                CALL LocRowCol(14, 1)
                PRINT "Update completed "; filename$; " modified."
                END
            ELSE
                CALL LocRowCol(14, 1)
                PRINT "Failed to update "; filename$
                END
            END IF
        END IF
    END IF
  'Help Screen
    IF INSTR(COMMAND$, "-H") THEN
        CALL Copyright
        CALL Help
        END
    END IF
  
  'List the last created report FDLARpt.txt file
    IF INSTR(COMMAND$, "-LL") THEN
      'IF FnFileExist%("FDLARpt.Txt") THEN
        IF Exist%("FDLARpt.Txt") THEN
            CALL DisplayReport
            CALL ScrnRest(1, 1, 25, 80, SEG Scrn%(1), -1)
            END
        ELSE
            BEEP
            DOSError$ = ErrorCode$(53)
            CALL ErrorMessage(DOSError$)
            CALL LocRowCol(15, 24)
            PRINT "Unable to locate file FDLARPT.TXT"
            CALL SetLevel(1)
            END
        END IF
    END IF
  
  'Make FDLARpt.Dat (Data file of Part I)
    IF INSTR(COMMAND$, "-D") THEN
        MkDataFile% = True
    END IF
  
  'List FDLARpt.txt after created
    IF INSTR(COMMAND$, "-L") THEN DispRpt% = True
  
  'Use a different Log file (default FD.Log in current dir)
    P% = INSTR(COMMAND$, "LOG=")
    IF P% THEN
        Temp$ = MID$(COMMAND$, P% + 4)
        P% = INSTR(Temp$, " ")
        IF P% THEN Temp$ = LEFT$(Temp$, P% - 1)
        LogFile$ = Temp$
    END IF

  'Exclude a net/nets, etc from FDLARpt.txt       -  -EXN
  '------------------------------------------------------
    P% = INSTR(COMMAND$, "-EXN")
    IF P% THEN
        AXNets$ = MID$(COMMAND$, P%)
        P% = INSTR(AXNets$, " ")
        Posn% = 5
        IF P% THEN AXNets$ = LEFT$(AXNets$, P% - 1)
        DO
            ExcludNet$(Ex%) = ParseString$(Posn%, AXNets$, ",")
            Ex% = Ex% + 1
        LOOP UNTIL Posn% = LEN(AXNets$) OR Ex% = 11
        Last% = FindLast%(BYVAL VARPTR(ExcludNet$(11)), 11)
        IF Last% THEN
            ExNet% = True
        END IF
    END IF

  'Suppress files in Part II          -SUP
  '----------------------------------------
    P% = INSTR(COMMAND$, "-SUP")
    IF P% THEN
        AXFiles$ = MID$(COMMAND$, P%)
        P% = INSTR(AXFiles$, " ")
        Posn% = 5
        IF P% THEN AXFiles$ = LEFT$(AXFiles$, P% - 1)
        DO
            ExcludFiles$(ExF%) = ParseString$(Posn%, AXFiles$, ",")
            ExF% = ExF% + 1
        LOOP UNTIL Posn% = LEN(AXFiles$) OR ExF% = 11
        LastF% = FindLast%(BYVAL VARPTR(ExcludFiles$(11)), 11)
        IF LastF% THEN
            ExFil% = True
        END IF
    END IF

  'Don't use High Ascii characters in FDLARpt.Txt
    IF INSTR(COMMAND$, "-NHA") THEN
        HighAscii% = False
    END IF
  
  'Don't erase the Temp work files (.$$$, .$$S)
    IF INSTR(COMMAND$, "-KTF") THEN
        DelTempFiles% = False
    END IF
  
  
    IF HighAscii% THEN
        Bar$ = ""
    ELSE
        Bar$ = "|"
    END IF
  
  'Record definition for the Work Files
  
    DIM MNode1 AS STRING * 15
    DIM MCallsOut1 AS INTEGER
    DIM MConnect1 AS INTEGER
    DIM MCallsIn1 AS INTEGER
    DIM MByteOut1 AS LONG
    DIM MByteIn1 AS LONG
    DIM MTimeOut1 AS INTEGER
    DIM MTimeIn1 AS INTEGER
  
    DIM MNode2 AS STRING * 15
    DIM MCallsOut2 AS INTEGER
    DIM MConnect2 AS INTEGER
    DIM MCallsIn2 AS INTEGER
    DIM MByteout2 AS LONG
    DIM MByteIn2 AS LONG
    DIM MTimeOut2 AS INTEGER
    DIM MTimeIn2 AS INTEGER
  
    TYPE FileRec
        FileNm AS STRING * 12
        FileByteOut AS LONG
        FileByteIn AS LONG
        FileCPS AS INTEGER
    END TYPE
    DIM FileRecE AS FileRec
  
    GOSUB InitMRecE
    GOSUB InitFileRecE
    CALL Copyright
  
  'Open the FD.LOG for read access
  
    IF NOT Exist%(LogFile$) THEN
        BEEP
        DOSError$ = ErrorCode$(53)
        CALL ErrorMessage(DOSError$)
        CALL LocRowCol(15, 24)
        PRINT "Unable to locate file "; LogFile$
        CALL SetLevel(1)
        END
    END IF
  
    FDLF% = FREEFILE
    OPEN LogFile$ FOR INPUT AS FDLF%
  
  'Get the start time and date from the logfile
  
    DO UNTIL EOF(FDLF%)
        LINE INPUT #FDLF%, Record$
        IF INSTR(1, Record$, "---") THEN
            IF INSTR(28, Record$, "FD") THEN
              'Start Day & Date
                BeginFd$ = MID$(Record$, 13, 13)
                LINE INPUT #FDLF%, Record$
              'Start Time
                Temp$ = MID$(Record$, 3, 8)
                BeginFd$ = BeginFd$ + " " + Temp$
                EXIT DO
            END IF
          ' IF INSTR(13, Record$, ",") THEN
            IF MID$(Record$, 13, 1) = "," THEN
                P% = INSTR(13, RRECORD$, ",")
                BeginFd$ = MID$(Record$, 13, P% - 1)
                LINE INPUT #FDLF%, Record$
              'Start Time
                Temp$ = MID$(Record$, 3, 8)
                BeginFd$ = BeginFd$ + " " + Temp$
                EXIT DO
            END IF
                BeginFd$ = MID$(Record$, 13)
                LINE INPUT #FDLF%, Record$
              'Start Time
                Temp$ = MID$(Record$, 3, 8)
                BeginFd$ = BeginFd$ + " " + Temp$
                EXIT DO
        END IF
    LOOP
    IF EOF(FDLF%) THEN BeginFd$ = "NO START TIME"
    CLOSE FDLF%

  'Open LogFile$ to read in Binary mode

    CHAN = FREEFILE
    OPEN LogFile$ FOR BINARY AS #CHAN
    MAXSIZE = 4 * 1024
    FILESTAT = 1
  
  '***********************************************
  'Make the Mail temp files ready to receive data
  '***********************************************
  
    MTmp% = FREEFILE
    OPEN "FDLATmp.$$$" FOR OUTPUT AS MTmp%      'Message Transfers & Calls
    FTmp% = FREEFILE
    OPEN "FDLATmpF.$$$" FOR OUTPUT AS FTmp%     'File Transfers & Calls
    UTmp% = FREEFILE
    OPEN "FDLATmpU.$$$" FOR OUTPUT AS UTmp%     'Undialable Nodes
    CTmp% = FREEFILE
    OPEN "FDLATmpC.$$$" FOR OUTPUT AS CTmp%     'Session cost
  
  'Write heading for the Session cost temp file
  
    CALL ReportTPLs(5, CTmp%)
  
  '*************************************
  '  Mail Loop to Create the data files
  '*************************************
  
    WHILE NOT FILESTAT = -1
       DO UNTIL FILESTAT = -1
          'End of LogFile
            PrevRecord$ = Record$
            IF FILESTAT = -1 THEN
               CLOSE #CHAN
               EXIT DO
               ELSE
                  CALL InputLine(CHAN%, MAXSIZE%, FILESTAT%, Record$)
            END IF
            IF INSTR(1, Record$, "+") THEN
                HoldRecord$ = Record$
                EndTime$ = MID$(Record$, 3, 8)
            END IF

            Ctr% = Ctr% + 1
            CALL LocRowCol(12, 15)
            PRINT "Scanning "; LogFile$; " :"; Ctr%
            IF INSTR(1, Record$, "---") THEN
               IF INSTR(28, Record$, "FD") THEN
                  'End Day & Date
                    EndFd$ = MID$(Record$, 13, 13)
               ELSE
                    EndFd$ = MID$(Record$, 13, 13)
                    IF RIGHT$(EndFd$, 1) = "," THEN
                        EndFd$ = LEFT$(EndFd$, 12)
                    END IF
               END IF
            IF FILESTAT = -1 THEN
               CLOSE #CHAN
               EXIT DO
               ELSE
                  CALL InputLine(CHAN%, MAXSIZE%, FILESTAT%, Record$)
            END IF
                    Ctr% = Ctr% + 1
                    CALL LocRowCol(12, 15)
                    PRINT "Scanning "; LogFile$; " :"; Ctr%
                END IF

          'Insufficient disk space
          '-----------------------
            IF INSTR(13, Record$, "Insufficient disk space for") THEN
                EXIT DO
            END IF

          'Undialable node
          '---------------
            IF INSTR(13, Record$, "Undialable node") THEN
                subString$ = " "
                P% = BackInstr%(0, Record$, subString$)
                IF P% THEN
                    MNode1 = LTRIM$(MID$(Record$, P% + 1))
                    GOSUB WriteUTmpRec
                    GOSUB InitMRecE
                    EXIT DO
                END IF
            END IF
          
          'Session Cost calls
          '------------------
            IF INSTR(1, Record$, "$") THEN
                IF INSTR(13, Record$, "To") THEN
                    subString$ = " "
                    P% = BackInstr%(0, Record$, subString$)
                    IF P% THEN
                        Cost& = VAL(MID$(Record$, P%))
                        IF Cost& THEN
                           'to fix a bug in FD.log where cost is entered
                           'as 32768.
                            IF Cost& > 30000 THEN EXIT DO
                            AtTime$ = RTRIM$(MID$(Record$, 3, 10))
                            Temp$ = MID$(Record$, 15)
                            P% = INSTR(Temp$, ",")
                            IF P% THEN
                                MNode1 = LTRIM$(LEFT$(Temp$, P% - 1))
                                IF ExNet% THEN
                                   FOR X% = 1 TO Last%
                                       IF INSTR(MNode1, ExcludNet$(X%)) THEN
                                           ChopNet% = True
                                           EXIT FOR
                                       END IF
                                   NEXT
                                 END IF
                                 IF ChopNet% THEN
                                    ChopNet% = False
                                    EXIT DO
                                 END IF
                                RptPtIII% = True
                                P% = INSTR(Temp$, ",")
                                IF P% THEN SessTime$ = MID$(Temp$, P% + 1)
                                P% = INSTR(SessTime$, ",")
                                IF P% THEN SessTime$ = LTRIM$(MID$(SessTime$, 1, P% - 1))
                              'so now we have: MNode1     (Node number)
                              '              : EndFD$            (date)
                              '              : AtTime$           (Logged at - time)
                              '              : SessTime$         (Session time)
                              '              : Cost%             (Session cost)
                                RptPtIII% = True
                                sep$ = " "
                                ParseLine EndFd$, sep$, ParsWrd$()
                                LoggedDate$ = ParsWrd$(2) + " " + ParsWrd$(3) + " " + ParsWrd$(4)
                                sep$ = ":"
                                ParseLine SessTime$, sep$, ParsWrd$()
                                SessMin% = VAL(ParsWrd$(1))
                                SessSec% = VAL(ParsWrd$(2))
                                Cost! = Cost& / 100
                                PRINT #CTmp%, Bar$; MNode1; TAB(17); LoggedDate$;
                                PRINT #CTmp%, TAB(28); AtTime$; '
                                PRINT #CTmp%, TAB(43);
                                PRINT #CTmp%, USING "##"; SessHrs%;
                                PRINT #CTmp%, TAB(49);
                                PRINT #CTmp%, USING "####"; SessMin%;
                                PRINT #CTmp%, TAB(57);
                                PRINT #CTmp%, USING "##"; SessSec%;
                                PRINT #CTmp%, TAB(66);
                                PRINT #CTmp%, USING "$####.##"; Cost!;
                                PRINT #CTmp%, TAB(76); Bar$
                                TotSessCost! = TotSessCost! + Cost!
                                GOSUB InitMRecE
                                EXIT DO
                            END IF
                        END IF
                    END IF
                END IF
            END IF
          
          'RING
          '****
            IF INSTR(13, Record$, "RING") THEN
                IF NoResponse% THEN
                    WroteMRec% = True
                    GOSUB WriteMTmpRec
                    GOSUB InitMRecE
                    NoResponse% = False
                    EXIT DO
                END IF
                IF INSTR(13, PrevRecord$, "Calling") THEN
                  'There must have been a call collision
                    WroteMRec% = True
                    GOSUB WriteMTmpRec
                    GOSUB InitMRecE
                    EXIT DO
                END IF
            END IF
          
          'BUSY
          '****
            IF INSTR(13, Record$, "BUSY") THEN
                MConnect1 = 0
                WroteMRec% = True
                GOSUB WriteMTmpRec
                GOSUB InitMRecE
                EXIT DO
            END IF
          
          'NO DIAL
          '*******
            IF INSTR(13, Record$, "NO DIAL") THEN
                IF OutgoingCall% THEN
                    MConnect1 = 0
                    WroteMRec% = True
                    GOSUB WriteMTmpRec
                    GOSUB InitMRecE
                    EXIT DO
                END IF
            END IF
          
         'NO CARRIER
          '**********
            IF INSTR(13, Record$, "NO CARRIER") THEN
                IF OutgoingCall% THEN
                    MConnect1 = 0
                    WroteMRec% = True
                    GOSUB WriteMTmpRec
                    GOSUB InitMRecE
                    EXIT DO
                END IF
            END IF
          
          'Using: Fido
          '-----------
            IF INSTR(13, Record$, "Using: Fido") AND NOT OutgoingCall% THEN
                subString$ = ","
                P% = BackInstr%(0, HoldRecord$, subString$)
                IF P% THEN
                    MNode1 = LTRIM$(MID$(HoldRecord$, P% + 1))
                    MConnect1 = 1
                    MCallsIn1 = 1
                END IF
            END IF
          
          'Outgoing Mail
          '-------------
            IF INSTR(13, Record$, "Sent") THEN
                IF ItsMail%(Record$) THEN
                    subString$ = ";"
                    P% = BackInstr%(0, Record$, subString$)
                    IF P% THEN
                        ByteOut& = VAL(MID$(Record$, P% + 1))
                        MByteOut1 = MByteOut1 + ByteOut&
                        subString$ = Comma
                        P% = BackInstr%(0, Record$, subString$)
                        OutCPS% = VAL(MID$(Record$, P% + 1))
                        IF OutCPS% THEN
                            TimeOut& = ByteOut& / OutCPS%
                            MTimeOut1 = MTimeOut1 + TimeOut&
                        ELSE
                            MTimeOut1 = 0
                        END IF
                    END IF
                ELSE
                    subString$ = "\"
                    P% = BackInstr%(0, Record$, subString$)
                    IF P% THEN
                        Temp$ = MID$(Record$, P% + 1)
                        IF RIGHT$(Temp$, 4) = ".REQ" THEN
                           FileRecE.FileNm = Temp$
                        END IF
                        subString$ = ","
                        P% = BackInstr%(0, Temp$, subString$)
                        IF P% THEN
                            FileRecE.FileCPS = VAL(MID$(Temp$, P% + 1))
                        ELSE
                            FileRecE.FileCPS = 0
                        END IF
                        subString$ = ";"
                        P% = BackInstr%(0, Temp$, subString$)
                        IF P% THEN
                            FileRecE.FileByteOut = VAL(MID$(Temp$, P% + 1))
                            FileRecE.FileNm = LEFT$(Temp$, P% - 1)
                        ELSE
                            FileRecE.FileByteOut = 0
                        END IF
                        GOSUB WriteFTmpRec
                        GOSUB InitFileRecE
                        EXIT DO
                    END IF
                END IF
            END IF
          
          ' Calling(outgoing call)
          '-----------------------
            IF INSTR(13, Record$, "Calling") THEN
                IF NoResponse% = True THEN
                    WroteMRec% = True
                    GOSUB WriteMTmpRec
                    GOSUB InitMRecE
                    NoResponse% = False
                END IF
                OutgoingCall% = True
                MCallsOut1 = 1
              ' subString$ = Comma
                CallingNode$(2) = ""                         '1.01b
                sep$ = ","                                   '1.01b
                ParseLine Record$, sep$, CallingNode$()      '1.01b
                MNode1 = LTRIM$(CallingNode$(2))             '1.01b
              ' P% = BackInstr%(0, Record$, subString$)
              ' IF P% THEN
              '     Temp$ = LEFT$(Record$, P% - 1)
              '     P% = BackInstr%(0, Temp$, subString$)
              '     MNode1 = LTRIM$(MID$(Temp$, P% + 1))
              ' END IF
            END IF
          
          'Incoming mail
          '-------------
            IF INSTR(13, Record$, "Rcvd") THEN
                IF ItsMail%(Record$) THEN
                    subString$ = ";"
                    P% = BackInstr%(0, Record$, subString$)
                    IF P% THEN
                        ByteIn& = VAL(MID$(Record$, P% + 1))
                        MByteIn1 = MByteIn1 + ByteIn&
                        subString$ = Comma
                        P% = BackInstr%(0, Record$, subString$)
                        InCPS% = VAL(MID$(Record$, P% + 1))
                        IF InCPS% THEN
                            TimeIn& = ByteIn& / InCPS%
                            MTimeIn1 = MTimeIn1 + TimeIn&
                        ELSE
                            MTimeIn1 = 0
                        END IF
                    END IF
                'incomplete
                '----------
                ELSEIF INSTR(Record$, "(incomplete)") THEN
                   FileRecE.FileCPS = 0
                   FileRecE.FileByteIn = 0
                   subString$ = "\"
                   P% = BackInstr%(0, Record$, subString$)
                   Temp$ = MID$(Record$, P% + 1)
                   P% = INSTR(Temp$, ",")
                   IF P% THEN
                       FileRecE.FileNm = LEFT$(Temp$, P% - 1)
                        GOSUB WriteFTmpRec
                        GOSUB InitFileRecE
                   END IF
                ELSE
                    subString$ = "\"
                    P% = BackInstr%(0, Record$, subString$)
                    IF P% THEN
                        Temp$ = MID$(Record$, P% + 1)
                        subString$ = ","
                        P% = BackInstr%(0, Temp$, subString$)
                        FileRecE.FileCPS = VAL(MID$(Temp$, P% + 1))
                        subString$ = ";"
                        P% = BackInstr%(0, Temp$, subString$)
                        FileRecE.FileByteIn = VAL(MID$(Temp$, P% + 1))
                        FileRecE.FileNm = LEFT$(Temp$, P% - 1)
                        GOSUB WriteFTmpRec
                        GOSUB InitFileRecE
                    END IF
                END IF
            END IF
          
          'Mail transfer completed
          '-----------------------
            IF INSTR(13, Record$, "Mail transfer completed") THEN
                IF INSTR(MNode1, "Unknown") THEN
            IF FILESTAT = -1 THEN
               CLOSE #CHAN
               EXIT DO
               ELSE
                  CALL InputLine(CHAN%, MAXSIZE%, FILESTAT%, Record$)
            END IF
                    IF INSTR(13, Record$, "To") OR INSTR(13, Record$, "From") THEN
                        Temp$ = MID$(Record$, 13)
                        P% = INSTR(Temp$, ",")
                        IF P% THEN
                            Temp$ = LEFT$(Temp$, P% - 1)
                            P% = INSTR(Temp$, " ")
                            MNode1 = MID$(Temp$, P% + 1)
                        END IF
                    END IF
                END IF
                WroteMRec% = True
                GOSUB WriteMTmpRec
                GOSUB InitMRecE
            END IF
          
          'Unable to complete mail transfer
          '--------------------------------
            IF INSTR(13, Record$, "Unable to complete mail transfer") THEN
                WroteMRec% = True
                GOSUB WriteMTmpRec
                GOSUB InitMRecE
            END IF

          'Mail received (An exception if "Mail transfer completed" not in log)
          '--------------------------------------------------------------------
            IF INSTR(13, Record$, "Mail received,") THEN
                IF NOT WroteMRec% THEN
                    WroteMRec% = True
                    GOSUB WriteMTmpRec
                    GOSUB InitMRecE
                    EXIT DO
                END IF
            END IF


          'CONNECT
          '*******
            IF INSTR(13, Record$, "CONNECT") THEN
            IF FILESTAT = -1 THEN
               CLOSE #CHAN
               EXIT DO
               ELSE
                  CALL InputLine(CHAN%, MAXSIZE%, FILESTAT%, Record$)
                     'Sending text in  -  skip a record
                     '---------------------------------
                      IF INSTR(13, Record$, "Sending text in") THEN
                          IF FILESTAT = -1 THEN
                              CLOSE #CHAN
                              EXIT DO
                              ELSE
                                  CALL InputLine(CHAN%, MAXSIZE%, FILESTAT%, Record$)
                          END IF
                       END IF
            END IF

                Ctr% = Ctr% + 1
                CALL LocRowCol(12, 15)
                PRINT "Scanning "; LogFile$; " :"; Ctr%
              
              'Human caller
              '------------
                IF INSTR(13, Record$, "Incoming call at") THEN
                    HumanBBS& = VAL(MID$(Record$, 30))
                    IF HumanBBS& = 9600 THEN
                        BBS96% = BBS96% + 1
                    ELSEIF HumanBBS& = 2400 THEN BBS24% = BBS24% + 1
                    ELSEIF HumanBBS& = 1200 THEN BBS12% = BBS12% + 1
                    ELSEIF HumanBBS& = 4800 THEN BBS48% = BBS48% + 1
                    ELSEIF HumanBBS& = 7200 THEN BBS72% = BBS72% + 1
                    ELSEIF HumanBBS& = 12000 THEN BBS120% = BBS120% + 1
                    ELSEIF HumanBBS& = 14400 THEN BBS14% = BBS14% + 1
                    ELSEIF HumanBBS& = 16800 THEN BBS16% = BBS16% + 1
                    ELSEIF HumanBBS& = 19200 THEN BBS19% = BBS19% + 1
                    ELSEIF HumanBBS& = 21600 THEN BBS216% = BBS216% + 1
                    ELSEIF HumanBBS& = 24000 THEN BBS240% = BBS240% + 1
                    ELSEIF HumanBBS& = 26400 THEN BBS264% = BBS264% + 1
                    ELSEIF HumanBBS& = 28800 THEN BBS288% = BBS288% + 1
                    ELSE
                        BBSOther% = BBSOther% + 1
                    END IF
                    EXIT DO
                END IF
              
              'Unable to initiate transfer
              '---------------------------
                IF INSTR(13, Record$, "Unable to initiate transfer") THEN
                    MConnect1 = 1
                    WroteMRec% = True
                    GOSUB WriteMTmpRec
                    GOSUB InitMRecE
                    EXIT DO
                END IF
              
                IF INSTR(13, Record$, "Sent") THEN
                    IF ItsMail%(Record$) THEN
                        subString$ = ";"
                        P% = BackInstr%(0, Record$, subString$)
                        IF P% THEN
                            ByteOut& = VAL(MID$(Record$, P% + 1))
                            MByteOut1 = MByteOut1 + ByteOut&
                            subString$ = Comma
                            P% = BackInstr%(0, Record$, subString$)
                            OutCPS% = VAL(MID$(Record$, P% + 1))
                            IF OutCPS% THEN
                                TimeOut& = ByteOut& / OutCPS%
                                MTimeOut1 = MTimeOut1 + TimeOut&
                            ELSE
                                MTimeOut1 = 0
                            END IF
                        END IF
                    ELSE
                        subString$ = "\"
                        P% = BackInstr%(0, Record$, subString$)
                        IF P% THEN
                            Temp$ = MID$(Record$, P% + 1)
                            subString$ = ","
                            P% = BackInstr%(0, Temp$, subString$)
                            FileRecE.FileCPS = VAL(MID$(Temp$, P% + 1))
                            subString$ = ";"
                            P% = BackInstr%(0, Temp$, subString$)
                            FileRecE.FileByteIn = VAL(MID$(Temp$, P% + 1))
                            FileRecE.FileNm = LEFT$(Temp$, P% - 1)
                            GOSUB WriteFTmpRec
                            GOSUB InitFileRecE
                        END IF
                    END IF
                END IF
              
              'Incoming mail
              '-------------
                IF INSTR(13, Record$, "Rcvd") THEN
                    IF ItsMail%(Record$) THEN
                        subString$ = ";"
                        P% = BackInstr%(0, Record$, subString$)
                        IF P% THEN
                            ByteIn& = VAL(MID$(Record$, P% + 1))
                            MByteIn1 = MByteIn1 + ByteIn&
                            subString$ = Comma
                            P% = BackInstr%(0, Record$, subString$)
                            InCPS% = VAL(MID$(Record$, P% + 1))
                            IF InCPS% THEN
                                TimeIn& = ByteIn& / InCPS%
                                MTimeIn1 = MTimeIn1 + TimeIn&
                            ELSE
                                MTimeIn1 = 0
                            END IF
                        END IF
                    ELSE
                        subString$ = "\"
                        P% = BackInstr%(0, Record$, subString$)
                        IF P% THEN
                            Temp$ = MID$(Record$, P% + 1)
                            subString$ = ","
                            P% = BackInstr%(0, Temp$, subString$)
                            FileRecE.FileCPS = VAL(MID$(Temp$, P% + 1))
                            subString$ = ";"
                            P% = BackInstr%(0, Temp$, subString$)
                            FileRecE.FileByteIn = VAL(MID$(Temp$, P% + 1))
                            FileRecE.FileNm = LEFT$(Temp$, P% - 1)
                            GOSUB WriteFTmpRec
                            GOSUB InitFileRecE
                        END IF
                    END IF
                  
                END IF
              
              'Session handshake failure
              '-------------------------
                IF INSTR(12, Record$, "Session handshake failure") THEN
                    IF OutgoingCall% THEN
                        MConnect1 = 1
                        WroteMRec% = True
                        GOSUB WriteMTmpRec
                        GOSUB InitMRecE
                    END IF
                END IF
              
              'Carrier lost - Outgoing call
              '----------------------------
                IF OutgoingCall% AND INSTR(13, Record$, "Carrier lost") THEN
                    MConnect1 = 1
                    WroteMRec% = True
                    GOSUB WriteMTmpRec
                    GOSUB InitMRecE
                END IF
              
                IF OutgoingCall% THEN MConnect1 = 1
              
              'Rejecting human caller
              '---------------------
                IF INSTR(13, Record$, "Rejecting human caller") THEN
                    RejCaller% = RejCaller% + 1
                  'Escape to the top of the loop
                    EXIT DO
                END IF
              
              'No response from remote system
              '------------------------------
                IF OutgoingCall% THEN
                    IF INSTR(13, Record$, "No response from remote system") THEN
                        MCallsOut1 = 1
                        MConnect1 = 1
                        NoResponse% = True
                    END IF
                END IF
              
              'Outgoing call (Calling***)
              '-----------------------
                IF INSTR(13, Record$, "Calling") THEN
                    OutgoingCall% = True
                    MCallsOut1 = 1
                    subString$ = Comma
                    P% = BackInstr%(0, Record$, subString$)
                    IF P% THEN
                        Temp$ = LEFT$(Record$, P% - 1)
                        P% = BackInstr%(0, Temp$, subString$)
                        MNode1 = LTRIM$(MID$(Temp$, P% + 1))
                    END IF
                END IF
              
              'Timeout waiting for hello packet
              '--------------------------------
                IF INSTR(13, Record$, "Timeout waiting for hello packet") THEN
            IF FILESTAT = -1 THEN
               CLOSE #CHAN
               EXIT DO
               ELSE
                  CALL InputLine(CHAN%, MAXSIZE%, FILESTAT%, Record$)
            END IF
                  'this may not work all the time.
                  'if the next record is the incoming Net name string then
                  'it should drop down and parse it as an incoming call.  If
                  'not - result will be unpredictable!
                  
                END IF
              
              'Incoming call - Unexpected password
              '-----------------------------------
                IF NOT OutgoingCall% THEN
                    IF INSTR(13, Record$, "Unexpected password") THEN
                        DO UNTIL MID$(Record$, 13, 19) <> "Unexpected password"
            IF FILESTAT = -1 THEN
               CLOSE #CHAN
               EXIT DO
               ELSE
                  CALL InputLine(CHAN%, MAXSIZE%, FILESTAT%, Record$)
            END IF
                            Ctr% = Ctr% + 1
                            CALL LocRowCol(12, 15)
                            PRINT "Scanning "; LogFile$; " :"; Ctr%
                        LOOP
                    END IF
                END IF
              'Drop through to parse the incoming call string
              
              'Incoming call (Get Node Number)
              '-------------
                IF NOT OutgoingCall% THEN
                    IF INSTR(1, Record$, "+") THEN
                        subString$ = ","
                        P% = BackInstr%(0, Record$, subString$)
                        IF P% THEN
                            MNode1 = LTRIM$(MID$(Record$, P% + 1))
                            P% = INSTR(MNode1, "@")
                            IF P% THEN
                                MNode1 = LEFT$(MNode1, P% - 1)
                            END IF
                            MConnect1 = 1
                            MCallsIn1 = 1
                            WroteMRec% = False
                        END IF
                    END IF
                END IF
            END IF
        LOOP
    WEND
  
  'Dummy record to mark the end of file.
    PRINT #MTmp%, ""; Comma; 0; Comma; 0; Comma; 0; Comma; 0; Comma; 0; Comma; 0; Comma; 0
    CLOSE
  
  '******************************
  'Start the Report output work
  '******************************
  
    Rpt% = FREEFILE
  
    OPEN "FDLARPT.TXT" FOR OUTPUT AS Rpt%
  
    PRINT #Rpt%,
    PRINT #Rpt%, LogFile$;
    PRINT #Rpt%, TAB(64 - LEN(FDLAVersion$)); "FDLA Version "; FDLAVersion$
    IF INSTR(SysName$, "Not Defined") THEN
        PRINT #Rpt%,
    ELSE
        P% = INSTR(SysName$, "@")
        IF P% THEN
            SysName$ = MID$(SysName$, 3, P% - 3)
            PRINT #Rpt, TAB(38 - LEN(SysName$) \ 2); SysName$
        END IF
    END IF
    Temp$ = "FrontDoor Log Statistics for the period"
    PRINT #Rpt%, TAB(38 - LEN(Temp$) \ 2); Temp$
    PRINT #Rpt%, SPC(12); "From "; BeginFd$; "  to  "; EndFd$ + " " + EndTime$
    CALL ReportTPLs(1, Rpt%)
  
  '********************
  'Sort the data files
  '********************
    SortProgram$ = "QSORT"      'default
  '  SortProgram$ = "SORT"
    IF RptPtI% THEN
        SortFlag% = True
        CALL LocRowCol(13, 15)
        PRINT "Sorting..."
Sorting:
      
        SHELL SortProgram$ + "< FDLATmp.$$$ > FDLATmp.$$S"
    END IF
  
    IF RptPtII% THEN
        SHELL SortProgram$ + "< FDLATmpF.$$$ > FDLATmpF.$$S"
        CALL LocRowCol(13, 15)
        PRINT "Sorting..."
    END IF
  
    IF RptPtIV% THEN
        CALL LocRowCol(13, 15)
        PRINT "Sorting..."
        SHELL SortProgram$ + "< FDLATmpU.$$$ > FDLATmpU.$$S"
    END IF
  
    VIEW PRINT 14 TO 23
    CLS
    CALL LocRowCol(14, 15)
    PRINT "Creating output report....."
    CALL LocRowCol(15, 15)
    PRINT "Working    ";
    VIEW PRINT  'Re-set screen
  
    IF RptPtI% THEN
      
      '************************************************************
      'Merge Records from FDLATmp$$S for output report FDLARPT.TXT
      '************************************************************
      
        STmp% = FREEFILE
        OPEN "FDLATMP.$$S" FOR INPUT AS STmp%
        IF LOF(STmp%) = 0 THEN
            BEEP
            DOSError$ = ErrorCode$(4)
            CALL ErrorMessage(DOSError$)
            CALL LocRowCol(15, 15)
            PRINT "Sort file FDLATMP.$$S is Nul (Zero length). Deleting File"
            CLOSE
            KILL "FDLATMP.$$S"
            IF Exist%("FDLATMP.$$$") THEN KILL "FDLATMP.$$$"
            IF Exist%("FDLATMP?.$$?") THEN KILL "FDLATMP?.$$?"
            CALL LocRowCol(17, 19)
            COLOR 10, 0
            PRINT "You may have run out of disk space or memory."
            IF SortProgram$ = "SORT" THEN
                CALL LocRowCol(18, 17)
                COLOR 10, 0
                PRINT "You are not using QSORT.  This may be the problem."
                CALL LocRowCol(19, 13)
                PRINT "FDLA was unable to find QSort so it tried to use DOS "; SortProgram$
                COLOR 7, 0
                CALL SetLevel(1)
                END
            END IF
            CALL SetLevel(1)
            END
        END IF
        IF MkDataFile% THEN
            DatF% = FREEFILE    'Data file from
            OPEN "FDLARpt.Dat" FOR OUTPUT AS DatF%              'Part I Report
        END IF
      
      
        INPUT #STmp%, MNode1, MCallsOut1, MConnect1, MCallsIn1, MByteOut1
        INPUT #STmp%, MByteIn1, MTimeOut1, MTimeIn1
      
        INPUT #STmp%, MNode2, MCallsOut2, MConnect2, MCallsIn2, MByteout2
        INPUT #STmp%, MByteIn2, MTimeOut2, MTimeIn2
        DO
            DO
                IF EOF(STmp%) THEN
                    EXIT DO
                END IF
                IF MNode1 = MNode2 THEN
                  'Combine Records
                    MCallsOut1 = MCallsOut1 + MCallsOut2
                    MConnect1 = MConnect1 + MConnect2
                    MCallsIn1 = MCallsIn1 + MCallsIn2
                    MByteOut1 = MByteOut1 + MByteout2
                    MByteIn1 = MByteIn1 + MByteIn2
                    MTimeOut1 = MTimeOut1 + MTimeOut2
                    MTimeIn1 = MTimeIn1 + MTimeIn2
                  
                  'Get the next record
                    INPUT #STmp%, MNode2, MCallsOut2, MConnect2, MCallsIn2, MByteout2
                    INPUT #STmp%, MByteIn2, MTimeOut2, MTimeIn2
                END IF
            LOOP UNTIL MNode1 <> MNode2
          
            IF MNode1 = MNode2$ THEN
              'Combine Records
                MCallsOut1 = MCallsOut1 + MCallsOut2
                MConnect1 = MConnect1 + MConnect2
                MCallsIn1 = MCallsIn1 + MCallsIn2
                MByteOut1 = MByteOut1 + MByteout2
                MByteIn1 = MByteIn1 + MByteIn2
                MTimeOut1 = MTimeOut1 + MTimeOut2
                MTimeIn1 = MTimeIn1 + MTimeIn2
              
                GOSUB WriteRpt
            ELSE
                GOSUB WriteRpt
            END IF
          
            MNode1 = MNode2
            MCallsOut1 = MCallsOut2
            MConnect1 = MConnect2
            MCallsIn1 = MCallsIn2
            MByteOut1 = MByteout2
            MByteIn1 = MByteIn2
            MTimeOut1 = MTimeOut2
            MTimeIn1 = MTimeIn2
            IF EOF(STmp%) THEN EXIT DO
            INPUT #STmp%, MNode2, MCallsOut2, MConnect2, MCallsIn2, MByteout2
            INPUT #STmp%, MByteIn2, MTimeOut2, MTimeIn2
        LOOP UNTIL MNode1 = ""
      
      'Clear vars for later use in Part IV
        MNode1 = "": MNode2 = ""
    ELSE
        CALL ReportTPLs(4, Rpt%)
        CALL ReportTPLs(2, Rpt%)
    END IF
  
  '************************************
  'Totals for FDLARpt.txt output Part I
  '************************************
    IF RptPtI% THEN
        CALL ReportTPLs(9, Rpt%)
      
        TotMAvgCPS& = (TotMByteOut1& + TotMByteIn1&)
        IF TotMAvgCPS& > 0 AND TotTimeOutIn& > 0 THEN
            TotMAvgCPS& = (TotMByteOut1& + TotMByteIn1&) \ TotTimeOutIn&
            MTotTimeMin! = TotTimeOutIn& / 60
        END IF
        PRINT #Rpt%, Bar$; " TOTALS"; TAB(17);
        PRINT #Rpt, USING "####"; TotCallsOut1%;
        PRINT #Rpt, TAB(25);
        PRINT #Rpt, USING "####"; TotConnect1%;
        PRINT #Rpt, TAB(33);
        PRINT #Rpt, USING "###"; TotCallsIn1%;
        PRINT #Rpt, TAB(37);
        PRINT #Rpt, USING "###,###,###"; TotMByteOut1&;
        PRINT #Rpt, TAB(51);
        PRINT #Rpt, USING "###,###,###"; TotMByteIn1&;
        PRINT #Rpt, TAB(65);
        PRINT #Rpt, USING "####"; TotMAvgCPS&;
        PRINT #Rpt, TAB(70);
        PRINT #Rpt, USING "####.#"; MTotTimeMin!;
        PRINT #Rpt, Bar$
        CALL ReportTPLs(2, Rpt%)
      ' IF ExNet% THEN
      '    PRINT #Rpt,
      '    PRINT #Rpt, "NOTE: -EXN option used to exclude Net "; ExcludeNet$;
      '    PRINT #Rpt, " from Part I."
      ' END IF
    END IF
    PRINT #Rpt,
    CALL ReportTPLs(3, Rpt%)
    PrtRec% = PrtRec% + 1
    CALL PrtCtrDisp(PrtRec%)
  
  
  '**********************************************
  ' Part II of FDLARpt.txt - file out/in listing
  '**********************************************
  
    IF RptPtII% THEN
        Ctr% = 0
        TmpF% = FREEFILE
        OPEN "FDLATmpF.$$S" FOR INPUT AS #TmpF%
        DO UNTIL EOF(TmpF%)
            INPUT #TmpF%, MNode1, FileRecE.FileNm, FileRecE.FileByteOut
            INPUT #TmpF%, FileRecE.FileByteIn, FileRecE.FileCPS
            Ctr% = Ctr% + 1
            IF FileRecE.FileCPS > 0 THEN
                FTranMin! = ((FileRecE.FileByteOut + FileRecE.FileByteIn) / FileRecE.FileCPS) / 60
                FTranSec& = (FileRecE.FileByteOut + FileRecE.FileByteIn) \ FileRecE.FileCPS
                TotFTranSec& = TotFTranSec& + FTranSec&
            ELSE
                FTranMin! = 0
            END IF
            TotFByteOut& = TotFByteOut& + FileRecE.FileByteOut
            TotFByteIn& = TotFByteIn& + FileRecE.FileByteIn
            TotFTranMin! = TotFTranMin! + FTranMin!
          
            PRINT #Rpt%, Bar$; MNode1; TAB(21); FileRecE.FileNm; TAB(37);
            PRINT #Rpt%, USING "###,###,###"; FileRecE.FileByteOut;
            PRINT #Rpt%, TAB(51);
            PRINT #Rpt%, USING "###,###,###"; FileRecE.FileByteIn;
            PRINT #Rpt%, TAB(65);
            PRINT #Rpt%, USING "####"; FileRecE.FileCPS;
            PRINT #Rpt%, TAB(71);
            PRINT #Rpt%, USING "###.#"; FTranMin!;
            PRINT #Rpt%, Bar$
          
            PrtRec% = PrtRec% + 1
            CALL PrtCtrDisp(PrtRec%)
        LOOP
        CALL ReportTPLs(9, Rpt%)
        IF TotFTranSec& > 0 AND (TotFByteOut& + TotFByteIn&) > 0 THEN
            FileCPSAvg% = (TotFByteOut& + TotFByteIn&) \ TotFTranSec&
        END IF
      
        PRINT #Rpt%, Bar$; " TOTALS"; TAB(25); Ctr%;
        PRINT #Rpt%, TAB(37);
        PRINT #Rpt%, USING "###,###,###"; TotFByteOut&;
        PRINT #Rpt%, TAB(51);
        PRINT #Rpt%, USING "###,###,###"; TotFByteIn&;
        PRINT #Rpt%, TAB(65);
        PRINT #Rpt%, USING "####"; FileCPSAvg%;
        PRINT #Rpt%, TAB(70);
        PRINT #Rpt%, USING "####.#"; TotFTranMin!;
        PRINT #Rpt%, Bar$
        CALL ReportTPLs(2, Rpt%)
        PRINT #Rpt%,
      
        PrtRec% = PrtRec% + 1
        CALL PrtCtrDisp(PrtRec%)
      
    ELSE        'No activity in the log
        CALL ReportTPLs(4, Rpt%)
        CALL ReportTPLs(2, Rpt%)
    END IF
  
  '******************************
  ' Part III Session Cost output
  '******************************
  
    IF RptPtIII% THEN
        CstF% = FREEFILE
        OPEN "FDLATmpC.$$$" FOR INPUT AS #CstF%
        DO UNTIL EOF(CstF%)
            LINE INPUT #CstF%, Record$
            PRINT #Rpt, Record$
          
            PrtRec% = PrtRec% + 1
            CALL PrtCtrDisp(PrtRec%)
          
        LOOP
        CALL ReportTPLs(2, Rpt%)
        PRINT #Rpt,
    ELSE
        CALL ReportTPLs(5, Rpt%)
        CALL ReportTPLs(6, Rpt%)
        CALL ReportTPLs(2, Rpt%)
        PRINT #Rpt,
    END IF
  
  '*********************************
  ' Part IV Undialable nodes report
  '*********************************
  
    CALL ReportTPLs(7, Rpt%)
    IF RptPtIV% THEN
        Und% = FREEFILE
        OPEN "FDLATmpU.$$S" FOR INPUT AS #Und%
        Ctr% = 0
        DO UNTIL EOF(Und%)
            INPUT #Und%, MNode1
            DO
                IF EOF(Und%) THEN
                    Ctr% = Ctr% + 1
                    GOSUB WritePtIV
                    EXIT DO
                END IF
                INPUT #Und%, MNode2
                IF MNode2 = MNode1 THEN
                    MNode1 = MNode2
                ELSE
                    Ctr% = Ctr% + 1
                    GOSUB WritePtIV
                END IF
            LOOP UNTIL MNode1 <> MNode2
          
        LOOP
      
        IF MNode1 <> MNode2 THEN
            MNode1 = MNode2
            Ctr% = Ctr% + 1
            GOSUB WritePtIV
        END IF
      
        IF Ctr% = 0 THEN
            CALL ReportTPLs(2, Rpt%)
            PRINT #Rpt,
        ELSE
            PRINT #Rpt, TAB(76); Bar$
            CALL ReportTPLs(2, Rpt%)
            PRINT #Rpt,
        END IF
    ELSE
        CALL ReportTPLs(4, Rpt%)
        CALL ReportTPLs(2, Rpt%)
        PRINT #Rpt,
    END IF
  
  ' ****************************
  ' Part V Summary report output
  '*****************************
    CALL ReportTPLs(8, Rpt%)
  
  '28800 caller
    PRINT #Rpt, Bar$; " BBS Callers at 28800   = ";
    PRINT #Rpt, USING "####"; BBS288%;
    GOSUB ReportBar

   '26400 caller
    PRINT #Rpt, Bar$; "                26400   = ";
    PRINT #Rpt, USING "####"; BBS264%;
    GOSUB ReportBar

   '24000 caller
    PRINT #Rpt, Bar$; "                24000   = ";
    PRINT #Rpt, USING "####"; BBS240%;
    GOSUB ReportBar

   '21600 caller
    PRINT #Rpt, Bar$; "                21600   = ";
    PRINT #Rpt, USING "####"; BBS216%;
    PRINT #Rpt, " "; Bar$;
    PRINT #Rpt, TAB(76); Bar$

   '19200 caller
    PRINT #Rpt, Bar$; "                19200   = ";
    PRINT #Rpt, USING "####"; BBS19%;
    PRINT #Rpt, " "; Bar$;
    PRINT #Rpt, TAB(76); Bar$

   '16800 caller
    PRINT #Rpt, Bar$; "                16800   = ";
    PRINT #Rpt, USING "####"; BBS16%;

    PRINT #Rpt, " "; Bar$; " Message Bytes Transferred    =";
    PRINT #Rpt, USING "###,###,###"; TotMByteOut1& + TotMByteIn1&;
    PRINT #Rpt, TAB(76); Bar$

   '14400 caller
    PRINT #Rpt, Bar$; "                14400   = ";
    PRINT #Rpt, USING "####"; BBS14%;
    PRINT #Rpt, " "; Bar$; " File Bytes Transferred       =";
    PRINT #Rpt, USING "###,###,###"; TotFByteOut& + TotFByteIn&;
    PRINT #Rpt, TAB(76); Bar$

   '12000 caller
    PRINT #Rpt, Bar$; "                12000   = ";
    PRINT #Rpt, USING "####"; BBS120%;
    PRINT #Rpt, " "; Bar$;
    PRINT #Rpt, TAB(76); Bar$
  
    PRINT #Rpt, Bar$; "                 9600   = ";
    PRINT #Rpt, USING "####"; BBS96%;
    PRINT #Rpt, " "; Bar$; " TOTAL Bytes Transferred      =";
    PRINT #Rpt, USING "###,###,###"; (TotFByteOut& + TotFByteIn&) + (TotMByteOut1& + TotMByteIn1&);
    PRINT #Rpt, TAB(76); Bar$

   '7200 caller
    PRINT #Rpt, Bar$; "                 7200   = ";
    PRINT #Rpt, USING "####"; BBS72%;
    PRINT #Rpt, " "; Bar$;
    PRINT #Rpt, TAB(76); Bar$

   '4800 caller
    PRINT #Rpt, Bar$; "                 4800   = ";
    PRINT #Rpt, USING "####"; BBS48%;
    GOSUB ReportBar
  
   '2400 caller
    PRINT #Rpt, Bar$; "                 2400   = ";
    PRINT #Rpt, USING "####"; BBS24%;
    GOSUB ReportBar

    PRINT #Rpt, Bar$; "                 1200   = ";
    PRINT #Rpt, USING "####"; BBS12%;
    GOSUB ReportBar

    PRINT #Rpt, Bar$; "                 Other  = ";
    PRINT #Rpt, USING "####"; BBSOther%;
    GOSUB ReportBar
    PRINT #Rpt, Bar$; TAB(33); Bar$; " Message Connect Time         =      ";
    IF MTotTimeMin! > 0 THEN
        MTotTimeHr! = MTotTimeMin! / 60
    END IF
    PRINT #Rpt, USING "###.#"; MTotTimeHr!;
    PRINT #Rpt, Bar$
  
    PRINT #Rpt, Bar$; " TOTAL BBS Callers      = ";
    PRINT #Rpt, USING "####"; BBS16% + BBS14% + BBS96% + BBS24% + BBS12% + BBS48% + BBS72% + BBS120% + BBS19% + BBS216% + BBS240% + BBS264% + BBS288% + BBSOther%;
    PRINT #Rpt, " "; Bar$; " File Transfer Connect Time   =      ";
    IF TotFTranMin! > 0 THEN
        TotFTranHr! = TotFTranMin! / 60
    END IF
    PRINT #Rpt, USING "###.#"; TotFTranHr!;
    PRINT #Rpt, Bar$
  
    PRINT #Rpt, Bar$; TAB(33); Bar$; " TOTAL Connect Time (Hours)   =      ";
    PRINT #Rpt%, USING "###.#"; MTotTimeHr! + TotFTranHr!;
    PRINT #Rpt, Bar$
  
    PRINT #Rpt, Bar$; " Rejected BBS Calls     = ";
    PRINT #Rpt, USING "####"; RejCaller%;
    PRINT #Rpt, " "; Bar$; " TOTAL Network Session Costs  =   ";
    PRINT #Rpt, USING "$####.##"; TotSessCost!;
    PRINT #Rpt, Bar$
  
    PRINT #Rpt, Bar$;
    IF HighAscii% THEN
        PRINT #Rpt, TAB(33); "Ĵ"
    ELSE
        PRINT #Rpt, TAB(33); "+------------------------------------------+"
    END IF
  
    PRINT #Rpt, Bar$; TAB(33); Bar$; " Unsuccessful Connect Attempts=      ";
    PRINT #Rpt, USING "#####"; (TotCallsOut1% + TotCallsIn1%) - TotConnect1%;
    PRINT #Rpt, Bar$
    IF HighAscii% THEN
        PRINT #Rpt, ""
    ELSE
      ' PRINT #Rpt, "+-------------------------------+------------------------------------------+"
        PRINT #Rpt, ">===============================+==========================================+"
    END IF
    CLOSE
  
    CALL LocRowCol(16, 15)
    PRINT "Finished Output: ";
    COLOR 15, 0
    PRINT "FDLARpt.Txt"
    COLOR 7, 0
  
    IF DelTempFiles% THEN
        KILL "FDLATmp.$$$"
        KILL "FDLATmpF.$$$"
        KILL "FDLATmpU.$$$"
        KILL "FDLATmpC.$$$"
        IF RptPtI% THEN
            KILL "FDLATmp.$$S"
        END IF
        IF RptPtII% THEN
            KILL "FDLATmpF.$$S"
        END IF
        IF RptPtIV% THEN
            KILL "FDLATmpU.$$S"
        END IF
    END IF
  
    VIEW PRINT  'Re set screen
  
    IF DispRpt% THEN
        CALL DisplayReport
      'Program ends in Sub
    END IF
    CALL LocRowCol(24, 1)
  
    END
  
  '**********************
  ' Program error traps
  '**********************
ErrHandler:
    IF SortFlag% AND ERR = 53 AND SortProgram$ = "QSORT" THEN
        SortProgram$ = "SORT"
        RESUME Sorting
    ELSE
    PRINT
    BEEP
    VIEW PRINT
    DOSError$ = ErrorCode$(ERR)
    CALL ErrorMessage(DOSError$)
    CALL SetLevel(1)
    END
    END IF
  '********************
  ' Sub-Routines
  '********************

ReportBar:
    IF HighAscii% THEN
        PRINT #Rpt, " Ĵ"
    ELSE
        PRINT #Rpt, " +------------------------------------------+"
    END IF
    RETURN
   
  'Write FDLATmp.$$$ mail record
  
WriteMTmpRec:
    IF ExNet% THEN
       FOR X% = 1 TO Last%
           IF INSTR(MNode1, ExcludNet$(X%)) THEN
               ChopNet% = True
               EXIT FOR
           END IF
       NEXT
    END IF
    IF ChopNet% THEN
        ChopNet% = False
        GOSUB InitMRecE
        RETURN
    END IF
    RptPtI% = True
    IF MConnect1 = 1 AND MCallsOut1 = 0 THEN
        MCallsIn1 = 1
    END IF
    PRINT #MTmp%, MNode1; Comma; MCallsOut1; Comma;
    PRINT #MTmp%, MConnect1; Comma; MCallsIn1; Comma;
    PRINT #MTmp%, MByteOut1; Comma; MByteIn1; Comma;
    PRINT #MTmp%, MTimeOut1;
    PRINT #MTmp%, Comma;
    PRINT #MTmp%, MTimeIn1
    RETURN
  
WriteFTmpRec:

    IF ExNet% THEN
       FOR X% = 1 TO Last%
           IF INSTR(MNode1, ExcludNet$(X%)) THEN
               ChopNet% = True
               EXIT FOR
           END IF
       NEXT
    END IF
    IF ChopNet% THEN
        ChopNet% = False
        GOSUB InitFileRecE
        RETURN
    END IF

    IF ExFil% THEN
       FOR X% = 1 TO LastF%
           IF INSTR(FileRecE.FileNm, ExcludFiles$(X%)) THEN
               ChopFile% = True
               EXIT FOR
           END IF
       NEXT
    END IF
    IF ChopFile% THEN
        ChopFile% = False
        GOSUB InitFileRecE
        RETURN
    END IF

    RptPtII% = True
    PRINT #FTmp%, MNode1; Comma; FileRecE.FileNm; Comma;
    PRINT #FTmp%, FileRecE.FileByteOut; Comma; FileRecE.FileByteIn; Comma;
    PRINT #FTmp%, FileRecE.FileCPS
    RETURN
  
WriteUTmpRec:                   'Undialable nodes

    IF ExNet% THEN
       FOR X% = 1 TO Last%
           IF INSTR(MNode1, ExcludNet$(X%)) THEN
               ChopNet% = True
               EXIT FOR
           END IF
       NEXT
    END IF
    IF ChopNet% THEN
        ChopNet% = False
        RETURN
    END IF

    RptPtIV% = True
    PRINT #UTmp%, MNode1
    RETURN
  
WriteRpt:
  'Write FDLARpt.Txt detail lines
  'A Nul record slipped in
    IF MCallsOut1 + MConnect1 + MCallsIn1 + MByteOut1 + MByteIn1 + MTimeOut1 + MTimeIn1 = 0 THEN
        RETURN
    END IF
  
    MByteOutIn1& = MByteOut1 + MByteIn1
    MTimeOutIn1% = MTimeOut1 + MTimeIn1
  
    IF MByteOutIn1& > 0 AND MTimeOutIn1% > 0 THEN
        MAvgCPS1% = MByteOutIn1& \ MTimeOutIn1%
        MtimeMin1! = MTimeOutIn1% / 60
    END IF
  
  'Data file from Part I of the report - FDLARpt.Dat
    IF MkDataFile% THEN
        PRINT #DatF%, MNode1; Comma; MCallsOut1; Comma; MConnect1; Comma; MCallsIn1; Comma;
        PRINT #DatF%, MByteOut1; Comma; MByteIn1; Comma; MTimeOut1; Comma;
        PRINT #DatF%, MTimeIn1; Comma; MByteOutIn1&; Comma; MTimeOutIn1%; Comma;
        PRINT #DatF%, MAvgCPS1%; Comma; MtimeMin1!
    END IF
  
  'Output to FDLARpt.txt of Part I data
  'collected from FDLATmp.$$S
  
    PRINT #Rpt, Bar$; MNode1; TAB(18);
    PRINT #Rpt, USING "####"; MCallsOut1;
    PRINT #Rpt, TAB(26);
    PRINT #Rpt, USING "###"; MConnect1;
    PRINT #Rpt, TAB(33);
    PRINT #Rpt, USING "###"; MCallsIn1;
    PRINT #Rpt, TAB(37);
    PRINT #Rpt, USING "###,###,###"; MByteOut1;
    PRINT #Rpt, TAB(51);
    PRINT #Rpt, USING "###,###,###"; MByteIn1;
    PRINT #Rpt, TAB(65);
    PRINT #Rpt, USING "####"; MAvgCPS1%;
    PRINT #Rpt, TAB(71);
    PRINT #Rpt, USING "###.#"; MtimeMin1!;
    PRINT #Rpt, Bar$
  
    PrtRec% = PrtRec% + 1
    CALL PrtCtrDisp(PrtRec%)
  
  'Totals
    TotCallsOut1% = TotCallsOut1% + MCallsOut1
    TotConnect1% = TotConnect1% + MConnect1
    TotCallsIn1% = TotCallsIn1% + MCallsIn1
    TotMByteOut1& = TotMByteOut1& + MByteOut1
    TotMByteIn1& = TotMByteIn1& + MByteIn1
    TotTimeOutIn& = TotTimeOutIn& + MTimeOutIn1%
  
    MByteOutIn1& = 0
    MTimeOutIn1% = 0
    MAvgCPS1% = 0
    MtimeMin1! = 0
    RETURN
  
WritePtIV:
    SELECT CASE Ctr%
    CASE IS = 1
        PRINT #Rpt%, Bar$; MNode1; TAB(22);
    CASE IS = 2
        PRINT #Rpt%, MNode1; TAB(42);
    CASE IS = 3
        PRINT #Rpt%, MNode1;
    CASE IS = 4
        Node1$ = RTRIM$(MNode1)
        PRINT #Rpt%, TAB(76 - LEN(Node1$)); Node1$; TAB(76); Bar$
        Ctr% = 0
    END SELECT
  
    PrtRec% = PrtRec% + 1
    CALL PrtCtrDisp(PrtRec%)
  
    RETURN
  
InitMRecE:
    MNode1 = "Unknown"
    MCallsOut1 = 0
    MConnect1 = 0
    MCallsIn1 = 0
    MByteOut1 = 0
    MByteIn1 = 0
    MTimeOut1 = 0
    MTimeIn1 = 0
  
    OutgoingCall% = False
    InCPS% = 0
    OutCPS% = 0
    ByteIn& = 0
    ByteOut& = 0
    TimeIn& = 0
    TimeOut& = 0
    RETURN
  
InitFileRecE:
    FileRecE.FileNm = "Unknown"
    FileRecE.FileByteOut = 0
    FileRecE.FileByteIn = 0
    FileRecE.FileCPS = 0
    RETURN

    FUNCTION BackInstr% (Start%, searchString$, subString$)
        IF Start% = 0 THEN Start% = 1
        n% = INSTR(Start%, searchString$, subString$)
        a% = n%
        DO WHILE n%
            n% = n% + 1
            n% = INSTR(n%, searchString$, subString$)
            IF n% THEN a% = n%
        LOOP
        BackInstr% = a%
    END FUNCTION

    SUB Copyright
      'Opening Screen
        CLS
        COLOR 15, 0
        Title$ = Copyright1$ + FDLAVersion$
        PRINT TAB(40 - LEN(Title$) / 2); Title$
        PRINT TAB(40 - LEN(Copyright2$) / 2); Copyright2$
        PRINT TAB(40 - LEN(Copyright3$) / 2); Copyright3$
        COLOR 7, 0
      
    END SUB

    SUB DisplayReport
        CLS
        COLOR 10, 0
        FILE$ = "FDLARpt.Txt"
        Escape = False
      
        Count = LineCount%(FILE$, SPACE$(4096))
        DRpt% = FREEFILE
        OPEN FILE$ FOR INPUT AS DRpt%
        REDIM Seeks&(1 TO Count)                ' Max number of lines
        CurSeek& = 1
        NumLines = 0
        DO UNTIL EOF(1)
            LINE INPUT #DRpt%, TEXT$
            NumLines = NumLines + 1
            Seeks&(NumLines) = CurSeek&         ' Save starting position
            CurSeek& = CurSeek& + LEN(TEXT$) + 2                ' Next position - 2 is
        LOOP    ' for C/R & LF
      
        CurCol = 1              ' Current Column
        SeekEl = 1              ' Current line
        Escape = False
        DO
            GOSUB LoadAndDisplay
            GOSUB KeyProcess
        LOOP UNTIL Escape
        CLOSE DRpt%
      ' CLS
      ' CALL LocRowCol(24, 1)
        CALL ScrnRest(1, 1, 25, 80, SEG Scrn%(1), -1)
        END
LoadAndDisplay:
        SEEK #DRpt%, Seeks&(SeekEl)
        FOR i = 1 TO 24
            IF NOT EOF(DRpt%) THEN LINE INPUT #DRpt%, TEXT$ ELSE TEXT$ = ""
            Strg$ = SPACE$(80)
            IF LEN(TEXT$) < CurCol THEN TEXT$ = TEXT$ + SPACE$(CurCol - LEN(TEXT$))
            LSET Strg$ = MID$(TEXT$, CurCol)
            LOCATE i, 1, 0: PRINT Strg$;
        NEXT i
        RETURN
      
      
KeyProcess:
        a$ = INKEY$: IF a$ = "" THEN GOTO KeyProcess
        SELECT CASE a$
        CASE CHR$(27): Escape = True            ' ESC
        CASE CHR$(88): Escape = True
        CASE CHR$(120): Escape = True
        CASE CHR$(0) + CHR$(72) ' Up Arrow
            SeekEl = SeekEl - 1
            IF SeekEl < 1 THEN SeekEl = 1: GOTO KeyProcess
        CASE CHR$(0) + CHR$(80) ' Dn Arrow
            SeekEl = SeekEl + 1
            IF SeekEl + 23 > NumLines THEN SeekEl = SeekEl - 1: GOTO KeyProcess
        CASE CHR$(0) + CHR$(77) ' Right Arrow
            CurCol = CurCol + 1
        CASE CHR$(0) + CHR$(75) ' Left Arrow
            CurCol = CurCol - 1
            IF CurCol < 1 THEN CurCol = 1: GOTO KeyProcess
        CASE CHR$(0) + CHR$(73) ' Page Up
            SeekEl = SeekEl - 24
            IF SeekEl < 1 THEN SeekEl = 1
        CASE CHR$(0) + CHR$(81) ' Page Dn
            SeekEl = SeekEl + 24
            IF SeekEl > NumLines THEN
                SeekEl = NumLines - 23: GOTO KeyProcess
            END IF
        CASE CHR$(0) + CHR$(71) ' Home
            SeekEl = 1
        CASE CHR$(0) + CHR$(79) ' End
            SeekEl = NumLines - 23
            IF SeekEl < 1 THEN SeekEl = 1: GOTO KeyProcess
        CASE ELSE
            GOTO KeyProcess
        END SELECT
        RETURN
      
    END SUB

    FUNCTION ErrorCode$ (Code%)
      
        SELECT CASE Code%
        CASE IS = 2
            ErrorCode$ = "Syntax error"
        CASE IS = 3
            ErrorCode$ = "RETURN without GOSUB"
        CASE IS = 4
            ErrorCode$ = "Out of DATA"
        CASE IS = 5
            ErrorCode$ = "Illegal function call"
        CASE IS = 6
            ErrorCode$ = "Overflow"
        CASE IS = 7
            ErrorCode$ = "Out of memory"
        CASE IS = 9
            ErrorCode$ = "Subscript out of range"
        CASE IS = 10
            ErrorCode$ = "Duplicate definition"
        CASE IS = 11
            ErrorCode$ = "Division by zero"
        CASE IS = 13
            ErrorCode$ = "Type mismatch"
        CASE IS = 14
            ErrorCode$ = "Out of string space"
        CASE IS = 16
            ErrorCode$ = "String formula too complex"
        CASE IS = 19
            ErrorCode$ = "No RESUME"
        CASE IS = 20
            ErrorCode$ = "RESUME without error"
        CASE IS = 24
            ErrorCode$ = "Device Timeout"
        CASE IS = 25
            ErrorCode$ = "Device Fault"
        CASE IS = 27
            ErrorCode$ = "Out of paper"
        CASE IS = 39
            ErrorCode$ = "CASE ELSE expected"
        CASE IS = 40
            ErrorCode$ = "Variable required"
        CASE IS = 50
            ErrorCode$ = "FIELD overflow"
        CASE IS = 51
            ErrorCode$ = "Internal error"
        CASE IS = 52
            ErrorCode$ = "Bad file name or number"
        CASE IS = 53
            ErrorCode$ = "File not found"
        CASE IS = 54
            ErrorCode$ = "Bad file mode"
        CASE IS = 55
            ErrorCode$ = "File already open"
        CASE IS = 56
            ErrorCode$ = "FIELD Statement active"
        CASE IS = 57
            ErrorCode$ = "Device I/O error"
        CASE IS = 58
            ErrorCode$ = "File already exists"
        CASE IS = 59
            ErrorCode$ = "Bad Record Length"
        CASE IS = 61
            ErrorCode$ = "Disk full"
        CASE IS = 62
            ErrorCode$ = "Input past end of file"
        CASE IS = 63
            ErrorCode$ = "Bad record number"
        CASE IS = 64
            ErrorCode$ = "Bad file name"
        CASE IS = 67
            ErrorCode$ = "Too many files"
        CASE IS = 68
            ErrorCode$ = "Device unavailable"
        CASE IS = 69
            ErrorCode$ = "Communication-buffer overflow"
        CASE IS = 70
            ErrorCode$ = "Permission denied"
        CASE IS = 71
            ErrorCode$ = "Disk not ready"
        CASE IS = 72
            ErrorCode$ = "Media error"
        CASE IS = 73
            ErrorCode$ = "Advanced feature unavailable"
        CASE IS = 74
            ErrorCode$ = "Rename accross disks"
        CASE IS = 75
            ErrorCode$ = "Path/File access error"
        CASE IS = 76
            ErrorCode$ = "Path not found"
        CASE ELSE
            ErrorCode$ = "Unknown error"
        END SELECT
    END FUNCTION

    SUB ErrorMessage (message$) STATIC
      
      ' Define color constants
        CONST BLACK = 0
        CONST BLUE = 1
        CONST GREEN = 2
        CONST CYAN = 3
        CONST RED = 4
        CONST MAGENTA = 5
        CONST BROWN = 6
        CONST WHITE = 7
        CONST BRIGHT = 8
        CONST BLINK = 16
        CONST Yellow = BROWN + BRIGHT
      
      ' Trim off spaces on each end of message
        message$ = LTRIM$(RTRIM$(message$))
      
      ' Make message length an odd number
        IF LEN(message$) MOD 2 = 0 THEN
            message$ = message$ + " "
        END IF
      
      ' Minimum length of message is 9 characters
        DO WHILE LEN(message$) < 9
            message$ = " " + message$ + " "
        LOOP
      
      ' Maximum length of message is 75
        message$ = LEFT$(message$, 75)
      
      ' Initialization of display
        SCREEN 0
        WIDTH 80
        CLS
        CALL Copyright
        COLOR WHITE + BRIGHT, BLACK
        LOCATE 6, 10
        PRINT "Darn.  I think we just blew it!"
      
      
      ' Calculate screen locations
        lm% = LEN(message$)
        col% = 38 - lm% \ 2
      
      ' Create the error box
        COLOR RED + BRIGHT, RED
        LOCATE 9, col%
        PRINT CHR$(201); STRING$(lm% + 2, 205); CHR$(187)
        LOCATE 10, col%
        PRINT CHR$(186); SPACE$(lm% + 2); CHR$(186)
        LOCATE 11, col%
        PRINT CHR$(186); SPACE$(lm% + 2); CHR$(186)
        LOCATE 12, col%
        PRINT CHR$(200); STRING$(lm% + 2, 205); CHR$(188)
      
      ' The title
        COLOR CYAN + BRIGHT, RED
        LOCATE 10, 36
        PRINT "* ERROR *";
      
      ' The message$
        COLOR Yellow, RED
        LOCATE 11, col% + 2
        PRINT message$;
     '  CLOSE
     '  KILL "*.$$?"
       END
      ' System will prompt for "any key"
        COLOR WHITE, BLACK
      '  LOCATE 22, 1
      ' LOCATE 15, 10
      ' PRINT "If you are unable to take corrective action with the error message"
      ' LOCATE 16, 10
      ' PRINT "stated above, please contact me via NetMail at FidoNet Node 1:134/75."
      ' LOCATE 17, 10
      ' PRINT "It's always appreciated if you send me your Binkley log file also."
      ' LOCATE 19, 10
      ' PRINT "If it's possible that you have memory problems, I highly recommend"
      ' LOCATE 20, 10
      ' PRINT "you try QSort (by Ben Baker) rather than the normal MS DOS Sort."
      ' SYSTEM
      
    END SUB

    SUB Help
        PRINT STRING$(79, "")
        COLOR 15, 0
        PRINT "Use:   ";
        COLOR 7, 0
        PRINT "FDLA [<-switch>] [LOG=logfilename]"
        PRINT
        PRINT SPC(7); "All switches are optional as is the log filename and may be given"
        PRINT SPC(7); "in any order.  If no Command Line parameters are given, FDLA defaults"
        PRINT SPC(7); "to creating FDLARpt.Txt and uses the Front Door log (FD.LOG) in the    "
        PRINT SPC(7); "default directory."
        COLOR 15, 0
        PRINT "Switches:"
        COLOR 7, 0
        PRINT TAB(8); "= No swich will produce FDLARpt.Txt and exit FDLA."
        PRINT " -D    = Make a data file FDLARpt.Dat from Part I of the report."
        PRINT " -H    = This brief help screen."
        PRINT " -EXN  = -EXN,Zone:Node (ie -EXN,1:134,2:). Exclusions from FDLARpt.*"
        PRINT " -KTF  = Don't delete created temp files (.$$$, .$$S)."
        PRINT " -L    = Produce FDLARpt.Txt and list it to the screen."
        PRINT " -LL   = List the last created FDLARpt.Txt file to the screen."
        PRINT " -NHA  = Don't use high ascii characters in FDLARpt.Txt."
        PRINT " -SN   = Configure FDLA.EXE to display your System Name on the output report."
        PRINT " -SUP  = -SUP,Filename(s) (ie -SUP,.REQ,.TIC). Exclusions from Pt FDLARpt.*"
        PRINT " LOG=  = Log path\log filename.  Optional if FD.LOG in default directory."
        PRINT STRING$(79, "")
      
    END SUB

        SUB InputLine (IOCHAN, BUFSIZE, STATUS, TEXT$) STATIC


        '[]=============================================================[]
        '[]        Inputs a line of text from the specified file        []
        '[]=============================================================[]

        STATIC TOTBYTES&        ' Total #bytes in file
        STATIC BYTES&           ' #Bytes read so far
        STATIC SEEKPOS&         ' Seek position in file
        STATIC SPOS             ' Start of line in buffer

        ' Initialize if this is the first call

        IF STATUS = 1 THEN
            STATUS = 0
            TOTBYTES& = LOF(IOCHAN)
            BYTES& = 0
            SEEKPOS& = 1
            BUFFER$ = STRING$(BUFSIZE, 0)
            SPOS = 1
        END IF

        EPOS = INSTR(SPOS, BUFFER$, CRLF$)
        IF EPOS <> 0 THEN
            '
            ' Easy - have a full line
            '
            TEXT$ = MID$(BUFFER$, SPOS, EPOS - SPOS)
        ELSE
            ' Partial line - read the next block
            '  and assemble the full line
            '
            IF LEFT$(BUFFER$, 1) = CHR$(0) THEN
                TEXT$ = ""
            ELSE
                TEXT$ = MID$(BUFFER$, SPOS, BUFSIZE - SPOS + 1)
            END IF
            IF (SEEKPOS& + BUFSIZE) > TOTBYTES& THEN
                BUFSIZE = TOTBYTES& - SEEKPOS& + 1
                BUFFER$ = STRING$(BUFSIZE, 0)
            END IF
            GET #IOCHAN, SEEKPOS&, BUFFER$
            BYTES& = BYTES& + BUFSIZE
            SEEKPOS& = SEEKPOS& + BUFSIZE
            IF BYTES& = TOTBYTES& THEN
                '
                ' Last block needs ending CRLF
                '
                IF RIGHT$(BUFFER$, 2) <> CRLF$ THEN
                    BUFFER$ = BUFFER$ + CRLF$
                    BUFSIZE = BUFSIZE + 2
                END IF
            END IF
            IF RIGHT$(TEXT$, 1) = CR$ THEN
                '
                ' Special case - CR at end of previous block
                '
                TEXT$ = LEFT$(TEXT$, LEN(TEXT$) - 1)
                EPOS = 0
            ELSE
                EPOS = INSTR(1, BUFFER$, CRLF$)
                TEXT$ = TEXT$ + MID$(BUFFER$, 1, EPOS - 1)
            END IF
        END IF

        ' Point to start of next line

        SPOS = EPOS + 2

        ' All done? If so set status and deallocate buffer

        IF (BYTES& = TOTBYTES& AND EPOS = (BUFSIZE - 1)) THEN
            BUFFER$ = "" ' This doesn't ERASE
            STATUS = -1
        END IF

        END SUB

    FUNCTION ItsMail% (Work$)
      
      'Determine by the extension on the filename is it's
      'Mail or a file of some other flavour.
      
        P% = QInstrB%(LEN(Work$) - 1, Work$, ".")
        IF P% THEN
            Extension$ = MID$(Work$, P% + 1, 2)
            SELECT CASE Extension$
            CASE IS = "MO", "TU", "WE", "TH", "FR", "SA", "SU", "OU", "PK", "CU", "HU", "DU"
                ItsMail% = True
            CASE ELSE
                ItsMail% = False
            END SELECT
        END IF
    END FUNCTION

    SUB LocRowCol (X%, Y%)
        LOCATE X%, Y%
    END SUB

  ' ************************************************
  ' **  Name:          ParseLine                  **
  ' **  Type:          Subprogram                 **
  ' **  Module:        PARSE.BAS                  **
  ' **  Language:      Microsoft QuickBASIC 4.00  **
  ' ************************************************
  '
  ' Breaks a string into an array of words, as defined
  ' by any characters listed in sep$.
  '
  ' EXAMPLE OF USE:  ParseLine x$, sep$, a$()
  ' PARAMETERS:      x$      String to be parsed
  '                  sep$    List of characters defined as word separators
  '                  a$()    Returned array of words
  ' VARIABLES:       t$      Temporary work string
  '                  i%      Index to array entries
  ' MODULE LEVEL
  '   DECLARATIONS:  DECLARE SUB ParseLine (x$, sep$, a$())
  '
    SUB ParseLine (X$, sep$, a$()) STATIC
        t$ = X$
        FOR i% = LBOUND(a$) TO UBOUND(a$)
            ParseWord t$, sep$, a$(i%)
            IF a$(i%) = "" THEN
                EXIT FOR
            END IF
        NEXT i%
        t$ = ""
    END SUB

  ' ************************************************
  ' **  Name:          ParseWord                  **
  ' **  Type:          Subprogram                 **
  ' **  Module:        PARSE.BAS                  **
  ' **  Language:      Microsoft QuickBASIC 4.00  **
  ' ************************************************
  '
  ' Breaks off the first word in a$, as delimited by
  ' any characters listed in sep$.
  '
  ' EXAMPLE OF USE:  ParseWord a$, sep$, word$
  ' PARAMETERS:      a$         String to be parsed
  '                  sep$       List of characters defined as word separators
  '                  word$      Returned first word parsed from a$
  ' VARIABLES:       lena%      Length of a$
  '                  i%         Looping index
  '                  j%         Looping index
  '                  k%         Looping index
  ' MODULE LEVEL
  '   DECLARATIONS:  DECLARE SUB ParseWord (a$, sep$, word$)
  '
    SUB ParseWord (a$, sep$, word$) STATIC
        word$ = ""
        lena% = LEN(a$)
        IF a$ = "" THEN
            EXIT SUB
        END IF
        FOR i% = 1 TO lena%
            IF INSTR(sep$, MID$(a$, i%, 1)) = 0 THEN
                EXIT FOR
            END IF
        NEXT i%
        FOR j% = i% TO lena%
            IF INSTR(sep$, MID$(a$, j%, 1)) THEN
                EXIT FOR
            END IF
        NEXT j%
        FOR k% = j% TO lena%
            IF INSTR(sep$, MID$(a$, k%, 1)) = 0 THEN
                EXIT FOR
            END IF
        NEXT k%
        IF i% > lena% THEN
            a$ = ""
            EXIT SUB
        END IF
        IF j% > lena% THEN
            word$ = MID$(a$, i%)
            a$ = ""
            EXIT SUB
        END IF
        word$ = MID$(a$, i%, j% - i%)
        IF k% > lena% THEN
            a$ = ""
        ELSE
            a$ = MID$(a$, k%)
        END IF
    END SUB

    SUB PrtCtrDisp (PrtRec%) STATIC
        SELECT CASE PrtRec%
        CASE IS = 1             ' 3
            CALL LocRowCol(15, 15)
            PRINT "Working    |"
        CASE IS = 2             '6
            CALL LocRowCol(15, 15)
            PRINT "Working    / "
        CASE IS = 3             '   9
            CALL LocRowCol(15, 15)
            PRINT "Working    - "
        CASE IS = 4             ' 12
            CALL LocRowCol(15, 15)
            PRINT "Working    \ "
        CASE ELSE
          '  IF PrtRec% > 12 THEN PrtRec% = 1
            IF PrtRec% > 4 THEN PrtRec% = 1
        END SELECT
      
    END SUB

    SUB ReportTPLs (TPL%, Fhandle%)
        SELECT CASE TPL%
        CASE IS = 1
            IF HighAscii% THEN
              'Template # 1
                PRINT #Fhandle%, "Ŀ"
                PRINT #Fhandle%, " Part I - Message Transfers & Calls "
                PRINT #Fhandle%, "͵"
                PRINT #Fhandle%, "Zone:Net/Node    Telephone Calls         Message Bytes       CPS  Tran"
                PRINT #Fhandle%, "    Number     Out  Connect  In  Outgoing     Incoming    Avg   Min"
                PRINT #Fhandle%, "͵"
            ELSE
                PRINT #Fhandle%, "+------------------+------------------------------------+------------------+"
                PRINT #Fhandle%, "|xxxxxxxxxxxxxxxxxx| Part I - Message Transfers & Calls |xxxxxxxxxxxxxxxxxx|"
                PRINT #Fhandle%, "+==============+===+================+=========================+======+=====+"
                PRINT #Fhandle%, "|Zone:Net/Node |   Telephone Calls  |       Message Bytes     |  CPS | Tran|"
                PRINT #Fhandle%, "|    Number    | Out | Connect | In | Outgoing   |  Incoming  |  Avg |  Min|"
                PRINT #Fhandle%, "+==============+=====+=========+====+============+============+======+====+"
            END IF
        CASE IS = 2
            IF HighAscii% THEN
              'Template # 2
                PRINT #Fhandle%, ";"
            ELSE
                PRINT #Fhandle%, ">==========================================================================+"
            END IF
        CASE IS = 3
            IF HighAscii% THEN
              'Template # 3
                PRINT #Fhandle%, "Ŀ"
                PRINT #Fhandle%, " PART II - Network File Transfers "
                PRINT #Fhandle%, "͵"
                PRINT #Fhandle%, "Zone:Net/Node                            File Bytes          CPS  Tran"
                PRINT #Fhandle%, "    Number         File Names      Outgoing     Incoming   Rate   Min"
                PRINT #Fhandle%, "͵"
            ELSE
                PRINT #Fhandle%, "+-------------------+----------------------------------+-------------------+"
                PRINT #Fhandle%, "|xxxxxxxxxxxxxxxxxxx| PART II - Network File Transfers |xxxxxxxxxxxxxxxxxxx|"
                PRINT #Fhandle%, "+==============+====+===============+==================+======+======+=====+"
                PRINT #Fhandle%, "|Zone:Net/Node |                    |       File Bytes        |  CPS | Tran|"
                PRINT #Fhandle%, "|    Number    |     File Names     | Outgoing   |  Incoming  | Rate |  Min|"
                PRINT #Fhandle%, "+==============+====================+============+============+======+=====+"
            END IF
        CASE IS = 4
            IF HighAscii% THEN
              'Template # 4
                PRINT #Fhandle%, "                  No records to process for this report.                  "
            ELSE
                PRINT #Fhandle%, "|                  No records to process for this report.                  |"
            END IF
        CASE IS = 5
            IF HighAscii% THEN
              'Template # 5
                PRINT #Fhandle%, "Ŀ"
                PRINT #Fhandle%, " PART III - Network Session Costs "
                PRINT #Fhandle%, "͵"
                PRINT #Fhandle%, "Zone:Net/Node      Logged At             Session Time          Cost    "
                PRINT #Fhandle%, "    Number      Date      Time        Hrs  Mins  Secs               "
                PRINT #Fhandle%, "͵"
            ELSE
                PRINT #Fhandle%, "+-------------------+----------------------------------+-------------------+"
                PRINT #Fhandle%, "|xxxxxxxxxxxxxxxxxxx| PART III - Network Session Costs |xxxxxxxxxxxxxxxxxxx|"
                PRINT #Fhandle%, "+==============+====+===============+==================+======+============+"
                PRINT #Fhandle%, "|Zone:Net/Node |     Logged At      |       Session Time      |    Cost    |"
                PRINT #Fhandle%, "|    Number    |  Date   |   Time   |     Hrs | Mins | Secs   |            |"
                PRINT #Fhandle%, "+==============+=========+==========+=========+======+========+============+"
            END IF
        CASE IS = 6
            IF HighAscii% THEN
              'Template # 6
                PRINT #Fhandle%, "          No Network Session Costs recorded for the period covered.       "
            ELSE
              
                PRINT #Fhandle%, "|          No Network Session Costs recorded for the period covered.       |"
            END IF
        CASE IS = 7
            IF HighAscii% THEN
              'Template # 7
                PRINT #Fhandle%, "Ŀ"
                PRINT #Fhandle%, "    PART IV - Undialable Nodes    "
                PRINT #Fhandle%, "͵"
            ELSE
                PRINT #Fhandle%, "+-------------------+----------------------------------+-------------------+"
                PRINT #Fhandle%, "|xxxxxxxxxxxxxxxxxxx|    PART IV - Undialable Nodes    |xxxxxxxxxxxxxxxxxxx|"
                PRINT #Fhandle%, "+===================+==================================+===================+"
            END IF
        CASE IS = 8
            IF HighAscii% THEN
              'Template # 8
                PRINT #Fhandle%, "Ŀ"
                PRINT #Fhandle%, " PART  V - SUMMARY  "
                PRINT #Fhandle%, "͵"
            ELSE
                PRINT #Fhandle%, "+--------------------------+--------------------+--------------------------+"
                PRINT #Fhandle%, "|xxxxxxxxxxxxxxxxxxxxxxxxxx| PART  V - SUMMARY  |xxxxxxxxxxxxxxxxxxxxxxxxxx|"
                PRINT #Fhandle%, "+==========================+====================+==========================+"
            END IF
        CASE IS = 9
            IF HighAscii% THEN
              'Template # 9
                PRINT #Fhandle%, "Ĵ"
            ELSE
                PRINT #Fhandle%, "+--------------------------------------------------------------------------+"
            END IF
        END SELECT
    END SUB

