; STARTUP.ASM for ASM16 version 4.0 or greater
; Copyright (C) 1994 Douglas Herr
;  all rights reserved

include	asm.inc

extrn	meminit:proc
extrn	breaktrap:proc
extrn	breakrelease:proc
extrn	mymain:proc

; make LINK search through the ASM16 library for external references
; so I don't have to specify the library on the command line
IF codesize EQ 1
IF datasize EQ 2
	IFDEF	NOXT
	includelib	asm286h
	ELSE
	includelib	asm86h
	ENDIF
ELSE
	IFDEF	NOXT
	includelib	asm286m
	ELSE
	includelib	asm86m
	ENDIF
ENDIF
ELSE
	IFDEF	NOXT
	includelib	asm286s
	ELSE
	includelib	asm86s
	ENDIF
ENDIF

; declare CODE segment before DATA segment
.code
@curseg	ends

stacksize	equ	1024

.stack stacksize

.data
public	pspseg
pspseg		dw	?		; storage for PSP segment

.code
start:
; start by pointing DS to DGROUP
	mov	dx,@data
	mov	ds,dx
	assume	ds:@data

; adjust for MS-LINK bug that puts SS in wrong segment
; THIS ADJUSTMENT IS REQURIED BY SEVERAL ASM16 SUBROUTINES
	mov	ax,ss
	sub	ax,dx			; paragraph difference
	mov	cl,4
	shl	ax,cl			; converted to bytes
	add	sp,ax			; fix SP for new SS
	mov	ss,dx			; assume ss:DGROUP

; save PSP segment for programs running under DOS 2.xx
	mov	pspseg,es

; Release memory beyond the end of the program.  This makes dynamic
; memory allocation possible.  MEMINIT does this automatically, as well
; as initializing the near heap.  When it's done, MEMINIT self destructs,
; leaving only a RET in case it's called again.
;
; CAUTION: Borland's TD debugger has trouble tracing through the self-
; destructing part of MEMINIT.  If you are using TD, step over MEMINIT
; instead of tracing through it.

	mov	bx,0FFFFh		; request dynamic heap allocation
	mov	ax,32767		; heap size requested
	call	meminit

; prevent an unintended program crash; trap Ctrl+Break, Ctrl+C and
; Ctrl+Alt+Del key combinations
	call	breaktrap

; call your main program here
	call	mymain

exit:
; de-activate the Ctrl+Break trap
	call	breakrelease

; normal program exit
	mov	ax,4C00h
	int	21h

end	start
	end
