; MODECHNG.ASM - Sample program for ASMLIB graphics
; Programmer: Douglas Herr
; date: 5/24/1992

; detect video equipment and switch to highest resolution mode available
; does not attempt to detect non-default monitor or SVGA or VESA equipment

include	asm.inc

public	graphmode, textmode

extrn	getcrt:proc, hgraph0:proc, htext:proc
extrn	crtinfo:proc, mode43:proc, hram8043:proc
extrn	viewlimit:proc
extrn	svga256:proc

.data
public	maxx, maxy
crt	dw 0
maxx	dw 0
maxy	dw 0
nocard	db 'graphics card required',0Dh,0Ah,7,'$'
rows	dw 25
grmode	db 0,0

.code
graphmode	proc
;	mov	ax,3
;	call	svga256
;	mov	ah,3
;	jmp	g10

	xor	ah,ah
	call	crtinfo
	mov	rows,ax
	call	getcrt
	mov	crt,ax
	cmp	al,-1
	je	cga
	cmp	al,127
	ja	hercules
	or	al,al
	jnz	evga

	or	ah,ah
	jnz	egamono
	lea	dx,nocard	; point to error message
	jmp	oops		; exit with CF = 1

egamono:mov	ax,000Fh
	int	10h
	mov	ah,07h
	jmp	short g10

; if CGA, use 2-color "high" resolution mode
cga:	mov	ax,6
	push	bp
	int	10h
	pop	bp
	mov	ah,03h
	jmp	short g10

; EGA color, VGA color or MCGA
evga:	add	al,0Fh
	int	10h
	mov	ah,03h
	jmp	short g10

hercules:
	call	hgraph0
	mov	ax,0708h

g10:	mov	word ptr grmode,ax
	call	viewlimit
	mov	ax,es:[bx]
	mov	maxx,ax
	mov	ax,es:2[bx]
	mov	maxy,ax
	clc
	ret
oops:	stc
	ret
graphmode	endp


; use TextMode to return to text mode after calling GraphMode
; call with: no parameters
; returns: nothing in particular
; uses: AX, flags
textmode	proc
	mov	ax,word ptr grmode
	cmp	al,08h
	je	herctext
	mov	al,ah
	xor	ah,ah

	push	bp
	int	10h
	pop	bp
	cmp	rows,25
	jbe	t9
	call	mode43
t9:	ret

herctext:
	call	htext
	cmp	rows,25
	jbe	t10
	call	hram8043
t10:	ret
textmode	endp

	end
