#// File    : DEMO.MAK
#// Author  : Eric Woodruff,  CIS ID: 72134,1150
#// Updated : Mon 03/06/95 20:39:31
#// Note    : Copyright 1995, Eric Woodruff, All rights reserved
#// Compiler: Borland C++ 4.xx
#//
#   Makefile for building the DPMI Exception Handler Library demo.  Unless
#   overridden by command line flags, this will generate a DPMI 16 application.
#
# Flags for DEMO.MAK:
#
# These command line switches alter the build flags used during
# compilation.  You can use them to alter the build characteristics or you
# can edit the default option flag settings in the make file down below.
#
#     -DDOS32        Build the 32-bit version - DPMIEX32.LIB.  If not
#                    specified, the 16-bit version is built - DPMIEXCP.LIB
#
#     -DOPT32        Compiler bugs prevent use of the optimization options
#                    for 32-bit protected mode apps prior to BC++ 4.5.
#                    BC++ 4.5 fixes the bugs, so define OPT32 to utilize
#                    the optimization features of the 32-bit compiler.
#
#     -DDEBUG        Include full debug info in the library and turn off all
#                    optimizations.  Library name used depends on the
#                    above settings:
#                       DPMIEXCD.LIB - 16-bit protected mode
#                       DPMIEX3D.LIB - 32-bit protected mode
#
#     -DBCROOT=...   Specifies the path where you installed the compiler
#                    (i.e. C:\BC, C:\BC4, C:\BORLANDC, etc.)
#
#     -DALIGNMENT=2  Optional word (=2) or dword (=4) aligned library.
#     -DALIGNMENT=4
#
# Examples:
#     make                    - 16-bit protected mode (DPMIEXCP.LIB)
#     make -DDOS32 -DOPT32    - Optmized 32-bit protected mode (DPMIEX32.LIB)
#     make -DDOS32 -DDEBUG    - 32 bit protected mode with full debug info
#

.autodepend
.swap
.silent

# ****************** Uncomment the appropriate lines to default to a
# ****************** specific build mode.

# The value assigned is not important.  It's just to get the defintion
# into existence.  If all are commented out, it defaults to BC++ 4.0/4.02
# with Turbo Vision 2.0.

# DOS32  =
# OPT32  =
# DEBUG  =

# ****************** Here's where to adjust the base directory location

!if !$d(BCROOT)
BCROOT = C:\BC4
!endif

# Set include file and library locations.
INCLUDE  = $(BCROOT)\INCLUDE;.;..;..\DPMIEXCP
LIBDIR   = $(BCROOT)\LIB

# ******************* Set up for 32 bit protected mode compile
!if $d(DOS32)

!if $d(DEBUG)
CFGNAME = DEMO32D.CFG
LIBNAME = DPMIEX3D.LIB
OBJDIR  = OBJS32D
!else
CFGNAME = DEMO32.CFG
LIBNAME = DPMIEX32.LIB
OBJDIR  = OBJS32
!endif

CPUFLAG    = -3
TARGETFLAG = -WX
LINKFLAGS  = /Tpe /ax
STARTUP    = c0x32.obj
USERLIBS   = $(LIBNAME)
STDLIBS    = dpmi32.lib cw32.lib
DPMIDEF    = DPMI32.DEF

CC      = BCC32
LIB     = TLIB
LINK    = TLINK32

!else   # DOS32

# ******************* Set up for 16 bit protected mode compile

!if $d(DEBUG)
CFGNAME = DEMO16D.CFG
LIBNAME = DPMIEXCD.LIB
OBJDIR  = OBJS16D
!else
CFGNAME = DEMO16.CFG
LIBNAME = DPMIEXCP.LIB
OBJDIR  = OBJS16
!endif

CPUFLAG    = -2
TARGETFLAG = -WX -ml
LINKFLAGS  = /Txe
STARTUP    = c0x.obj
USERLIBS   = $(LIBNAME)
STDLIBS    = dpmi16.lib emux.lib mathwl.lib cwl.lib
DPMIDEF    = DPMI16.DEF

CC      = BCC
LIB     = TLIB
LINK    = TLINK

!endif # DOS32

# ******************* Set other compiler options

!if $d(ALIGNMENT)
ALIGNFLAG = -a$(ALIGNMENT)
!else
ALIGNFLAG =
!endif

# ******************* Set debug and optimization options

CFLAGS1    =
CFLAGSN32  =

!if $d(DEBUG)

# NOTE: Don't use Stack Overflow Checking!
#       The exception handler switches stacks and this really messes
#       up the stack checking code.  Also turn this option off for
#       any module that has functions called by the exception handler
#       (i.e. clean up and exit code).
CDEBUGFLAG = /v -k -N-
LINKFLAGS  = $(LINKFLAGS) /v

!else

CDEBUGFLAG = /v- /DNDEBUG -k- -N- -G-

# These optimization options **cannot** be used for the BC++ 4.0/4.02
# 32-bit protected mode compiler due to bugs.   However, BC++ 4.5 fixes
# these bugs, so define OPT32 to include these optimizations if you have it.
!if !$d(DOS32) || $d(OPT32)
CFLAGSN32 = -Oe -Os -O -Ob -Ol -Z
!endif

!if !$d(DOS32)
CFLAGSN32 = -h -OW
!endif

!endif

# Put them all together.  Compiler options are spread across three definitions
# because they can exceed 128 characters per line which causes it to fail.
CFLAGS1 = $(CFLAGS1) -RT- -x- -ff -w -w-sig -w-amp -P- -n$(OBJDIR)
CFLAGS2 = $(CDEBUGFLAG) $(ALIGNFLAG) $(CCOVYFLAGS) $(CPUFLAG) $(CFLAGSN32)
CFLAGS3 = -I$(INCLUDE) /DREPORT_EMS_XMS

# ******************* Build dependencies

DEMONAME = EXCPTEST

.path.obj = $(OBJDIR)

# Go ahead and build them.

.c.obj:
     $(CC) -c +$(CFGNAME) {$< }

all: $(CFGNAME) dirs $(DEMONAME).exe

dirs:
    IF NOT EXIST $(OBJDIR) MD $(OBJDIR)

$(CFGNAME): demo.mak
    ECHO $(TARGETFLAG) $(CFLAGS1) > $(CFGNAME)
    ECHO $(CFLAGS2) >> $(CFGNAME)
    ECHO $(CFLAGS3) >> $(CFGNAME)

$(DEMONAME).exe: $(DEMONAME).obj
  $(LINK) @&&|
$(LINKFLAGS)/L$(LIBDIR) +       # linker options
$(STARTUP) +                    # startup code
$(OBJDIR)\$(DEMONAME).obj       # object files
$(DEMONAME)                     # exe name
$(DEMONAME)                     # mapfile
$(USERLIBS) +                   # user libraries
$(STDLIBS)                      # standard libraries
$(DPMIDEF)                      # DPMI .DEF file (if any)
|

# End of DPMI Exception Handler Library demo program make file
