// File    : DPMIEXCP.CPP/.C
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Mon 03/06/95 20:39:31
// Note    : Copyright 1995, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 4.xx
//
// This file contains the custom exception handler class functions.
// The code in here is generic enough that it will work without modification
// for either the 16-bit or 32-bit protected mode version.
//*
//* NOTE: IF MODIFICATIONS ARE MADE TO ONE FILE, SIMPLY COPY THIS TO THE OTHER!
//*
//* DPMIEXCP.CPP --> DPMIEXCP.C     or      DPMIEXCP.C --> DPMIEXCP.CPP
//*

#include <stdlib.h>
#include <windows.h>

#include <dpmiexcp.h>

#if !defined(__FLAT__)

#ifdef __cplusplus

// An array of pointers to the custom handler functions for
// exceptions 00 through 10h.  None are trapped by default.
DPMICustomHandler DPMIExceptionHandler::customFuncs[17] = {
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };

// Static exception information structure.
DPMIExceptionData DPMIExceptionHandler::exceptionInfo = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 0, NULL, 0, NULL };

#else

// An array of pointers to the custom handler functions for
// exceptions 00 through 10h.  None are trapped by default.
DPMICustomHandler customFuncs[17] = {
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };

// Static exception information structure.
struct DPMIExceptionData exceptionInfo = {
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 0, NULL, 0, NULL };

#endif  // ifdef __cplusplus

#else

// The 32-bit version also needs to access the data selector in
// a slightly different manner.
unsigned short DataSel;

#ifdef __cplusplus

// The 32-bit version needs an array of twice the size due to
// the storage of 64-bit pointers.
DPMICustomHandler DPMIExceptionHandler::customFuncs[34] = {
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };

// Static exception information structure.
DPMIExceptionData DPMIExceptionHandler::exceptionInfo = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0 };

#else

// The 32-bit version needs an array of twice the size due to
// the storage of 64-bit pointers.
DPMICustomHandler customFuncs[34] = {
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL,
    NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL };

// Static exception information structure.
struct DPMIExceptionData exceptionInfo = {
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, NULL, 0, NULL, 0, NULL, 0 };

#endif  // ifdef __cplusplus

#endif

#ifdef __cplusplus

// Initialize the static flag data member.
int DPMIExceptionHandler::exceptionsTrapped = 0;

// In Exception Handler flag.  Prevents an endless loop of exceptions.
int DPMIExceptionHandler::inExceptionHandler = 0;

// Handle and pointer to the custom handler's stack.  The constructor
// allocates memory for it with GlobalAlloc().
HGLOBAL     DPMIExceptionHandler::stackHandle = NULL;
char _HUGE *DPMIExceptionHandler::stackPointer = NULL;

// Pointer for the recovery function.  By default, it won't do anything.
DPMICustomHandler DPMIExceptionHandler::RecoveryFunction = DefaultRecovery;

// Pointer for the clean-up function.  By default, it won't do anything.
ExceptionCleanUp DPMIExceptionHandler::CleanUpFunction = DefaultCleanUp;

// Create a global instance of the class to hook up the entry stubs at
// startup automatically.  This is done prior to calling main() by the
// startup code.
static DPMIExceptionHandler excp;

#else   // ifdef __cplusplus

// Initialize the static flag data member.
int exceptionsTrapped = 0;

// In Exception Handler flag.  Prevents an endless loop of exceptions.
int inExceptionHandler = 0;

// Handle and pointer to the custom handler's stack.  The constructor
// allocates memory for it with GlobalAlloc().
HGLOBAL     stackHandle = NULL;
char _HUGE *stackPointer = NULL;

// Pointer for the recovery function.  By default, it won't do anything.
DPMICustomHandler RecoveryFunction = DefaultRecovery;

// Pointer for the clean-up function.  By default, it won't do anything.
ExceptionCleanUp CleanUpFunction = DefaultCleanUp;

#endif  // ifdef __cplusplus

// ****************************************************************************

// NOTE: Don't confuse this with a custom exception handler!  The recovery
//       function is intended to be called *by* the custom exception handler.
//       It's just a quick way to write a generic handler that can be used
//       by any application.  The generic handler can call the recovery
//       function to handle the application-specific recovery.
//
// You may be able to recover from some exceptions if you know how.
// In those cases, simply do what is necessary and return 1 so that
// the caller will return from the exception handler and continue as
// if nothing happened.  If you are unable to recover from the exception
// or don't want to, return 0 so that it can take the appropriate action.
int DefaultRecovery(struct DPMIExceptionData *ex)
{
    // For overflow exceptions, just carry on at the current Fault CS:(E)IP.
    if(ex->ExceptionNumber == 4)
        return 1;

    return 0;       // No recovery, just exit.
}

// Default exit function used below.
void JustExit(void)
{
    // Act like an abort function() by returning 3.  However, instead of
    // calling _exit() it calls exit() (no leading underscore).  Buffers
    // are flushed, files are closed, global objects are destroyed, and
    // functions registered with atexit() are called.
    exit(3);
}

// Every application will have different clean-up requirements.  By creating
// your own function and pointing CleanUpFunction at it, you can attempt to
// make a more graceful exit (i.e. close files, shut down the user interface,
// etc).  By default, it will do nothing.  ExitType will be zero if it will
// exit via the original handler upon return, or 1 if it will attempt to
// exit via your own function (set ex->FaultCSIP.CS_IP to the address
// of your "clean up and exit" function.
void DefaultCleanUp(int ExitType, struct DPMIExceptionData *ex)
{
    // If not going through the original handler on exit, this default
    // function must make the return address point to something other than
    // the address that caused the exception or it will crash.

#if !defined(__FLAT__)
    // Chaining to the original vector will not work for exception 5
    // because it will reflect it as an interrupt (INT 5 = Print Screen)
    // and it gets stuck in an endless loop.  A regular press of the
    // Print Screen key will *NOT* invoke the exception handler though.
    if(ExitType || ex->ExceptionNumber == 5)
        ex->FaultCSIP.CS_IP = JustExit;

#else
    if(ExitType || ex->ExceptionNumber == 5)
    {
        ex->FaultCSEIP.EIP_CS.Offset = (int)JustExit;
        ex->FaultCSEIP.EIP_CS.Selector = _CS;
    }
#endif
}

// ****************************************************************************

// Route the exceptions through dispatch and allocate a stack for the
// custom handlers.
#ifdef __cplusplus
DPMIExceptionHandler::DPMIExceptionHandler(void)
#else
void DPMIExceptionHandlerCtor(void)
#endif
{
#if defined(__FLAT__)
    DataSel = _DS;          // Initialize DataSel for the 32-bit version.
#endif

    // Allocate memory for the custom handler's stack and lock it.
    // This memory is used for the stack because the SS:(E)SP on entry
    // could be invalid.  2K is allocated, increase it if necessary.
    stackHandle = GlobalAlloc(GMEM_FIXED | GMEM_NODISCARD, 2048);

    // Only trap exceptions if memory was allocated for the stack.
    if(stackHandle != NULL)
    {
        // Point to end of stack (remember, it works from the end back!)
        stackPointer = (char _HUGE *)GlobalLock(stackHandle) + 2046;
        trapExceptions();

#ifndef __cplusplus
        atexit(DPMIExceptionHandlerDtor);   // Call C "destructor" at exit
#endif
    }
}

// Release the exceptions handlers.  Note that the stack memory is *NOT*
// released.  It could be in use as the active stack segment if the exit
// is due to an exception.  Freeing that memory would cause a GPF.
#ifdef __cplusplus
DPMIExceptionHandler::~DPMIExceptionHandler(void)
#else
void DPMIExceptionHandlerDtor(void)
#endif
{
    releaseExceptions();
}

// Install a custom exception handler function.  Call with 'Function'
// set to NULL to remove the custom exception handler.
// This function returns 0 on failure, 1 on success.
#ifdef __cplusplus
int DPMIExceptionHandler::setExceptionHandler(int Exception,
    DPMICustomHandler Function)
#else
int setExceptionHandler(int Exception, DPMICustomHandler Function)
#endif
{
#ifndef __cplusplus
    // Call the "constructor" for the C version if it hasn't been
    // called already.
    if(!stackPointer)
        DPMIExceptionHandlerCtor();
#endif

    if(Exception < 0 || Exception > 16)
        return 0;

#if !defined(__FLAT__)

    customFuncs[Exception] = Function;

#else

    Exception *= 2;

    customFuncs[Exception] = Function;
    customFuncs[Exception + 1] = (DPMICustomHandler)_CS;
#endif

    return 1;
}

// Get the current pointer value for the given exception.  Useful for
// getting an address if you temporarily swap or remove exception handlers,
// etc. If NULL is returned, no custom exception handler is in place.
#ifdef __cplusplus
const DPMICustomHandler DPMIExceptionHandler::getExceptionHandler(
    int Exception)
#else
const DPMICustomHandler getExceptionHandler(int Exception)
#endif
{
    if(Exception < 0 || Exception > 16)
        return NULL;

#if defined(__FLAT__)
    Exception *= 2;
#endif

    return customFuncs[Exception];
}
