;// File    : DPMIX16A.ASM
;// Author  : Eric Woodruff,  CIS ID: 72134,1150
;// Updated : Mon 03/06/95 20:39:31
;// Note    : Copyright 1995, Eric Woodruff, All rights reserved
;// Compiler: TASM 4.0
;//
;// tasm /m2 /ml /q /w2 /z[n|i] [/DC_VERSION] [/DNOTRAP] dpmix16a.asm
;//
;// This file contains the 16-bit protected mode custom exception handler
;// trapping and release functions and low level code.  The trapping function
;// routes exceptions 00h through 10h to the general entry points found
;// below.  All they do is push their exception number onto the stack and
;// jump down to the dispatch code.  The dispatch code checks the function
;// pointer array to see if a custom handler has been installed for the
;// exception that is occuring.  If the entry is NULL, it simply jumps to the
;// prior exception handler (probably terminating the application in an
;// inelegant fashion).  If the entry is not NULL, it places a call to the
;// user-defined function.  Once inside the function, the user can modify
;// almost any of the items in the passed structure including the fault CS:IP
;// which usually points to the faulting instruction.  If the user-defined
;// function returns 0 in AX, the dispatch function will jump to the old
;// handler.  If the user-defined function returns a non-zero value in AX,
;// it will assume that the user-defined function has fixed the situation and
;// will return to the address contained in ex->FaultCSIP.  Note that you
;// can point this to a clean-up function that closes open files, unhooks
;// interrupts, etc and then gracefully exits the application.
;//

; *****************************************************************************
; The PC is at least a 286 because it is running a 16-bit protected mode
; application

        P286

IFNDEF C_VERSION
        MODEL   LARGE
ELSE
        MODEL   LARGE, C
ENDIF

; *****************************************************************************
; Static array in the DPMIExceptionHandler class.  It contains the addresses
; of any user-defined exception handler functions.  Each array element
; corresponds to the given exception (00h-10h).

IFNDEF C_VERSION

; An array of pointers to the custom handler functions
EXTRN NOLANGUAGE    @DPMIExceptionHandler@customFuncs:DWORD

; Flag to determine whether or not the exceptions have already been
; trapped by this application.
EXTRN NOLANGUAGE    @DPMIExceptionHandler@exceptionsTrapped:WORD

; Flag to prevent an endless loop of exceptions.  If non-zero when
; checked, a subsequent exception is routed to the original handler.
EXTRN NOLANGUAGE    @DPMIExceptionHandler@inExceptionHandler:WORD

; Pointer to the custom handler's stack.
EXTRN NOLANGUAGE    @DPMIExceptionHandler@stackPointer:DWORD

; Static structure used to hold the exception data upon entry to the
; dispatch function.
EXTRN NOLANGUAGE    @DPMIExceptionHandler@exceptionInfo:WORD

; Equates to skip the IFDEFs in the code.
@@customFuncs@@         EQU     @DPMIExceptionHandler@customFuncs
@@exceptionsTrapped@@   EQU     @DPMIExceptionHandler@exceptionsTrapped
@@inExceptionHandler@@  EQU     @DPMIExceptionHandler@inExceptionHandler
@@stackPointer@@        EQU     @DPMIExceptionHandler@stackPointer
@@exceptionInfo@@       EQU     @DPMIExceptionHandler@exceptionInfo

ELSE

; An array of pointers to the custom handler functions
EXTRN   C   customFuncs:DWORD

; Flag to determine whether or not the exceptions have already been
; trapped by this application.
EXTRN   C   exceptionsTrapped:WORD

; Flag to prevent an endless loop of exceptions.  If non-zero when
; checked, a subsequent exception is routed to the original handler.
EXTRN   C   inExceptionHandler:WORD

; Pointer to the custom handler's stack.
EXTRN   C   stackPointer:DWORD

; Static structure used to hold the exception data upon entry to the
; dispatch function.
EXTRN   C   exceptionInfo:WORD

; Equates to skip the IFDEFs in the code.
@@customFuncs@@         EQU     customFuncs
@@exceptionsTrapped@@   EQU     exceptionsTrapped
@@inExceptionHandler@@  EQU     inExceptionHandler
@@stackPointer@@        EQU     stackPointer
@@exceptionInfo@@       EQU     exceptionInfo

ENDIF

; *****************************************************************************
; Pointer array for the original vectors.  The original vector is jumped to
; when no custom handler is installed or when the custom handler returns zero.

        DATASEG

originalVectors     dd  17 dup(0)
OldSS               dw  0               ; Saved SS:SP
OldSP               dw  0

; *****************************************************************************
; The active data segment upon entry to the exception handler may not belong
; to our application.  This is in the code segment to insure that we can get
; at the application's true data segment.  This gives us a proper reference to
; the data segment.

        CODESEG

DataSel     dw      @data

; *****************************************************************************
; Entry points for the exception handlers.  I found it easier to trap them
; all and route them through a dispatch function instead of trying to trap
; each one individually.  It's much cleaner this way.  The dispatch code
; takes care of setup, calling the function, and clean up.  All you need to
; do is tell it what function to call.

@@EntryPoints:

    push    0                           ; Push the exception number and
    jmp     short @@ExceptionDispatch   ; dispatch the exception to the
                                        ; proper handler code.
    push    1
    jmp     short @@ExceptionDispatch

    push    2
    jmp     short @@ExceptionDispatch

    push    3
    jmp     short @@ExceptionDispatch

    push    4
    jmp     short @@ExceptionDispatch

    push    5
    jmp     short @@ExceptionDispatch

    push    6
    jmp     short @@ExceptionDispatch

    push    7
    jmp     short @@ExceptionDispatch

    push    8
    jmp     short @@ExceptionDispatch

    push    9
    jmp     short @@ExceptionDispatch

    push    0Ah
    jmp     short @@ExceptionDispatch

    push    0Bh
    jmp     short @@ExceptionDispatch

    push    0Ch
    jmp     short @@ExceptionDispatch

    push    0Dh
    jmp     short @@ExceptionDispatch

    push    0Eh
    jmp     short @@ExceptionDispatch

    push    0Fh
    jmp     short @@ExceptionDispatch

    push    10h             ; We're already there, so no need to JMP.

; -----------------------------------------------------------------------------
; At this point, the stack frame contains the following exception data:
;
;       Stack selector (SS)                     -----+
;       Stack pointer  (SP)                          | Pushed by the
;       CPU Flags                                    | caller (DPMI server)
;       Code selector (fault location)       (CS)    |
;       Instruction pointer (fault location) (IP)    |
;       Error code                              -----+
;
;       Return CS (to caller - DO NOT MODIFY)   -----+ Pushed by the CALL
;       Return IP (to caller - DO NOT MODIFY)   -----+ to get here.
;
;       Exception number (pushed by the above entry point code)
;
; The dispatch code below adds the following data to the stack frame:
;
;       ES
;       DS
;       AX, CX, DX, BX, original SP, BP, SI, DI  (pushed by PUSHA)
;
; Note: 'original SP' can be ignored.  It's just a by-product of PUSHA.

@@ExceptionDispatch:

    push    es
    push    ds
    pusha
    mov     bp, sp

    mov     ds, cs:[DataSel]    ; Point to the application's data segment.
                                ; We arrive here on the server's locked
                                ; stack so there is no need to switch stacks.

    mov     bx, [bp + 20]       ; Exception function address = Ex. Number * 4 +
    shl     bx, 2               ; <table offset>
    add     bx, offset @@customFuncs@@

    mov     ax, [bx]            ; If no custom handler is installed,
    or      ax, [bx + 2]        ; jump to the original vector.
    jz      short CallOldHandler

    ; Call the old handler if the exception handler has caused an exception.
    cmp     @@inExceptionHandler@@, 0
    jne     short CallOldHandler

    push    ds                  ; This exception has a custom handler.
    pop     es
    mov     di, offset @@exceptionInfo@@

    push    ds
    push    ss
    pop     ds
    mov     si, bp              ; Top of the exception data (ex->DI).

    cld
    mov     cx, 19              ; Move the exception data to the holding area.
    rep     movsw
    pop     ds

    mov     ax, cs              ; ex->FaultCSIP = @@CallHandler.
    mov     [bp + 30], ax
    mov     ax, offset @@CallHandler
    mov     [bp + 28], ax

    popa
    pop     ds
    pop     es
    add     sp, 2               ; Get rid of the exception number.

    retf                        ; Return to the server which will then
                                ; route us to @@CallHandler below.

; -----------------------------------------------------------------------------
CallOldHandler:

    popa                        ; Restore the original register values.
    pop     ds
    pop     es

; Okay, this looks rather odd, but it's the easiest way I could find
; to get the right return address on the stack and still preserve the
; stack frame and register values that were there upon entry.
;
; Create a stack position for the second word of the return address.
; The exception number pushed by the entry point is still on the stack and
; it is simply reused for the first word of the return address.

    push    ax

    push    bp                  ; Save BP and get the base stack pointer.
    mov     bp, sp

    push    ds                  ; Save these for the original handler.
    push    ax
    push    bx

    mov     ds, cs:[DataSel]    ; Need our DS once again.

    mov     bx, [bp + 4]        ; Original vector address = Ex. Number * 4 +
    shl     bx, 2               ; <table offset>
    add     bx, offset originalVectors

    mov     ax, word ptr [bx + 2]   ; Create a "return" address.
    mov     word ptr [bp + 4], ax
    mov     ax, word ptr [bx]
    mov     word ptr [bp + 2], ax

    pop     bx                  ; Pop the saved values.
    pop     ax
    pop     ds
    pop     bp

    retf                        ; Jump to the original vector.

; -----------------------------------------------------------------------------
; If the custom handler is to be called, we end up here.  This will actually
; call the custom handler and take the appropriate action upon return.
; The 16-bit handler probably doesn't have to do it this way, but the 32-bit
; handler does.  We can't call the custom handler from the dispatch code
; because in 32-bit protected mode, the assumption that DS=ES=SS does NOT
; hold.  SS points to the server's locked stack and the ES and DS selectors
; may or may not belong to us.  Calling the custom handler from there would
; result in additional exceptions due to improper use of selectors.  Up until
; then I had not found it to be a problem in 16-bit protected mode because it
; doesn't make that assumption (DS=ES=SS).  However, I wanted to keep the code
; as similar as possible between platforms and the documentation I've got
; seems to imply that this is the preferred method.

; Note that no register values are preserved here.  All registers will be
; loaded from the exceptionInfo structure prior to returning either to the
; user's routine or the original exception handler vector.

@@CallHandler:

    mov     ds, cs:[DataSel]    ; Reload DS incase the exception was due to
                                ; a problem with it.

    mov     si, offset @@exceptionInfo@@
    les     di, dword ptr [@@stackPointer@@]

    ; Switch stacks to insure that SS:(E)SP is valid.  The old SS:(E)SP is
    ; *NOT* saved for stack exceptions.  Chances are good that the old
    ; SS:(E)SP are invalid and cannot be used below.
    mov     bx, [si + 20]
    cmp     bx, 12
    jne     short NotStackException

    mov     OldSS, es           ; Use the custom handler stack instead
    mov     OldSP, di           ; when exiting.
    jmp     short StackException

NotStackException:
    mov     OldSS, ss           ; Save the original SS:(E)SP
    mov     OldSP, sp

StackException:
    mov     ax, es
    mov     ss, ax
    mov     sp, di

    inc     @@inExceptionHandler@@

    ; Exception function address = Ex. Number * 4 + <table offset>
    shl     bx, 2
    add     bx, offset @@customFuncs@@

    push    ds                  ; Pointer to the exception information.
    push    offset @@exceptionInfo@@

    call    dword ptr ds:[bx]   ; Call the custom exception handler.
    add     sp, 4

    or      ax, ax              ; Does the user want to call the old handler?

    jz      short CallOriginalHandler       ; Yes.

; Return to the address is ex->FaultCSIP.  First though, we must recreate
; the proper stack frame.

    dec     @@inExceptionHandler@@

    mov     si, offset @@exceptionInfo@@ + 18

    mov     ax, [si + 14]       ; Push the original flags on the stack
    push    ax

    mov     cx, 10
    std

PushLoop0:
    lodsw
    push    ax                  ; Push the PUSHA, DS, and ES register values.
    loop    PushLoop0

    popa                        ; Now restore the registers and return
    pop     ds                  ; to the original exception handler vector.
    pop     es
    popf                        ; Restore flags.

    mov     ss, OldSS           ; And finally, restore the original SS:SP
    mov     sp, OldSP

; Okay, this looks rather odd, but it's the easiest way I could find
; to get the right return address on the stack and still preserve the
; stack frame and register values that were there upon entry.

    push    ax                  ; Create stack positions for the
    push    ax                  ; return address.

    push    bp                  ; Save BP and get the base stack pointer.
    mov     bp, sp

    push    ax                  ; Save these for the original handler.
    push    bx
    pushf

    ; Create a "return" address.
    mov     bx, offset @@exceptionInfo@@ + 28
    mov     ax, word ptr [bx + 2]
    mov     word ptr [bp + 4], ax
    mov     ax, word ptr [bx]
    mov     word ptr [bp + 2], ax

    popf                        ; Pop the saved values.
    pop     bx
    pop     ax
    pop     bp

    retf                        ; Jump to the address.

; -----------------------------------------------------------------------------
; Return to the original exception vector.  First though, we must recreate
; the proper stack frame.

CallOriginalHandler:

    dec     @@inExceptionHandler@@

    mov     si, offset @@exceptionInfo@@ + 36
    mov     cx, 8
    std

PushLoop1:
    lodsw
    push    ax                  ; Push the exception data.
    loop    PushLoop1

    lodsw                       ; Skip exception number.

    mov     cx, 10

PushLoop2:
    lodsw
    push    ax                  ; Push the PUSHA, DS, and ES register values.
    loop    PushLoop2

    popa                        ; Now restore the registers and return
    pop     ds                  ; to the original exception handler vector.
    pop     es

; Okay, this looks rather odd, but it's the easiest way I could find
; to get the right return address on the stack and still preserve the
; stack frame and register values that were there upon entry.

    push    ax                  ; Create stack positions for the
    push    ax                  ; return address.

    push    bp                  ; Save BP and get the base stack pointer.
    mov     bp, sp

    push    ds                  ; Save these for the original handler.
    push    bx
    push    si

    mov     ds, cs:[DataSel]    ; Need our DS once again.

    ; Original vector address = Ex. Number * 4 + <table offset>
    mov     si, offset @@exceptionInfo@@ + 20
    mov     bx, [si]
    shl     bx, 2
    add     bx, offset originalVectors

    mov     si, word ptr [bx + 2]   ; Create a "return" address.
    mov     word ptr [bp + 4], si
    mov     si, word ptr [bx]
    mov     word ptr [bp + 2], si

    pop     si                  ; Pop the saved values.
    pop     bx
    pop     ds
    pop     bp

    retf                        ; Jump to the original vector.

; *****************************************************************************
; *****************************************************************************

; The GetSegmentLimit function is used to return the limit for a given
; segment selector.
;
; Parameters: Segment selector value
;             Address of an 'int' to store the limit
;
;    Returns: AX = 0 - Bad selector
;             AX = 1 - Success
;

    PUBLIC  C   GetSegmentLimit

GetSegmentLimit     PROC    C
    push    bp
    mov     bp, sp

    mov     bx, [bp + 6]        ; Get segment selector
    lsl     cx, bx              ; Load the limits
    mov     ax, 1
    jz      short GoodSelector  ; Is it valid?

    xor     ax, ax              ; No.

GoodSelector:
    les     bx, dword ptr [bp + 8]  ; Store the limit.
    mov     word ptr es:[bx], cx

    pop     bp
    ret

GetSegmentLimit     endp

; *****************************************************************************
; This is the function that is used to store the original vectors and hook up
; the entry points for exceptions 00h through 10h.
;
IFNDEF C_VERSION

    PUBLIC @DPMIExceptionHandler@trapExceptions$qv

@DPMIExceptionHandler@trapExceptions$qv     PROC

ELSE
    PUBLIC trapExceptions

trapExceptions     PROC     C

ENDIF
    ; If they've already been trapped, ignore the request.
    cmp     @@exceptionsTrapped@@, 0
    jnz     short AlreadyTrapped

    push    di

    cld
    mov     ax, 0202h           ; Get exception handler vector.
    xor     bx, bx

    push    ds
    pop     es
    mov     di, offset originalVectors

GetVectors:
    int     31h
    inc     bl

    mov     word ptr [di], dx   ; CX:DX = Selectior:Offset of original vector.
    mov     word ptr [di + 2], cx
    add     di, 4

    cmp     bl, 11h             ; Only handles exceptions 00h-10h.
    jne     short GetVectors

    xor     bx, bx              ; Now hook up the entry points.
    push    cs
    pop     cx                  ; CX:DX = Entry point address.
    mov     dx, offset @@EntryPoints

    mov     ax, 0203h           ; Set exception handler vector.

SetVectors:

IFDEF NOTRAP
    cmp     bl, 1               ; If told not to, don't trap vectors
    jb      short NoSkip        ; 01, 02, 03, and 0F.
    cmp     bl, 4
    jb      short SkipVectors
    cmp     bl, 0Fh
    je      short SkipVectors
ENDIF

NoSkip:
    int     31h

SkipVectors:
    inc     bl
    add     dx, 4               ; PUSH immed16/JMP short = 4 bytes.

    cmp     bl, 11h
    jne     short SetVectors

    pop     di

    inc     @@exceptionsTrapped@@    ; Flag them as trapped.

AlreadyTrapped:

    ret

IFNDEF C_VERSION
@DPMIExceptionHandler@trapExceptions$qv     ENDP
ELSE
trapExceptions     ENDP
ENDIF

; *****************************************************************************
; This is the function that restores the original exception handler vectors.
;
IFNDEF C_VERSION

    PUBLIC @DPMIExceptionHandler@releaseExceptions$qv

@DPMIExceptionHandler@releaseExceptions$qv      PROC

ELSE

    PUBLIC releaseExceptions

releaseExceptions   PROC    C

ENDIF
    ; If they've already been released, ignore the request.
    cmp     @@exceptionsTrapped@@, 0
    je      short AlreadyReleased

    push    si

    cld
    mov     si, offset originalVectors

    xor     bx, bx
    mov     ax, 0203h           ; Set exception handler vector.

RestoreVectors:

IFDEF NOTRAP
    cmp     bl, 1               ; If told not to trap them, don't restore
    jb      short NoSkip2       ; vectors 01, 02, 03, and 0F.
    cmp     bl, 4
    jb      short SkipRestore
    cmp     bl, 0Fh
    je      short SkipRestore
ENDIF

NoSkip2:
    mov     dx, word ptr [si]   ; CX:DX = Original vector.
    mov     cx, word ptr [si + 2]

    int     31h

SkipRestore:
    inc     bl
    add     si, 4

    cmp     bl, 11h
    jne     short RestoreVectors

    pop     si

    dec     @@exceptionsTrapped@@    ; Flag them as released.

AlreadyReleased:

    ret

IFNDEF C_VERSION
@DPMIExceptionHandler@releaseExceptions$qv      ENDP
ELSE
releaseExceptions      ENDP
ENDIF
        end
