;// File    : DPMIX32A.ASM
;// Author  : Eric Woodruff,  CIS ID: 72134,1150
;// Updated : Mon 03/06/95 20:39:31
;// Note    : Copyright 1995, Eric Woodruff, All rights reserved
;// Compiler: TASM 4.0
;//
;// tasm /m2 /ml /q /w2 /z[n|i] [/DC_VERSION] [/DNOTRAP] dpmix32a.asm
;//
;// This file contains the 32-bit protected mode custom exception handler
;// trapping and release functions and low level code.  The trapping function
;// routes exceptions 00h through 10h to the general entry points found
;// below.  All they do is push their exception number onto the stack and
;// jump down to the dispatch code.  The dispatch code checks the function
;// pointer array to see if a custom handler has been installed for the
;// exception that is occuring.  If the entry is NULL, it simply jumps to the
;// prior exception handler (probably terminating the application in an
;// inelegant fashion).  If the entry is not NULL, it places a call to the
;// user-defined function.  Once inside the function, the user can modify
;// almost any of the items in the passed structure including the fault CS:EIP
;// which usually points to the faulting instruction.  If the user-defined
;// function returns 0 in AX, the dispatch function will jump to the old
;// handler.  If the user-defined function returns a non-zero value in AX,
;// it will assume that the user-defined function has fixed the situation and
;// will return to the address contained in ex->FaultCSEIP.  Note that you
;// can point this to a clean-up function that closes open files, unhooks
;// interrupts, etc and then gracefully exits the application.
;//

; *****************************************************************************
; The PC is at least a 386 because it is running a 32-bit protected mode
; application

        P386

IFNDEF C_VERSION
        MODEL   FLAT
ELSE
        MODEL   FLAT, C
ENDIF

; *****************************************************************************
; Static array in the DPMIExceptionHandler class.  It contains the addresses
; of any user-defined exception handler functions.  Each array element
; corresponds to the given exception's CS and EIP (00h-10h).  Because we
; can't store a 48 bit pointer, there are two elements for every exception.
; One for the CS value and one for the EIP value.  The same thing applies
; to the originalVectors array below.

IFNDEF C_VERSION

; An array of pointers to the custom handler functions
EXTRN NOLANGUAGE    @DPMIExceptionHandler@customFuncs:DWORD

; Flag to determine whether or not the exceptions have already been
; trapped by this application.
EXTRN NOLANGUAGE    @DPMIExceptionHandler@exceptionsTrapped:DWORD

; Flag to prevent an endless loop of exceptions.  If non-zero when
; checked, a subsequent exception is routed to the original handler.
EXTRN NOLANGUAGE    @DPMIExceptionHandler@inExceptionHandler:DWORD

; Pointer to the custom handler's stack.
EXTRN NOLANGUAGE    @DPMIExceptionHandler@stackPointer:DWORD

; Static structure used to hold the exception data upon entry to the
; dispatch function.
EXTRN NOLANGUAGE   @DPMIExceptionHandler@exceptionInfo:DWORD

; Equates to skip the IFDEFs in the code.
@@customFuncs@@         EQU     @DPMIExceptionHandler@customFuncs
@@exceptionsTrapped@@   EQU     @DPMIExceptionHandler@exceptionsTrapped
@@inExceptionHandler@@  EQU     @DPMIExceptionHandler@inExceptionHandler
@@stackPointer@@        EQU     @DPMIExceptionHandler@stackPointer
@@exceptionInfo@@       EQU     @DPMIExceptionHandler@exceptionInfo

ELSE

; An array of pointers to the custom handler functions
EXTRN   C   customFuncs:DWORD

; Flag to determine whether or not the exceptions have already been
; trapped by this application.
EXTRN   C   exceptionsTrapped:DWORD

; Flag to prevent an endless loop of exceptions.  If non-zero when
; checked, a subsequent exception is routed to the original handler.
EXTRN   C   inExceptionHandler:DWORD

; Pointer to the custom handler's stack.
EXTRN   C   stackPointer:DWORD

; Static structure used to hold the exception data upon entry to the
; dispatch function.
EXTRN   C   exceptionInfo:DWORD

; Equates to skip the IFDEFs in the code.
@@customFuncs@@         EQU     customFuncs
@@exceptionsTrapped@@   EQU     exceptionsTrapped
@@inExceptionHandler@@  EQU     inExceptionHandler
@@stackPointer@@        EQU     stackPointer
@@exceptionInfo@@       EQU     exceptionInfo

ENDIF

; In 32-bit protected mode, the CS and DS selectors are mapped to the
; same 1 Meg of memory so the offset of DataSel is the same for both the
; CS and DS selectors.  All we need to do is load the value via CS:[DataSel].
EXTRN   C             DataSel:WORD

; *****************************************************************************
; Pointer array for the original vectors.  The original vector is jumped to
; when no custom handler is installed or when the custom handler returns zero.

        DATASEG

originalVectors     dd  34 dup(0)
OldSS               dw  0               ; Saved SS:ESP
OldESP              dd  0

; *****************************************************************************

        CODESEG

; *****************************************************************************
; Entry points for the exception handlers.  I found it easier to trap them
; all and route them through a dispatch function instead of trying to trap
; each one individually.  It's much cleaner this way.  The dispatch code
; takes care of setup, calling the function, and clean up.  All you need to
; do is tell it what function to call.

@@EntryPoints:

    push    large 0                     ; Push the exception number and
    jmp     short @@ExceptionDispatch   ; dispatch the exception to the
                                        ; proper handler code.
    push    large 1
    jmp     short @@ExceptionDispatch

    push    large 2
    jmp     short @@ExceptionDispatch

    push    large 3
    jmp     short @@ExceptionDispatch

    push    large 4
    jmp     short @@ExceptionDispatch

    push    large 5
    jmp     short @@ExceptionDispatch

    push    large 6
    jmp     short @@ExceptionDispatch

    push    large 7
    jmp     short @@ExceptionDispatch

    push    large 8
    jmp     short @@ExceptionDispatch

    push    large 9
    jmp     short @@ExceptionDispatch

    push    large 0Ah
    jmp     short @@ExceptionDispatch

    push    large 0Bh
    jmp     short @@ExceptionDispatch

    push    large 0Ch
    jmp     short @@ExceptionDispatch

    push    large 0Dh
    jmp     short @@ExceptionDispatch

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;TEST!!!!
;;
;; Simulate a call to the exception handler.
;;
;;@@returnHere:
;;
;;    push    0FFFFFFFFh
;;    push    ss
;;    push    esp
;;    pushfd
;;    push    cs
;;    push    offset @@returnHere
;;    push    0000FFFFh
;;    push    cs
;;    call    @@pushExcp
;;
;;    nop
;;    nop
;;    nop
;;    nop
;;
;;@@pushExcp:
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;TEST!!!!
    push    large 0Eh
    jmp     short @@ExceptionDispatch

    push    large 0Fh
    jmp     short @@ExceptionDispatch

    push    large 10h       ; We're already there, so no need to JMP.

; -----------------------------------------------------------------------------
; At this point, the stack frame contains the following exception data:
;
;       Stack selector (SS)                     -----+
;       Stack pointer  (ESP)                         | Pushed by the
;       CPU Flags                                    | caller (DPMI server)
;       Code selector (fault location)       (CS)    |
;       Instruction pointer (fault location) (EIP)   |
;       Error code                              -----+
;
;       Return CS (to caller - DO NOT MODIFY)   -----+ Pushed by the CALL
;       Return EIP (to caller - DO NOT MODIFY)  -----+ to get here.
;
;       Exception number (pushed by the above entry point code)
;
; The dispatch code below adds the following data to the stack frame:
;
;       ES
;       DS
;       EAX, ECX, EDX, EBX, original ESP, EBP, ESI, EDI  (pushed by PUSHAD)
;
; Note: 'original ESP' can be ignored.  It's just a by-product of PUSHAD.

@@ExceptionDispatch:

    push    es                  ; NOTE:  ES and DS are 16-bit registers
    push    ds                  ;        but *32 BITS* are pushed onto the
    pushad                      ;        stack.  The upper word is '0000'.
    mov     ebp, esp

    mov     ds, cs:[DataSel]    ; Point to the application's data segment.
                                ; We arrive here on the server's locked
                                ; stack so there is no need to switch stacks.

    mov     ebx, [ebp + 40]     ; Exception function address = Ex. Number * 8 +
    shl     ebx, 3              ; <table offset>
    add     ebx, offset @@customFuncs@@

    mov     eax, [ebx]          ; If no custom handler is installed,
    or      eax, [ebx + 4]      ; jump to the original vector.
    jz      short CallOldHandler

    ; Call the old handler if the exception handler has caused an exception.
    cmp     @@inExceptionHandler@@, 0
    jne     short CallOldHandler

    push    ds                  ; This exception has a custom handler.
    pop     es
    mov     edi, offset @@exceptionInfo@@

    push    ds
    push    ss
    pop     ds
    mov     esi, ebp            ; Top of the exception data (ex->DI).

    cld
    mov     ecx, 19             ; Move the exception data to the holding area.
    rep     movsd

    mov     eax, cr2            ; Get the linear address that caused it.
    stosd
    pop     ds

    xor     eax, eax
    mov     ax, cs             ; ex->FaultCSEIP = @@CallHandler.
    mov     [ebp + 60], eax
    mov     eax, offset @@CallHandler
    mov     [ebp + 56], eax

    popad
    pop     ds
    pop     es
    add     esp, 4              ; Get rid of the exception number.

    retf                        ; Return to the server which will then
                                ; route us to @@CallHandler below.

; -----------------------------------------------------------------------------
CallOldHandler:

    popad                       ; Restore the original register values.
    pop     ds
    pop     es

; Okay, this looks rather odd, but it's the easiest way I could find
; to get the right return address on the stack and still preserve the
; stack frame and register values that were there upon entry.
;
; Create a stack position for the second word of the return address.
; The exception number pushed by the entry point is still on the stack and
; it is simply reused for the first dword of the return address.

    push    eax

    push    ebp                 ; Save BP and get the base stack pointer.
    mov     ebp, esp

    push    ds                  ; Save these for the original handler.
    push    eax
    push    ebx

    mov     ds, cs:[DataSel]    ; Need our DS once again.

    mov     ebx, [ebp + 8]      ; Original vector address = Ex. Number * 8 +
    shl     ebx, 3              ; <table offset>
    add     ebx, offset originalVectors

    mov     eax, dword ptr [ebx + 4]    ; Create a "return" address.
    mov     dword ptr [ebp + 8], eax
    mov     eax, dword ptr [ebx]
    mov     dword ptr [ebp + 4], eax

    pop     ebx                 ; Pop the saved values.
    pop     eax
    pop     ds
    pop     ebp

    retf                        ; Jump to the original vector.

; -----------------------------------------------------------------------------
; If the custom handler is to be called, we end up here.  This will actually
; call the custom handler and take the appropriate action upon return.
; The 16-bit handler probably doesn't have to do it this way, but the 32-bit
; handler does.  We can't call the custom handler from the dispatch code
; because in 32-bit protected mode, the assumption that DS=ES=SS does NOT
; hold.  SS points to the server's locked stack and the ES and DS selectors
; may or may not belong to us.  Calling the custom handler from there would
; result in additional exceptions due to improper use of selectors.  Up until
; then I had not found it to be a problem in 16-bit protected mode because it
; doesn't make that assumption (DS=ES=SS).  However, I wanted to keep the code
; as similar as possible between platforms and the documentation I've got
; seems to imply that this is the preferred method.

; Note that no register values are preserved here.  All registers will be
; loaded from the exceptionInfo structure prior to returning either to the
; user's routine or the original exception handler vector.

@@CallHandler:

    mov     ds, cs:[DataSel]    ; Reload DS incase the exception was due to
                                ; a problem with it.

    mov     es, cs:[DataSel]    ; Same for ES.

    mov     esi, offset @@exceptionInfo@@
    mov     edi, dword ptr [@@stackPointer@@]

    ; Switch stacks to insure that SS:(E)SP is valid.  The old SS:(E)SP is
    ; *NOT* saved for stack exceptions.  Chances are good that the old
    ; SS:(E)SP are invalid and cannot be used below.
    mov     ebx, dword ptr [esi + 40]
    cmp     ebx, 12
    jne     short NotStackException

    mov     OldSS, es           ; Use the custom handler stack instead
    mov     OldESP, edi         ; when exiting.
    jmp     short StackException

NotStackException:
    mov     OldSS, ss           ; Save the original SS:(E)SP
    mov     OldESP, esp

StackException:
    mov     ax, es
    mov     ss, ax
    mov     esp, edi

    inc     @@inExceptionHandler@@

    ; Exception function address = Ex. Number * 8 + <table offset>
    shl     ebx, 3
    add     ebx, offset @@customFuncs@@

    ; Pointer to the exception information.
    push    offset @@exceptionInfo@@

    call    dword ptr ds:[ebx]  ; Call the custom exception handler.
    add     esp, 4

    or      eax, eax            ; Does the user want to call the old handler?

    jz      short CallOriginalHandler       ; Yes.

; Return to the address is ex->FaultCSEIP.  First though, we must recreate
; the proper stack frame.

    dec     @@inExceptionHandler@@

    mov     esi, offset @@exceptionInfo@@ + 36

    mov     eax, [esi + 28]     ; Push the original flags on the stack
    push    eax

    mov     ecx, 10
    std

PushLoop0:
    lodsd
    push    eax                 ; Push the PUSHAD, DS, and ES register values.
    loop    PushLoop0

    popad                       ; Now restore the registers and return
    pop     ds                  ; to the original exception handler vector.
    pop     es
    popfd                       ; Restore flags.

    mov     ss, OldSS           ; And finally, restore the original SS:ESP
    mov     esp, OldESP

; Okay, this looks rather odd, but it's the easiest way I could find
; to get the right return address on the stack and still preserve the
; stack frame and register values that were there upon entry.

    push    eax                 ; Create stack positions for the
    push    eax                 ; return address.

    push    ebp                 ; Save BP and get the base stack pointer.
    mov     ebp, esp

    push    eax                 ; Save these for the original handler.
    push    ebx
    pushfd

    ; Create a "return" address.
    mov     ebx, offset @@exceptionInfo@@ + 56
    mov     eax, dword ptr [ebx + 4]
    mov     dword ptr [ebp + 8], eax
    mov     eax, dword ptr [ebx]
    mov     dword ptr [ebp + 4], eax

    popfd                       ; Pop the saved values.
    pop     ebx
    pop     eax
    pop     ebp

    retf                        ; Jump to the address.

; -----------------------------------------------------------------------------
; Return to the original exception vector.  First though, we must recreate
; the proper stack frame.

CallOriginalHandler:

    dec     @@inExceptionHandler@@

    mov     esi, offset @@exceptionInfo@@ + 72
    mov     ecx, 8
    std

PushLoop1:
    lodsd
    push    eax                 ; Push the exception data.
    loop    PushLoop1

    lodsd                       ; Skip exception number.

    mov     ecx, 10

PushLoop2:
    lodsd
    push    eax                 ; Push the PUSHAD, DS, and ES register values.
    loop    PushLoop2

    popad                       ; Now restore the registers and return
    pop     ds                  ; to the original exception handler vector.
    pop     es

; Okay, this looks rather odd, but it's the easiest way I could find
; to get the right return address on the stack and still preserve the
; stack frame and register values that were there upon entry.

    push    eax                 ; Create stack positions for the
    push    eax                 ; return address.

    push    ebp                 ; Save BP and get the base stack pointer.
    mov     ebp, esp

    push    ds                  ; Save these for the original handler.
    push    ebx
    push    esi

    mov     ds, cs:[DataSel]    ; Need our DS once again.

    ; Original vector address = Ex. Number * 8 + <table offset>
    mov     esi, offset @@exceptionInfo@@ + 40
    mov     ebx, [esi]
    shl     ebx, 3
    add     ebx, offset originalVectors

    mov     esi, dword ptr [ebx + 4]   ; Create a "return" address.
    mov     dword ptr [ebp + 8], esi
    mov     esi, dword ptr [ebx]
    mov     dword ptr [ebp + 4], esi

    mov     esi, offset @@exceptionInfo@@ + 76

;;;;;;;;;;;;;;;;;;;;;;;;;;;TEST!!!!
;;    mov     ebx, cr2       ; Test to see what's in CR2 at this point.
;;;;;;;;;;;;;;;;;;;;;;;;;;;TEST!!!!

    mov     ebx, [esi]          ; Restore the CR2 value that was in effect.
    mov     cr2, ebx

    pop     esi                 ; Pop the saved values.
    pop     ebx
    pop     ds
    pop     ebp

    retf                        ; Jump to the original vector.

; *****************************************************************************
; *****************************************************************************

; The GetSegmentLimit function is used to return the limit for a given
; segment selector.
;
; Parameters: Segment selector value
;             Address of an 'int' to store the limit
;
;    Returns: EAX = 0 - Bad selector
;             EAX = 1 - Success
;

    PUBLIC  C   GetSegmentLimit

GetSegmentLimit     PROC    C
    push    ebp
    mov     ebp, esp
    push    ebx

    mov     ebx, [ebp + 8]      ; Get segment selector
    lsl     ecx, ebx            ; Load the limits
    mov     eax, 1
    jz      short GoodSelector  ; Is it valid?

    xor     eax, eax            ; No.

GoodSelector:
    mov     ebx, dword ptr [ebp + 12]
    mov     dword ptr [ebx], ecx        ; Store the limit.

    pop     ebx
    pop     ebp
    ret

GetSegmentLimit     endp

; *****************************************************************************
; This is the function that is used to store the original vectors and hook up
; the entry points for exceptions 00h through 10h.
;
IFNDEF C_VERSION

    PUBLIC @DPMIExceptionHandler@trapExceptions$qv

@DPMIExceptionHandler@trapExceptions$qv     PROC

ELSE
    PUBLIC trapExceptions

trapExceptions     PROC     C

ENDIF
    ; If they've already been trapped, ignore the request.
    cmp     @@exceptionsTrapped@@, large 0
    jnz     short AlreadyTrapped

    push    bx                  ; BC++ 4.xx may use (E)BX like EDI and ESI!
    push    edi

    cld
    mov     ax, 0202h           ; Get exception handler vector.
    xor     bx, bx

    mov     edi, offset originalVectors

GetVectors:
    int     31h
    inc     bl

    mov     dword ptr [edi], edx   ; CX:EDX = Selectior:Offset of original vector.
    mov     dword ptr [edi + 4], ecx
    add     edi, 8

    cmp     bl, 11h             ; Only handles exceptions 00h-10h.
    jne     short GetVectors

    xor     bx, bx              ; Now hook up the entry points.
    push    cs                  ; 16-bit reg, but 32-bits are pushed!
    pop     ecx                 ; CX:EDX = Entry point address.
    mov     edx, offset @@EntryPoints

    mov     ax, 0203h           ; Set exception handler vector.

SetVectors:

IFDEF NOTRAP
    cmp     bl, 1               ; If told not to, don't trap vectors
    jb      short NoSkip        ; 01, 02, 03, and 0F.
    cmp     bl, 4
    jb      short SkipVectors
    cmp     bl, 0Fh
    je      short SkipVectors
ENDIF

NoSkip:
    int     31h

SkipVectors:
    inc     bl
    add     edx, 4              ; PUSH immed16/JMP short = 4 bytes.

    cmp     bl, 11h
    jne     short SetVectors

    pop     edi
    pop     bx

    inc     @@exceptionsTrapped@@   ; Flag them as trapped.

AlreadyTrapped:

    ret

IFNDEF C_VERSION
@DPMIExceptionHandler@trapExceptions$qv     ENDP
ELSE
trapExceptions     ENDP
ENDIF

; *****************************************************************************
; This is the function that restores the original exception handler vectors.
;
IFNDEF C_VERSION

    PUBLIC @DPMIExceptionHandler@releaseExceptions$qv

@DPMIExceptionHandler@releaseExceptions$qv      PROC

ELSE

    PUBLIC releaseExceptions

releaseExceptions   PROC    C

ENDIF
    ; If they've already been released, ignore the request.
    cmp     @@exceptionsTrapped@@, large 0
    je      short AlreadyReleased

    push    bx                  ; BC++ 4.xx may use (E)BX like EDI and ESI!
    push    esi

    cld
    mov     esi, offset originalVectors

    xor     bx, bx
    mov     ax, 0203h           ; Set exception handler vector.

RestoreVectors:

IFDEF NOTRAP
    cmp     bl, 1               ; If told not to trap them, don't restore
    jb      short NoSkip2       ; vectors 01, 02, 03, and 0F.
    cmp     bl, 4
    jb      short SkipRestore
    cmp     bl, 0Fh
    je      short SkipRestore
ENDIF

NoSkip2:
    mov     edx, dword ptr [esi]   ; CX:EDX = Original vector.
    mov     ecx, dword ptr [esi + 4]

    int     31h

SkipRestore:
    inc     bl
    add     esi, 8

    cmp     bl, 11h
    jne     short RestoreVectors

    pop     esi
    pop     bx

    dec     @@exceptionsTrapped@@   ; Flag them as released.

AlreadyReleased:

    ret

IFNDEF C_VERSION
@DPMIExceptionHandler@releaseExceptions$qv      ENDP
ELSE
releaseExceptions      ENDP
ENDIF
        end
