// File    : EXCPHND.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Mon 03/06/95 20:39:31
// Note    : Copyright 1995, Eric Woodruff, All rights reserved
// Compiler: Borland 4.xx
//
// C/C++ version of the custom exception handler (no UI library)
//

#if !defined(__EXCPHND_H)
#define __EXCPHND_H

#if !defined(__DPMIEXCP_H)
#include <dpmiexcp.h>
#endif

// Replacement abort() function to prevent abnormal termination
// without proper clean-up.  Just make sure that the EXCPHND.CPP/.C module
// is linked in prior to the standard library so that this one gets used.

void abort(void);

// The generic exception handler.  An 'int' return type is used so that the
// prototype can be used in either 16 or 32-bit protected mode.
// Use this as the parameter for DPMIExceptionHandler::setExceptionHandler().

int AppExceptionHandler(struct DPMIExceptionData *ex);

// This function displays the exception data and returns a string of
// valid characters to be used for a selection.
char *DisplayExceptionData(struct DPMIExceptionData *ex);

#endif      // __EXCPHND_H
