// File    : EXCPTEST.C
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Mon 03/06/95 20:39:31
// Note    : Copyright 1995, Eric Woodruff, All rights reserved
// Compiler: Borland 4.xx
//
// C++ version of the demo program (no UI library)
//

#include <conio.h>
#include <ctype.h>
#include <stdio.h>
#include <stdlib.h>

// Define the DPMI exception handler stuff.
#include <excphnd.h>

// ****************************************************************************

int ExitValue = 0;

// ****************************************************************************

void AppExceptionExit(void)
{
    // This is just for the demo program's atexit() function.
    ExitValue = 999;

    //
    // This is the only mandatory part: Call exit() to terminate the program.
    //
    // Act like an abort function() by returning 3.  However, instead of
    // calling _exit() it calls exit() (no leading underscore).  Buffers
    // are flushed, files are closed, global objects are destroyed, and
    // functions registered with atexit() are called.
    exit(3);
}

// This is a generic clean-up function that can be used for any
// application.  You can use this as a starting point for your own
// applications.
void AppCleanUp(int ExitType, struct DPMIExceptionData *ex)
{
    if(!ExitType)
    {
        // If terminating via the original exception vector, make sure
        // that you shutdown any user interfaces, disconnect interrupts, etc.
        // Otherwise, a lock-up would soon follow the return to DOS.

        // Return and let the original handler display its information.
        return;
    }

    // Otherwise, termination will take place via a custom function.
    // All we need to do is store its address in the fault CI:(E)IP address
    // of the exception data structure.
    //
    // That function can simply call exit or contain additional code to
    // disconnect user interrupts, etc.
    //

#if !defined(__FLAT__)

    ex->FaultCSIP.CS_IP = AppExceptionExit;

#else

    ex->FaultCSEIP.EIP_CS.Offset = (int)AppExceptionExit;
    ex->FaultCSEIP.EIP_CS.Selector = _CS;

#endif
}

// ****************************************************************************

void doOption(char opt)
{
    int x, y, z, array[6] = { 0, 3, 1, 2, 3, 4 };
    char *p;

    switch(opt)
    {
        case '0':
            x = 1;      // Force a divide by zero exception (0)
            y = 0;
            z = x / y;
            x += z;

            break;

        case '4':
            _AL = 0xFF;
            _BL = 0xFF;

#if !defined(__FLAT__)
            asm {
                mul     bl          // Force an overflow exception (4)
                into
            }
#else
            __emit__(0xF6);         // mul bl
            __emit__(0xE3);

            __emit__(0xCE);         // into
#endif
            break;

        case '5':
#if !defined(__FLAT__)
            // Generate a BOUND exception (5)
            asm mov     ax, 4
            asm push    ss
            asm pop     es
            asm lea     bx, array
            asm bound   ax, es:[bx]
#else
            _EBX = (unsigned long)&array[0];
            _EAX = 4;

            __emit__(0x62);         // bound eax, [ebx]
            __emit__(0x03);
#endif
            break;

        case '6':
            __emit__(0x0F);     // Emit a CPUID instruction which causes
            __emit__(0xA2);     // an invalid opcode exception (6) on all
                                // but a Pentium and a few recent 486's.
            break;

        case 'C':
            // Force a stack exception (12)
#if !defined(__FLAT__)
            asm {
                xor     bp, bp
                mov     ax, [bp - 6]
            }
#else
            __emit__(0x33);             // xor ebp, ebp
            __emit__(0xED);
            __emit__(0x8B);             // mov eax, [ebp - 6]
            __emit__(0x45);
            __emit__(0xFA);
#endif
            break;

        case 'D':
            // Force a GPF (exception 13, DPMI16) or a page fault
            // (exception 14, DPMI32) via a NULL pointer access.
            p = NULL;

            *p = 'X';

            break;

        case 'S':
            // If you use spawn() or system(), you *MUST* release
            // the exception traps *before* the call!  If you don't
            // and the other application causes an exception, this
            // application's handler may pop up.  That's just asking
            // for trouble.  Another reason is that if the other
            // application traps exceptions and doesn't release them,
            // you could end up with the vectors pointing into undefined
            // memory space upon return to this application.
            releaseExceptions();

            system("test16.exe");
            puts("Press any key...");
            getch();

            // When you return, retrap the exceptions.
            trapExceptions();

            break;

        default:
            break;
    }
}

void exitFunc(void)
{
    if(ExitValue == 999)
        puts("An exception caused the program to terminate");
    else
        puts("The application terminated normally.");
}

void main(void)
{
    char option = ' ';

    // Exception handler setup

    // Point to the clean-up function.
    CleanUpFunction = AppCleanUp;

    // Hook the exceptions you want to trap.
    setExceptionHandler(0, AppExceptionHandler);
//    setExceptionHandler(1, AppExceptionHandler);
//    setExceptionHandler(3, AppExceptionHandler);
    setExceptionHandler(4, AppExceptionHandler);
    setExceptionHandler(5, AppExceptionHandler);
    setExceptionHandler(6, AppExceptionHandler);
//    setExceptionHandler(11, AppExceptionHandler);
    setExceptionHandler(12, AppExceptionHandler);
    setExceptionHandler(13, AppExceptionHandler);
    setExceptionHandler(14, AppExceptionHandler);

    atexit(exitFunc);

    while(option != 'X')
    {
        clrscr();

        puts("\nDPMI Exception Handler Test\n");
        puts("0 - 00 Divide by zero");
        puts("4 - 04 Overflow");
        puts("5 - 05 BOUND");
        puts("6 - 06 Invalid opcode");
        puts("C - 0C Stack exception");
        puts("D - 0D/0E GPF/Page Fault\n");
        puts("S - DOS Shell");
        puts("X - Exit\n");

        option = toupper(getch());

        if(option != 'X')
            doOption(option);
    }

    // Always release the exception handlers prior to exit.
    releaseExceptions();

    exit(0);
}
