#// File    : MAKEFILE.MAK
#// Author  : Eric Woodruff,  CIS ID: 72134,1150
#// Updated : Mon 03/06/95 20:39:31
#// Note    : Copyright 1995, Eric Woodruff, All rights reserved
#// Compiler: Borland C++ 4.xx
#//
#   Makefile for building the DPMI Exception Handler Library.
#   Unless overridden by command line flags, this will generate a DPMI16
#   version of the library called DPMIEXCP.LIB.
#
# File location assumptions:
#
# Directory Layout:
#   DPMIEXCP              - Base directory. The name is not significant.
#   DPMIEXCP\DPMIEXCP     - DPMI exception handler source files directory.
#   DPMIEXCP\C            - C version of the make files and demo
#   DPMIEXCP\CPP          - C++ version of the make files and demo
#   DPMIEXCP\TV           - Turbo Vision version of the make files and demo
#   DPMIEXCP\<dir>\OBJ??? - Object file dir(s) generated by the build.  Each
#                           build uses a unique name for the object directory
#                           associated with the library being created.  Once
#                           the lib(s) are built, you can delete these.
#
# Flags for MAKEFILE.MAK:
#
# These command line switches alter the build flags used during
# compilation.  You can use them to alter the build characteristics or you
# can edit the default option flag settings in the make file down below.
#
#     -DNOTRAP       Specify that exceptions 01, 02, 03, and 0F should NOT
#                    be trapped.  Done automatically for debugging.
#
#     -DNOTASM       Use this if you don't have Turbo Assembler 4.0.
#
#     -DDOS32        Build the 32-bit version - DPMIEX32.LIB.  If not
#                    specified, the 16-bit version is built - DPMIEXCP.LIB
#
#     -DOPT32        Compiler bugs prevent use of the optimization options
#                    for 32-bit protected mode apps prior to BC++ 4.5.
#                    BC++ 4.5 fixes the bugs, so define OPT32 to utilize
#                    the optimization features of the 32-bit compiler.
#
#     -DDEBUG        Include full debug info in the library and turn off all
#                    optimizations.  Library name generated depends on the
#                    above settings:
#                       DPMIEXCD.LIB - 16-bit protected mode
#                       DPMIEX3D.LIB - 32-bit protected mode
#
#     -DBCROOT=...   Specifies the path where you installed the compiler
#                    (i.e. C:\BC, C:\BC4, C:\BORLANDC, etc.)
#
#     -DALIGNMENT=2  Optional word (=2) or dword (=4) aligned library.
#     -DALIGNMENT=4
#
# Examples:
#     make                    - 16-bit protected mode (DPMIEXCP.LIB)
#     make -DDOS32 -DOPT32    - Optmized 32-bit protected mode (DPMIEX32.LIB)
#     make -DDOS32 -DDEBUG    - 32 bit protected mode with full debug info
#     make -DNOTASM           - 16-bit protected mode, no TASM.
#

.autodepend
.swap

# ****************** Uncomment the appropriate lines to default to a
# ****************** specific build mode.

# The value assigned is not important.  It's just to get the defintion
# into existence.  If all are commented out, it defaults to BC++ 4.0/4.02
# with Turbo Vision 2.0 and TASM is available for use.

# NOTASM =
# DOS32  =
# OPT32  =
# DEBUG  =

# ****************** Here's where to adjust the base directory location

!if !$d(BCROOT)
BCROOT = C:\BC4
!endif

# Set include file locations and default response file name.
INCLUDE = $(BCROOT)\INCLUDE;.;..;..\DPMIEXCP

RSPNAME = DPMI16.RSP
PCOMPDIR = .

# ******************* Set up for 32 bit protected mode compile
!if $d(DOS32)

!if $d(DEBUG)
CFGNAME = DPMIEX3D.CFG
LIBNAME = DPMIEX3D.LIB
OBJDIR  = OBJS32D
!else
CFGNAME = DPMIEX32.CFG
LIBNAME = DPMIEX32.LIB
OBJDIR  = OBJS32
!endif

RSPNAME = DPMI32.RSP
CPUFLAG = -3
TARGETFLAG = -WX

CC      = BCC32
ASM     = TASM32
LIB     = TLIB
LINK    = TLINK32
AFLAGS32 = /D__FLAT__

!else   # DOS32

# ******************* Set up for 16 bit protected mode compile

!if $d(DEBUG)
CFGNAME = DPMIEXCD.CFG
LIBNAME = DPMIEXCD.LIB
OBJDIR  = OBJS16D
!else
CFGNAME = DPMIEXCP.CFG
LIBNAME = DPMIEXCP.LIB
OBJDIR  = OBJS16
!endif

CPUFLAG = -2
TARGETFLAG = -WX -ml

CC      = BCC
ASM     = TASM
LIB     = TLIB
LINK    = TLINK
AFLAGS32 =

!endif # DOS32

# ******************* Set other compiler options

!if $d(ALIGNMENT)
ALIGNFLAG = -a$(ALIGNMENT)
!else
ALIGNFLAG =
!endif

# ******************* Set debug and optimization options

CFLAGS1    =
CFLAGSN32  =

!if $d(DEBUG)

# NOTE: Don't use Stack Overflow Checking!
#       The exception handler switches stacks and this really messes
#       up the stack checking code.  Also turn this option off for
#       any module that has functions called by the exception handler
#       (i.e. clean up and exit code).
CDEBUGFLAG = /v -k -N-
ADEBUGFLAG = /zi
LIBFLAGS   = /P128

!else

CDEBUGFLAG = /v- /DNDEBUG -k- -N- -G-
ADEBUGFLAG = /zn
LIBFLAGS   = /0

# These optimization options **cannot** be used for the BC++ 4.0/4.02
# 32-bit protected mode compiler due to bugs.   However, BC++ 4.5 fixes
# these bugs, so define OPT32 to include these optimizations if you have it.
!if !$d(DOS32) || $d(OPT32)
CFLAGSN32 = -Oe -Os -O -Ob -Ol -Z
!endif

!if !$d(DOS32)
CFLAGSN32 = -h -OW
!endif

!endif

# If NOTRAP or DEBUG is defined, tell the assembler module not to trap
# exceptions 01, 02, 03, and 0F
!if $d(NOTRAP) || $d(DEBUG)
AFLAGS = /DNOTRAP
!endif

# Put them all together.  Compiler options are spread across three definitions
# because they can exceed 128 characters per line which causes it to fail.
CFLAGS1 = $(CFLAGS1) -RT- -x- -ff -w -w-sig -w-amp -P- -n$(OBJDIR)
CFLAGS2 = $(CDEBUGFLAG) $(ALIGNFLAG) $(CCOVYFLAGS) $(CPUFLAG) $(CFLAGSN32)
CFLAGS3 = -I$(INCLUDE)
AFLAGS  = $(AFLAGS) /m2 /ml /q /w2 $(ADEBUGFLAG) $(AOVYFLAGS) $(AFLAGS32) /DC_VERSION

# ******************* Build dependencies

.path.obj = $(OBJDIR)

OBJS = EXCPHND.OBJ \
       DPMIEXCP.OBJ

# Add the proper assembler module
!if !$d(DOS32)
OBJS = $(OBJS) DPMIX16A.OBJ
!else
OBJS = $(OBJS) DPMIX32A.OBJ
!endif

# Go ahead and build it.

.asm.obj:
!if !$d(NOTASM)
     $(ASM) $(AFLAGS) $&.ASM $(OBJDIR)\$&.OBJ
!else

!if !$d(DOS32)
     COPY $(PCOMPDIR)\DPMIX16A.OBJ $(OBJDIR)
!else
     COPY $(PCOMPDIR)\DPMIX32A.OBJ $(OBJDIR)
!endif

!endif

.c.obj:
     $(CC) -c +$(CFGNAME) {$. }

all: $(CFGNAME) dirs $(LIBNAME)
    DEL $(CFGNAME)

dirs:
    IF NOT EXIST $(OBJDIR) MD $(OBJDIR)

$(CFGNAME):
    ECHO $(TARGETFLAG) $(CFLAGS1) > $(CFGNAME)
    ECHO $(CFLAGS2) >> $(CFGNAME)
    ECHO $(CFLAGS3) >> $(CFGNAME)

*.c: $(CFGNAME)

excphnd.obj : excphnd.c

dpmiexcp.obj : ..\dpmiexcp\dpmiexcp.c
     $(CC) -c +$(CFGNAME) ..\dpmiexcp\dpmiexcp.c

!if !$d(DOS32)

dpmix16a.obj : ..\dpmiexcp\dpmix16a.asm
!if !$d(NOTASM)
    $(ASM) $(AFLAGS) ..\dpmiexcp\dpmix16a.asm $(OBJDIR)\dpmix16a.OBJ
!else
    COPY $(PCOMPDIR)\DPMIX16A.OBJ $(OBJDIR)
!endif

!else

dpmix32a.obj : ..\dpmiexcp\dpmix32a.asm
!if !$d(NOTASM)
    $(ASM) $(AFLAGS) ..\dpmiexcp\dpmix32a.asm $(OBJDIR)\dpmix32a.OBJ
!else
    COPY $(PCOMPDIR)\DPMIX32A.OBJ $(OBJDIR)
!endif

!endif

$(LIBNAME): $(OBJS)
     @cd $(OBJDIR)
     @if exist ..\$(LIBNAME) del ..\$(LIBNAME)
     $(LIB) $(LIBFLAGS) ..\$(LIBNAME) @..\$(RSPNAME)
     @cd ..

# End of DPMI Exception Handler Library make file
