// File    : TVEXCDLG.H
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Mon 03/06/95 20:39:31
// Note    : Copyright 1995, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 4.xx
//
// This is the header file for the generic TV exception dialog handlers.
//

#if !defined(__TVEXCDLG_H)
#define __TVEXCDLG_H

#if !defined(__DPMIEXCP_H)
#include <dpmiexcp.h>
#endif

// ****************************************************************************

// A derived TDialog class is used so that the custom button command values
// will be recognized.

class TVExceptionDialog : public TDialog
{
private:
    DPMIExceptionData *ex;

    char title[80];

public:
    TVExceptionDialog(DPMIExceptionData *ex);

    virtual const char *getTitle(short maxSize);
    virtual void handleEvent(TEvent &event);
};

// Button commands for the dialog.  These can be disabled if necessary.
const
    cmAttemptRecovery   = 253,
    cmExitApplication   = 254,
    cmExitViaOldHandler = 255;

// Replacement abort() function to prevent abnormal termination
// without proper clean-up.  Just make sure that the TVEXCDLG.CPP module
// is linked in prior to the standard library so that this one gets used.
//
// NOTE:  You might want to copy this function into your real mode
//        applications too.  It will insure proper shut down of TV
//        applications and avoid the unstable system that usually results
//        from a call to abort() (after running out memory for example).
//
void abort(void);

// The generic exception handler.  An 'int' return type is used so that the
// prototype can be used in either 16 or 32-bit protected mode.
// Use this as the parameter for DPMIExceptionHandler::setExceptionHandler().

int TVExceptionHandler(DPMIExceptionData *ex);

#endif  // __TVEXCDLG_H
