// File    : TVEXTEST.CPP
// Author  : Eric Woodruff,  CIS ID: 72134,1150
// Updated : Mon 03/06/95 20:39:31
// Note    : Copyright 1995, Eric Woodruff, All rights reserved
// Compiler: Borland C++ 4.xx
//
// This is a demo program to test the custom exception handler class.
//

#include <conio.h>
#include <stdio.h>
#include <stdlib.h>

#define Uses_MsgBox
#define Uses_TApplication
#define Uses_TDeskTop
#define Uses_TDialog
#define Uses_TEvent
#define Uses_TKeys
#define Uses_TMenuBar
#define Uses_TMenuItem
#define Uses_TRect
#define Uses_TScreen
#define Uses_TStatusDef
#define Uses_TStatusItem
#define Uses_TStatusLine
#define Uses_TSubMenu
#include <tvision\tv.h>

// Define the DPMI exception handler stuff.
#include <tvexcdlg.h>

// ****************************************************************************

const
    cmDivideByZero   = 100,
    cmOverflow       = 101,
    cmBound          = 102,
    cmInvalidOpCode  = 103,
    cmStackException = 104,
    cmGPFPageFault   = 105;

int ExitValue = 0;

// ****************************************************************************

void TVExceptionExit(void)
{
    // Clear the desktop from the screen.  This isn't normally necessary,
    // but the exit function displays some text so we need a clear screen.
    TProgram::application->suspend();

    // This is just for the demo program's atexit() function.
    ExitValue = 999;

    //
    // This is the only mandatory part: Call exit() to terminate the program.
    //
    // Act like an abort function() by returning 3.  However, instead of
    // calling _exit() it calls exit() (no leading underscore).  Buffers
    // are flushed, files are closed, global objects are destroyed, and
    // functions registered with atexit() are called.
    exit(3);
}

// This is a generic clean-up function that can be used for Turbo Vision
// applications.  You can use this as a starting point for your own
// applications.
void TVCleanUp(int ExitType, DPMIExceptionData *ex)
{
    TEvent anEvent;

    // Force a graceful exit.
    anEvent.what = evCommand;
    anEvent.message.command = cmQuit;

    // Allow TV to handle the cmQuit command in case there is any
    // processing attached to it in the overridden application.
    TProgram::application->handleEvent(anEvent);

    if(!ExitType)
    {
        // If terminating via the original exception vector, make sure
        // TV shuts itself down completely after the cmQuit call!
        // Otherwise, the global objects and interrupts (mouse, keyboard,
        // critical error handler, etc) will still be active after the
        // return to DOS.  A lock-up would soon follow.

        TProgram::application->suspend();

        // Return and let the original handler display its information.
        return;
    }

    // Otherwise, termination will take place via a custom function.
    // All we need to do is store its address in the fault CS:(E)IP address
    // of the exception data structure.
    //
    // That function can simply call exit or contain additional code to
    // disconnect user interrupts, etc.  By calling exit() from that
    // function, you can insure that the global TV objects are destroyed
    // so there is no need to call suspend() first.
    //

#if !defined(__FLAT__)

    ex->FaultCSIP.CS_IP = TVExceptionExit;

#else

    ex->FaultCSEIP.EIP_CS.Offset = (int)TVExceptionExit;
    ex->FaultCSEIP.EIP_CS.Selector = _CS;

#endif
}

// ****************************************************************************

class TExceptionDemo : public TApplication
{
public:
    TExceptionDemo();

    static TMenuBar *initMenuBar(TRect r);
    static TStatusLine *initStatusLine(TRect r);

    virtual void handleEvent(TEvent &event);
};

TExceptionDemo::TExceptionDemo() :
    TProgInit(&TExceptionDemo::initStatusLine,
              &TExceptionDemo::initMenuBar,
              &TExceptionDemo::initDeskTop)
{
    // Point to the clean-up function.
    DPMIExceptionHandler::CleanUpFunction = TVCleanUp;

    // Hook the exceptions you want to trap.
    DPMIExceptionHandler::setExceptionHandler(0, TVExceptionHandler);
//    DPMIExceptionHandler::setExceptionHandler(1, TVExceptionHandler);
//    DPMIExceptionHandler::setExceptionHandler(3, TVExceptionHandler);
    DPMIExceptionHandler::setExceptionHandler(4, TVExceptionHandler);
    DPMIExceptionHandler::setExceptionHandler(5, TVExceptionHandler);
    DPMIExceptionHandler::setExceptionHandler(6, TVExceptionHandler);
//    DPMIExceptionHandler::setExceptionHandler(11, TVExceptionHandler);
    DPMIExceptionHandler::setExceptionHandler(12, TVExceptionHandler);
    DPMIExceptionHandler::setExceptionHandler(13, TVExceptionHandler);
    DPMIExceptionHandler::setExceptionHandler(14, TVExceptionHandler);
}

void TExceptionDemo::handleEvent(TEvent &event)
{
    int x, y, z, array[6] = { 0, 3, 1, 2, 3, 4 };
    char *p;

    TApplication::handleEvent(event);

    if(event.what == evCommand)
        switch(event.message.command)
        {
            case cmDivideByZero:
                x = 1;      // Force a divide by zero exception (0)
                y = 0;
                z = x / y;
                x += z;

                break;

            case cmOverflow:
                _AL = 0xFF;
                _BL = 0xFF;

#if !defined(__FLAT__)
                asm {
                    mul     bl          // Force an overflow exception (4)
                    into
                }
#else
                __emit__(0xF6);         // mul bl
                __emit__(0xE3);

                __emit__(0xCE);         // into
#endif
                break;

            case cmBound:
#if !defined(__FLAT__)
                // Generate a BOUND exception (5)
                asm mov     ax, 4
                asm push    ss
                asm pop     es
                asm lea     bx, array
                asm bound   ax, es:[bx]
#else
                _EBX = (unsigned long)&array[0];
                _EAX = 4;

                __emit__(0x62);         // bound eax, [ebx]
                __emit__(0x03);
#endif
                break;

            case cmInvalidOpCode:
                __emit__(0x0F);     // Emit a CPUID instruction which causes
                __emit__(0xA2);     // an invalid opcode exception (6) on all
                                    // but a Pentium and a few recent 486's.
                break;

            case cmStackException:
                // Force a stack exception (12)
#if !defined(__FLAT__)
                asm {
                    xor     bp, bp
                    mov     ax, [bp - 6]
                }
#else
                __emit__(0x33);             // xor ebp, ebp
                __emit__(0xED);
                __emit__(0x8B);             // mov eax, [ebp - 6]
                __emit__(0x45);
                __emit__(0xFA);
#endif
                break;

            case cmGPFPageFault:
                // Force a GPF (exception 13, DPMI16) or a page fault
                // (exception 14, DPMI32) via a NULL pointer access.
                p = NULL;

                *p = 'X';

                break;

            case cmDosShell:
                // If you use spawn() or system(), you *MUST* release
                // the exception traps *before* the call!  If you don't
                // and the other application causes an exception, this
                // application's handler may pop up.  That's just asking
                // for trouble.  Another reason is that if the other
                // application traps exceptions and doesn't release them,
                // you could end up with the vectors pointing into undefined
                // memory space upon return to this application.
                DPMIExceptionHandler::releaseExceptions();

                suspend();

                system("test16.exe");
                puts("Press any key...");
                getch();

                resume();
                redraw();

                // When you return, retrap the exceptions.
                DPMIExceptionHandler::trapExceptions();
                break;

            default:
                break;
        }
}

TMenuBar *TExceptionDemo::initMenuBar(TRect r)
{
    r.b.y = r.a.y+1;

    return new TMenuBar( r,
      *new TSubMenu( "~E~xceptions", kbAltH ) +
        *new TMenuItem( "00    ~D~ivide by zero", cmDivideByZero, kbAlt0, hcNoContext, "Alt+0") +
        *new TMenuItem( "04    ~O~verflow", cmOverflow, kbAlt4, hcNoContext, "Alt+4") +
        *new TMenuItem( "05    ~B~OUND", cmBound, kbAlt5, hcNoContext, "Alt+5") +
        *new TMenuItem( "06    ~I~nvalid opcode", cmInvalidOpCode, kbAlt6, hcNoContext, "Alt+6") +
        *new TMenuItem( "0C    ~S~tack exception", cmStackException, kbAltC, hcNoContext, "Alt+C") +
        *new TMenuItem( "0D/0E ~G~PF/Page Fault", cmGPFPageFault, kbAltD, hcNoContext, "Alt+D") +
         newLine() +
        *new TMenuItem( "DOS S~h~ell", cmDosShell, kbNoKey) +
        *new TMenuItem( "E~x~it", cmQuit, kbAltX, hcNoContext, "Alt-X" ) );
}

TStatusLine *TExceptionDemo::initStatusLine(TRect r)
{
    r.a.y = r.b.y-1;
    return new TStatusLine( r,
        *new TStatusDef( 0, 0xFFFF ) +
            *new TStatusItem( "~Alt-X~ Exit", kbAltX, cmQuit ) +
            *new TStatusItem( 0, kbF10, cmMenu ) );
}

void exitFunc(void)
{
    // Prevent the final screen clear on exit.
    TScreen::clearOnSuspend = False;

    if(ExitValue == 999)
        puts("An exception caused the program to terminate");
    else
        puts("The application terminated normally.");
}

void main(void)
{
    atexit(exitFunc);

    TExceptionDemo exceptionTest;
    exceptionTest.run();

    exceptionTest.shutDown();
    exceptionTest.suspend();

    // Always release the exception handlers prior to exit.
    DPMIExceptionHandler::releaseExceptions();
    exit(0);
}
