// File from page 553 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: WIND5.CPP -- Pure abstract base classes
#include <iostream.h>
enum note { middleC, Csharp, Cflat }; // Etc.

class instrument {
public:
  // Pure virtual functions:
  virtual void play(note) const = 0;
  virtual char* what() const = 0;
  // Assume this will modify the object:
  virtual void adjust(int) = 0;
};
// Rest of the file is the same ...

class wind : public instrument {
public:
  void play(note) const {
    cout << "wind::play" << endl;
  }
  char* what() const { return "wind"; }
  void adjust(int) {}
};

class percussion : public instrument {
public:
  void play(note) const {
    cout << "percussion::play" << endl;
  }
  char* what() const { return "percussion"; }
  void adjust(int) {}
};

class string : public instrument {
public:
  void play(note) const {
    cout << "string::play" << endl;
  }
  char* what() const { return "string"; }
  void adjust(int) {}
};

class brass : public wind {
public:
  void play(note) const {
    cout << "brass::play" << endl;
  }
  char* what() const { return "brass"; }
};

class woodwind : public wind {
public:
  void play(note) const {
    cout << "woodwind::play" << endl;
  }
  char* what() const { return "woodwind"; }
};

// Identical function from before:
void tune(instrument& i) {
  // ...
  i.play(middleC);
}

// New function:
void f(instrument& i) { i.adjust(1); }

main() {
  wind flute;
  percussion drum;
  string violin;
  brass flugelhorn;
  woodwind recorder;
  tune(flute);
  tune(drum);
  tune(violin);
  tune(flugelhorn);
  tune(recorder);
  f(flugelhorn);
}
