// File from page 738 in "Thinking in C++" by Bruce Eckel
//////////////////////////////////////////////////
// From the compressed package ECKELT01.ZIP 2/21/95
// Copyright (c) Bruce Eckel, 1995 
// Source code file from the book "Thinking in C++", 
// Prentice Hall, 1995, ISBN: 0-13-917709-4
// All rights reserved EXCEPT as allowed by the following 
// statements: You may freely use this file for your own 
// work, including modifications and distribution in 
// executable form only. You may copy and distribute this 
// file, as long as it is only distributed in the complete 
// (compressed) package with the other files from this 
// book and you do not remove this copyright and notice. 
// You may not distribute modified versions of the source 
// code in this package. This package may be freely placed 
// on bulletin boards, internet nodes, shareware disks and 
// product vendor disks. You may not use this file in 
// printed media without the express permission of the 
// author. Bruce Eckel makes no 
// representation about the suitability of this software 
// for any purpose. It is provided "as is" without express 
// or implied warranty of any kind. The entire risk as to 
// the quality and performance of the software is with 
// you. Should the software prove defective, you assume 
// the cost of all necessary servicing, repair, or 
// correction. 
// If you think you've found an error, please 
// email all modified files with loudly commented changes 
// to: eckel@aol.com (please use the same 
// address for non-code errors found in the book).
//////////////////////////////////////////////////

//: RECYCLE2.CPP -- Chapter 14 example w/ RTTI
#include <fstream.h>
#include <stdlib.h>
#include <time.h>
#include <typeinfo.h>
#include "..\14\tstack.h"
ofstream out("recycle2.out");

class trash {
  float Weight;
public:
  trash(float Wt) : Weight(Wt) {}
  virtual float value() const = 0;
  float weight() const { return Weight; }
  virtual ~trash() {}
};

class aluminum : public trash {
  static float val;
public:
  aluminum(float Wt) : trash(Wt) {}
  float value() const { return val; }
  static void value(int newval) {
    val = newval;
  }
};

float aluminum::val = 1.67;

class paper : public trash {
  static float val;
public:
  paper(float Wt) : trash(Wt) {}
  float value() const { return val; }
  static void value(int newval) {
    val = newval;
  }
};

float paper::val = 0.10;

class glass : public trash {
  static float val;
public:
  glass(float Wt) : trash(Wt) {}
  float value() const { return val; }
  static void value(int newval) {
    val = newval;
  }
};

float glass::val = 0.23;

// Sums up the value of the trash in a bin:
template<class T> void
SumValue(const tstack<T>& bin, ostream& os) {
  tstackIterator<T> tally(bin);
  float val = 0;
  while(tally) {
    val += tally->weight() * tally->value();
    os << "weight of "
        << typeid(*tally.current()).name()
        << " = " << tally->weight() << endl;
    tally++;
  }
  os << "Total value = " << val << endl;
}

main() {
  // Seed the random number generator
  time_t t;
  srand((unsigned)time(&t));

  tstack<trash> bin; // Default to ownership
  // Fill up the trash bin:
  for(int i = 0; i < 30; i++)
    switch(rand() % 3) {
      case 0 :
        bin.push(new aluminum(rand() % 100));
        break;
      case 1 :
        bin.push(new paper(rand() % 100));
        break;
      case 2 :
        bin.push(new glass(rand() % 100));
        break;
    }
  // Note difference w/ chapter 14: Bins hold
  // exact type of object, not base type:
  tstack<glass> glassbin(0); // No ownership
  tstack<paper> paperbin(0);
  tstack<aluminum> ALbin(0);
  tstackIterator<trash> sorter(bin);
  // Sort the trash:
  while(sorter) {
    aluminum* ap =
      dynamic_cast<aluminum*>(sorter.current());
    paper* pp =
      dynamic_cast<paper*>(sorter.current());
    glass* gp =
      dynamic_cast<glass*>(sorter.current());
    if(ap) ALbin.push(ap);
    if(pp) paperbin.push(pp);
    if(gp) glassbin.push(gp);
    sorter++;
  }
  SumValue(ALbin, out);
  SumValue(paperbin, out);
  SumValue(glassbin, out);
  SumValue(bin, out);
}
