@ECHO OFF
REM ============================================================================
REM 
REM LARC-S "LARC Examples"
REM LARC-D "Source Library Backup Batch File"
REM LARC-V "100"
REM
REM Revision history:
REM kbg 05/15/94 100 - Created.
REM
REM Some general notes about this file follows.
REM
REM This batch file is executed you select "backup library source files" from
REM the "Release" menu.  The batch file is responsible for creating a complete
REM backup of just the files that are present in the currently selected LARC
REM source library.
REM
REM This batch file is started by LARC and LARC passes the following parameters:
REM 
REM     %1 = Argument 1 contains the two character hard drive name (i.e., "C:").
REM
REM     %2 = Argument 2 contains source file directory name (i.e., "C:\LARCEMP").
REM
REM     %3 = Argument 3 contains current system date formatted as mm-dd-yy.
REM
REM     %4 = Argument 4 contains current system time formatted as hh:mm:ss.
REM
REM     %5 = Argument 8 contains the three character source library number.
REM	     This number can be used to backup the LARC control files
REM	     (MODCTL.nnn, RELCTL.nnn, REVCTL.nnn) that belong with the
REM	     current library.
REM
REM LARC allows you complete freedom over how your product is backed up.  Since
REM LARC executes this standard DOS command batch file, you can use any
REM combination of system commands to backup the sources.
REM
REM Normally, ECHO OFF is set to keep things like REM lines from being
REM scrolled up the screen.  Then ECHO commands are used to display progress
REM messages.  
REM
REM ============================================================================




REM ============================================================================
REM Display some initial information on the screen.
REM
REM Use Ken's File Deletion utility with the "/N" option to delete any existing
REM files with being prompted before the delete.  Notice that this entire
REM process will use the C:\LARC3\TEMP directory.  You can use any directory
REM name.  However, if you were to backup directly to an off-line media, such
REM as tape, then you might need to replace this delete command with appropriate
REM tape formatting or initialization commands.
REM ============================================================================
ECHO.
ECHO Source Library Backup Command File
ECHO.
ECHO Delete all files from the temporary work directory C:\LARC3\TEMP...
KDEL/N C:\LARC3\TEMP\*.*




REM ============================================================================
REM Now a file will be created and printed that describes the contents of the
REM backup set.  This file should be stored with the backup set to help you
REM identify the contents at a future date.
REM ============================================================================
ECHO.
ECHO Creating READ.ME file containing notes of the backup files...

ECHO.									> C:\LARC3\TEMP\READ.ME
ECHO 		Source Backup Diskettes for LARC Examples		>> C:\LARC3\TEMP\READ.ME
ECHO 		Created %6 at %7 					>> C:\LARC3\TEMP\READ.ME
ECHO.									>> C:\LARC3\TEMP\READ.ME
ECHO 		This backup contains:					>> C:\LARC3\TEMP\READ.ME
ECHO.									>> C:\LARC3\TEMP\READ.ME
ECHO 			READ.ME		This file			>> C:\LARC3\TEMP\READ.ME
ECHO 			SOURCES.ZIP	Source files			>> C:\LARC3\TEMP\READ.ME
ECHO 			*.%5		LARC system control files	>> C:\LARC3\TEMP\READ.ME
ECHO 			SYSLOG.ZIP	LARC system activity log file	>> C:\LARC3\TEMP\READ.ME
ECHO.									>> C:\LARC3\TEMP\READ.ME

PRINT C:\LARC3\TEMP\READ.ME




REM ============================================================================
REM Create a ZIP file containing all of the source files.
REM ============================================================================
ECHO.
ECHO Zip the source files...
PKZIP C:\LARC3\TEMP\SOURCES.ZIP C:\LARCSRC\EXAMPLES\*.*




REM ============================================================================
REM Copy the LARC control files for your library into the temporary
REM directory as a safeguard.  This will get the control files stored
REM it the exact state as when the backup was created.
REM ============================================================================
ECHO.
ECHO Copy the LARC control files...
COPY C:\LARC3\*.%8 C:\LARC3\TEMP\*.* >NUL




REM ============================================================================
REM Copy the LARC system activity log file for your library into the temporary
REM directory.  This will save the current state of the activity log file in
REM case you need to investigate LARC activity through the point when the backup
REM was created.
REM ============================================================================
ECHO.
ECHO Zip the LARC activity log file...
PKZIP C:\LARC3\TEMP\SYSLOG.ZIP C:\LARC3\SYSLOG.*




REM ============================================================================
REM Create the backup diskettes using Ken's File Copy utility to copy the files
REM from the temporary directory to diskette A:.  You would, of course, replace
REM this command with the commands neccessary to copy the files to your backup
REM media.
REM ============================================================================
ECHO.
ECHO Start copying the zipped source files to the backup diskettes
ECHO in drive A:.  Make sure that each diskette is labeled:
ECHO.
ECHO 		LARC Hello Example Source Backup
ECHO 		Created %6
ECHO 		Diskette 1 of n
ECHO.
KCOPY C:\LARC3\TEMP\*.* A:




REM ============================================================================
REM Remove the last diskette an make sure that all diskettes have been
REM properly labeled.
REM ============================================================================
ECHO.
ECHO Remove the last diskette from drive A: and make sure that
ECHO each diskette is properly labelled and write protected!




REM ============================================================================
REM Finally, we delete the files from the temporary directory.  This step
REM may be unnecessary if you backup directly to your backup media.
REM ============================================================================
KDEL/N C:\LARC3\TEMP\*.*
