unit mcgagraf;

interface

procedure screenmode(mode : byte);
procedure setpalette(palette:shortint);
procedure putpixel(x,y:integer;color:byte);

const
  textmode    = 3;
  graphmode   = $13;
  grayscale   = 1;
  standardVGA = 2;
  rainbowVGA  = 3;
  redscale    = 4;
  greenscale  = 5;
  bluescale   = 6;
  heatscale   = 7;

implementation

uses
  crt;
type
  palettetype = array[0..255*3 + 2] of byte;


const
graypal:array[0..63*3 + 2] of byte =
(0,0,0,
1,1,1,
2,2,2,
3,3,3,
4,4,4,
5,5,5,
6,6,6,
7,7,7,
8,8,8,
9,9,9,
10,10,10,
11,11,11,
12,12,12,
13,13,13,
14,14,14,
15,15,15,
16,16,16,
17,17,17,
18,18,18,
19,19,19,
20,20,20,
21,21,21,
22,22,22,
23,23,23,
24,24,24,
25,25,25,
26,26,26,
27,27,27,
28,28,28,
29,29,29,
30,30,30,
31,31,31,
32,32,32,
33,33,33,
34,34,34,
35,35,35,
36,36,36,
37,37,37,
38,38,38,
39,39,39,
40,40,40,
41,41,41,
42,42,42,
43,43,43,
44,44,44,
45,45,45,
46,46,46,
47,47,47,
48,48,48,
49,49,49,
50,50,50,
51,51,51,
52,52,52,
53,53,53,
54,54,54,
55,55,55,
56,56,56,
57,57,57,
58,58,58,
59,59,59,
60,60,60,
61,61,61,
62,62,62,
63,63,63
);


rainbowpal :palettetype =
(0,0,0,
62,0,63,
61,0,63,
60,0,63,
59,0,63,
58,0,63,
57,0,63,
56,0,63,
55,0,63,
54,0,63,
53,0,63,
52,0,63,
51,0,63,
50,0,63,
49,0,63,
48,0,63,
47,0,63,
46,0,63,
45,0,63,
44,0,63,
43,0,63,
42,0,63,
41,0,63,
40,0,63,
39,0,63,
38,0,63,
37,0,63,
36,0,63,
35,0,63,
34,0,63,
33,0,63,
32,0,63,
31,0,63,
30,0,63,
29,0,63,
28,0,63,
27,0,63,
26,0,63,
25,0,63,
24,0,63,
23,0,63,
22,0,63,
21,0,63,
20,0,63,
19,0,63,
18,0,63,
17,0,63,
16,0,63,
15,0,63,
14,0,63,
13,0,63,
12,0,63,
11,0,63,
10,0,63,
9,0,63,
8,0,63,
7,0,63,
6,0,63,
5,0,63,
4,0,63,
3,0,63,
2,0,63,
1,0,63,
0,0,63,
0,0,63,
0,2,63,
0,4,63,
0,6,63,
0,8,63,
0,10,63,
0,12,63,
0,14,63,
0,16,63,
0,18,63,
0,20,63,
0,22,63,
0,24,63,
0,26,63,
0,28,63,
0,30,63,
0,32,63,
0,34,63,
0,36,63,
0,38,63,
0,40,63,
0,42,63,
0,44,63,
0,46,63,
0,48,63,
0,50,63,
0,52,63,
0,54,63,
0,56,63,
0,58,63,
0,60,63,
0,62,63,
0,63,63,
0,63,61,
0,63,59,
0,63,57,
0,63,55,
0,63,53,
0,63,51,
0,63,49,
0,63,47,
0,63,45,
0,63,43,
0,63,41,
0,63,39,
0,63,37,
0,63,35,
0,63,33,
0,63,31,
0,63,29,
0,63,27,
0,63,25,
0,63,23,
0,63,21,
0,63,19,
0,63,17,
0,63,15,
0,63,13,
0,63,11,
0,63,9,
0,63,7,
0,63,5,
0,63,3,
0,63,1,
0,63,0,
2,63,0,
4,63,0,
6,63,0,
8,63,0,
10,63,0,
12,63,0,
14,63,0,
16,63,0,
18,63,0,
20,63,0,
22,63,0,
24,63,0,
26,63,0,
28,63,0,
30,63,0,
32,63,0,
34,63,0,
36,63,0,
38,63,0,
40,63,0,
42,63,0,
44,63,0,
46,63,0,
48,63,0,
50,63,0,
52,63,0,
54,63,0,
56,63,0,
58,63,0,
60,63,0,
62,63,0,
63,63,0,
63,61,0,
63,59,0,
63,57,0,
63,55,0,
63,53,0,
63,51,0,
63,49,0,
63,47,0,
63,45,0,
63,43,0,
63,41,0,
63,39,0,
63,37,0,
63,35,0,
63,33,0,
63,31,0,
63,29,0,
63,27,0,
63,25,0,
63,23,0,
63,21,0,
63,19,0,
63,17,0,
63,15,0,
63,13,0,
63,11,0,
63,9,0,
63,7,0,
63,5,0,
63,3,0,
63,1,0,
63,0,0,
63,0,1,
63,0,2,
63,0,3,
63,0,4,
63,0,5,
63,0,6,
63,0,7,
63,0,8,
63,0,9,
63,0,10,
63,0,11,
63,0,12,
63,0,13,
63,0,14,
63,0,15,
63,0,16,
63,0,17,
63,0,18,
63,0,19,
63,0,20,
63,0,21,
63,0,22,
63,0,23,
63,0,24,
63,0,25,
63,0,26,
63,0,27,
63,0,28,
63,0,29,
63,0,30,
63,0,31,
63,0,32,
63,0,33,
63,0,34,
63,2,35,
63,4,36,
63,6,37,
63,8,38,
63,10,39,
63,12,40,
63,14,41,
63,16,42,
63,18,43,
63,20,44,
63,22,45,
63,24,46,
63,26,47,
63,28,48,
63,30,49,
63,32,50,
63,34,51,
63,36,52,
63,38,53,
63,40,54,
63,42,55,
63,44,56,
63,46,57,
63,48,58,
63,50,59,
63,52,60,
63,56,63,
63,60,63,
0,0,0
);


bluepal : palettetype =
(0,0,0,
0,0,0,
0,0,0,
0,0,0,
0,0,1,
0,0,1,
0,0,1,
0,0,1,
0,0,2,
0,0,2,
0,0,2,
0,0,2,
0,0,3,
0,0,3,
0,0,3,
0,0,3,
0,0,4,
0,0,4,
0,0,4,
0,0,4,
0,0,5,
0,0,5,
0,0,5,
0,0,5,
0,0,6,
0,0,6,
0,0,6,
0,0,6,
0,0,7,
0,0,7,
0,0,7,
0,0,7,
0,0,8,
0,0,8,
0,0,8,
0,0,8,
0,0,9,
0,0,9,
0,0,9,
0,0,9,
0,0,10,
0,0,10,
0,0,10,
0,0,10,
0,0,11,
0,0,11,
0,0,11,
0,0,11,
0,0,12,
0,0,12,
0,0,12,
0,0,12,
0,0,13,
0,0,13,
0,0,13,
0,0,13,
0,0,14,
0,0,14,
0,0,14,
0,0,14,
0,0,15,
0,0,15,
0,0,15,
0,0,15,
0,0,16,
0,0,16,
0,0,16,
0,0,16,
0,0,17,
0,0,17,
0,0,17,
0,0,17,
0,0,18,
0,0,18,
0,0,18,
0,0,18,
0,0,19,
0,0,19,
0,0,19,
0,0,19,
0,0,20,
0,0,20,
0,0,20,
0,0,20,
0,0,21,
0,0,21,
0,0,21,
0,1,21,
0,1,22,
0,1,22,
0,2,22,
0,2,22,
0,2,23,
0,3,23,
0,3,23,
0,4,23,
0,4,24,
0,4,24,
0,5,24,
0,5,24,
0,5,25,
0,6,25,
0,6,25,
0,7,25,
0,7,26,
0,7,26,
0,8,26,
0,8,26,
0,8,27,
0,9,27,
0,9,27,
0,10,27,
0,10,28,
0,10,28,
0,11,28,
0,11,28,
0,11,29,
0,12,29,
0,12,29,
0,13,29,
0,13,30,
0,13,30,
0,14,30,
0,14,30,
0,14,31,
0,15,31,
0,15,31,
0,16,31,
0,16,32,
0,16,32,
0,17,32,
0,17,32,
0,17,33,
0,18,33,
0,18,33,
0,19,33,
0,19,34,
0,19,34,
0,20,34,
0,20,34,
0,20,35,
0,21,35,
0,21,35,
0,22,35,
0,22,36,
0,22,36,
0,23,36,
0,23,36,
0,23,37,
0,24,37,
0,24,37,
0,25,37,
0,25,38,
0,25,38,
0,26,38,
0,26,38,
0,26,39,
0,27,39,
0,27,39,
0,28,39,
0,28,40,
0,28,40,
0,29,40,
0,29,40,
0,29,41,
0,30,41,
0,30,41,
0,31,41,
0,31,42,
0,31,42,
0,32,42,
0,32,42,
0,32,43,
0,33,43,
0,33,43,
0,34,43,
0,34,44,
0,34,44,
0,35,44,
0,35,44,
0,35,45,
0,36,45,
1,36,45,
2,37,45,
3,37,46,
4,37,46,
5,38,46,
5,38,46,
6,38,47,
7,39,47,
8,39,47,
9,40,47,
10,40,48,
11,40,48,
11,41,48,
12,41,48,
13,41,49,
14,42,49,
15,42,49,
16,43,49,
17,43,50,
17,43,50,
18,44,50,
19,44,50,
20,44,51,
21,45,51,
22,45,51,
23,46,51,
23,46,52,
24,46,52,
25,47,52,
26,47,52,
27,47,53,
28,48,53,
29,48,53,
29,49,53,
30,49,54,
31,49,54,
32,50,54,
33,50,54,
34,50,55,
35,51,55,
35,51,55,
36,52,55,
37,52,56,
38,52,56,
39,53,56,
40,53,56,
41,53,57,
41,54,57,
42,54,57,
43,55,57,
44,55,58,
45,55,58,
46,56,58,
47,56,58,
47,56,59,
48,57,59,
49,57,59,
50,58,59,
51,58,60,
52,58,60,
52,59,60,
53,59,60,
54,59,61,
55,60,61,
56,60,61,
57,61,61,
58,61,62,
58,61,62,
59,62,62,
60,62,62,
61,62,63,
62,63,63,
63,63,63,
0,0,0
);


redpal : palettetype =
(0,0,0,
0,0,0,
0,0,0,
1,0,0,
1,0,0,
1,0,0,
2,0,0,
2,0,0,
2,0,0,
3,0,0,
3,0,0,
3,0,0,
4,0,0,
4,0,0,
4,0,0,
5,0,0,
5,0,0,
5,0,0,
6,0,0,
6,0,0,
6,0,0,
7,0,0,
7,0,0,
7,0,0,
8,0,0,
8,0,0,
8,0,0,
9,0,0,
9,0,0,
9,0,0,
10,0,0,
10,0,0,
10,0,0,
11,0,0,
11,0,0,
11,0,0,
12,0,0,
12,0,0,
12,0,0,
13,0,0,
13,0,0,
13,0,0,
14,0,0,
14,0,0,
14,0,0,
15,0,0,
15,0,0,
15,0,0,
16,0,0,
16,0,0,
16,0,0,
17,0,0,
17,0,0,
17,0,0,
18,0,0,
18,0,0,
18,0,0,
19,0,0,
19,0,0,
19,0,0,
20,0,0,
20,0,0,
20,0,0,
21,0,0,
21,0,0,
21,0,0,
22,0,0,
22,0,0,
22,0,0,
23,0,0,
23,0,0,
23,0,0,
24,0,0,
24,0,0,
24,0,0,
25,0,0,
25,0,0,
25,0,0,
26,0,0,
26,0,0,
26,0,0,
27,0,0,
27,0,0,
27,0,0,
28,0,0,
28,0,0,
28,0,0,
29,0,0,
29,0,0,
29,0,0,
30,0,0,
30,0,0,
30,0,0,
31,0,0,
31,0,0,
31,0,0,
32,0,0,
32,0,0,
32,0,0,
33,0,0,
33,0,0,
33,0,0,
34,0,0,
34,0,0,
34,0,0,
35,0,0,
35,0,0,
35,0,0,
36,0,0,
36,0,0,
36,0,0,
37,0,0,
37,0,0,
37,0,0,
38,0,0,
38,0,0,
38,0,0,
39,0,0,
39,0,0,
39,0,0,
40,0,0,
40,0,0,
40,0,0,
41,0,0,
41,0,0,
41,0,0,
42,0,0,
42,0,0,
42,0,0,
43,0,0,
43,0,0,
43,0,0,
44,0,0,
44,0,0,
44,0,0,
45,0,0,
45,0,0,
45,0,0,
46,0,0,
46,0,0,
46,0,0,
47,0,0,
47,0,0,
47,0,0,
48,0,0,
48,0,0,
48,0,0,
49,0,0,
49,0,0,
49,0,0,
50,0,0,
50,0,0,
50,0,0,
51,0,0,
51,0,0,
51,0,0,
52,0,0,
52,0,0,
52,0,0,
53,0,0,
53,0,0,
53,0,0,
54,0,0,
54,0,0,
54,0,0,
55,0,0,
55,0,0,
55,0,0,
56,0,0,
56,0,0,
56,0,0,
57,0,0,
57,0,0,
57,0,0,
58,0,0,
58,0,0,
58,0,0,
59,0,0,
59,0,0,
59,0,0,
60,0,0,
60,0,0,
60,0,0,
61,0,0,
61,0,0,
61,0,0,
62,0,0,
62,0,0,
62,0,0,
63,0,0,
63,0,0,
63,0,0,
63,1,1,
63,2,2,
63,3,3,
63,4,4,
63,5,5,
63,6,6,
63,7,7,
63,8,8,
63,9,9,
63,10,10,
63,11,11,
63,12,12,
63,13,13,
63,14,14,
63,15,15,
63,16,16,
63,17,17,
63,18,18,
63,19,19,
63,20,20,
63,21,21,
63,22,22,
63,23,23,
63,24,24,
63,25,25,
63,26,26,
63,27,27,
63,28,28,
63,29,29,
63,30,30,
63,31,31,
63,32,32,
63,33,33,
63,34,34,
63,35,35,
63,36,36,
63,37,37,
63,38,38,
63,39,39,
63,40,40,
63,41,41,
63,42,42,
63,43,43,
63,44,44,
63,45,45,
63,46,46,
63,47,47,
63,48,48,
63,49,49,
63,50,50,
63,51,51,
63,52,52,
63,53,53,
63,54,54,
63,55,55,
63,56,56,
63,57,57,
63,58,58,
63,59,59,
63,60,60,
63,61,61,
63,62,62,
63,63,63,
0,0,0
);


greenpal : palettetype =
(0,0,0,
0,0,0,
0,0,0,
0,0,0,
0,1,0,
0,1,0,
0,1,0,
0,1,0,
0,2,0,
0,2,0,
0,2,0,
0,2,0,
0,3,0,
0,3,0,
0,3,0,
0,3,0,
0,4,0,
0,4,0,
0,4,0,
0,4,0,
0,5,0,
0,5,0,
0,5,0,
0,5,0,
0,6,0,
0,6,0,
0,6,0,
0,6,0,
0,7,0,
0,7,0,
0,7,0,
0,7,0,
0,8,0,
0,8,0,
0,8,0,
0,8,0,
0,9,0,
0,9,0,
0,9,0,
0,9,0,
0,10,0,
0,10,0,
0,10,0,
0,10,0,
0,11,0,
0,11,0,
0,11,0,
0,11,0,
0,12,0,
0,12,0,
0,12,0,
0,12,0,
0,13,0,
0,13,0,
0,13,0,
0,13,0,
0,14,0,
0,14,0,
0,14,0,
0,14,0,
0,15,0,
0,15,0,
0,15,0,
0,15,0,
0,16,0,
0,16,0,
0,16,0,
0,16,0,
0,17,0,
0,17,0,
0,17,0,
0,17,0,
0,18,0,
0,18,0,
0,18,0,
0,18,0,
0,19,0,
0,19,0,
0,19,0,
0,19,0,
0,20,0,
0,20,0,
0,20,0,
0,20,0,
0,21,0,
0,21,0,
0,21,0,
0,21,1,
0,22,1,
0,22,1,
0,22,2,
0,22,2,
0,23,2,
0,23,3,
0,23,3,
0,23,4,
0,24,4,
0,24,4,
0,24,5,
0,24,5,
0,25,5,
0,25,6,
0,25,6,
0,25,7,
0,26,7,
0,26,7,
0,26,8,
0,26,8,
0,27,8,
0,27,9,
0,27,9,
0,27,10,
0,28,10,
0,28,10,
0,28,11,
0,28,11,
0,29,11,
0,29,12,
0,29,12,
0,29,13,
0,30,13,
0,30,13,
0,30,14,
0,30,14,
0,31,14,
0,31,15,
0,31,15,
0,31,16,
0,32,16,
0,32,16,
0,32,17,
0,32,17,
0,33,17,
0,33,18,
0,33,18,
0,33,19,
0,34,19,
0,34,19,
0,34,20,
0,34,20,
0,35,20,
0,35,21,
0,35,21,
0,35,22,
0,36,22,
0,36,22,
0,36,23,
0,36,23,
0,37,23,
0,37,24,
0,37,24,
0,37,25,
0,38,25,
0,38,25,
0,38,26,
0,38,26,
0,39,26,
0,39,27,
0,39,27,
0,39,28,
0,40,28,
0,40,28,
0,40,29,
0,40,29,
0,41,29,
0,41,30,
0,41,30,
0,41,31,
0,42,31,
0,42,31,
0,42,32,
0,42,32,
0,43,32,
0,43,33,
0,43,33,
0,43,34,
0,44,34,
0,44,34,
0,44,35,
0,44,35,
0,45,35,
0,45,36,
1,45,36,
2,45,37,
3,46,37,
4,46,37,
5,46,38,
5,46,38,
6,47,38,
7,47,39,
8,47,39,
9,47,40,
10,48,40,
11,48,40,
11,48,41,
12,48,41,
13,49,41,
14,49,42,
15,49,42,
16,49,43,
17,50,43,
17,50,43,
18,50,44,
19,50,44,
20,51,44,
21,51,45,
22,51,45,
23,51,46,
23,52,46,
24,52,46,
25,52,47,
26,52,47,
27,53,47,
28,53,48,
29,53,48,
29,53,49,
30,54,49,
31,54,49,
32,54,50,
33,54,50,
34,55,50,
35,55,51,
35,55,51,
36,55,52,
37,56,52,
38,56,52,
39,56,53,
40,56,53,
41,57,53,
41,57,54,
42,57,54,
43,57,55,
44,58,55,
45,58,55,
46,58,56,
47,58,56,
47,59,56,
48,59,57,
49,59,57,
50,59,58,
51,60,58,
52,60,58,
52,60,59,
53,60,59,
54,61,59,
55,61,60,
56,61,60,
57,61,61,
58,62,61,
58,62,61,
59,62,62,
60,62,62,
61,63,62,
62,63,63,
63,63,63,
0,0,0
);


sunpal : palettetype =
(0,0,0,
0,0,0,
0,0,0,
0,0,0,
1,0,0,
1,0,0,
1,0,0,
1,0,0,
2,0,0,
2,0,0,
2,0,0,
2,0,0,
3,0,0,
3,0,0,
3,0,0,
3,0,0,
4,0,0,
4,0,0,
4,0,0,
4,0,0,
5,0,0,
5,0,0,
5,0,0,
5,0,0,
6,0,0,
6,0,0,
6,0,0,
6,0,0,
7,0,0,
7,0,0,
7,0,0,
7,0,0,
8,0,0,
8,0,0,
8,0,0,
8,0,0,
9,0,0,
9,0,0,
9,0,0,
9,0,0,
10,0,0,
10,0,0,
10,0,0,
10,0,0,
11,0,0,
11,0,0,
11,0,0,
11,0,0,
12,0,0,
12,0,0,
12,0,0,
12,0,0,
13,0,0,
13,0,0,
13,0,0,
13,0,0,
14,0,0,
14,0,0,
14,0,0,
14,0,0,
15,0,0,
15,0,0,
15,0,0,
15,0,0,
16,0,0,
16,0,0,
16,0,0,
16,0,0,
17,0,0,
17,0,0,
17,0,0,
17,0,0,
18,0,0,
18,0,0,
18,0,0,
18,0,0,
19,0,0,
19,0,0,
19,0,0,
19,0,0,
20,0,0,
20,0,0,
20,0,0,
20,0,0,
21,0,0,
21,0,0,
21,0,0,
21,1,0,
22,1,0,
22,1,0,
22,2,0,
22,2,0,
23,2,0,
23,3,0,
23,3,0,
23,4,0,
24,4,0,
24,4,0,
24,5,0,
24,5,0,
25,5,0,
25,6,0,
25,6,0,
25,7,0,
26,7,0,
26,7,0,
26,8,0,
26,8,0,
27,8,0,
27,9,0,
27,9,0,
27,10,0,
28,10,0,
28,10,0,
28,11,0,
28,11,0,
29,11,0,
29,12,0,
29,12,0,
29,13,0,
30,13,0,
30,13,0,
30,14,0,
30,14,0,
31,14,0,
31,15,0,
31,15,0,
31,16,0,
32,16,0,
32,16,0,
32,17,0,
32,17,0,
33,17,0,
33,18,0,
33,18,0,
33,19,0,
34,19,0,
34,19,0,
34,20,0,
34,20,0,
35,20,0,
35,21,0,
35,21,0,
35,22,0,
36,22,0,
36,22,0,
36,23,0,
36,23,0,
37,23,0,
37,24,0,
37,24,0,
37,25,0,
38,25,0,
38,25,0,
38,26,0,
38,26,0,
39,26,0,
39,27,0,
39,27,0,
39,28,0,
40,28,0,
40,28,0,
40,29,0,
40,29,0,
41,29,0,
41,30,0,
41,30,0,
41,31,0,
42,31,0,
42,31,0,
42,32,0,
42,32,0,
43,32,0,
43,33,0,
43,33,0,
43,34,0,
44,34,0,
44,34,0,
44,35,0,
44,35,0,
45,35,0,
45,36,0,
45,36,1,
45,37,2,
46,37,3,
46,37,4,
46,38,5,
46,38,5,
47,38,6,
47,39,7,
47,39,8,
47,40,9,
48,40,10,
48,40,11,
48,41,11,
48,41,12,
49,41,13,
49,42,14,
49,42,15,
49,43,16,
50,43,17,
50,43,17,
50,44,18,
50,44,19,
51,44,20,
51,45,21,
51,45,22,
51,46,23,
52,46,23,
52,46,24,
52,47,25,
52,47,26,
53,47,27,
53,48,28,
53,48,29,
53,49,29,
54,49,30,
54,49,31,
54,50,32,
54,50,33,
55,50,34,
55,51,35,
55,51,35,
55,52,36,
56,52,37,
56,52,38,
56,53,39,
56,53,40,
57,53,41,
57,54,41,
57,54,42,
57,55,43,
58,55,44,
58,55,45,
58,56,46,
58,56,47,
59,56,47,
59,57,48,
59,57,49,
59,58,50,
60,58,51,
60,58,52,
60,59,52,
60,59,53,
61,59,54,
61,60,55,
61,60,56,
61,61,57,
62,61,58,
62,61,58,
62,62,59,
62,62,60,
63,62,61,
63,63,62,
63,63,63,
63,63,63
);



procedure screenmode(mode : byte);

begin
  asm
    mov  ah,00           {set value in ah to 00}
    mov  al,mode         {set value in al to whatever mode ($13 or 3)}
    int  10h
  end;
end;

procedure assigngraypal;   {Special procedure for 64 color Grayscale}

var
  x : integer;

begin
  for x := 0 to 63 do
    begin
      port[$3C8] := x;
      port[$3C9] := graypal[x*3];
      port[$3C9] := graypal[x*3+1];
      port[$3C9] := graypal[x*3+2];
    end;
end;

procedure setpalette(palette : shortint);

label green,rainbow,blue,red,sun;

var x : integer;

begin
  case palette of
    1 : begin
          AssignGrayPal;
          exit;
        end;
    2 : exit;             {standard VGA palette}
    3 : goto rainbow;
    4 : goto red;
    5 : goto green;
    6 : goto blue;
    7 : goto sun;
    else exit;
  end;
rainbow:  for x := 0 to 255 do
    begin
      port[$3C8] := x;
      port[$3C9] := rainbowpal[x*3];
      port[$3C9] := rainbowpal[x*3 + 1];
      port[$3C9] := rainbowpal[x*3 + 2];
    end;
    exit;
sun    :  for x := 0 to 255 do
    begin
      port[$3C8] := x;
      port[$3C9] := sunpal[x*3];
      port[$3C9] := sunpal[x*3 + 1];
      port[$3C9] := sunpal[x*3 + 2];
    end;
    exit;
blue   :  for x := 0 to 255 do
    begin
      port[$3C8] := x;
      port[$3C9] := bluepal[x*3];
      port[$3C9] := bluepal[x*3 + 1];
      port[$3C9] := bluepal[x*3 + 2];
    end;
    exit;
red    :  for x := 0 to 255 do
    begin
      port[$3C8] := x;
      port[$3C9] := redpal[x*3];
      port[$3C9] := redpal[x*3 + 1];
      port[$3C9] := redpal[x*3 + 2];
    end;
    exit;
green  :  for x := 0 to 255 do
    begin
      port[$3C8] := x;
      port[$3C9] := greenpal[x*3];
      port[$3C9] := greenpal[x*3 + 1];
      port[$3C9] := greenpal[x*3 + 2];
    end;
    exit;
end;

procedure putpixel(x,y:integer;color:byte);

begin
  mem[$A000:((y-1) * 320) + x] := color;
end;


end.