include dpmi.inc
codeseg

dpmi_allocateDosMem    proc
arg bufsize:dword

        SAVEBX

; Adjust bufsize to paragraph count (fail if more than 64K paragraphs).
IFDEF __FLAT__
        mov     ebx,bufsize
        add     ebx,15
        shr     ebx,4
        mov     eax,ebx
        shr     eax,16
        or      ax,ax
        jnz     @@Fail
ELSE
        mov     bx,word ptr bufsize
        mov     ax,word ptr bufsize+2
        add     bx,15
        adc     ax,0
        mov     cx,4
@@1:    shr     ax,1
        rcr     bx,1
        loop    @@1
        or      ax,ax
        jnz     @@Fail
ENDIF

        calldpmi 0100h
        jc      @@Fail

IFDEF __FLAT__
; put DX:AX into EAX
        shl     edx,16
        mov     dx,ax
        mov     eax,edx
ENDIF

@@Done:
        RESTOREBX
        ret
@@Fail:
IFDEF __FLAT__
        xor     eax,eax
ELSE
        xor     ax,ax
        mov     dx,ax
ENDIF
        ret
endp

public  dpmi_allocateDosMem
end
