include dpmi.inc
codeseg
dpmi_present   proc
arg infoPtr:Pointer

        SAVEBX
;
; First ensure that int 2F is installed.
;
        push    es
        mov     ax,352Fh
        int     21h
        mov     ax,es
        or      ax,bx
        pop     es
        jz      @@Fail
;
; Now try and get the DPMI info.
;
        mov     ax,1687h
        int     2Fh
        or      ax,ax
        jz      @@Fail
        mov     ax,bx
;
; The user CAN pass in a null pointer argument!
;
IFDEF __FLAT__
        mov     ebx,infoPtr
        or      ebx,ebx
        jz      @@Pass
        and     al,1
        mov     byte ptr [ebx.info_supports32Bit],al
        mov     byte ptr [ebx.info_cpu],cl
        mov     byte ptr [ebx.info_major],dh
        mov     byte ptr [ebx.info_minor],dl

ELSE
        test    word ptr infoPtr,0FFh
        jz      @@Pass
        push    ds
        lds     bx,infoPtr
        and     al,1
        mov     byte ptr [bx.info_supports32Bit],al
        mov     byte ptr [bx.info_cpu],cl
        mov     byte ptr [bx.info_major],dh
        mov     byte ptr [bx.info_minor],dl
        pop     ds
ENDIF

@@Pass:
        mov     INTRESULT,1
        ret
@@Fail:
        xor     INTRESULT,INTRESULT
        ret
endp

public  dpmi_present
end

