UNIT PICDEF;
(*----------------------------------------------------------------------------
                 author  : Michael Fiel
                   date  : 06.02.1995 - 10.02.1995
                 version : 1.00
           (C) copyright : Michael Fiel, Vienna 1995

This file is part of unit <PICTRANS> see more information in "PicTrans.Pas"
----------------------------------------------------------------------------*)
INTERFACE
  USES
    Objects;

  CONST
    MaxTiffTags = 200; (* Max count of Tiff Tags                            *)
    (* Picture Type constants                                               *)
    piPCX  = 1;
    piBMP  = 2;
    piTIFF = 3;

  TYPE
    PalArray = array [0..15,0..2] of Byte; (* GetPalette                    *)

(*----------------------------------------------------------------------------
.BMP  definitions
----------------------------------------------------------------------------*)
    TBmpHeader = record (* BMP file header                                  *)
      Signatur : Word;          (* signature 'BM'                           *)
      FLen     : Longint;       (* File length in byte                      *)
      Dummy1   : Word;          (* reserved                                 *)
      Dummy2   : Word;          (* reserved                                 *)
      Offset   : Longint;       (* offset of oicture data                   *)
    end;

    TBmpInfo = record (* BMP information header                             *)
      InfoSize     : Longint;   (* info header length (=40)                 *)
      Xmax         : Longint;   (* picture width x-dimension in pixel       *)
      Ymax         : Longint;   (* picture width y-dimension in pixel       *)
      Planes       : Word;      (* color dimension must be 1                *)
      BitsPerPixel : Word;      (* Bits/Pixel - 1, 2 4, 8                   *)
      Compress     : LongInt;   (* compression Type                         *)
      XSize        : Longint;   (* Picture Size X-Dimension in Byte         *)
      Hdpi         : Longint;   (* pic dimension in pels horizontal         *)
      Vdpi         : Longint;   (*           -""-        vertikal           *)
      Cols         : Longint;   (* colors used                              *)
      Coli         : Longint;   (* necessary colors                         *)
    end;

(*----------------------------------------------------------------------------
.PCX definitions
----------------------------------------------------------------------------*)
    TPcxHeader = record (* PCX File header                                  *)
      Signature: Byte;                       (* always 10                   *)
      Version  : Byte;                       (* 5 - with palette            *)
      Encoding : Byte;                       (* 1 PCX compression 0 none    *)
      BitsPerPix : Byte;                     (* Bits/Pixel - 1, 2 4, 8      *)
      Xmin : Integer;                        (* Pic dimensions              *)
      Ymin : Integer;
      Xmax : Integer;
      Ymax : Integer;
      Hdpi : Integer;                        (* (dots per inch)             *)
      Vdpi : Integer;                        (* 300 is default              *)
      ColorMap: Array [0..15, 1..3] of Byte; (* RGB palette for 16 colors   *)
      Reserved : Byte;                       (* set to 0                    *)
      NPlanes : Byte;                        (* plane count                 *)
      BytesPerLinePerPlane : Integer;        (* Byte/Line                   *)
      PaletteInfo : Integer;                 (* 1 or 2                      *)
      HScreenSize : Integer;                 (* for Paintbrush IV Plus      *)
      VScreenSize : Integer;                 (* "                           *)
      Dummy : Array [74..127] of Byte;       (* filler                      *)
    end;
(*----------------------------------------------------------------------------
.TIFF definitions
----------------------------------------------------------------------------*)
  CONST
    (* TAG data type *)
    tiByte  = $01;
    tiChar  = $02;
    tiWord  = $03;
    tiLong  = $04;
    (* TAG format *)
    ttSubFile       = $0FF;
    ttImageWidth    = $100;
    ttImageLength   = $101;
    ttBitsPerSample = $102;
    ttCompresion    = $103;
    ttPhotoMetric   = $106;
    ttStripOffset   = $111;
    ttOrientation   = $112;
    ttSamplesPPixel = $115;
    ttMinSampleVal  = $118;
    ttMaxSampleVal  = $119;
    ttPlanarConfig  = $11C;
    ttColorResUnit  = $12C;
    ttColorResCurve = $12D;
    ttColorMap      = $140;

  TYPE
    TTiffHeader = record (* Header for tiff files                           *)
      ByteOrder : Array[0..1] of Char; (* II = Intel / MM = Motorola        *)
      VerID     : Integer;             (* always $2A                        *)
      FirstIFD  : LongInt;             (* Offset of first IFD Blok          *)
    end;

    (* for a desripten of the use of TAG please see object TScreenToTIFF in
       unit "PICTRANS.PAS"                                                  *)
    PTiffTag = ^TTiffTag;
    TTiffTag = object(TObject) (* aTiff Tag                                 *)
      TagType : Integer; (* Type of the Tiff TAG                            *)
      DatType : Integer; (* Type of holded Data valid : [tiByte..tiLong]    *)
      Length  : LongInt; (* length of data                                  *)
      Data    : LongInt; (* Data or Pointer to data (file offset)           *)
      constructor Init(TType,DType : Integer; Len,Dat : LongInt);
      (* initialize data, where
        <TType> is the type off the TAG
        <DType> is the Type of data to be hold
        <Length> is the length of the data or the count of the data
        <Dat> is the data or a file offset of the data                      *)
    end;

IMPLEMENTATION
  USES
    Memory;

  constructor TTiffTag.Init(TType,DType : Integer; Len,Dat : LongInt);
    (* for a desripten of the use of TAG please see object TScreenToTIFF in
       unit "PICTRANS.PAS"                                                  *)
    begin
      {$IFDEF VER70}
      if not inherited Init then FAIL;
      {$ELSE}
      TObject.Init;
      {$ENDIF}
      TagType := TType;
      DatType := DType;
      Length  := Len;
      Data:=Dat;
    end;

END.