UNIT PICTRANS;
(*----------------------------------------------------------------------------
                 author  : Michael Fiel
                   date  : 11FEB95
                 version : 1.00
           (C) copyright : Michael Fiel, Vienna 1995

       compiler versions : TP 6.x, TP 7.x, BP 7.x

                 targets : DOS real mode
                           DOS protected mode

  supported file formats : PCX Ver 5.0 RLE compression
                           BMP No Compression
                           TIFF Ver 5.0 no compression

  supported grafic modes : VGA 640x480 16 colors

!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!ATTENTION : Use only with a VGA color adapter and 640x480 16 color Mode.!!!!!
!DON'T USE ANY OTHER VIDEO MODES !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

This unit is FREEWARE (i.e. no charge,no liability), you can contribute this
library on every media you want, as long as it's an unmodified version,
please do not contribute modfied versions, I will not support any of them.
The legal stuff first, this source is protected via the AUSTRIAN law
(Copyright...). This code has bugs (see known problems), use it at your own
risk, and test it very well.

List of Files :

  "PICTRANSPAS" : this file
  "PICDEF.PAS"  : definitions for this unit
  "PDEMO.PAS"   : demonstyration for this unit

Version 1.00 only supports 640x480 16 colors VGA, maybe future versions will
support more grafic modes or more file formats, but what I have now is enough
for me, I can't say if or when I'll update this version.

This unit contains Objects to save screen parts into either BMP/PCX/TIFF
files. The sipelst way to use this unit is to use the function

  function SaveScreen(PicType : Word;FName : String;Where:TRect) : Boolean;

which is described in detail further down. If you are not used to the
data type TRect, watch Borlands help or manual. This function will save
the rectangle defined in <Where> into the file with the name FName. If this
file already exists, it will be overwritten. The type of the file can be set
in the functions paramter <PicType>. Valid values, which are defined in unit
PicDef, are : piPCX .... PCX file format
              piBMP .... BMP file format
              piTIFF ... TIFF file format

that's it for the simple way.

This unit does not use BGI drivers, althoug I'm not sure about the
Palette call in the constructor of Object TScreenToPic. I normaly use
a grafics libary (GVision) which is compatible to Borlands TV and provides
Palette calls to me, I adapted this call for non GVision useres, I tested
in DPMI and REAL and it seem to work.

Now to the object hirachy

  TScreenToPic : This is the "father" off all following objects, which defines
  -------------- the methodes the derived objects should use. The object is
                 initialised with the Coordiantes ot the screen rect, that's
                 it. If you want this object to save the screen rect, call the
                 function Save, which assumes a Stream to save it's data. The
                 function Save calls SaveHeader which should save the Header
                 information into the stream. Derived Objects must overwrite
                 SaveHeader which MUST call SavePalette. The palette can stay
                 at various places, so it's you responsabilty to save it at the
                 right place. After calling save header, function save saves
                 all the rest of the picture i.e. the pixel data.
                 TScreenToPic offers two functions which are used for direct
                 screen access. GetPixel is awfull slow, so I decided to
                 access the screen memory direct, that's why this unit supports
                 only VGA 640x480x16 modus. The function RasterScreenPlanes
                 copies the values of the 4 vga planes into a buffer, so one
                 line (length=Size.X) is copied in a row for all 3 colors
                 and the intensity. this is used directly by the PCX file
                 format, TIFF and BMP use the funtion RasterLine, which
                 decodes the 4 values of the Planes into 1 buffer, which
                 then contains the colors off all pixels in a row. Using
                 RasterLine is the second easiest way, this is like getpixel
                 for the whole line.

  TScreenToPCX : This objects uses the methodes off TScreenToPic and adds
  -------------- a New funtion to Encrypt the Data. Screen will be saved into
                 a PCX File.

  TScreenToBMP : This objects uses the methodes off TScreenToPic and adds
  -------------- no new funtion. Screen will be saved into a BMP File.

  TScreenToTIFF: This objects uses the methodes off TScreenToPic and adds
  -------------- new functions for TAG handling.
                 Screen will be saved into a TIFF File.

if you want to add new picture types, or if you find any bugs, or if you
have anly problems, or if you just want to say hallo, please send me an
e-mail to :

 CIS      : 100041,2007
 Internet : 100041.2007@compuserve.com

!! I will only give support via the Compuserve Information Service !!!

KNOWN PROBLEMS :

I had some problems when the Size.X value is odd with the most picture types.
In BMP the size must be (Size.X mod 4 = 0)... I tried to cath this, but to
stay save please use only even dimensions for the screen rect.

I have testet the pictures with various programs (PaintBrush,PhotoShop..)
and it seem to work.

please excuse all grammar or other errors, english is not my native language.

have fun,

11FEB1995 Michael Fiel, Vienna Austria

Some words at the end, Austria today is shocked by a nazi terror bomb attack,
where 4 people belonging to a certain minority where killed.
please not again, help stop racism.

WITH CREDITS TO : Ian Ashdown, P.Eng., Vancouver,Canada
                  code adapted from his libary PCX_COMM.C Ver 1.00B PublicDoamin

                  Gnter Born, for his book "Dateiformate, Programmier-
                  handbuch" Addison-Wesely ISBN 3-89319-477-0 german language

----------------------------------------------------------------------------*)
{$IFDEF WINDOWS} 'ERROR - This unit does not support this compiler target' {$ENDIF}
INTERFACE
  USES
    PicDef,  (* Type and Const definitions for this unit                    *)
    Objects; (* used for TRect,Objects,Collections,Streams                  *)

(*---------------------------------------------------------------------------
  function SaveScreen(PicType : Word;FName : String;Where:TRect) : Boolean;

  Saves a screen rect into the specified file format, where
  <PicType> : is the Type of the file format.
              valid values are : piPCX .... PCX file format
                                 piBMP .... BMP file format
                                 piTIFF ... TIFF file format
  <FName>   : is the name of the file (no error checking for filename)
  <Where>   : contains the Screen Cordinates (A.X,A.Y,B.X,B.Y)

  returns true if the screen rect was saved correctly otherwise false
----------------------------------------------------------------------------*)
function SaveScreen(PicType : Word;FName : String;Where:TRect) : Boolean;
(*--------------------------------------------------------------------------*)
  TYPE
    PScreenToPic = ^TScreenToPic; (* description see above                  *)
    TScreenToPic = object(TObject)

      Where      : TRect; (* Screen Coordinates of the rect                 *)
      Size       : TPoint; (* Size X,Y of Rect                              *)
      BPerLPlane : Word; (* How many Bits per Plane ?                       *)
      BPerLine   : Word; (* How many Bits per line ?                        *)

      PlaneBuf   : Array[0..320] of Byte; (* Buffer for plane (80*4)        *)
      LineBuf    : Array[0..640] of Byte; (* Buffer for one Line            *)

      Palette    : PalArray; (* active Palette 16 colors                    *)
      Mask       : Integer; (* Mask for unused bits                         *)

      constructor Init(Bounds : TRect); (* initialize                       *)
      (* returens length of the Palette fo a file type                      *)
      function    GetPaletteLen : Word; virtual;

      (* Saves the Screen rect into the Stream S                            *)
      function    Save(var S : TStream) : Boolean; virtual;
      (* Saves the Header into the stream S                                 *)
      function    SaveHeader(var S : TStream) : Boolean; virtual;
      (* Saves the Palette into Stream S                                    *)
      function    SavePalette(var S : TStream) : Boolean; virtual;

      (* compress 2 Pixels into 1 Byte and saves the hole line into <S>     *)
      function    Save2in1(var S:TStream) : Boolean; virtual;

      (* reads all 4 planes out the screen memory                           *)
      function    RasterScreenPlanes(Line : Word) : Boolean; virtual;
      (* converts plane information into PicelColor Info for 1 line         *)
      function    RasterLine(Line : Word) : Boolean; virtual;
      (* returnes Red,Green and Blue value for Color <Color>                *)
      procedure   GetRGBColor(Color : Word;var R,G,B:Byte); virtual;

    end;

    PScreenToPCX = ^TScreenToPCX; (* Save a PCX File                        *)
    TScreenToPCX = object(TScreenToPic)

      PHeader     : TPCXHeader; (* PCX Header                               *)
      EBuf        : Array[0..1024] of Byte; (* Buffer for Encoded picture   *)
      EBufSize    : Word; (* Count of Encoded bytes in <EBuf>               *)

      (* all from derived object                                            *)
      function    GetPaletteLen : Word; virtual;
      function    Save(var S : TStream) : Boolean; virtual;
      function    SaveHeader(var S : TStream) : Boolean; virtual;
      function    SavePalette(var S : TStream) : Boolean; virtual;
      function    EncodeLine : Boolean; virtual;

    end;

    PScreenToBMP = ^TScreenToBMP; (* Saves a BMP FIle                       *)
    TScreenToBMP = object(TScreenToPic)
      (* all from derived object                                            *)
      function    GetPaletteLen : Word ; virtual;
      function    Save(var S : TStream) : Boolean; virtual;
      function    SaveHeader(var S : TStream) : Boolean; virtual;
      function    SavePalette(var S : TStream) : Boolean; virtual;
    end;

    PScreenToTIFF = ^TScreenToTiff; (* Saves a TIFF file                    *)
    TScreenToTiff = object(TScreenToPic)

      TagColl     : PCollection; (* Container for TIFF Tags                 *)
      IFDOffset   : Word; (* Offset off first IFD                           *)

      (* all from derived object                                            *)
      constructor Init(Bounds : TRect);
      destructor  Done; virtual;
      function    GetPaletteLen : Word ; virtual;

      function    Save(var S : TStream) : Boolean; virtual;
      function    SaveHeader(var S : TStream) : Boolean; virtual;
      function    SavePalette(var S : TStream) : Boolean; virtual;
      (* New function *)
      (* Creates TIFF Tags                                                  *)
      function    CreateTags : Boolean; virtual;
      (* Modify a Tiff Tag                                                  *)
      function    ModifyTag(TagType,NewLen,NewVal : LongInt) : Boolean;

    end;

IMPLEMENTATION
  USES
    Dos; (* Register                                                        *)

  TYPE
(*----------------------------------------------------------------------------
OBJECT TTagCollection

This container is used to hold the TAGS for the TAG Image File Format.
It's a descent of a sorted collection because Tags must be sorted in
ascending order, overwriting the function compare makes it possible to insert
TAGS at the right place = insert and forget.

see more at the TTScreenToTiff object description
----------------------------------------------------------------------------*)
    PTagCollection = ^TTagCollection; (* Tags immer aufsteigend sortiert *)
    TTagCollection = object(TSortedCollection)
      function Compare(Key1, Key2: Pointer): Integer; virtual;
    end;

(*----------------------------------------------------------------------------
OBJECT TScreenToPic
----------------------------------------------------------------------------*)

  constructor TScreenToPic.Init(Bounds:TRect);
    var
      Regs : Registers; (* Used for the GetPalette call                     *)
    begin

      if Bounds.Empty then FAIL;(* if it's not a valid screenrect then fail *)
      {$IFDEF VER70}
      if not inherited Init then FAIL;
      {$ELSE}
      TObject.Init;
      {$ENDIF}

      Where:=Bounds; (* save screen coordinates                             *)
      Size.X:=(Where.B.X - Where.A.X); (* calculate X-dimension in pixel    *)
      Size.Y:=(Where.B.Y - Where.A.Y); (* calculate Z-dimension in pixel    *)

      BPerLine:=((Size.X + 7) SHR 3); (* caculate ammount of Bits per line  *)
      (* calculate bits per PLane, musst be even                            *)
      BPerLPlane := 2 * (((((Size.X - 1) + 7) SHR 3) + 1) DIV 2);

      (* calculate Bit Mask to cut off unused Pixels                        *)
      Mask := (Size.X AND 7);
      if (Mask <> 0) then Mask:=($FF SHR Mask);

      (* receive the actual color Palette for VGA 640x480 16 colors         *)
      Regs.AH:=$10;
      Regs.AL:=$17;
      Regs.BX:=$00;
      Regs.CX:=16;
      Regs.DX:=Ofs(Palette);
      Regs.ES:=Seg(Palette);
      Intr($10,Regs);
      (* Palette received, constructor finished                             *)

    end;

  function TScreenToPic.GetPaletteLen : Word;
    (* This function will be used by descent objects to determine the
       length of the palette wich will be saved in this file format         *)
    begin
      GetPaletteLen:=0; (* default value i.e. no palette                    *)
    end;

  procedure TScreenToPic.GetRGBColor(Color : Word;var R,G,B:Byte);
    (* returns the Reg,Green and Blue Value in <R,G,B>                      *)
    (* where <Color> means, yes the color, a value between 0..15;           *)
    begin
      R:=(Palette[Color,0] mod 64);
      G:=(Palette[Color,1] mod 64);
      B:=(Palette[Color,2] mod 64);
    end;

  function TScreenToPic.Save(var S : TStream) : Boolean;
    (* This function saves the whole screen rect.
       It first calls function SaveHeader, almost every picture file format
       has some kind of header. Desecnt objects must overwrite this methode,
       and call it first, and then save the pictures data themself

       Datas are to be saved into the Stream <S>, there is no error checking
       if <S> is assigned in descent objects, and the Stream is not closed
       at the end !                                                         *)
    begin
      if not (S.Status=stOK) then (* Stream OK ?                            *)
        Save:=False (* NO                                                   *)
      else
        Save:=SaveHeader(S); (* Save the files header                       *)
    end;

  function TScreenToPic.SaveHeader(var S : TStream) : Boolean;
    (* This function is designed to save the Header data of a picture.
       It is also responsible to call the function SavePalette, because
       palette informations are sved on various places, be shure to call
       function savepallette in descent objects
       Datas are to be saved into the Stream <S>                            *)
    begin
      ABSTRACT; (* run an error                                             *)
    end;

  function TScreenToPic.SavePalette(var S : TStream) : Boolean;
    (* This function is designed to save the palette information of a screen
       rect, it must be overwritten in descent objects, and is called
       from the SaveHeader function. The length of a palette is determined
       by the function GetPalette, this is needed especialy for the TIFF
       object, if want to save greater resolution pictures dont forget
       to overerite.                                                        *)
    begin
      ABSTRACT;
    end;

  function TScreenToPic.Save2in1(var S:TStream) : Boolean;
    (* saves 2 Pixels stored in <LineBuf> as a byte into 1 byte of
       <OutBuf>. works with 16 colors and is used from the
       BMP and TIFF object to save 16 color screen lines                    *)
    var
      OutBuf : array[0..320] of byte; (* 640, can not be greater            *)
      Color  : Byte; (* packed color for OutBuf                             *)
      i      : Integer; (* counter variable                                 *)
    begin

      Save2in1 := False;

      for i:=0 to Size.X-1 do begin (* Step 2, where's my basic ???         *)

        Color:=(LineBuf[i] SHL 4); (* Get 1 color and pack it               *)
        inc(i); (* step 2 , where's ......                                  *)
        inc(Color,(LineBuf[i] AND $0F)); (* and pack second byte            *)

        OutBuf[i DIV 2]:=Color; (* set color in out buffer                  *)

      end;

      S.Write(OutBuf,(Size.X+1) DIV 2); (* Write OutBuffer into stream      *)

      Save2in1:=(S.Status=stOK);

    end;

  function TScreenToPic.RasterLine(Line : Word) : Boolean;
    (*  copies the Data of the 4 Planes of a VGA card into the array
       <LineBuf>, <LineBuf> then contains a number of bytes which
       represent the pixel colors of the screen Line <Line>, where
       <line> means the ***relative*** linenumber of the ScreenRect,
       **not** the absolute line number.
       the function RasterScreenPlanes copies the 4 planes in an array
       <PlaneBuf> see more there.
       if you want to use other modes then 640x480x16 then you have
       to change this function, but be carefull with your VGA and monitor   *)
    var
      b,b1     : byte;
      t,i,j    : Integer;

    begin

      RasterLine:=False;

      if (RasterScreenPlanes(Line)) then begin
        (* all 4 planes are now in a row in <PlaneBuf>                      *)

        for t := 0 to Size.X-1 do begin (* the whole line length            *)

          b:=0;

          for i:=3 downto 0 do begin (* all 4 planes                        *)

            (* Get the right byte ot the Plane no. <i>                      *)
            j:=(t mod 8); (* that's the bit of interrest                    *)
            if ((j=0) and (t>0)) then begin
              b1:=PlaneBuf[(i*BPerLPlane) + (t DIV 8)-1];
              j:=1;
            end else begin
              b1:=PlaneBuf[(i*BPerLPlane) + (t DIV 8)];
              j:=(1 SHL (8-j)); (* = 2^x *)
            end;

            (* is the right bit set ?                                       *)
            if (b1 and j = j) then (* yes it is                             *)
              b:= (b or (1 SHL i)); (* add color factor                     *)

          end;

          LineBuf[t]:=b; (* save color of pixel in <LineBuf>                *)

        end;

        RasterLine:=True;

      end;

    end;

  function TScreenToPic.RasterScreenPlanes(Line : Word) : Boolean;
    (* this function copies the 4 planes which are used to store the
       color information in a vga adapter in a row into <PlaneBuf>, where
       <line> means the ***relative*** linenumber of the ScreenRect,
       **not** the absolute line number.
       for more infos on vga plane design, please take a book, but you
       need to change this methode, if you want to use other vga modi,
       because the plane design and memory offsets for vga adapters
       change, be carfull.                                                  *)

    var
      VAddr    : Pointer; (* Pointer to Screen Memory                       *)
      Plane    : Integer; (* no. of plane                                   *)
      b        : byte;

    begin

      RasterScreenPlanes:=False;

      inc(Line,Where.A.Y); (* calculate absolute value of line nr           *)

      (* calculate Pointer do Screen Mem !!!! Only VGA 16 Colors !!!!       *)
      VAddr:=Ptr(SegA000,Line*80+(Where.A.X DIV 8));

      for Plane :=0 to 3 do begin (* get planes in arow                     *)

        PortW[$03CE]:=((Plane SHL 8) or $04); (* set plane and writemodus 0 *)

        (* copy screen memory into <PlaneBuf>                               *)
        Move(VAddr^,PlaneBuf[(Plane*BPerLPlane)],BPerLPlane);

        (* mask off unused pixels                                           *)
        b:=PlaneBuf[BPerLPlane-1];
        b := (b or Mask);
        PlaneBuf[BPerLPlane-1]:=b;

        if (BPerLPlane and 1) = 1 then begin (* add byte                    *)
          b:=$FF;
          PlaneBuf[BPerLPlane]:=b;
        end;

        RasterScreenPlanes:=True;

        PortW[$03C4]:=$0F02; (* enable all color planes, write mode 0       *)

      end;

    end;

(*----------------------------------------------------------------------------
OBJECT TScreenToPCX

Saves a screen rect as a PCX file, desent of TScreenToPic

PCX is a file format desined from ZSoft. It has a header, followd by
compressed data (repeat count + Value), and stores the picture information
like the VGA planes r,g,b and intensity.

File Type is PCX 5.0 compression 1 16 colors VGA 640x480
----------------------------------------------------------------------------*)

  function TScreenToPCX.GetPaletteLen : Word;
    begin
      GetPaletteLen:=(16 * 3); (* 16 R+G+B entries                          *)
    end;

  function TScreenToPCX.EncodeLine : Boolean;
    (* encodes a line stored in <LineBuf> into <EBuf>, this is the
       standard compression for pcx, but sometimes it can happen that
       unencoded pictures are smaller then encoded
       Saves the dta as they come directly from the plane r,g,b and
       intensity in a row                                                   *)
    var
      LastV : Byte; (* Last color value                                     *)
      Val   : Byte; (* color value                                          *)
      RCnt  : Byte; (* repeat count                                         *)
      t     : Integer; (* counter var                                       *)

    (* Writes the value <aVal> into <EBuf> according the PCX compression    *)
    procedure Encode(aVal,aCount : Byte);
      var
        b:byte;
      begin
        if (((aVal and $C0) = $C0) or (aCount>1)) then begin
          b := ($C0 or aCount);
          EBuf[EBufSize]:=b;
          inc(EBufSize);
        end;
        EBuf[EBufSize]:=aVal;
        inc(EBufSize);
      end;

    begin

      EncodeLine:=False;
      EBufSize:=0;

      LastV:=PlaneBuf[0]; (* get plane value                                *)
      RCnt:=0;

      for t:=0 to (BPerLPlane * 4) - 1 do begin (* all pixel infos          *)

        Val:=PlaneBuf[t]; (* actual value                                   *)

        if (Val=LastV) then begin (* repeated value ?                       *)

          inc(RCnt); (* inc repetition count                                *)
          if RCnt=$3F then begin
            Encode(LastV,RCnt); (* encode value and count into <EBuf>       *)
            RCnt:=0;
          end;

        end else begin

          if RCnt>0 then Encode(LastV,RCnt); (* encode stuff                *)

          LastV:=Val;
          RCnt:=1;

        end;

      end;

      if RCnt > 0 then Encode(LastV,RCnt); (* something forgotten ?         *)

      EncodeLine:=True;

    end;

  function TScreenToPCX.SaveHeader(var S : TStream) : Boolean;
    begin

      SaveHeader:=False;

      FillChar(PHeader,SizeOf(PHeader),0);

      with PHeader do begin

        Signature  := 10; (* always 10                                      *)
        Version    := 5;  (* PCX with palette information                   *)
        Encoding   := 1;  (* compression yes                                *)
        BitsPerPix := 1;  (* 1 Bit/Pixel                                    *)
        XMin       := 0;
        YMin       := 0;
        XMax       := Size.X-1; (* Picture Size X-Dimension                 *)
        YMax       := Size.Y-1; (* Picture Size Y-Dimension                 *)
        HDpi       := 640;
        VDpi       := 480;
        Reserved   := 0;
        NPlanes    := 4;  (* R,G,B & Intesity                               *)
        BytesPerLinePerPlane := BPerLPlane;
        PaletteInfo := 1;
        HScreenSize :=640;
        VScreenSize :=480;
      end;

      if SavePalette(S) then begin (* Save palette (part of header)         *)
        S.Write(PHeader,SizeOf(PHeader)); (* write header+palette into <S>  *)
        SaveHeader:=(S.Status=stOK);
      end;

    end;

  function TScreenToPCX.SavePalette(var S : TStream) : Boolean;
    var
      R,G,B    : Byte;
      t        : Integer;
    begin

      SavePalette:=False;

      with PHeader do begin
        for t:=0 to 15 do begin (* get all colors                           *)
          GetRGBColor(t,R,G,B); (* get r+g+b part                           *)
          (* and save them                                                  *)
          ColorMap[t,1]:=((R SHL 6) or (R SHL 4) or (R SHL 2));
          ColorMap[t,2]:=((G SHL 6) or (G SHL 4) or (G SHL 2));
          ColorMap[t,3]:=((B SHL 6) or (B SHL 4) or (B SHL 2));
        end;
      end;

      SavePalette:=True;

    end;

  function TScreenToPCX.Save(var S : TStream) : Boolean;
    var
      t        : Integer;

    begin

      Save:=False;

      (* allways call previous object, calls save header and save palette   *)
      {$IFDEF VER70}
      if inherited Save(S) then begin
      {$ELSE}
      if TScreenToPic.Save(S) then begin
      {$ENDIF}

        for t := 0 to Size.Y-1 do begin (* now save rest of the picture     *)

          if (RasterScreenPlanes(t)) then begin (* copy screen memory       *)
            if not EncodeLine then EXIT; (* encode screen data              *)
            S.Write(EBuf,EBufSize); (* write screen data into stream        *)
          end else
            EXIT;

        end;

      end;

      Save:=True;

    end;

(*----------------------------------------------------------------------------
OBJECT TScreenToBMP

Save a screen rect into a .BMP file.

Windows BMP has a header with version ID... followed by a Information
header holding data like size colors...
Picture data a saved like they are on the screen, where 1 byte represent
the color codes of 2 screen pixels.

File Type : BMP no compression VGA 640x480 16 colors
----------------------------------------------------------------------------*)
  function TScreenToBMP.GetPaletteLen : Word;
    begin
      GetPaletteLen:=(16 * 4); (* R,G,B + reserved for 16 colors            *)
    end;

  function TScreenToBMP.SaveHeader(var S : TStream) : Boolean;
    var
      BHeader : TBmpHeader; (* BMP header (Unit PICDEF)                     *)
      BInfo   : TBmpInfo;   (* BMP info header (Unit PICDEF)                *)
      VSize   : LongInt;    (* File Size                                    *)
    begin

      SaveHeader:=False;

      (* calculate file size                                                *)
      VSize:=((LongInt(Size.X) * LongInt(Size.Y)) DIV 2);

      with BHeader do begin
        Signatur:=$4D42; (* 'BM'                                            *)
        FLen:=SizeOF(BHeader)+SizeOF(BInfo)+GetPaletteLen+VSize; (* fileSize*)
        Dummy1:=0; (* resered                                               *)
        Dummy2:=0; (* -""-                                                  *)
        (* offset of picture data                                           *)
        Offset:=SizeOF(BHeader)+SizeOF(BInfo)+GetPaletteLen;
      end;

      (* calculate picture size, must be (mod 4 = 0)                        *)
      Size.X := ((Size.X DIV 2) + ((Size.X DIV 2) MOD 4)) * 2;

      with BInfo do begin (* BMP info header                                *)
        InfoSize:=SizeOf(BInfo); (* header size                             *)
        XMax:=Size.X; (* X - dimension                                      *)
        YMax:=Size.Y; (* Y -    -""-                                        *)
        Planes:=1; (* not used                                              *)
        BitsPerPixel:=4; (* 16 colors                                       *)
        Compress:=0; (* no compression                                      *)
        XSize:=0; (* 0 data not compressed                                  *)
        HDpi:=0;
        VDpi:=0;
        Cols:=0;
        Coli:=0;
      end;

      (* write header and info into BMP File                                *)
      S.Write(BHeader,SizeOf(BHeader));
      S.Write(BInfo,SizeOf(BInfo));

      (* save palette                                                       *)
      if (S.Status=stOK) then SaveHeader:=SavePalette(S);

    end;

  function TScreenToBMP.SavePalette(var S : TStream) : Boolean;
    var
      R,G,B   : Byte;       (* Color values                                 *)
      t       : Integer;    (* counter var                                  *)
    begin

      SavePalette:=False;

      for t:=0 to 15 do begin (* save all 16 color values                   *)

        GetRGBColor(t,R,G,B); (* get color values                           *)
        R:=(R SHL 2);
        G:=(G SHL 2);
        B:=(B SHL 2);

        S.Write(B,1); (* save single values, in this order                  *)
        S.Write(G,1);
        S.Write(R,1);
        B:=0;
        S.Write(B,1); (* reserved, not used yet                             *)

      end;

      SavePalette:=(S.Status=stOK);

    end;

  function TScreenToBMP.Save(var S : TStream) : Boolean;
    var
      t       : Integer;
      OutBuf  : array[0..319] of byte; (* 640x480                           *)

    begin

      Save:=False;

      {$IFDEF VER70}
      if inherited Save(S) then begin
      {$ELSE}
      if TScreenToPic.Save(S) then begin
      {$ENDIF}
        for t:=Size.Y-1 DownTo 0 do begin (* Last Line First                *)
          if not RasterLine(t) then EXIT; (* calc planes into one line      *)
          if not Save2in1(S) then EXIT; (* ans standard save as tiff does   *)
        end;
      end;

      Save:=True;

    end;

(*---------------------------------------------------------------------------
OBJECT TTagCollection

This container is used to hold the TAGS for the TAG Image File Format.
It's a descent of a sorted collection because Tags must be sorted in
ascending order, overwriting the function compare makes it possible to insert
TAGS at the right place = insert and forget.

NO DUPLICATES ! (Tiff definition)

see more at the TTScreenToTiff object description
---------------------------------------------------------------------------*)
  function TTagCollection.Compare(Key1, Key2: Pointer): Integer;
    (* sort order is the Type of the tag, duplicates are not allowed *)
    var
      Type1,Type2 : Word;
    begin

      Type1:=PTiffTag(Key1)^.TagType;
      Type2:=PTiffTag(Key2)^.TagType;

      if Type1 < Type2 then
        Compare:=-1
      else if (Type1 > Type2) then
        Compare:=1
      else
        Compare:=0;

    end;

(*---------------------------------------------------------------------------
OBJECT TScreenToTIFF

TAG Image File Format.

This seems to be the most powerfull picture format, but as already
mentioned, I tried to hold the pictures simple, so many reades can handle
them. The definition is not stored in a common header but in so called
TAGs. the meaning of a tag depends on his type, a TAG can hold lets say,
the data for the x-resolution, or the file offset off the color palette
or whatever. TAGs must be saved in ascending order, the sort value is the
TAG type. A TAG is always 12 byte long and is hold in a IFD (Internal
File Directory) data structure. there can be as many IFD in a file as you
want, an IFD always contains a pointer to the next IFD. there is a little
file header which contains a pointer to the first IFD. Pictures can be
stored in so calles strips, this is recomended for large pictures,
but sorry, not supportet in this unit. With a view enhancements, one
could implement a tiff format according to the CCITT compression
mode for FAX. one could then send screen shots via fax. but this a
lot work, but more problem is the modem. does anyone know fax commands
(something like AT ?) for group 2or3 modems ? faxing out a dos program
without any resident stuff would be fine.

A tag is saved as an Object TTiffTag wich is defined in unit PicDef.
if you want to modify TAGS use the function modifyTag, if you want to
add TAGs you have to overwrite the funtion CreateTags.

----------------------------------------------------------------------------*)
  function TScreenToTIFF.GetPaletteLen: Word;
    begin
      GetPaletteLen:=(16 * 3) * 2; (*  Palette entry type is word           *)
    end;

  constructor TScreenToTiff.Init(Bounds : TRect);
    begin

      {$IFDEF VER70}
      if not inherited Init(Bounds) then FAIL;
      {$ELSE}
      TScreenToPic.Innit(Bounds);
      {$ENDIF}

      (* initialize TAG container                                           *)
      TagColl:=New(PTagCollection,Init(MaxTiffTags,MaxTiffTags));
      if (TagColl=NIL) then FAIL;
      (* Offset of first IFD                                                *)
      IFDOffset:=SizeOF(TTiffHeader)+(GetPaletteLen);

      if not CreateTags then begin (* create TAGs                           *)
        Dispose(TagColl,Done);
        FAIL;
      end;

      (* calculate BIT mask for last bits                                   *)
      Mask := (Size.X AND 7);
      if (Mask <> 0) then Mask:=($FF SHL Mask);

    end;

  destructor TScreenToTiff.Done;
    begin
      Dispose(TagColl,Done);
      {$IFDEF VER70}
      inherited Done;
      {$ELSE}
      TScreenToPic.Done;
      {$ENDIF}
    end;

  function TScreenToTiff.CreateTags : Boolean;
    begin

      CreateTags := False;

      (* stadard TAG                                                        *)
      TagColl^.Insert(New(PTiffTag,Init(ttSubFile,tiWord,1,1)));
      (* Size X                                                             *)
      TagColl^.Insert(New(PTiffTag,Init(ttImageWidth,tiWord,1,Size.X)));
      (* Size Y                                                             *)
      TagColl^.Insert(New(PTiffTag,Init(ttImageLength,tiWord,1,Size.Y)));
      (* BitsPerPixel                                                       *)
      TagColl^.Insert(New(PTiffTag,Init(ttBitsPerSample,tiWord,1,4)));
      (* samples Per Pixel                                                  *)
      TagColl^.Insert(New(PTiffTag,Init(ttSamplesPPixel,tiWord,1,1)));
      (* compression                                                        *)
      TagColl^.Insert(New(PTiffTag,Init(ttCompresion,tiWord,1,1)));
      (* save palette after header                                          *)
      TagColl^.Insert(New(PTiffTag,Init(ttColorMap,tiWord,
                                       (GetPaletteLen DIV 2),
                                       SizeOf(TTiffHeader))));
      (* orientation                                                        *)
      TagColl^.Insert(New(PTiffTag,Init(ttOrientation,tiWord,1,1)));
      (* photometric interpretation                                         *)
      TagColl^.Insert(New(PTiffTag,Init(ttPhotoMetric,tiWord,1,3)));
      (* MinSample value for black                                          *)
      TagColl^.Insert(New(PTiffTag,Init(ttMinSampleVal,tiWord,1,0)));
      (* MaxSample value for white                                          *)
      TagColl^.Insert(New(PTiffTag,Init(ttMaxSampleVal,tiWord,1,$4000)));
      (* Planar Configuration                                               *)
      TagColl^.Insert(New(PTiffTag,Init(ttPlanarConfig,tiWord,1,1)));

      CreateTags:=(TagColl^.Count=12); (* all 12 tags stored ?              *)

    end;

  function TScreenToTiff.ModifyTag(TagType,NewLen,NewVal : LongInt) : Boolean;
    (* Use this function if you want to modify TAG values where
       <TagType> is the Type of the TAG you want to change
       <NewLen> is the new length of the Data
       <NewVal> is the new Data Value                                       *)

    function isTag(PTag : PTiffTag) : Boolean; FAR;
      (* Iteration used with FirstThat to determine if it's the in
         <TagType> specified TAG                                            *)
      begin
        isTag:=(PTag^.TagType = TagType);
      end;

    var
      TiffTag : PTiffTag;

    begin

      ModifyTag:=False;

      TiffTag:=TagColl^.FirstThat(@isTag);
      if (TiffTag<>NIL) then begin (* TAG already inserted                  *)
        (* set new values                                                   *)
        TiffTag^.Length:=NewLen;
        TiffTag^.Data:=NewVal;

        ModifyTag:=True;

      end;

    end;

  function TScreenToTiff.SaveHeader(var S : TStream) : Boolean;
    var
      THeader : TTiffHeader; (* Header of TIFF file                         *)
    begin

      SaveHeader:=False;

      with THeader do begin
        FillChar(ByteOrder,2,ord('I')); (* Intel Byteorder                  *)
        VerID := $2A; (* always                                             *)
        FirstIFD:=IFDOffset; (* offset of first IFD                         *)
      end;

      S.Write(THeader,SizeOF(THeader)); (* Write header into stream         *)
      SaveHeader:=SavePalette(S); (* and save Palette                       *)

    end;

  function TScreenToTiff.SavePalette(var S : TStream) : Boolean;
    var
      R,G,B   : Byte; (* Red,Gren and Blue                                  *)
      t,i     : Integer; (* counter vars                                    *)
      TifPal  : Array[0..15,0..2] of Word; (* 16 colors !                   *)

    begin

      for t:= 0 to 15 do begin
        GetRGBColor(t,R,G,B); (* get color values                           *)
        TifPal[t,0]:=(R SHL $0A);
        TifPal[t,1]:=(G SHL $0A);
        TifPal[t,2]:=(B SHL $0A);
      end;

      for i := 0 to 2 do
        for t := 0 to 15 do
          S.Write(TifPal[t,i],2); (* write palette into stream              *)

      SavePalette:=(S.Status=stOK);

    end;

  function TScreenToTiff.Save(var S : TStream) : Boolean;
    var
      t,i    : Integer;
      PicOff : LongInt;
      Color  : Byte;
      OutBuf  : array[0..319] of byte; (*640x480*)

    procedure SaveTagToStream(PTag : PTiffTag); FAR;
      (* Iteration methode to write all tags into the stream                *)
      begin
        with PTag^ do begin
          S.Write(TagType,2);
          S.Write(DatType,2);
          S.Write(Length,4);
          S.Write(Data,4);
        end;
      end;

    begin

      Save:=False;

      
      if Odd(Size.X) then inc(Size.X); (* must be even                      *)

      {$IFDEF VER70}
      if inherited Save(S) then begin (* never FORGET                       *)
      {$ELSE}
      if TScreenToPic.Save(S) then begin (* never FORGET                    *)
      {$ENDIF}

        (* calculate offset off picture values                              *)
        PicOFF:=S.GetPos+((TagColl^.Count+1)*12) + 6; (* +6 -> IFS HEAD     *)
        TagColl^.Insert(New(PTiffTag,Init(ttStripOffset,tiLong,1,PicOFF)));

        (* IFS                                                              *)
        S.Write(TagColl^.Count,2);
        TagColl^.ForEach(@SaveTagToStream); (* save all tags                *)
        PicOFF:=0; (* help var, no more IFS                                 *)
        S.Write(PicOff,4);

        for t:=0 to Size.Y-1 do begin (* Save all lines                     *)

         if not RasterLine(t) then EXIT; (* get line                        *)
         if not Save2in1(S) then Exit; (* save same as with bmp             *)

        end;

        Save:=True;

      end;

    end;


(*----------------------------------------------------------------------------
  function SaveScreen(PicType : Word;FName : String;Where:TRect) : Boolean;

  Saves a screen rect into the specified file format, where
  <PicType> : is the Type of the file format.
              valid values are : piPCX .... PCX file format
                                 piBMP .... BMP file format
                                 piTIFF ... TIFF file format
  <FName>   : is the name of the file (no error checking for filename)
  <Where>   : contains the Screen Cordinates (A.X,A.Y,B.X,B.Y)

  returns true if the screen rect was saved correctly.
----------------------------------------------------------------------------*)
function SaveScreen(PicType : Word;FName : String;Where:TRect) : Boolean;
  var
    PPic : PScreenToPic; (* object which saves the screen rect              *)
    S    : PStream; (* stream to save to object                             *)
  begin

    SaveScreen:=False;

    case PicType of (* initialize object                                    *)
      piPCX  : PPic:=New(PScreenToPCX,Init(Where));
      piBMP  : PPic:=New(PScreenToBMP,Init(Where));
      piTIFF : PPic:=New(PScreenToTIFF,Init(Where));
    end;

    if (PPic<>NIL) then begin (* yes we have a valid object                 *)

       S:=New(PBufStream,Init(FName,stCreate,4096)); (* Open bufferd file   *)

       if ((S<>NIL) and (S^.Status=stOK)) then SaveScreen:=PPic^.Save(S^);

       Dispose(S,Done);
       Dispose(PPic,Done);

    end;

  end;


END.

