/*
 *  File Browse Utility, version 1.4
 *
 *  (c) 1992 Barry Nance
 *
 *  distributed through
 *  BYTE Magazine's Software Corner
*/

// Original program by Mr. Nance was all incorporated in one file: LIST.C.
// I split it up in order to demonstrate some PPT functionality.
// No substantive changes.   This is the 2nd of two source modules,
// LIST1.C and LIST2.c.  There is also a header file, LIST.H.
// Gary L. Levine, Feb/1993.

#include <stdio.h>
#include <dos.h>
#include <dir.h>
#include <bios.h>
#include <fcntl.h>
#include <conio.h>
#include <io.h>
#include <stdlib.h>
#include <string.h>
#include <alloc.h>
#include <process.h>
#include <ctype.h>
#include <share.h>
#include <errno.h>
#include <list.h>


/************************************/

extern  char  *fileprompt;
extern  char  *inv_arg;
extern  char  *notfound;
extern  char  *emptyfile;
extern  char  *noaccess;
extern  char  *presskey;

extern  *help[];

extern  unsigned char string[];
extern  char  string1[];

extern  char  search_arg[];
extern  int   search_flag;
extern  int   ignore_case;
extern  int   spos;

extern  long  line_number;
extern  long  linenum_save;

extern  unsigned char CharCode;
extern  unsigned char ScanCode;

extern  int   xesc;
extern  int   eof_flag;
extern  int   start_of_file;
extern  int   line_end_char;
extern  int   hex_mode;
extern  int   wrap_mode;

extern  int   start_save;
extern  int   eof_save;
extern  int   fbufblock_save;
extern  int   fbufndx_save;

extern  unsigned    top, left, bottom, right, screen_width, screen_height;
extern  int         left_relative_pos;

extern  struct ftime ftimestruc;
extern  struct ffblk findblock;

extern  char  filename[];
extern  char  drive[];
extern  char  path[];
extern  char  name[];
extern  char  ext[];

extern  int   count;
extern  int   flag;
extern  int   file_num;
extern  int   current_row;
extern  int   file_is_empty;

extern  int   screen_rcds;
extern  int   screen_lines_hold;
extern  int   screen_lines;
extern  int   lines_read;
extern  int   rcds_read;
extern  int   lines_displayed;

extern  unsigned    i, j, k;

extern  int   fh;
extern  long  filesize;
extern  long  curr_filepos;
extern  long  temp_long;
extern  unsigned    num_blocks;
extern  int   fbufndx;
extern  int   fbufbytes;
extern  unsigned    fbufblock;

extern  char  *filelist_ptr;
extern  char  *list_ptr;
extern  char  *file_buff_ptr;
extern  char  *screen_save_ptr;
extern  char  *dos_screen_save_ptr;

extern  char  line_save[160];

extern  unsigned char low_inten;
extern  unsigned char high_inten;
extern  unsigned char found_attr;

extern  struct  csavetype   cursor_data;
extern  struct  csavetype   my_cpos;
extern  struct  csavetype   dos_cpos;

extern  union   REGS regs;

extern  int skip[];         /* increment to rightmost occurance of ch */
extern  int cmap[];         /* upper to lowercase character map */


/************************************/

void    fill_window(void)
        {
        textattr(low_inten);
        window(left+1, top+1, right-1, bottom-1);
        clrscr();
        window(1, 1, 80, 25);

        current_row = top + 1;
        screen_rcds = 0;
        screen_lines= 0;

        while (screen_lines < bottom - top - 1)
            {
            if (fgetrecord(string, STR_SIZE) == -1)
                break;
            screen_rcds++;
            textattr(low_inten);
            if ( search_flag == 2
              && (search(search_arg, strlen(search_arg),
                          string, strlen(string)) != -1) )
                textattr(found_attr);
            if (hex_mode)
                display_hex();
            else
                display_line();
            screen_lines += lines_displayed;
            }
        }

/************************************/

void    display_line(void)
        {
        int w, index;
        char s[81];

        w = 0;
        lines_displayed = 0;
        index = left_relative_pos;

        do  {
            window(left + 1, current_row, right - 1, current_row);
            clrscr();
            window(1, 1, 80, 25);
            gotoxy(left + 1, current_row);
            strncpy(s, &string[index], screen_width);
            s[screen_width] = '\0';
            cputs(s);
            current_row++;
            lines_displayed++;
            if (strlen(&string[index]) < screen_width + 1)
                return;
            index += screen_width;
            w += screen_width;
            }
        while (wrap_mode && current_row < bottom);
        }

/************************************/

void    show_line_num(void)
        {
        if (hex_mode || line_number == -1L)
            strcpy(string1, "     ");
        else
            sprintf(string1, "%5ld", line_number);

        textattr(high_inten);
        gotoxy(7, 25);
        cputs(string1);
        gotoxy(80, 25);
        }

/************************************/

void    display_hex(void)
        {
        int i, column_shift;
        unsigned char ch;

        column_shift = 10;
        if ( search_flag == 2
          && (search(search_arg, strlen(search_arg),
                      string, strlen(string)) != -1) )
            textattr(found_attr);
        else
            textattr(low_inten);

        gotoxy(left + 2, current_row);
        cprintf("%6.6lX ", curr_filepos);
        lines_displayed = 1;

        for (i=0; i<16; i++)
            {
            if (curr_filepos + i == filesize)
                break;
            ch = string[i];
            gotoxy(left + column_shift + (i * 3), current_row);
            cprintf("%2.2X ", (int) ch);
            if (i == 7)
                {
                cprintf("- ");
                column_shift = 12;
                }
            gotoxy(left + 61 + i, current_row);
            if (   ch == 0  || ch == BELL
                || ch == BS || ch == TAB
                || ch == LINEFEED || ch == CR  )
                ch = '.';
            cprintf("%c", ch);
            }

        current_row++;
        textattr(low_inten);
        }

/************************************/

int     fgetbyte(void)
        {
        eof_flag = FALSE;
        start_of_file = FALSE;
fgetbyte01:
        if (fbufblock == (num_blocks - 1) && fbufndx == fbufbytes)
            return -1;

        if (fbufndx < fbufbytes)
            return (int) file_buff_ptr[fbufndx++];

        fbufblock++;
        fbufndx = 0;
        lseek(fh, ((long) fbufblock) * BUFSIZEL, SEEK_SET);
        fbufbytes = read(fh, file_buff_ptr, BUFSIZE);
        goto fgetbyte01;
        }

/************************************/

int     fgetline(unsigned char buff[], int max_chars)
        {
        int  ch, i;

        if (hex_mode || !wrap_mode)
            return fgetrecord(buff, max_chars);

        memset(buff, 0, max_chars);
        i = 0;

        while (i < screen_width)
            {
            if ( (ch = fgetbyte()) == -1)
                {
                if (i == 0)
                    {
                    eof_flag = TRUE;
                    return -1;
                    }
                break;
                }
            if (ch == line_end_char || ch == 0)
                break;
            if (ch == CR || ch == LINEFEED || ch == BS)
                continue;
            if (ch == TAB)
                {
                do
                    buff[i++] = SPACE;
                while ( (i % 4) != 0 );
                continue;
                }
            if (ch == BELL)
                ch = SPACE;
            buff[i++] = (unsigned char) ch;
            }

        lines_read++;
        return 0;
        }

/************************************/

int     fgetrecord(unsigned char buff[], int max_chars)
        {
        int    i, c, rc;

        memset(buff, 0, max_chars);
        if (hex_mode)
            {
            curr_filepos = ( ((long) fbufblock) * BUFSIZEL) + fbufndx;
            for (i=0; i<16; i++)
                {
                if ( (c = fgetbyte()) == -1 )
                    if (i == 0 || search_flag != 0)
                        {
                        eof_flag = TRUE;
                        rc = -1;
                        goto fgs_exit;
                        }
                    else
                        {
                        lines_read++;
                        rc = 0;
                        goto fgs_exit;
                        }
                buff[i] = (unsigned char) c;
                }
            lines_read++;
            rc = 0;
            goto fgs_exit;
            }

        i = 0;
fgs1:   if (i == max_chars - 1)
            {
            if (wrap_mode)
                {
                c = (i + screen_width-1) / screen_width;
                if (c == 0) c = 1;
                lines_read += c;
                }
            else
                {
                lines_read++;
                }
            rc = 0;
            goto fgs_exit;
            }

        if ( (c = fgetbyte()) == -1 )
            {
            if (i == 0)
                {
                eof_flag = TRUE;
                rc = -1;
                goto fgs_exit;
                }
            if (wrap_mode)
                {
                c = (i + screen_width-1) / screen_width;
                if (c == 0) c = 1;
                lines_read += c;
                }
            else
                lines_read++;
            rc = 0;
            goto fgs_exit;
            }

        if (c == line_end_char || c == 0)
            {
            if (wrap_mode)
                {
                c = (i + screen_width-1) / screen_width;
                if (c == 0) c = 1;
                lines_read += c;
                }
            else
                lines_read++;
            rc = 0;
            goto fgs_exit;
            }

        if (c == CR || c == LINEFEED)
            goto fgs1;
        if (c == BS && i == 0)
            goto fgs1;

        if (c == TAB)
            {
            do
                buff[i++] = SPACE;
            while ( (i % 4) != 0 );
            goto fgs1;
            }

        if (c == BELL)
            c = SPACE;

        buff[i++] = (unsigned char) c;
        goto fgs1;


fgs_exit:
        if (rc != -1)
            rcds_read++;

        return rc;
        }

/************************************/

int     fprevbyte(void)
        {
        eof_flag = FALSE;
        start_of_file = FALSE;
sprev01:
        if (fbufblock == 0 && fbufndx <= 0)
            return -1;

        if (fbufndx > 0)
            return (int) file_buff_ptr[--fbufndx];

        fbufblock--;
        lseek(fh, ((long) fbufblock) * BUFSIZEL, SEEK_SET);
        fbufbytes = read(fh, file_buff_ptr, BUFSIZE);
        fbufndx = fbufbytes;
        goto sprev01;
        }

/************************************/

int     fprevline(void)
        {
        int  ch, i, j;

        if (hex_mode || !wrap_mode)
            return fprevrecord();

        if ( (ch = fprevbyte()) == -1)
            {
            start_of_file = TRUE;
            return -1;
            }

        i = 1;
        if (ch == line_end_char || ch == 0)
            ch = fprevbyte();

        while (ch != line_end_char && ch != 0 && ch != -1)
            {
            ch = fprevbyte();
            if (ch == CR || ch == LINEFEED || ch == BS)
                continue;
            i++;
            }

        j = 0;
        while (i > screen_width || j % (screen_width + 1) != 0)
            {
            ch = fgetbyte();
            i--;
            j++;
            }

        lines_read++;
        return 0;
        }

/************************************/

int     fprevrecord(void)
        {
        int     ch, slen, rc;

        if (hex_mode)
            {
            if (fprevbyte() == -1)
                {
                start_of_file = TRUE;
                rc = -1;
                goto g1l_exit;
                }
            while ( (fbufndx % 16) != 0 )
                {
                if (fprevbyte() == -1)
                    break;
                }
            lines_read++;
            rc = 0;
            goto g1l_exit;
            }

        if ( (ch = fprevbyte()) == -1)
            {
            start_of_file = TRUE;
            rc = -1;
            goto g1l_exit;
            }

        slen = 1;
        if (ch == line_end_char || ch == 0)
            ch = fprevbyte();

        while (ch != line_end_char && ch != 0 && ch != -1)
            {
            slen++;
            ch = fprevbyte();
            }

        if (ch != -1)
            {
            slen--;
            ch = fgetbyte();
            }

        if (wrap_mode)
            {
            ch = (slen + screen_width-1) / screen_width;
            if (ch == 0) ch = 1;
            lines_read += ch;
            }
        else
            lines_read++;

        rc = 0;

g1l_exit:
        if (rc != -1)
            rcds_read++;

        return rc;
        }

/************************************/

void    gohome(void)
        {
        if (xesc) goto restore_the_screen;

        textattr(high_inten);
        gotoxy(1, 25);
        cputs(presskey);
        getkey();

restore_the_screen:
        puttext(1, 1, 80, 25, screen_save_ptr);
        restore_cursor(&cursor_data);

        free(file_buff_ptr);
        free(screen_save_ptr);
        free(dos_screen_save_ptr);
        free(filelist_ptr);

        exit(0);
        }

/************************************/


void    save_cursor(struct csavetype *csave)
        {
        _AH = 3;
        _BH = 0;
        geninterrupt(0x10);
        csave->curloc  = _DX;
        csave->curmode = _CX;
        }


void    restore_cursor(struct csavetype *csave)
        {
        _DX = csave->curloc;
        _AH = 2;
        _BH = 0;
        geninterrupt(0x10);

        _CX = csave->curmode;
        _AH = 1;
        geninterrupt(0x10);
        }



int     kbdstring(char buff[], int max_chars)
        {
        int             ft, i, j, insert_mode, ctype, res;
        unsigned char   row, col, trow, tcol;
        unsigned int    cblock;

        ft = TRUE;
        i = j = insert_mode = 0;
        if (get_video_mode() == 7)
            cblock = 0x000D;
        else
            cblock = 0x0007;

        _AH = 3;
        _BH = 0;
        geninterrupt(0x10);
        ctype = _CX;
        col = wherex();
        row = wherey();

        cprintf("%-*s", max_chars-1, buff);
        gotoxy(col, row);

ks1:    getkey();
        tcol = wherex();
        trow = wherey();

        if (CharCode == ESC)
            {
            buff[0] = '\0';
            res = 0;
            goto kbdstring_exit;
            }

        if (CharCode == 0)
            {
            if (ScanCode == INSKEY)
                {
                if (insert_mode)
                    {
                    insert_mode = FALSE;
                    _CX = ctype;
                    _AH = 1;
                    geninterrupt(0x10);
                    }
                else
                    {
                    insert_mode = TRUE;
                    _CX = cblock;
                    _AH = 1;
                    geninterrupt(0x10);
                    }
                }
            else
            if (ScanCode == HOMEKEY)
                {
                i = 0;
                gotoxy(col, row);
                }
            else
            if (ScanCode == ENDKEY)
                {
                i = strlen(buff);
                gotoxy(col+strlen(buff), row);
                }
            else
            if (ScanCode == DELKEY)
                {
                for (j = i; j < strlen(buff); j++)
                    buff[j] = buff[j+1];
                gotoxy(col, row);
                cprintf("%-*s", max_chars-1, buff);
                gotoxy(tcol, trow);
                }
            else
            if (ScanCode == RIGHTKEY)
                {
                if (i < strlen(buff))
                    {
                    i++;
                    gotoxy(tcol+1, trow);
                    }
                }
            else
            if (ScanCode == LEFTKEY)
                {
                if (i > 0)
                    {
                    i--;
                    gotoxy(tcol-1, trow);
                    }
                }
            }

        if (CharCode == 0)
            goto ks1;

        if (CharCode == BS)
            {
            if (i > 0)
                {
                i--;
                gotoxy(tcol-1, trow);
                }
            }

        if (CharCode == CR)
            {
            res = 0;
            goto kbdstring_exit;
            }

        if (CharCode < 32)
            goto ks1;

        if (i == max_chars-1)
            goto ks1;

        if (ft)
            {
            ft = FALSE;
            if (i == 0 && !insert_mode)
                {
                memset(buff, 0, max_chars);
                gotoxy(col, row);
                cprintf("%-*s", max_chars-1, buff);
                gotoxy(col, row);
                }
            }

        if (insert_mode)
            {
            for (j = strlen(buff)-1; j >= i; j--)
                if (j < max_chars-2)
                    buff[j+1] = buff[j];
            buff[i++] = CharCode;
            _CX = ctype;
            _AH = 1;
            geninterrupt(0x10);
            gotoxy(col, row);
            cprintf("%-*s", max_chars-1, buff);
            gotoxy(++tcol, trow);
            _CX = cblock;
            _AH = 1;
            geninterrupt(0x10);
            }
        else
            {
            buff[i++] = CharCode;
            cprintf("%c", CharCode);
            }

        goto ks1;


kbdstring_exit:
        _CX = ctype;
        _AH = 1;
        geninterrupt(0x10);
        return res;
        }

void    getkey(void)
        {
        int     k;

        k        = bioskey(0);
        CharCode = k & 0x00FF;
        ScanCode = (k & 0xFF00) >> 8;
        }

int     get_video_mode(void)
        {
        regs.x.ax = 0x0f00;
        int86(0x10, &regs, &regs);
        regs.h.ah = 0;
        return regs.x.ax;
        }

void    scroll_up(unsigned char numlines)
        {
        regs.h.ah = 6;
        regs.h.al = numlines;
        regs.h.ch = (unsigned char) top;
        regs.h.cl = (unsigned char) left;
        regs.h.dh = (unsigned char) bottom-2;
        regs.h.dl = (unsigned char) right-2;
        regs.h.bh = (unsigned char) low_inten;
        int86(0x10, &regs, &regs);
        }

void    scroll_dn(unsigned char numlines)
        {
        regs.h.ah = 7;
        regs.h.al = numlines;
        regs.h.ch = (unsigned char) top;
        regs.h.cl = (unsigned char) left;
        regs.h.dh = (unsigned char) bottom-2;
        regs.h.dl = (unsigned char) right-2;
        regs.h.bh = (unsigned char) low_inten;
        int86(0x10, &regs, &regs);
        }

/************************************/

void    search_setup(pat,plen,icase)
                  unsigned char *pat;   /* pattern */
                  int plen;             /* pattern length */
                  int icase;            /* ignore case */

        {
        register unsigned char *p;
        register int i;

    /* initialize the skip array and character map */
        for (i = 0; i < CSIZE; ++i)
            {
            skip[i] = plen;
            cmap[i] = i;
            }

    /* map upper to lowercase on case insensitive searches */
        if (icase)
            for (i = 'A'; i <= 'Z'; ++i)
                cmap[i] = tolower(i);
    
    /* compute the skip values for characters in the pattern */
        for (i = plen-1, p = pat; i > 0; --i, ++p)
            skip[cmap[*p]] = i;
        }


int     search(pat,plen,str,slen)
                  unsigned char *pat;   /* pattern */
                  int plen;             /* pattern length */
                  unsigned char *str;   /* string */
                  int slen;             /* string length */
        {
        register unsigned char *pp,*pe,*sp,*se,*sb;

    /* exit immediately if the pattern is longer than the string */
        if (plen > slen)
            return -1;

    /* compute the pattern and string ends */
        pe = pat + plen;    
        se = str + slen;

    /* compute the starting point for the first match attempt */
        sb = str + plen - 1;

    /* match the pattern against the string */
        do {
            pp = pe - 1;
            sp = sb;
            while (pp >= pat && cmap[*sp] == cmap[*pp])
                {
                --sp;
                --pp;
                }
            if (pp < pat)
                return (sp - str + 1);
            }
        while ((sb += skip[cmap[*sb]]) < se);

    /* no match found */
        return -1;
        }


