*
*                        RRRRRRR
*                        RRR  RRR
*                        RRR   RRR
*                        RRR  RRR
*                        RRRRRRR   E S T l i b
*                        RRR RRR
*                        RRR  RRR
*                        RRR   RRR
*                        RRR    RRR
*
*                        for Force v2.x
*
*                      D E M O N S T R A T I O N
*
*               [ created using a RESTlib BETA release ]
*
*               RESTlib (c) 1993, 1994 Jayson R. Minard
*
*******************************************************************************
*
* This demo shows a VERY simple database browse using VLIST_PICK.  Please
* note that only 5 records are read at a time therefore using only a small
* amount of memory...  That is also the reason that no scroll bar is present.
* To include the scroll bar would cause everything to look strange since only
* 5 elements are actually known by RESTlib and therefore the scroll bar
* would represent a position within only these 5 elements.  You could however
* get around this problem by displaying the scroll-bar from the keyboard
* handler but we will save that idea for another day...
*

* !LOOK:  this is the number of records that are shown in the list
#DEFINE browse_height 5

#INCLUDE WARN.HDR
#INCLUDE DATABASE.HDR
#INCLUDE STRING.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE IO.HDR
#INCLUDE COLORS.HDR
#INCLUDE KEYS.HDR
#INCLUDE date.hdr

#INCLUDE restlist.hdr
#INCLUDE restmisc.hdr

*- define our database

DBFDEF browse1
     CHAR(20)     first_name
     CHAR(20)     last_name
     CHAR(40)     salutation
     CHAR(40)     address1
     CHAR(40)     address2
     CHAR(30)     city
     CHAR( 2)     state
     CHAR(10)     zip
     CHAR(12)     phone1
     CHAR(12)     phone2
     DATE          f_contact
     DATE          l_contact
     DATE          n_contact
ENDDEF

INDEXDEF
  CHAR( 40 )    i_browse1     UPPER( browse1->last_name + browse1->first_name )
ENDDEF

VARDEF
  LOGICAL is_mouse
ENDDEF

*- this function returns the titles that are displayed for each database
*  column that is visible.

FUNCTION CHAR Dbf_Titles
  VARDEF
    CHAR temp_str
  ENDDEF

  temp_str = SPACE( 5 ) + CENTER( "Name", 42 ) + " ~ "
  temp_str = temp_str + CENTER( "City/Sate/Zip", 29 ) + " ~ "
  temp_str = temp_str + CENTER( "Phone 1", 12 ) + " ~ "
  temp_str = temp_str + CENTER( "Phone 2", 12 ) + " ~ "
  temp_str = temp_str + CENTER( "Next Contact", 14 )

  RETURN temp_str
ENDPRO

*- this function returns the string used for one row in the database
*  that is displayed.

FUNCTION CHAR Dbf_Line
  VARDEF
    CHAR( 128 ) temp_str
    CHAR( 15 )  temp_zip
    CHAR( 42 )  temp_addr
  ENDDEF

  temp_zip = ALLTRIM( browse1->zip )
  IF RIGHT( temp_zip, 1 ) = "-"
    temp_zip = LEFT( temp_zip, LEN( temp_zip ) - 1 )
  ENDIF

  temp_str = STR( A_RECNO( browse1 ), 5, 0 )

  temp_addr = RTRIM( ALLTRIM( browse1->last_name ) + ", " +;
                     ALLTRIM( browse1->first_name ) )
  IF temp_addr = ","
    temp_addr = ""
  ENDIF

  temp_str = temp_str + R_PAD( temp_addr, 42 ) + " ~ "

  temp_addr = RTRIM( ALLTRIM( browse1->city ) + ", " +;
                     ALLTRIM( browse1->state ) + " " +;
                     ALLTRIM( temp_zip ) )
  IF temp_addr = ","
    temp_addr = ""
  ENDIF

  temp_str = temp_str + R_PAD( temp_addr, 29 ) + " ~ "

  temp_addr = browse1->phone1
  IF SUBSTR( temp_addr, 4, 1 ) = "-" .AND. LEFT( temp_addr, 1 ) = " "
    temp_addr = "    " + SUBSTR( temp_addr, 5, 14 )
  ENDIF
  IF ALLTRIM( temp_addr ) = "-"
    temp_addr = ""
  ENDIF

  temp_str = temp_str + R_PAD( temp_addr, 12 ) + " ~ "

  temp_addr = browse1->phone2
  IF SUBSTR( temp_addr, 4, 1 ) = "-" .AND. LEFT( temp_addr, 1 ) = " "
    temp_addr = "    " + SUBSTR( temp_addr, 5, 14 )
  ENDIF
  IF ALLTRIM( temp_addr ) = "-"
    temp_addr = ""
  ENDIF

  temp_str = temp_str + R_PAD( temp_addr, 12 ) + " ~ "

  temp_addr = DTOC( browse1->n_contact )
  IF LEFT( temp_addr, 8 ) = "  /  /  "
    temp_addr = ""
  ENDIF

  temp_str = temp_str + R_PAD( temp_addr, 14 )

  RETURN temp_str
ENDPRO

FUNCTION UINT Dbf_Width
  *- This function should return the string width of what the function
  *  dbf_line() produces...

  !browse1 GOTO TOP

  RETURN LEN( Dbf_Line() )
ENDPRO

VARDEF EXTERN
  INT __last_key
ENDDEF

* !LOOK:  This routine (DBF_HANDLER) will handle adding and removing
*         rows from our short pick-list to simulate that the list
*         contains every record in the database.  It could also be
*         used to allow editting of records or any other function
*         that might be called from the browser.

FUNCTION INT DBF_Handler
  PARAMETERS VALUE LONG list_handle,;
             VALUE UINT list_element,;
                   UINT mouse_stat,;
             VALUE UINT mrow,;
             VALUE UINT mcol,;
                    INT pick_key,;
             VALUE UINT top_element,;
             VALUE UINT last_element,;
             VALUE UINT ur,;
             VALUE UINT uc,;
             VALUE UINT lr,;
             VALUE UINT lc,;
             VALUE UINT scroll_col

  VARDEF
    INT   list_return
    CHAR  temp_str
    ULONG temp_rec
    UINT  counter
  ENDDEF

  IF mouse_stat = &jl_mouse_left    && mouse left button hit while outside
                                    && of pick-list area

    mouse_stat = &jl_mouse_ignore
    list_return = &jl_continue

    DO CASE
      *- mouse hit at top of box
      CASE mrow = ( ur - 1 )
        pick_key = &k_up

      *- mouse hit at bottom of box
      CASE mrow = ( lr + 1 )
        pick_key = &k_down

      *- user clicking the left arrow in the mouse box
      CASE mrow = 16 .AND. mcol = 39
        pick_key = &k_left
        __last_key = &k_left

      *- user clicking the right arrow in the mouse box
      CASE mrow = 16 .AND. mcol = 41
        pick_key = &k_right
        __last_key = &k_right

      *- user clicking the up arrow in the mouse box
      CASE mrow = 15 .AND. mcol = 40
        pick_key = &k_up

      *- user clicking the down arrow in the mouse box
      CASE mrow = 17 .AND. mcol = 40
        pick_key = &k_down

      OTHERWISE
        pick_key = 0

      ENDCASE

  ENDIF

  *- call the built-in keyboard handler for default actions
  list_return = Default_Key_Handler( list_handle, list_element,;
                                     mouse_stat, mrow, mcol,;
                                     pick_key, top_element, last_element,;
                                     ur, uc, lr, lc,;
                                     scroll_col )

  *- now deal with special conditions for our VIRTUAL database list
  IF list_return = &jl_continue
    DO CASE
      CASE pick_key = &k_home .OR.;
               pick_key = &k_end

      *- abort list on CTRL-LEFT or CTRL-RIGHT so that the calling routine
      *  will go to the start or end of the row.
      CASE pick_key = &k_c_right .OR.;
               pick_key = &k_c_left
        list_return = &jl_abort

      *- go down in the list
      CASE pick_key = &k_down

        *- we hit the last element in the list so remove the first element
        *  and add a new last element to simulate scrolling down in the
        *  database
        IF list_element = last_element

          *- find the record number of the last element in the list
          temp_str = Vlist_Str( list_handle, list_element )
          temp_str = LEFT( temp_str, 5 )
          temp_rec = VAL( temp_str )

          *- go to the last element's record in the database
          !browse1 GOTO temp_rec

          *- go to the next record which we will add to the list
          !browse1 SKIP

          IF A_EOF( browse1 )
            *- we are at the end of the database so do nothing!
            list_return = &jl_ignore
          ELSE
            *- delete the first list element and add the new one
            list_return = &jl_repaint
            Vlist_Delete( list_handle, 1 )
            Vlist_Add( list_handle, Dbf_Line() )
          ENDIF

        ENDIF

      *- go to the bottom of the list
      CASE pick_key = &k_c_pg_down .OR.;
               pick_key = &k_c_end

        *- go to the end of the database and then come backwards &BROWSE_HEIGHT
        counter = 0
        !browse1 GOTO BOTTOM
        DO WHILE .NOT. A_BOF( browse1 ) .AND. counter < &browse_height
          counter = counter + 1
          !browse1 SKIP -1
        ENDDO

        *- add these last &BROWSE_HEIGHT lines to the list while deleting the
        *  first element each time.
        DO WHILE .NOT. A_EOF( browse1 )
          Vlist_Add( list_handle, Dbf_Line() )
          Vlist_Delete( list_handle, 1 )
          !browse1 SKIP
        ENDDO

        pick_key    = &k_end
        list_return = &jl_paint_key

      *- go down a page in the list
      CASE pick_key = &k_pg_down

        *- find the record number of the last element
        temp_str = Vlist_Str( list_handle, last_element )
        temp_str = LEFT( temp_str, 5 )
        temp_rec = VAL( temp_str )

        *- go to the record of the last element in the database
        !browse1 GOTO temp_rec
        counter = 0

        *- remove the first record each time we add one of the new ones
        *  for the next page.
        DO WHILE .NOT. A_EOF( browse1 ) .AND. ( counter < &browse_height )
          !browse1 SKIP
          counter = counter + 1
          IF .NOT. A_EOF( browse1 )
            Vlist_Delete( list_handle, 1 )
            Vlist_Add( list_handle, Dbf_Line() )
          ENDIF

        ENDDO

        list_return = &jl_repaint

      CASE pick_key = &k_up

        IF list_element = top_element
          *- find the database record of the first element.
          temp_str = Vlist_Str( list_handle, list_element )
          temp_str = LEFT( temp_str, 5 )
          temp_rec = VAL( temp_str )

          *- go to the database record of the first element.
          !browse1 GOTO temp_rec

          *- go backwards 1 record.
          !browse1 SKIP -1

          IF A_BOF( browse1 )
            *- if we are at the beginning of the database then do nothing.
            list_return = &jl_ignore
          ELSE
            *- we need to delete the old last element and insert a new
            *  first element.
            list_return = &jl_repaint
            Vlist_Delete( list_handle, last_element )
            Vlist_Insert( list_handle, 1,;
                          &STAT_normal, &COLOR_default, Dbf_Line() )
          ENDIF

        ENDIF

      *- go up a virtual database page.
      CASE pick_key = &k_pg_up
        *- find the first element's database record
        temp_str = Vlist_Str( list_handle, top_element )
        temp_str = LEFT( temp_str, 5 )
        temp_rec = VAL( temp_str )

        *- go to the first element's database record
        !browse1 GOTO temp_rec
        counter = 0

        *- add the first &BROWSE_HEIGHT database records into the list
        *  while deleting the old list elements.
        DO WHILE .NOT. A_BOF( browse1 ) .AND. ( counter < &browse_height )
          !browse1 SKIP -1
          counter = counter + 1
          IF .NOT. A_BOF( browse1 )
            Vlist_Delete( list_handle, last_element )
            Vlist_Insert( list_handle, 1,;
                          &STAT_normal, &COLOR_default, Dbf_Line() )
          ENDIF

        ENDDO

        list_return = &jl_repaint

      *- go to the top of the database.
      CASE pick_key = &k_c_pg_up .OR.;
               pick_key = &k_c_home

        *- add the first &BROWSE_HEIGHT records to the list while deleting
        *  the old ones.

        counter = 0
        !browse1 GOTO TOP
        DO WHILE .NOT. A_EOF( browse1 ) .AND. counter < &browse_height
          counter = counter + 1
          Vlist_Add( list_handle, Dbf_Line() )
          Vlist_Delete( list_handle, 1 )
          !browse1 SKIP
        ENDDO

        pick_key    = &k_home
        list_return = &jl_paint_key

    ENDCASE

  ENDIF

  RETURN list_return
ENDPRO

**** FORCE_MAIN()

PROCEDURE Force_Main

  VARDEF
    LONG     browse_list
    UINT     b_left,;
             b_right,;
             b_top,;
             b_select,;
             counter
    LOGICAL  b1,;
             keep_going,;
             scroll_bar
    INT      lkey, i, position, ret_val
    LONG     recnum
    CHAR     temp_str
    BYTE     temp_byte[ 254 ] BASED temp_str
  ENDDEF

  __embed_char = "~"

  IF .NOT. EXIST( "people.dbf" )
    BUILD "people.dbf" FROM ALIAS browse1
    b1 = .T.
  ENDIF

  OPEN "people.dbf" ALIAS browse1 EXCLUSIVE
  SET ALIAS i_browse1 TO "people.fdx"

  IF .NOT. EXIST( "people.fdx" ) .OR. b1
    !browse1 INDEX i_browse1
  ENDIF

  !browse1 SET INDEX TO i_browse1

  !browse1 GOTO TOP

  browse_list = Vlist_Init( 250 )
  recnum      = 0
  b_top       = 1
  b_select    = 1
  b_left      = 6
  b_right     = 65        && 60 wide display area
  keep_going  = .T.
  scroll_bar  = .F.

  counter = 0

  DO WHILE .NOT. A_EOF( browse1 ) .AND. counter < &browse_height
    counter = counter + 1
    Vlist_Add( browse_list, Dbf_Line() )
    !browse1 SKIP
  ENDDO

  CLEAR
  __color_std = &black_light_grey
  @24, 0 SAY CENTER( "RESTlib demonstration 'A SIMPLE BROWSER' (c) 1993, 1994 Jayson R. Minard", 80 )

  FILL( 3, 7, 11, 70, &double_box, " ", &black_light_grey, &black_white, 0 )
  @5,  8 TO 5, 69
  @5,  7 SAY ""
  @5, 70 SAY ""

  IF _mouse_Init() = 0
    is_mouse = .F.
  ELSE
    _mouse_Reset()
    is_mouse = .T.
  ENDIF

  IF is_mouse
    FILL( 14, 37, 18, 43, &single_box, " ", &black_light_grey, &black_white, 0 )

    @13,24  SAY "Use MOUSE by clicking on arrows..."

    __color_std = &black_light_grey
    @16, 40 SAY ""
    __color_std = &black_white
    @16, 39 SAY "" && left
    @16, 41 SAY "" && right
    @17, 40 SAY "" && down
    @15, 40 SAY "" && up
  ENDIF

  __color_std = &black_white

  __color_hi_std   = &black_light_grey
  __color_hi_enhcd = &black_light_grey

  CURSOR_OFF()

  *---------------------------------------------------------------------------*

  DO WHILE keep_going
    temp_str = SUBSTR( Dbf_Titles(), b_left, ( b_right - b_left + 1 ) )
    Embedded_Say( 4, 9, b_right - b_left + 1, temp_str, .F. )

    __color_std = __color_hi_std

    position = 8
    @ 5,  8 TO  5, 69
    @ 3,  8 TO  3, 69 DOUBLE
    @11,  8 TO 11, 69 DOUBLE

    FOR i = 1 TO LEN( temp_str )
      IF temp_byte[ i - 1 ] <> '~'
        position = position + 1
        IF temp_byte[ i - 1 ] = ""
          @  3, position SAY ""
          @  5, position SAY ""
          @ 11, position SAY ""
        ENDIF
      ENDIF
    NEXT

    __color_std = &black_white

    *- this picklist only shows part of the database row defined by
    *  b_left and b_right.  As we change b_left and b_right we can
    *  simulate scrolling the database row horizontally.

    ret_val = VLIST_PICK( browse_list, 6, 9, 10, 68, 70,;
                           b_top, b_select, 0, 0,;
                           b_left, b_right,;
                           1, 0,;
                           Dbf_Handler,;
                           .F., scroll_bar, .T., is_mouse, .T.,;
                           &BLACK_WHITE, &BLACK_LIGHT_GREY,;
                           &BLUE_WHITE, &BLACK_LIGHT_GREY,;
                           &BLACK_LIGHT_GREY, &BLACK_LIGHT_GREY,;
                           &BLACK_YELLOW, &BLACK_YELLOW )

    lkey = lastkey()

    DO CASE
      CASE ret_val = &EXIT_ERROR
        *- there was an ERROR!
        keep_going = .F.
        recnum = -1

      CASE ret_val = &EXIT_ESC
        *- the user hit ESC to exit the pick-list
        keep_going = .F.
        recnum     = 0

      CASE lkey = &k_c_right .AND. ret_val = &EXIT_ABORT
        *- The user hit CTRL-RIGHT so lets scroll all the way to the
        *  right end of the database ROW (horizontally).
        IF Dbf_Width() > 60
          b_right = Dbf_Width()
          b_left  = b_right - 59
        ENDIF

      CASE lkey = &k_c_left .AND. ret_val = &EXIT_ABORT
        *- The user hit CTRL-LEFT so lets scroll all the way to the
        *  left end of the database ROW (horizontally).
        b_left  = 6
        b_right = 65

      CASE ret_val = &EXIT_RIGHT
        *- the list exitted since the user hit the RIGHT arrow key.  We
        *  will scroll 5 characters horizontally to the RIGHT.
        IF b_right < ( Dbf_Width() )
          b_right = b_right + 5
          b_left  = b_left  + 5
        ENDIF

      CASE ret_val = &EXIT_LEFT
        *- the list exitted since the user hit the LEFT arrow key.  We
        *  will scroll 5 characters horizontally to the LEFT.
        IF b_left > 6
          b_left  = b_left  - 5
          b_right = b_right - 5
        ENDIF

      CASE ret_val = &EXIT_SELECT
        *- the user selected a row by hitting the ENTER key.

        keep_going = .F.
        temp_str   = VLIST_CSTR( browse_list )
        temp_str   = LEFT( temp_str, 5 )
        recnum     = VAL( temp_str )
    ENDCASE

  ENDDO

  IF recnum <> 0
    !browse1 GOTO recnum
    * now we are at the selected record!
  ENDIF


  *---------------------------------------------------------------------------*

  IF is_mouse
    _mouse_Reset()
    _mouse_Cursor( .F. )
  ENDIF

  CURSOR_ON()

  CLEAR

  IF recnum > 0
    ? "record selected:   " + I_STR( recnum )
    ?
    ? ALLTRIM( browse1->last_name ) + ", " + ALLTRIM( browse1->first_name )
    ?
  ELSE
    IF recnum = -1
      ? "ERROR aborted selection."
      ?
    ELSE
      ? "ESC aborted selection."
      ?
    ENDIF
  ENDIF

  VLIST_CLEAR( browse_list )

  CLOSE ALL
  QUIT
ENDPRO


