*
*                        RRRRRRR
*                        RRR  RRR
*                        RRR   RRR
*                        RRR  RRR
*                        RRRRRRR   E S T l i b
*                        RRR RRR
*                        RRR  RRR
*                        RRR   RRR
*                        RRR    RRR
*
*                        for Force v2.x
*
*                      D E M O N S T R A T I O N
*
*               [ created using a RESTlib BETA release ]
*
*               RESTlib (c) 1993, 1994 Jayson R. Minard
*
*******************************************************************************
*
* This program demonstrates many (but not nearly all) of RESTlib's user
* interface capabilities.  It does not use the easiest methods available
* in RESTlib so that advanced actions could be produced.  Look at the other
* demo programs for more simple examples of RESTlib.
*

#INCLUDE WARN.HDR
#INCLUDE DATE.HDR
#INCLUDE STRING.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE DATABASE.HDR
#INCLUDE IO.HDR
#INCLUDE COLORS.HDR

#INCLUDE restmisc.hdr
#INCLUDE restlist.hdr
#INCLUDE restmenu.hdr
#INCLUDE restkey.hdr
#INCLUDE restedit.hdr

*******************************************************************************
*                              global variables                               *
*******************************************************************************

VARDEF
  LOGICAL set_delete_on
  LOGICAL is_mouse
  LOGICAL main_loop

  LOGICAL at_end
  LOGICAL at_front

  *- menu list
  LONG    menu_list
  LONG    prompt_list

  *- colors used within...  There are a lot, but hey, it can never be too
  *  pretty looking.

  BYTE  d_main_std,;
        d_main_enhcd,;
        d_main_enhcd2,;
        d_main_border,;
        d_main_off,;
        d_main_skip,;
        d_main_hi_std,;
        d_main_hi_enhcd,;
        d_main_back,;
        d_main_data,;
        d_menu_std,;
        d_menu_enhcd,;
        d_menu_hi_std,;
        d_menu_hi_enhcd,;
        d_menu_border,;
        d_menu_skip

ENDDEF

*******************************************************************************
*                            database definitions                             *
*******************************************************************************

DBFDEF people
  CHAR(20)  first_name
  CHAR(20)  last_name
  CHAR(40)  salutation
  CHAR(40)  address1
  CHAR(40)  address2
  CHAR(30)  city
  CHAR( 2)  state
  CHAR(10)  zip
  CHAR(12)  phone1
  CHAR(12)  phone2
  DATE    f_contact
  DATE    l_contact
  DATE    n_contact
ENDDEF

INDEXDEF
  CHAR( 40 )  i_people     UPPER( people->last_name +;
                                  people->first_name )
ENDDEF


*******************************************************************************
*                                Draw_Border()                                *
*******************************************************************************

PROCEDURE Draw_Border
  PARAMETERS VALUE LOGICAL active,;
             VALUE LOGICAL clear_middle

  VARDEF
    CHAR( 1 ) fill_middle
  ENDDEF

  IF clear_middle
    fill_middle = " "
  ELSE
    fill_middle = ""
  ENDIF

  IF active
    FILL( 3, 5, 17, 73, __gui_box, fill_middle, d_main_border, d_main_std, 6 )
  ELSE
    FILL( 3, 5, 17, 73, "        ", fill_middle, d_main_back, d_main_back, 0 )
    FILL( 3, 5, 16, 72, __gui_box, fill_middle, d_main_off, d_main_std, 0 )
  ENDIF

ENDPRO

*******************************************************************************
*                                DRAW_TITLES()                                *
*******************************************************************************

PROCEDURE Draw_Titles
  VARDEF
    BYTE  old_std
  ENDDEF

  old_std   = __color_std

  __color_std = d_main_std
  @ 4,  7 SAY "Last name: "
  @ 4, 40 SAY "First name: "
  @ 6,  7 SAY "Salutation: "
  @ 8,  7 SAY "Address: "
  @11,  7 SAY "City: "
  @11, 45 SAY "State: "
  @11, 56 SAY "Zip: "
  @13,  7 SAY "Phone 1: "
  @13, 30 SAY "Phone 2: "
  @15,  7 SAY "First contact: "
  @15, 32 SAY "Last: "
  @15, 48 SAY "Next: "

  __color_std   = old_std

ENDPRO


*******************************************************************************
*                                 DRAW_REC()                                  *
*******************************************************************************

PROCEDURE Draw_Rec
  VARDEF
    BYTE  old_std
  ENDDEF

  old_std   = __color_std

  __color_std   = d_main_data
  @ 4, 18 SAY people->last_name
  @ 4, 52 SAY people->first_name
  @ 6, 19 SAY people->salutation
  @ 8, 16 SAY people->address1
  @ 9, 16 SAY people->address2
  @11, 13 SAY people->city
  @11, 52 SAY people->state PICTURE "@!"
  @11, 61 SAY people->zip PICTURE "XXXXX-XXXX"
  @13, 16 SAY people->phone1 PICTURE "999-999-9999"
  @13, 39 SAY people->phone2 PICTURE "999-999-9999"
  @15, 22 SAY people->f_contact
  @15, 38 SAY people->l_contact
  @15, 54 SAY people->n_contact

  __color_std   = old_std

ENDPRO

*******************************************************************************
*                                  GET_REC()                                  *
*******************************************************************************

PROCEDURE Get_Rec
  VARDEF
    BYTE  old_std, old_enhcd
    UINT  saved_area
  ENDDEF

  saved_area = SAVESCRN( 24, 0, 24, 79 )

  old_std   = __color_std
  old_enhcd = __color_enhcd

  __color_std = d_main_std
  @24, 0 SAY CENTER( "Press <ESC> to abort EDIT, <PG-DOWN> or RIGHT-MOUSE-BUTTON to save/exit", 80 )

  __color_std   = d_main_data
  __color_enhcd = d_main_enhcd
  @ 4, 18 GET people->last_name
  @ 4, 52 GET people->first_name
  @ 6, 19 GET people->salutation
  @ 8, 16 GET people->address1
  @ 9, 16 GET people->address2
  @11, 13 GET people->city
  @11, 52 GET people->state PICTURE "@!"
  @11, 61 GET people->zip PICTURE "XXXXX-XXXX"
  @13, 16 GET people->phone1 PICTURE "999-999-9999"
  @13, 39 GET people->phone2 PICTURE "999-999-9999"
  @15, 22 GET people->f_contact
  @15, 38 GET people->l_contact
  @15, 54 GET people->n_contact

  CURSOR_ON()
  READ
  CURSOR_OFF()

  __color_enhcd = old_enhcd
  __color_std   = old_std

  RESTORESCRN( saved_area )

ENDPRO

*******************************************************************************
*                                    Add()                                    *
*******************************************************************************

PROCEDURE Add
  PARAMETERS       LOGICAL    ret_val,;
             CONST CHAR( 40 ) add_str

  * !LOOK:  The following code segment shows the addition of elements into
  *         a list.  The code determines if the element is to be skipped
  *         or not (horizontal lines in a menu are skipped).

  IF ret_val = .F.
    RETURN
  ENDIF

  IF AT( "?", add_str ) > 0 .AND. AT( "...", add_str ) > 0
    IF .NOT. Vlist_Append( menu_list, &stat_skip, &color_default, add_str )
      ret_val = .F.
    ENDIF

  ELSE
    IF .NOT. Vlist_Add( menu_list, add_str )
      ret_val = .F.
    ENDIF

  ENDIF

ENDPRO

*******************************************************************************
*                                 SET_MENUS()                                 *
*******************************************************************************

PROCEDURE Setup_Menus
  VARDEF
    LOGICAL ret_val
  ENDDEF

  * !LOOK:  The following code segment shows the creation of a pulldown
  *         and one of the prompt menu lists.

  menu_list = VLIST_INIT( 50 )
  IF menu_list = 0
    __color_std = &black_white
    CLEAR
    ? "!ERROR:  cannot initialize pulldown menu system due to insufficient memory"
    ?
    QUIT 1
  ENDIF

  ADD( ret_val, "1.1 @1  |  ~DBF Manipulation  " )
  ADD( ret_val, "1.1.0   |" )
  ADD( ret_val, "1.1.1   | ~Append " )
  ADD( ret_val, "1.1.2   | ~Modify " )
  ADD( ret_val, "1.1.?   |..." )
  ADD( ret_val, "1.1.3   | ~Browse " )
  ADD( ret_val, "1.1.?   |..." )
  ADD( ret_val, "1.1.4   | ~Reindex " )
  ADD( ret_val, "1.1.5   | ~Pack " )
  ADD( ret_val, "1.2 @21 |  ~Utilities  " )
  ADD( ret_val, "1.2.0   |" )
  ADD( ret_val, "1.2.1   | ~Edit Text File " )
  ADD( ret_val, "1.2.?   |..." )
  ADD( ret_val, "1.2.3   | ~Quit " )

  IF ret_val = .F.
    __color_std = &black_white
    CLEAR
    ? "!ERROR:  setting pulldown options due to insufficient memory"
    ?
    QUIT 1
  ENDIF

ENDPRO

*******************************************************************************
*                               SETUP_PROMPTS()                               *
*******************************************************************************

PROCEDURE SETUP_PROMPTS

  * !LOOK:  here is where the prompt bar across the bottom of the screen is
  *         setup and initialized.

  prompt_list = VLIST_INIT( 40 )

  IF prompt_list = 0
    __color_std = &black_white
    CLEAR
    ? "!ERROR:  cannot initialize prompt system due to insufficient memory"
    ?
    QUIT 1
  ENDIF

  * !LOOK:  This code sets up a list to simulate the @PROMPT command

  VList_Add( prompt_list, "1.1 @20,3  |  ~Next  " )
  VList_Add( prompt_list, "1.2 @20,11 |  ~Previous  " )
  VList_Add( prompt_list, "1.3 @20,23 |  ~Top  " )
  VList_Add( prompt_list, "1.4 @20,30 |  ~Bottom  " )
  VList_Add( prompt_list, "1.5 @20,40 |  [ ] ~Deleted  " )
  VList_Add( prompt_list, "1.6 @20,55 |  [X] ~SET DELETE ON  " )

ENDPRO

*******************************************************************************
*                               ALTER_PROMPTS()                               *
*******************************************************************************

PROCEDURE Alter_Prompts

  * !LOOK:  we can now alter elements in an existing list during program
  *         execution.  This list just happens to be the prompt list
  *         that we use for the prompt bar at the bottom of the screen.

  IF .NOT. A_DELETED( people )
    Vlist_Edit( prompt_list, 5, "1.5 @20, 40 |  [ ] ~Deleted  " )
  ELSE
    Vlist_Edit( prompt_list, 5, "1.5 @20, 40 |  [X] ~Deleted  " )
  ENDIF

  IF at_end
    Vlist_Set_Status( prompt_list, 1, &stat_skip )
    Vlist_Set_Status( prompt_list, 4, &stat_skip )
  ELSE
    Vlist_Set_Status( prompt_list, 1, &stat_normal )
    Vlist_Set_Status( prompt_list, 4, &stat_normal )
  ENDIF

  IF at_front
    Vlist_Set_Status( prompt_list, 2, &stat_skip )
    Vlist_Set_Status( prompt_list, 3, &stat_skip )
  ELSE
    Vlist_Set_Status( prompt_list, 2, &stat_normal )
    Vlist_Set_Status( prompt_list, 3, &stat_normal )
  ENDIF

ENDPRO

*******************************************************************************
*                                 DBF_LINE()                                  *
*******************************************************************************

FUNCTION CHAR Dbf_Line
  VARDEF
    CHAR one_line
    CHAR temp_str
  ENDDEF

  one_line = STR( A_RECNO( people ), 5, 0 )
  temp_str = ALLTRIM( people->last_name ) + ", " + ALLTRIM( people->first_name )
  IF LEN( temp_str ) < 38
    temp_str = temp_str + SPACE( 38 - LEN( temp_str ) )
  ELSE
    temp_str = LEFT( temp_str, 38 )
  ENDIF

  one_line = one_line + temp_str + ""
  one_line = one_line + people->phone1 + ""
  one_line = one_line + people->phone2

  RETURN one_line
ENDPRO

*******************************************************************************
*                                  Confirm()                                  *
*******************************************************************************

FUNCTION UINT Confirm_It
  PARAMETERS VALUE UINT decision,;
             CONST CHAR( 12 ) text_stuff

  * !LOOK:  use the RESTlib Confirm_Box() routine to as the user
  *         a quick question.
  decision = Confirm_Box( text_stuff, "", " ~Yes ", " ~No ", -1, -1, ;
                          d_menu_std, d_menu_hi_std,;
                          d_menu_enhcd, d_menu_hi_enhcd,;
                          d_menu_border )

  RETURN decision
ENDPRO


*******************************************************************************
*                         OUR_PROMPT_HANDLER()                                *
*******************************************************************************
*
* This guy handles the keystrokes and mouse activity for our prompt bar
* across the bottom of the screen.
*
* This allows us the edit the current record when the mouse is pressed
* with its cursor over the edit area.
*

FUNCTION INT Our_Prompt_handler
  PARAMETERS VALUE LONG list_handle,;
             VALUE UINT list_element,;
                   UINT mouse_stat,;
             VALUE UINT mrow,;
             VALUE UINT mcol,;
                    INT pick_key,;
             VALUE UINT top_element,;
             VALUE UINT last_element

  VARDEF
    INT     list_return
    UINT    saved_area
  ENDDEF

  IF mouse_stat = &jl_mouse_left     && left button pressed outside of
                                     && any prompts
    IF mcol >= 5 .AND. mcol <= 72 .AND. mrow >=3 .and. mrow <= 16
      saved_area = SAVESCRN( 19, 1, 22, 78 )
      FILL( 19, 1, 22, 78, "        ", "", d_main_back, d_main_back, 0 )
      FILL( 19, 1, 21, 77, __gui_box, "", d_main_off, d_main_std, 0 )
      draw_border( .T., .T. )
      draw_titles()
      get_rec()
      draw_rec()
      draw_border( .F., .F. )
      RESTORESCRN( saved_area )
    ENDIF
  ENDIF

    *- lets pass control onto the default handler
    list_return = Default_Prompt_Handler( list_handle,;
                                          list_element,;
                                          mouse_stat,;
                                          mrow, mcol,;
                                          pick_key,;
                                          top_element,;
                                          last_element )

  return list_return
ENDPRO

*******************************************************************************
*                              RESET_PEOPLE()                                 *
*******************************************************************************

PROCEDURE Reset_People
  VARDEF
    UINT selected
    INT ret_val
  ENDDEF

  !people GOTO TOP
  Draw_Border( .F., .T. )
  Draw_Titles()
  Draw_Rec()
  at_front = .T.
  at_end = A_EOF( people )

  * change the prompt bar to represent the current record
  Alter_Prompts()

  * redisplay the prompt bar in its new state
  ret_val = _manual_Prompts( prompt_list, 1, selected,;
                             Our_Prompt_Handler,;
                             is_mouse, .T.,;
                             d_main_skip, d_main_skip,;
                             __color_enhcd, __color_hi_enhcd,;
                             d_main_skip )
ENDPRO

*******************************************************************************
*                               Handle_Select()                               *
*******************************************************************************
* This routine is called when an element is selected from a pulldown menu     *
* system.                                                                     *
*******************************************************************************

FUNCTION UINT Handle_Select
  PARAMETERS VALUE LONG handle,;
       VALUE UINT system,;
       VALUE UINT over,;
       VALUE UINT down,;
             UINT sub_saved,;
             UINT head_saved

  VARDEF
    BYTE old_std, old_enhcd
    UINT decision, save_var
    ULONG old_rec
    LONG  browse_list
    UINT  browse_left, browse_right, browse_top, browse_current
    UINT  temp_cnt, temp_first, saved_area, saved_area2
    INT   ret_val
    CHAR       temp_str
    CHAR( 85 ) temp_str2
    LOGICAL    wrap_mode
  ENDDEF

  * !LOOK:  here is where all pulldown menu selections are processed.  The
  *         pulldown system is still active so all we have to do is return
  *         to it to continue or tell it to abort.

  DO CASE
    CASE over = 1 .AND. down < 4
      IF down <> 3
        saved_area = SAVESCRN( 2, 1, 8, 12 )
      ELSE
        restorescrn( sub_saved )
        sub_saved = 0
      ENDIF
      Draw_Border( .T., .T. )

      DO CASE
        CASE over = 1 .AND. down = 1   && add
          old_rec = A_RECNO( people )

          Draw_Titles()
          !people APPEND BLANK
          Get_Rec()
          IF LASTKEY() = 27
            !people DELETE
            !people GOTO old_rec
          ENDIF

          Draw_Rec()
        CASE over = 1 .AND. down = 2   && modify
          Draw_Titles()
          Get_Rec()
          Draw_Rec()
        CASE over = 1 .AND. down = 3   && browse
          old_rec = A_RECNO( people )

          * !LOOK:  the VLIST system can be used for database browse simulation:

          browse_list = VLIST_INIT( 250 )
          IF browse_list <> 0

            !people GOTO TOP

            temp_first = 1
            DO WHILE .NOT. A_EOF( people )
              IF .NOT. Vlist_Add( browse_list, Dbf_Line() )
                EXIT
              ENDIF

              IF A_RECNO( people ) = old_rec
                temp_first = Vlist_Number( browse_list )
              ENDIF

              !people SKIP
            ENDDO

            browse_current = temp_first
            IF browse_current > 12
              browse_top = browse_current - 6

              DO WHILE ( Vlist_Max( browse_list ) - browse_top + 1 ) < 12
                browse_top = browse_top - 1
              ENDDO

            ELSE
              browse_top = 1
            ENDIF

            browse_left    = 6
            browse_right   = 100

            old_std   = __color_std
            old_enhcd = __color_enhcd
            __color_enhcd = d_main_enhcd
            __color_std = d_menu_std

            * !LOOK:  the following is the actual display of the database
            *         browse simulation.  This is where you would replace
            *         the old FORCE picklist with VLIST_PICK.  This could
            *         also be done differently by having the keyboard
            *         handler read records on-the-fly so you can have
            *         a limited number of records in memory at one time
            *         to save memory.  See the DBFVIEW demo for an example
            *         of a virtual list...

            @ 3, 5 SAY CENTER( "Database pick-list using VLIST_PICK()", 68 )
            @16, 5 SAY CENTER( "Select 'focus' record with <ENTER>, use <ESC> to abort", 68 )

            saved_area2 = SAVESCRN( 24, 0, 24, 79 )
            __color_std = d_main_std
            @24, 0 SAY CENTER( "Press <ESC> | RIGHT-MOUSE-BUTTON to abort browse", 80 )

            ret_val = Vlist_Pick( browse_list, 4, 6, 15, 69, 71,;
                        browse_top, browse_current,;
                        0, 0, browse_left, browse_right, 1, 0,;
                        Default_Key_Handler,;
                        .F., .T., .F., is_mouse, .F.,;
                        d_main_std, d_main_hi_std,;
                        d_main_enhcd, d_main_hi_enhcd,;
                        d_main_skip, d_main_skip,;
                        d_main_data, d_main_border )

            RESTORESCRN( saved_area2 )

            __color_std   = old_std
            __color_enhcd = old_enhcd

            IF ret_val = &EXIT_ERROR .OR. ret_val = &EXIT_ESC
              !people GOTO old_rec
            ELSE
              old_rec = VAL( LEFT( Vlist_Cstr( browse_list ), 5 ) )
              !people GOTO old_rec

              *- let us update the prompt area so this looks cool
              Alter_Prompts()
              browse_top = 1

              ret_val = _Manual_Prompts( prompt_list, 1, browse_top,;
                            Our_Prompt_Handler,;
                            is_mouse, .T.,;
                            d_main_skip, d_main_skip,;
                            __color_enhcd, __color_hi_enhcd,;
                            d_main_skip )

            ENDIF


            Vlist_Clear( browse_list )
          ENDIF

          Draw_Border( .F., .T. )
          Draw_Titles()
          Draw_Rec()
      ENDCASE

      Draw_Border( .F., .F. )
      IF down <> 3
        RESTORESCRN( saved_area )
      ENDIF

    CASE over = 1 .AND. down = 4   && reindex
      IF Confirm_It( 1, "Index data?" ) = 1
        saved_area = SAVESCRN( 10, 32, 13, 47 )
        FILL( 10, 32, 13, 49, __gui_box, " ", d_menu_border, d_menu_std, 6 )
        @11, 34 SAY "ReINDEXing..."
        !people REINDEX
        RESTORESCRN( saved_area )

        restorescrn( sub_saved )
        sub_saved = 0
        Reset_People()

        * !LOOK:  use the RESTlib Message_Box() routine to display a
        *         quick message to the user.
        Message_Box( "Done Indexing", "", " ~Ok ", -1, -1,;
                          d_menu_std, d_menu_hi_std,;
                          d_menu_enhcd, d_menu_hi_enhcd,;
                          d_menu_border )
      ENDIF

    CASE over = 1 .AND. down = 5   && pack
      IF Confirm_It( 1, "Pack data?" ) = 1
        saved_area = SAVESCRN( 10, 33, 13, 47 )
        FILL( 10, 33, 13, 47, __gui_box, " ", d_menu_border, d_menu_std, 6 )
        @11, 35 SAY "PACKing..."
        !people PACK
        !people REINDEX
        RESTORESCRN( saved_area )

        restorescrn( sub_saved )
        sub_saved = 0
        Reset_People()

        * !LOOK:  use the RESTlib Message_Box() routine to display a
        *         quick message to the user.
        Message_Box( "Done Packing", "", " ~Ok ", -1, -1,;
                          d_menu_std, d_menu_hi_std,;
                          d_menu_enhcd, d_menu_hi_enhcd,;
                          d_menu_border )
      ENDIF

    CASE over = 2 .AND. down = 1
      * edit text file
      restorescrn( sub_saved )
      sub_saved = 0

      old_std   = __color_std
      old_enhcd = __color_enhcd
      __color_enhcd = d_main_enhcd
      __color_std = d_menu_std

      saved_area = SAVESCRN( 0, 0, 24, 79 )

      Draw_Border( .T., .T. )

      __color_std = d_menu_std
      @ 3, 5 SAY CENTER( " ", 68 )
      @16, 5 SAY CENTER( "Select TEXT file to edit", 68 )

      __color_std = d_main_std
      temp_str = "<ESC> to abort"
      temp_str = temp_str + "   [ mem = " + I_STR( _memory_left() ) + " ]"
      @24, 0 SAY CENTER( temp_str, 80 )

      * !LOOK:  we will use a built in RESTlib routine to allow the
      *         user to select a text file to edit.  This routine
      *         even allows them to travel to different directories
      *         to find the appropriate file.

      temp_str = One_FPick( 4, 6, 15, 69, 71, 3, 6, 60,;
                            &BLUE_LIGHT_GREEN+128, "", "*.*", .T.,;
                            is_mouse, .T.,;
                            d_main_std, d_main_enhcd,;
                            d_main_skip, d_main_data, d_main_border,;
                            d_menu_std )
      RESTORESCRN( saved_area )

      IF temp_str <> "*" .AND. temp_str <> "-" .AND. Exist( temp_str )

        * !LOOK:  use the RESTlib Confirm_Box() routine to as the user
        *         a quick question.

        decision = Confirm_Box( "Edit Text File",;
                        "Start with WORD WRAP active?",;
                        " ~Yes ", " ~No ", -1, -1,;
                          d_menu_std, d_menu_hi_std,;
                          d_menu_enhcd, d_menu_hi_enhcd,;
                          d_menu_border )

        IF decision > 0
          IF decision = 1
            wrap_mode = .T.
            browse_right = 78
          ELSE
            wrap_mode = .F.
            browse_right = 127
          ENDIF

          saved_area = SAVESCRN( 0, 0, 24, 79 )

          Draw_Border( .T., .T. )
          __color_std = d_menu_std
          @ 3, 5 SAY CENTER( "Edit Text File: " + LEFT( temp_str, 53 ), 68 )
          @16, 5 SAY CENTER( " ", 68 )

          __color_std = d_main_std
          temp_str2 = "ALT-X to exit, ALT-W to save, ALT-T toggle word wrap"
          temp_str2 = temp_str2 + "   [ mem = " + I_STR( _memory_left() ) + " ]"
          @24, 0 SAY CENTER( temp_str2, 80 )

          * !LOOK:  use the RESTlib text editor to edit a text file of
          *         the user's choice.

          decision = Text_Editor( temp_str, 4, 6, 15, 69, 71, 1, 1,;
                                  browse_right, 128,;
                                  .F., wrap_mode, .F.,;
                                  .F., .T., .T.,;
                                  16, 8, is_mouse,;
                                  5, 20, DEFAULT_EDIT_HANDLER,;
                                  d_main_std, d_main_hi_std,;
                                  d_main_std, d_main_hi_std,;
                                  d_main_skip, d_main_data, d_main_border,;
                                  d_menu_hi_std, d_menu_border,;
                                  d_menu_std, d_menu_enhcd, d_menu_border )
          IF decision <> 0
            * !LOOK:  use the RESTlib Message_Box() routine to display a
            *         quick message to the user.
            Message_Box( "Error loading file:", "Probably ran out of memory!",;
                         " ~Ok ", -1, -1,;
                          d_menu_std, d_menu_hi_std,;
                          d_menu_enhcd, d_menu_hi_enhcd,;
                          d_menu_border )
          ENDIF

          RESTORESCRN( saved_area )
        ENDIF
      ELSE
        IF temp_str = "-"
          saved_area = SAVESCRN( 0,0, 24, 79 )
          * !LOOK:  use the RESTlib Message_Box() routine to display a
          *         quick message to the user.
          MESSAGE_BOX( "ONE_FPICK() Failure", "not enough memory!", " ~Ok ",;
                       -1, -1,;
                        d_menu_std, d_menu_hi_std,;
                        d_menu_enhcd, d_menu_hi_enhcd,;
                        d_menu_border )
          RESTORESCRN( saved_area )
        ENDIF
      ENDIF

      __color_std   = old_std
      __color_enhcd = old_enhcd

    CASE over = 2 .AND. down = 3
      IF Confirm_It( 2, "Exit demo?" ) = 1
        main_loop = .F.
        RETURN 1
      ENDIF

    OTHERWISE
  ENDCASE

  RETURN 0
ENDPRO

*******************************************************************************
*                                FORCE_MAIN()                                 *
*******************************************************************************

PROCEDURE Force_Main
  PARAMETERS CONST CHAR( 128 ) dos_cmd_line

  VARDEF
    CHAR( 128 )  our_cmd_line
    BYTE         old_std, old_y, old_x
    LOGICAL      re_index
    UINT         selected
    INT          lkey
    CHAR( 8 )    old_time
    UINT         pull_over, pull_down
    ULONG        cur_rec
    INT          adapt, ret_val
    LOGICAL      pulled, looper
    UINT         head_saved, sub_saved
    CHAR         temp_str
  ENDDEF

  set exact on

  adapt = What_Adapter()

  IF adapt <> &_vga .AND. adapt <> &_ega
    ? "... this demo will not run without a EGA or VGA system..."
    ?
    QUIT 1
  ENDIF

  *- save machine state

  old_std = __color_std
  old_y   = ROW()
  old_x   = COL()
  SAVE_SCREEN()

  SET STATUS OFF
  SET SCOREBOARD OFF
  SET EXCLUSIVE ON

  our_cmd_line = ALLTRIM( UPPER( dos_cmd_line ) )

  *- check for database existance

  SET ALIAS i_people TO "people"

  re_index = .F.
  IF .NOT. EXIST( "people.dbf" )
    ? "cannot build database since we are using dynamic stuff here!"
    QUIT 1
  ELSE
    IF .NOT. EXIST( "people.fdx" )
      re_index = .T.
    ENDIF

  ENDIF

  SET ALIAS i_people TO "people.fdx"
  OPEN "people.dbf" ALIAS people EXCLUSIVE

  IF re_index
    !people INDEX i_people
  ENDIF

  !people SET INDEX TO i_people

  *- set color variables

  d_main_std       = &blue_white+128
  d_main_enhcd     = &black_white
  d_main_enhcd2    = &blue_white
  d_main_border    = &blue_white+128
  d_main_off       = &blue_blue+128
  d_main_data      = &blue_light_grey+128
  d_main_back      = &blue_white
  d_main_skip      = &blue_light_grey+128
  d_main_hi_std    = &blue_light_cyan+128
  d_main_hi_enhcd  = &black_light_cyan
  d_menu_std       = &white_black+128
  d_menu_enhcd     = &black_white
  d_menu_hi_std    = &white_light_red+128
  d_menu_hi_enhcd  = &black_light_red
  d_menu_border    = &white_black+128
  d_menu_skip      = &white_black+128

  SET DELETE ON
  set_delete_on = .T.

  !people GOTO TOP

  *- draw initial screen

  __color_std      = d_main_std
  __color_enhcd    = d_main_enhcd
  __color_enhcd2   = d_main_enhcd2
  __color_skip     = d_main_skip
  __color_bar      = d_main_data
  __color_tab      = d_main_border
  __color_hi_std   = d_main_hi_std
  __color_hi_enhcd = d_main_hi_enhcd

  * !LOOK:  to start the GUI looking fonts just add one line...

  Start_GUI_Look( .F. )

  * The .F. parameter tells Start_GUI_Look() to stay in 25 line mode rather
  * than the possible 43/50 line modes of EGA/VGA systems.

  IF .NOT. __gui_active
    *- this error should never really happen if we checked that
    *  the system was EGA/VGA already BUT we better make sure...

    __color_std = &black_white
    ?
    ? "Fonts did not load!  Is this an EGA/VGA system?"
    ?
    QUIT
  ENDIF

  CLEAR

  *- first draw our 'desktop'
  FILL( 0, 0, 24, 79, "        ", " ", d_main_back, d_main_back, 0 )

  __color_std = d_main_std
  temp_str = "Press <ESC> | RIGHT-MOUSE-BUTTON for pulldown menus"
  temp_str = temp_str + "   [ mem = " + I_STR( _memory_left() ) + " ]"
  @24, 0 SAY CENTER( temp_str, 80 )
  temp_str = "RESTlib V2.4 Demonstration " + __gui_copy + " 1993, 1994 Jayson R. Minard"
  @ 0, 0 SAY CENTER( temp_str, 80 )

  *- now set up the box where the data is displayed

  Draw_Border( .F., .T. )
  Draw_Titles()

  main_loop = .T.

  *- initialize the VLIST lists used for menus and prompts

  Setup_Menus()
  Setup_Prompts()

  *- do we have a mouse here?

  IF _mouse_Init() = 0
    is_mouse = .F.
  ELSE
    is_mouse = .T.
    _mouse_Reset()
    _mouse_Set_Rowcol( 13, 77 )
  ENDIF

  selected = 1
  at_end   = A_EOF( people )
  at_front = .T.
  pull_over = 1
  pull_down = 1
  pulled = .F.

  *- draw box for prompts:
  FILL( 19, 1, 22, 78, __gui_box, " ", d_main_border, d_main_std, 6 )

  CURSOR_OFF()
  Alter_Prompts()

  DO WHILE main_loop
    Draw_Rec()

    * !LOOK:  here is the prompt display and execution for the prompt
    *         bar across the bottom of the screen.

    ret_val = _Manual_Prompts( prompt_list, 1, selected,;
                             Our_Prompt_Handler,;
                             is_mouse, .F.,;
                             d_main_std, d_main_hi_std,;
                             d_main_enhcd, d_main_hi_enhcd,;
                             d_main_skip )

    DO CASE
      CASE ret_val = &EXIT_ERROR
        main_loop = .F.
        LOOP

      CASE ret_val = &EXIT_ESC
        FILL( 19, 1, 22, 78, "        ", "", d_main_back, d_main_back, 0 )
        FILL( 19, 1, 21, 77, __gui_box, "", d_main_off, d_main_std, 0 )

        *- show the prompts dull like but do not execute them

        ret_val = _manual_Prompts( prompt_list, 1, selected,;
                      Our_Prompt_Handler,;
                      is_mouse, .T.,;
                      d_main_skip, d_main_skip,;
                      __color_enhcd, __color_hi_enhcd,;
                      d_main_skip )

        __color_std      = d_menu_std
        __color_enhcd    = d_menu_enhcd
        __color_hi_std   = d_menu_hi_std
        __color_hi_enhcd = d_menu_hi_enhcd
        __color_skip     = d_menu_skip

        @ 0, 0 CLEAR TO 0, 79

        __color_std = d_main_std
        temp_str = "<ESC> or RIGHT-MOUSE-BUTTON to exit the pulldown menu"
        temp_str = temp_str + "   [ mem = " + I_STR( _memory_left() ) + " ]"
        @24, 0 SAY CENTER( temp_str, 80 )
        __color_std = d_menu_std

        looper = .T.

        DO WHILE looper

          * !LOOK:  here is the pulldown menu execution

          ret_val = _Manual_Pulldown( menu_list, 1, pull_over, pull_down, pulled,;
                          Default_Menu_Handler,;
                          0, 1, 0,;
                          __gui_box, is_mouse, .T., .T.,;
                          sub_saved, head_saved,;
                          d_menu_std, d_menu_hi_std,;
                          d_menu_enhcd, d_menu_hi_enhcd,;
                          d_menu_skip, d_menu_std, d_menu_hi_std,;
                          d_menu_enhcd, d_menu_hi_enhcd, d_menu_border )

          IF ret_val <> &EXIT_ERROR .AND. ret_val <> &EXIT_ESC
            *- call our routine to handle the pulldown menu selection.  This
            *  was written as a subroutine just so this case statement wasn't
            *  any larger than it already is...

            ret_val = Handle_Select( menu_list, 1, pull_over, pull_down,;
                                     sub_saved, head_saved )
            IF ret_val = 1
              looper = .F.
            ENDIF
          ELSE
            looper = .F.
            IF ret_val = &EXIT_ERROR
              main_loop = .F.
            ENDIF
          ENDIF
          IF ( sub_saved <> 0 )
            restorescrn( sub_saved )
          ENDIF

          IF ( head_saved <> 0 )
            freescrn( head_saved )
          ENDIF
        ENDDO

        __color_std = d_main_std
        temp_str = "Press <ESC> | RIGHT-MOUSE-BUTTON for pulldown menus"
        temp_str = temp_str + "   [ mem = " + I_STR( _memory_left() ) + " ]"
        @24, 0 SAY CENTER( temp_str, 80 )
        temp_str = "RESTlib V2.4 Demonstration " + __gui_copy + " 1993 Jayson R. Minard"
        @ 0, 0 SAY CENTER( temp_str, 80 )

        __color_enhcd    = d_main_enhcd
        __color_hi_std   = d_main_hi_std
        __color_hi_enhcd = d_main_hi_enhcd
        __color_skip     = d_main_skip

        FILL( 19, 1, 22, 78, __gui_box, "", d_main_border, d_main_std, 6 )

        cur_rec = A_RECNO( people )

        *- see if next record is end of file
        !people SKIP
        IF A_EOF( people )
          at_end = .T.
          selected = 2
        ELSE
          at_end = .F.
        ENDIF

        !people GOTO cur_rec

        *- see if previous record is beginning of file
        !people SKIP -1
        IF A_BOF( people )
          at_front = .T.
          selected = 1
        ELSE
          at_front = .F.
        ENDIF

        *- go back to the right record
        !people GOTO cur_rec

        Alter_Prompts()

      CASE selected = 1 && next
        !people SKIP 2
        IF A_EOF( people )
          at_end = .T.
          selected = 2
        ELSE
          at_end = .F.
        ENDIF

        !people SKIP - 1

        at_front = A_BOF( people )

        Alter_Prompts()

      CASE selected = 2        && previous
        !people SKIP -2
        IF A_BOF( people )
          at_front = .T.
          selected = 1
        ELSE
          at_front = .F.
          !people SKIP
        ENDIF

        at_end = A_EOF( people )

        Alter_Prompts()

      CASE selected = 3 && top
        !people GOTO TOP
        at_front = .T.
        at_end = A_EOF( people )
        selected = 1

        Alter_Prompts()

      CASE selected = 4 && bottom
        !people GOTO BOTTOM
        at_end = .T.
        at_front = A_BOF( people )
        selected = 2

        Alter_Prompts()

      CASE selected = 5 && deleted()
        IF A_DELETED( people )
          !people RECALL
        ELSE
          !people DELETE
        ENDIF

        Alter_Prompts()

      CASE selected = 6 && set delete
      * !LOOK:  alter an existing prompt to act like a push-button

        IF set_delete_on
          SET DELETE OFF
          Vlist_Edit( prompt_list, 6, "1.6 @20, 55 |  [ ] ~SET DELETE ON  " )
        ELSE
          SET DELETE ON
          Vlist_Edit( prompt_list, 6, "1.6 @20, 55 |  [X] ~SET DELETE ON  " )
        ENDIF

        set_delete_on = .NOT. set_delete_on
    ENDCASE

  ENDDO

  * !LOOK:  to turn GUI looking fonts off just call one line again...

  Stop_GUI_Look()

  *- reset machine state
  CURSOR_ON()

  IF is_mouse
    _mouse_Reset()
    _mouse_Cursor( .F. )
  ENDIF

  CLOSE ALL
  __color_std = old_std
  RESTORE_AREA()
  @ old_y, old_x

ENDPRO




