*
*                        RRRRRRR
*                        RRR  RRR
*                        RRR   RRR
*                        RRR  RRR
*                        RRRRRRR   E S T l i b
*                        RRR RRR
*                        RRR  RRR
*                        RRR   RRR
*                        RRR    RRR
*
*                        for Force v2.x
*
*                      D E M O N S T R A T I O N
*
*               [ created using a RESTlib BETA release ]
*
*               RESTlib (c) 1993, 1994 Jayson R. Minard
*
*******************************************************************************
*
* This program is a simple demonstration of using RESTlib's HELP STACK
* for procedure level help.
*
* NOTE:  this demo tracts help locations on a procedure level but you
*        can just as easliy push and pop help locations within a single
*        routine many times!
*

#INCLUDE WARN.HDR
#INCLUDE STRING.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE IO.HDR
#INCLUDE COLORS.HDR
#INCLUDE KEYS.HDR
#INCLUDE DATABASE.HDR

#INCLUDE resthelp.hdr
#INCLUDE restmenu.hdr
#INCLUDE restdata.hdr
#INCLUDE restedit.hdr
#INCLUDE restmisc.hdr

#DEFINE  help_main_gets            1
#DEFINE  help_ask_name             2
#DEFINE  help_ask_home_address     3
#DEFINE  help_ask_work_address     4

#DEFINE  ask_home 1
#DEFINE  ask_work 2

DBFDEF Help_DBF
  INT( 3 )    Location
  MEMO        Help_Text
ENDDEF

INDEXDEF
  INT( 3 )    i_help_dbf   Help_DBF->Location
ENDDEF

FUNCTION INT Show_Help

  VARDEF
    INT     lkey,;
            last_proc,;
            ret_val,;
            lastx,;
            lasty
    CHAR    temp_str
    LOGICAL read_only
    LOGICAL keep_going
  ENDDEF

  lkey = LastKey()

  IF lkey = &K_F1
    lastx = COL()
    lasty = ROW()

    ON KEY DO

    *- get the last location number and description (which we ignore)
    IF Help_Last( last_proc, temp_str )
      lkey = 0

      *- find help in database and display it.  If no help exists then
      *  allow user to write his own!

      !Help_DBF SEEK last_proc
      IF .NOT. FOUND()
        *- if no help for a topic is there then ask them if they want to
        *  create it!

        ret_val = Confirm_Box( "No help for topic found...",;
                               "Would you like to create help for this topic?",;
                               " ~Yes ", " ~No ", -1, -1,;
                               &black_white, &black_light_cyan,;
                               &blue_white, &blue_light_cyan,;
                               &black_yellow )
        IF ret_val = 1
          read_only = .F.
          !Help_DBF APPEND BLANK
          !Help_DBF REPLACE Help_DBF->Location WITH last_proc
          keep_going = .T.
        ELSE
          keep_going = .F.
        ENDIF
      ELSE
        CURSOR_OFF()
        read_only = .T.
        keep_going = .T.
      ENDIF

      IF keep_going
        SAVE_AREA( 7, 10, 17, 70 )

        FILL( 7, 10, 17, 70, &DOUBLE_BOX, " ", &blue_yellow, &blue_white, 0 )
        Between( 7, 10, 70, " Maybe put TITLE here? ", &blue_light_red )
        IF .NOT. read_only
          ColorSay( 17, 56, " ALT-X Exits ", &blue_light_magenta )
        ELSE
          Between( 17, 10, 70, " ALT-X Exits ", &blue_light_magenta )
        ENDIF

        Memo_Editor( Help_DBF->Help_Text, 8, 11, 16, 69, 70,;
                     1, 1, 58, 128, .T.,;
                     .T., .F., read_only,;
                     (.NOT. read_only),;
                     (.NOT. read_only), 17, 12,;
                     .F., 5, 5, Default_Edit_Handler,;
                     &blue_light_grey, &blue_light_cyan,;
                     &blue_white, &blue_light_cyan,;
                     &blue_dark_grey, &blue_yellow, &blue_yellow,;
                     &blue_light_magenta, &blue_magenta,;
                     &blue_white, &black_white, &blue_yellow )

        *- turn cursor on since memo editor leaves it off
        Cursor_On()
        RESTORE_AREA()
      ENDIF

    ELSE
      Message_Box( "HELP ERROR", "Nothing presently on HELP STACK!",;
                   " ~Ok ", -1, -1,;
                   &black_white, &black_light_cyan,;
                   &blue_white, &blue_light_cyan,;
                   &black_yellow )

      ? "Nothing in help stack!"
    ENDIF

    ON KEY DO Show_Help
    @lasty, lastx
  ENDIF

  RETURN lkey
ENDPRO

PROCEDURE Ask_Address
  PARAMETERS VALUE INT home_or_work

  VARDEF
    CHAR( 40 ) address1,;
               address2
  ENDDEF

  address1 = SPACE( 40 )
  address2 = SPACE( 40 )

  CLEAR
  @24, 2 SAY "Press F1 for Help"

  *- tell the help system where we are currently
  IF home_or_work = &ask_home
    Help_QPush( &help_ask_home_address )
    @ 8,2 SAY "Enter Home Address..."
  ELSE
    Help_QPush( &help_ask_work_address )
    @ 8,2 SAY "Enter Work Address..."
  ENDIF

  @ 2, 2 SAY "RESTlib HELP STACK Demo"
  @10,2 SAY "Address: " GET address1
  @11,2 SAY "         " GET address2
  READ

  *- clear this routine from the help stack on exit
  Help_QPop()
ENDPRO

PROCEDURE Ask_Name
  VARDEF
    CHAR( 40 )  user_name
  ENDDEF

  user_name = SPACE( 40 )

  *- tell the help system where we are currently
  Help_QPush( &help_ask_name )

  CLEAR
  @ 2, 2 SAY "RESTlib HELP STACK Demo"
  @24, 2 SAY "Press F1 for Help"
  @10, 2 SAY "Enter user name: " GET user_name PICTURE "XXXXXXXXXXXXXXXXXXXX"
  READ

  Ask_Address( &ask_home )
  Ask_Address( &ask_work )

  *- clear this routine from the help stack on exit
  Help_QPop()
ENDPRO

PROCEDURE Main_Gets
  VARDEF
    CHAR( 40 )  user_id
    CHAR( 5 )   user_pwd
  ENDDEF

  user_id = SPACE( 40 )
  user_pwd = SPACE( 5 )

  *- tell the help system where we are currently
  Help_QPush( &help_main_gets )

  CLEAR
  @ 2, 2 SAY "RESTlib HELP STACK Demo"
  @24, 2 SAY "Press F1 for Help"

  @10, 2 SAY " Enter user ID: " GET user_id PICTURE "XXXXXXXXXXXXXXXXXXXXXXX"
  @12, 2 SAY "Enter Password: " GET user_pwd PICTURE "XXXXX"
  READ

  Ask_Name()

  *- clear this routine from the help stack on exit
  Help_QPop()

ENDPRO

PROCEDURE Force_Main
  PARAMETERS CONST CHAR( 128 ) raw_cmd_line

  __color_std = &black_white
  __color_enhcd = &blue_white
  __color_enhcd2 = &red_white

  *- open help database
  IF ( .NOT. EXIST( "HELPDEMO.DBF" ) ) .OR.;
     ( UPPER( ALLTRIM( raw_cmd_line ) ) = "/NEW" )

    *- if it is missing then create it.  The user will have a chance to
    *  write the help whenever they try to call it up for a specific
    *  location!
    BUILD "HELPDEMO.DBF" FROM ALIAS Help_DBF
    CLOSE ALL
  ENDIF

  OPEN "HELPDEMO.DBF" ALIAS Help_DBF

  *- really I shouldn't index everytime but it was easy to code <g>...
  SET ALIAS i_help_dbf TO "HELPDEMO.FDX"
  !Help_DBF INDEX i_help_dbf

  *- turn the help STACK on!
  IF .NOT. Help_Init()
    ? "Could not initialize help system..."
    QUIT 1
  ENDIF

  ON KEY DO Show_Help

  *- We will use the short stack method that uses a location number
  *  only for recognition of where the program state is.

  Main_Gets()

  *- turn the help STACK off!
  Help_DeInit()

  CLEAR
  CLOSE ALL

  ?
  ? "You can erase HELPDEMO.DBF or run this program with the /NEW parameter"
  ? "to clear out the current help text.  You will then be prompted to enter"
  ? "new help text at each help location if you press F1 at the appropriate"
  ? "time..."
  ?
ENDPRO
