*
*                        RRRRRRR
*                        RRR  RRR
*                        RRR   RRR
*                        RRR  RRR
*                        RRRRRRR   E S T l i b
*                        RRR RRR
*                        RRR  RRR
*                        RRR   RRR
*                        RRR    RRR
*
*                        for Force v2.x
*
*                      D E M O N S T R A T I O N
*
*               [ created using a RESTlib BETA release ]
*
*               RESTlib (c) 1993, 1994 Jayson R. Minard
*
*******************************************************************************
*
* This demo shows the use of the pick-list routines from RESTlib.
*

#INCLUDE WARN.HDR
#INCLUDE STRING.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE IO.HDR
#INCLUDE COLORS.HDR
#INCLUDE KEYS.HDR
#INCLUDE DATABASE.HDR

#INCLUDE restdata.hdr
#INCLUDE restmisc.hdr
#INCLUDE restlist.hdr

PROCEDURE Force_Main
  VARDEF
    LONG     list_handle
    INT      top_element, ;
             selected,;
             exit_code,;
             color_count,;
             counter
    LOGICAL  is_mouse
    CHAR     selected_file
  ENDDEF

  list_handle = VList_Init( 10 )
  IF list_handle = 0
    ? "Error initializing the list!"
    QUIT
  ENDIF

  top_element = 0
  FOR counter = 1 TO 300
    IF .NOT. VList_Add( list_handle, "Item " + STR( counter, 4, 0 ) )
      ? "Error adding list element!"
      QUIT
    ENDIF

    top_element = top_element + 1
    IF top_element = 7
      top_element = 0
      VList_CSet_Status( list_handle, &STAT_SKIP )
    ENDIF

  NEXT

  selected = 1
  top_element = 1

  IF _Mouse_Init() <> 0
    is_mouse = .T.
    _Mouse_Reset()
  ELSE
    is_mouse = .F.
  ENDIF

  CURSOR_OFF()

  CLEAR
  @ 0, 2 SAY "RESTlib VLIST_PICK() example (single column)"
  @ 2, 2 SAY "Select items with <ENTER> but exit selecting with <ESC>"
  FILL( 4, 8, 21, 22, &DOUBLE_BOX, " ", &BLACK_LIGHT_GREY, &BLACK_WHITE, 0 )

  *- show an example of VLIST_PICK using a single column pick-list

  REPEAT
    exit_code = VList_Pick( list_handle, ;
                           5, 10, 20, 20, 22, ;
                           top_element, ;
                           selected, ;
                           0, 0,;    && first element, last element
                           0, 0, ;
                           1, 2, ;   && number of columns, spaces between
                           Default_Key_Handler, ;
                           .F., .T., .F., is_mouse, .F.,;
                           &BLACK_WHITE, &BLACK_LIGHT_CYAN,;
                           &BLUE_WHITE, &BLUE_LIGHT_CYAN,;
                           &BLACK_LIGHT_GREY, &BLACK_LIGHT_GREY,;
                           &BLACK_LIGHT_GREY, &BLACK_LIGHT_GREY )

    IF exit_code = &EXIT_SELECT
      @23,0 SAY "Last selected = " + STR( selected, 4, 0 )
    ENDIF

  UNTIL exit_code = &EXIT_ESC .OR. exit_code = &EXIT_ERROR

  *- change the colors of the elements to make a rainbow and hide every
  *  one that is set currently as skipped!

  color_count = 15
  VList_Top( list_handle )
  DO WHILE .NOT. VList_Eof( list_handle )
    IF VList_CGet_Status( list_handle ) = &STAT_SKIP
      VList_CSet_Status( list_handle, &STAT_HIDE )
    ELSE
      VList_CSet_Color( list_handle, color_count )
      color_count = color_count - 1
      IF color_count = 8
        color_count = 7
      ELSE
        IF color_count = 6
          color_count = 15
        ENDIF
      ENDIF
    ENDIF

    VList_Skip( list_handle, &SKIP_FORWARD )
  ENDDO

  *- show an example of VLIST_PICK using multiple columns

  CLEAR
  @ 0, 2 SAY "RESTlib VLIST_PICK() example (multiple column / multiple color)"
  @ 2, 2 SAY "Select items with <ENTER> but exit selecting with <ESC>"
  FILL( 4, 8, 21, 46, &DOUBLE_BOX, " ", &BLACK_LIGHT_GREY, &BLACK_WHITE, 0 )

  REPEAT
    exit_code = VList_Pick( list_handle, ;
                           5, 10, 20, 44, 46, ;
                           top_element, ;
                           selected, ;
                           0, 0,;    && first element, last element
                           0, 0, ;
                           3, 2, ;   && number of columns, spaces between
                           Default_Key_Handler, ;
                           .F., .T., .F., is_mouse, .F.,;
                           &BLACK_WHITE, &BLACK_LIGHT_CYAN,;
                           &BLUE_WHITE, &BLUE_LIGHT_CYAN,;
                           &BLACK_LIGHT_GREY, &BLACK_LIGHT_GREY,;
                           &BLACK_LIGHT_GREY, &BLACK_LIGHT_GREY )

    IF exit_code = &EXIT_SELECT
      @23,0 SAY "Last selected = " + STR( selected, 4, 0 )
    ENDIF

  UNTIL exit_code = &EXIT_ESC .OR. exit_code = &EXIT_ERROR

  *- show an example of VLIST_PICK using multiple columns but with a limitted
  *  range of items.

  CLEAR
  @ 0, 2 SAY "RESTlib VLIST_PICK() example (only showing items 40..160)"
  @ 2, 2 SAY "Select items with <ENTER> but exit selecting with <ESC>"
  FILL( 4, 8, 21, 46, &DOUBLE_BOX, " ", &BLACK_LIGHT_GREY, &BLACK_WHITE, 0 )

  REPEAT
    exit_code = VList_Pick( list_handle, ;
                           5, 10, 20, 44, 46, ;
                           top_element, ;
                           selected, ;
                           40, 160,;    && first element, last element
                           0, 0, ;
                           3, 2, ;   && number of columns, spaces between
                           Default_Key_Handler, ;
                           .F., .T., .F., is_mouse, .F.,;
                           &BLACK_WHITE, &BLACK_LIGHT_CYAN,;
                           &BLUE_WHITE, &BLUE_LIGHT_CYAN,;
                           &BLACK_LIGHT_GREY, &BLACK_LIGHT_GREY,;
                           &BLACK_LIGHT_GREY, &BLACK_LIGHT_GREY )

    IF exit_code = &EXIT_SELECT
      @23,0 SAY "Last selected = " + STR( selected, 4, 0 )
    ENDIF

  UNTIL exit_code = &EXIT_ESC .OR. exit_code = &EXIT_ERROR

  *- now show an example of the most simple pick-list routine

  CLEAR
  @ 0, 2 SAY "RESTlib VPICK_LIST() simple pick-list example"
  @ 2, 2 SAY "Select ONE item"
  FILL( 4, 8, 21, 21, &DOUBLE_BOX, " ", &BLACK_LIGHT_GREY, &BLACK_WHITE, 0 )
  VPick_List( list_handle, 5, 10, 20, 19, selected, .F., .F. )

  *- clear our string list
  VList_Clear( list_handle )

  *- now show the file picking routines
  CLEAR
  @ 0, 2 SAY "RESTlib ONE_FPICK() example for picking a filename"
  FILL( 4, 13, 20, 67, &DOUBLE_BOX, " ", &BLACK_LIGHT_GREY, &BLACK_WHITE, 0 )
  selected_file = One_FPick( 5, 15, 19, 65, 67, 4, 15, 39,;
                             &BLACK_LIGHT_GREEN, "", "*.*", .T.,;
                             is_mouse, .T., &BLACK_WHITE, &BLUE_WHITE,;
                             &BLACK_LIGHT_GREY,;
                             &BLACK_LIGHT_GREY, &BLACK_LIGHT_GREY,;
                             &BLACK_YELLOW )
  IF selected_file = "-"
    @22, 0 SAY "Error Occured!"
  ELSE
    IF selected_file = "*"
      @22, 0 SAY "ESC Pressed, selection aborted!"
    ELSE
      @22, 0 SAY "File selected: '" + selected_file + "'"
    ENDIF
  ENDIF
  @24, 0 SAY "Press any key to continue..."

  DO WHILE INKEY() <> 0
  ENDDO

  GET_KEY()

  *- now show multiple file selections from the same directory

  CLEAR
  @ 0, 2 SAY "RESTlib MANY_FPICK() example for picking multiple filenames in same DIR"
  @ 2, 2 SAY "SPACE to select, ENTER to exit w/selected list, CTRL-U unmark ALL, ESC aborts"

  FILL( 4, 13, 20, 67, &DOUBLE_BOX, " ", &BLACK_LIGHT_GREY, &BLACK_WHITE, 0 )
  list_handle = Many_FPick( 5, 15, 19, 65, 67, 4, 15, 39,;
                             &BLACK_LIGHT_GREEN, &BLACK_LIGHT_RED,;
                             "", "*.*", .T.,;
                             is_mouse, .T., ;
                             .F., 200,;   && select from multiple dirs?, max #
                             &BLACK_WHITE, &BLUE_WHITE,;
                             &BLACK_LIGHT_GREY,;
                             &BLACK_LIGHT_GREY, &BLACK_LIGHT_GREY,;
                             &BLACK_YELLOW )
  CLEAR
  IF list_handle = -1
    ? "Error Occured!"
  ELSE
    IF list_handle = 0
      ? "ESC Pressed, selection aborted!"
    ELSE
      ? "The following files were selected:"
      ?
      VList_Top( list_handle )
      DO WHILE .NOT. VList_EOF( list_handle )
        ? VList_CStr( list_handle )
        VList_Skip( list_handle, &SKIP_FORWARD )
      ENDDO
      VList_Clear( list_handle )
    ENDIF
  ENDIF

  ? "Press any key to continue..."

  DO WHILE INKEY() <> 0
  ENDDO

  GET_KEY()

  *- now show multiple file selections from multiple directories

  CLEAR
  @ 0, 2 SAY "RESTlib MANY_FPICK() example for picking multiple filenames across many DIRs"
  @ 2, 2 SAY "SPACE to select, ENTER to exit w/selected list, CTRL-U unmark ALL, ESC aborts"

  FILL( 4, 13, 20, 67, &DOUBLE_BOX, " ", &BLACK_LIGHT_GREY, &BLACK_WHITE, 0 )
  list_handle = Many_FPick( 5, 15, 19, 65, 67, 4, 15, 39,;
                             &BLACK_LIGHT_GREEN, &BLACK_LIGHT_RED,;
                             "", "*.*", .T.,;
                             is_mouse, .T., ;
                             .T., 200,;   && select from multiple dirs?, max #
                             &BLACK_WHITE, &BLUE_WHITE,;
                             &BLACK_LIGHT_GREY,;
                             &BLACK_LIGHT_GREY, &BLACK_LIGHT_GREY,;
                             &BLACK_YELLOW )
  CLEAR
  IF list_handle = -1
    ? "Error Occured!"
  ELSE
    IF list_handle = 0
      ? "ESC Pressed, selection aborted!"
    ELSE
      ? "The following files were selected:"
      ?
      VList_Top( list_handle )
      DO WHILE .NOT. VList_EOF( list_handle )
        ? VList_CStr( list_handle )
        VList_Skip( list_handle, &SKIP_FORWARD )
      ENDDO
      VList_Clear( list_handle )
    ENDIF
  ENDIF

  ? "Press any key to continue..."

  DO WHILE INKEY() <> 0
  ENDDO

  GET_KEY()

  *- now show multiple file selections from the same directory but only
  *  allow 3 to be selected

  CLEAR
  @ 0, 2 SAY "RESTlib MANY_FPICK() example for picking up to 3 filenames in same DIR"
  @ 2, 2 SAY "SPACE to select, ENTER to exit w/selected list, CTRL-U unmark ALL, ESC aborts"

  FILL( 4, 13, 20, 67, &DOUBLE_BOX, " ", &BLACK_LIGHT_GREY, &BLACK_WHITE, 0 )
  list_handle = Many_FPick( 5, 15, 19, 65, 67, 4, 15, 39,;
                             &BLACK_LIGHT_GREEN, &BLACK_LIGHT_RED,;
                             "", "*.*", .T.,;
                             is_mouse, .T., ;
                             .F., 3,;   && select from multiple dirs?, max #
                             &BLACK_WHITE, &BLUE_WHITE,;
                             &BLACK_LIGHT_GREY,;
                             &BLACK_LIGHT_GREY, &BLACK_LIGHT_GREY,;
                             &BLACK_YELLOW )
  CLEAR
  IF list_handle = -1
    ? "Error Occured!"
  ELSE
    IF list_handle = 0
      ? "ESC Pressed, selection aborted!"
    ELSE
      ? "The following files were selected:"
      ?
      VList_Top( list_handle )
      DO WHILE .NOT. VList_EOF( list_handle )
        ? VList_CStr( list_handle )
        VList_Skip( list_handle, &SKIP_FORWARD )
      ENDDO
      VList_Clear( list_handle )
    ENDIF
  ENDIF

  ? "Press any key to continue..."

  DO WHILE INKEY() <> 0
  ENDDO

  GET_KEY()

  *- DONE

  CLEAR
  ?
  ? "Done."
  ?
  IF is_mouse
    _Mouse_Reset()
    _Mouse_Cursor( .F. )
  ENDIF

  CURSOR_ON()

ENDPRO

