*
*                        RRRRRRR
*                        RRR  RRR
*                        RRR   RRR
*                        RRR  RRR
*                        RRRRRRR   E S T l i b
*                        RRR RRR
*                        RRR  RRR
*                        RRR   RRR
*                        RRR    RRR
*
*                        for Force v2.x
*
*                      D E M O N S T R A T I O N
*
*               [ created using a RESTlib BETA release ]
*
*               RESTlib (c) 1993, 1994 Jayson R. Minard
*
*******************************************************************************
*
* This demo shows simple menus (mouse-able) from RESTlib.  For a more complex
* demo see DEMO.PRG.
*
* You will see PROMPTS, POP-UP Menus, and PULL-DOWN Menus here.
*

#INCLUDE WARN.HDR
#INCLUDE STRING.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE IO.HDR
#INCLUDE COLORS.HDR
#INCLUDE KEYS.HDR
#INCLUDE DATABASE.HDR

#INCLUDE restmenu.hdr
#INCLUDE restdata.hdr
#INCLUDE restmisc.hdr

PROCEDURE Force_Main

  VARDEF
    LOGICAL is_mouse
    UINT    result_id,;
            over_id,;
            down_id,;
            save_temp
    INT     exit_code
    CHAR    temp_str
    LOGICAL pulled
  ENDDEF

  __color_std = &BLACK_WHITE
  __color_enhcd = &BLUE_WHITE
  __color_enhcd2 = &RED_WHITE

  CLEAR

  IF _Mouse_Init() <> 0
    is_mouse = .T.
    _Mouse_Reset()
  ELSE
    is_mouse = .F.
  ENDIF

  @ 4, 5 SAY "RESTlib Example of AT_PROMPT() and MENU_TO()"
  @ 8, 5 SAY "Select a prompt:"

  *- set our prompts
  At_Prompt( 10, 5, " ~Prompt 1 " )
  At_Prompt( 10, 15, " ~Choice 2 " )
  At_Prompt( 10, 26, " ~Option 3 " )

  *- set our starting prompt number (also used to retrieve the selected ID)
  result_id = 1

  *- execute the menu
  exit_code = Menu_To( result_id, &black_white, &black_light_cyan,;
                       &blue_white, &blue_light_cyan, &black_light_grey )

  *- now grey the prompts.  We do not have to call At_Prompt again since
  *  the prompts are in memory until specifically cleared.

  Show_Prompts( &black_light_grey, &black_light_grey, &black_light_grey,;
                &black_light_grey, &black_light_grey )

  DO CASE
    CASE exit_code = &EXIT_SELECT
      DO CASE
        CASE result_id = 1
          temp_str = "Prompt 1"
        CASE result_id = 2
          temp_str = "Choice 2"
        CASE result_id = 3
          temp_str = "Option 3"
      ENDCASE

      Message_Box( "Selection Made:", temp_str, " ~Ok ", 13, -1,;
                   &blue_white, &blue_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &blue_yellow )

    CASE exit_code = &EXIT_ESC
      Message_Box( "ESC Hit", "Selection Aborted", " ~Ok ", 13, -1,;
                   &magenta_white, &magenta_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &magenta_yellow )
    CASE exit_code = &EXIT_ERROR
      Message_Box( "Error", "Prompts Failed", " ~Ok ", 13, -1,;
                   &red_white, &red_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &red_yellow )
  ENDCASE

  *- clear these prompts out of memory
  Clear_Prompts()

  CLEAR

  @ 4, 5 SAY "RESTlib Example of AT_PROMPT() and MENU_TO()"
  @ 8, 5 SAY "Select a prompt:"

  *- now create prompts that use our own ID numbers
  At_Prompt_ID( 10, 5, " ~Prompt 3 ", 3 )
  At_Prompt_ID( 10, 15, " ~Choice 7 ", 7 )
  At_Prompt_ID( 10, 26, " ~Option 3 ", 13 )

  *- but turn off the second prompt!
  Edit_Prompt_Stat( 7, &STAT_SKIP )

  *- change the text on the third prompt to the correct new text
  Edit_Prompt( 13, " ~Option 13 " )

  *- set our starting prompt number (also used to retrieve the selected ID)
  result_id = 13

  *- execute the menu
  exit_code = Menu_To( result_id, &black_white, &black_light_cyan,;
                       &blue_white, &blue_light_cyan, &black_light_grey )

  *- now grey the prompts.  We do not have to call At_Prompt again since
  *  the prompts are in memory until specifically cleared.

  Show_Prompts( &black_light_grey, &black_light_grey, &black_light_grey,;
                &black_light_grey, &black_light_grey )

  DO CASE
    CASE exit_code = &EXIT_SELECT
      DO CASE
        CASE result_id = 1
          temp_str = "Prompt 3"
        CASE result_id = 2
          temp_str = "Choice 7"
        CASE result_id = 3
          temp_str = "Option 13"
      ENDCASE

      Message_Box( "Selection Made:", temp_str, " ~Ok ", 13, -1,;
                   &blue_white, &blue_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &blue_yellow )

    CASE exit_code = &EXIT_ESC
      Message_Box( "ESC Hit", "Selection Aborted", " ~Ok ", 13, -1,;
                   &magenta_white, &magenta_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &magenta_yellow )
    CASE exit_code = &EXIT_ERROR
      Message_Box( "Error", "Prompts Failed", " ~Ok ", 13, -1,;
                   &red_white, &red_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &red_yellow )
  ENDCASE

  *- clear these prompts out of memory
  Clear_Prompts()

  result_id = Confirm_Box( "Continue...", "Do you wish to see more?",;
                           " ~Yes ", " ~No ", -1, -1,;
                           &blue_white, &blue_light_cyan,;
                           &black_white, &black_light_cyan,;
                           &blue_yellow )

  IF result_id = 2
    CLEAR
    QUIT
  ENDIF

  ***** NOW SHOW POP-UP menu stuff!
  CLEAR

  @ 4, 5 SAY "RESTlib Example of ADD_TO_POPUP() and DO_POPUP()"

  *- create our popup menu

  *- you could create it as follows but I want to control the menu ID
  *  myself so...

*  Add_To_PopUp( " ~Open " )    && ID = 1
*  Add_To_PopUp( " ~Close " )   && ID = 2
*  Add_Sep_To_PopUp()           && ID = none
*  Add_To_PopUp( " O~ptions " ) && ID = 4
*  Add_To_PopUp( " Go ~fish " ) && ID = 5
*  Add_Sep_To_PopUp()           && ID = none
*  Add_To_PopUp( " E~xit " )    && ID = 6

  Add_To_PopUp_ID( " ~Open ", 1 )     && ID = 1
  Add_To_PopUp_ID( " ~Close ", 2 )    && ID = 2
  Add_Sep_To_PopUp()                  && ID = none
  Add_To_PopUp_ID( " O~ptions ", 3 )  && ID = 3
  Add_To_PopUp_ID( " Go ~fish ", 4  ) && ID = 4
  Add_Sep_To_PopUp()                  && ID = none
  Add_To_PopUp_ID( " E~xit ", 5 )     && ID = 5

  *- execute the popup

  result_id = 2
  exit_code = Do_PopUp( 7, 20, result_id, "My Popup",;
                        &blue_white, &blue_light_red,;
                        &black_white, &black_light_red,;
                        &blue_light_grey, &blue_light_magenta,;
                        &blue_yellow )

  *- note that our CASE statement is similar for all menu calls!

  DO CASE
    CASE exit_code = &EXIT_SELECT
      DO CASE
        CASE result_id = 1
          temp_str = "Open"
        CASE result_id = 2
          temp_str = "Close"
        CASE result_id = 3
          temp_str = "Options"
        CASE result_id = 4
          temp_str = "Go fish"
        CASE result_id = 5
          temp_str = "Exit"
      ENDCASE

      Message_Box( "Selection Made:", temp_str, " ~Ok ", -1, -1,;
                   &blue_white, &blue_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &blue_yellow )

    CASE exit_code = &EXIT_ESC
      Message_Box( "ESC Hit", "Selection Aborted", " ~Ok ", -1, -1,;
                   &magenta_white, &magenta_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &magenta_yellow )
    CASE exit_code = &EXIT_ERROR
      Message_Box( "Error", "PopUp Failed to Execute", " ~Ok ", -1, -1,;
                   &red_white, &red_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &red_yellow )
  ENDCASE

  *- do the popup again with a few edited or disabled menu items and use
  *  the last selected item as the starting point...

  *- change ID #4 text to something new
  Edit_PopUp_Item( 4, " Stop ~fishing " )

  *- change the ID of what they just selected to be skipped
  Edit_PopUp_Stat( result_id, &STAT_SKIP )

  *- change ID #5 text to something new
  Edit_PopUp_Item( 5, " ~Help " )

  CLEAR

  @ 4, 5 SAY "RESTlib Example of ADD_TO_POPUP() and DO_POPUP()"

  *- execute the popup (the -1 row and col means to center the popup)
  exit_code = Do_PopUp( 3, 3, result_id, "My Popup #2",;
                        &blue_white, &blue_light_red,;
                        &black_white, &black_light_red,;
                        &blue_light_grey, &blue_light_magenta,;
                        &blue_yellow )

  *- note that our CASE statement is similar for all menu calls!

  DO CASE
    CASE exit_code = &EXIT_SELECT
      DO CASE
        CASE result_id = 1
          temp_str = "Open"
        CASE result_id = 2
          temp_str = "Close"
        CASE result_id = 3
          temp_str = "Options"
        CASE result_id = 4
          temp_str = "Go fish"
        CASE result_id = 5
          temp_str = "Help"
      ENDCASE

      Message_Box( "Selection Made:", temp_str, " ~Ok ", -1, -1,;
                   &blue_white, &blue_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &blue_yellow )

    CASE exit_code = &EXIT_ESC
      Message_Box( "ESC Hit", "Selection Aborted", " ~Ok ", -1, -1,;
                   &magenta_white, &magenta_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &magenta_yellow )
    CASE exit_code = &EXIT_ERROR
      Message_Box( "Error", "PopUp Failed to Execute", " ~Ok ", -1, -1,;
                   &red_white, &red_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &red_yellow )
  ENDCASE

  Clear_PopUP()

  CLEAR

  **** NOW Do a Pulldown menu!

  *- draw the screen all pretty like...

  __color_std = &BLACK_LIGHT_GREY
  @1,0  TO 1,79 DOUBLE
  @23,0 TO 23, 79
  FILL( 2, 0, 22, 79, "", "", &BLACK_LIGHT_CYAN, &BLACK_LIGHT_CYAN, 0 )
  Middle( 24, "RESTlib Pulldown Menu Example    --    <ESC> to exit menu", &BLACK_WHITE)
  __color_std = &BLACK_WHITE

  *- build the menus and sub-menus
  Add_Menu( 2, " ~File ", 1 )
    Add_To_Menu( " ~Open ", 1 )
    Add_To_Menu( " ~Close ", 2 )
    Add_Sep_To_Menu()
    Add_To_Menu( " ~Quit ", 3 )
  Add_Menu( 8, " ~Edit ", 2 )
    Add_To_Menu( " ~Cut ", 1 )
    Add_To_Menu( " C~opy ", 2 )
    Add_To_Menu( " ~Paste ", 3 )
  Add_Menu( 14, " ~Utilities ", 3 )
    Add_To_Menu( " ~Memory ", 1 )
    Add_To_Menu( " ~Shell To Dos ", 2 )
    Add_To_Menu( " ~Reindex ", 3 )
    Add_Sep_To_Menu()
    Add_To_Menu( " ~Give Up ", 4 )

  over_id = 1
  down_id = 1
  pulled = .F.

  *- this pulldown menu will start rolled up at OVER = 1
  exit_code = Do_Pulldown( over_id, down_id,;
                           pulled, 0, .F., save_temp, save_temp,;
                           &BLACK_WHITE, &BLACK_LIGHT_CYAN,;
                           &BLUE_WHITE, &BLUE_LIGHT_CYAN,;
                           &BLACK_LIGHT_GREY,;
                           &BLACK_WHITE, &BLACK_LIGHT_CYAN,;
                           &BLUE_WHITE, &BLUE_LIGHT_CYAN,;
                           &BLACK_LIGHT_GREY )

  DO CASE
    CASE exit_code = &EXIT_SELECT
      DO CASE
        CASE over_id = 1
          temp_str = "File | "
          DO CASE
            CASE down_id = 1
              temp_str = temp_str + "Open"
            CASE down_id = 2
              temp_str = temp_str + "Close"
            CASE down_id = 3
              temp_str = temp_str + "Quit"
          ENDCASE

        CASE over_id = 2
          temp_str = "Edit | "
          DO CASE
            CASE down_id = 1
              temp_str = temp_str + "Cut"
            CASE down_id = 2
              temp_str = temp_str + "Copy"
            CASE down_id = 3
              temp_str = temp_str + "Paste"
          ENDCASE

        CASE over_id = 3
          temp_str = "Utilities | "
          DO CASE
            CASE down_id = 1
              temp_str = temp_str + "Memory"
            CASE down_id = 2
              temp_str = temp_str + "Shell To Dos"
            CASE down_id = 3
              temp_str = temp_str + "Reindex"
            CASE down_id = 4
              temp_str = temp_str + "Give Up"
          ENDCASE
      ENDCASE

      Message_Box( "Selection Made:", temp_str, " ~Ok ", -1, -1,;
                   &blue_white, &blue_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &blue_yellow )

    CASE exit_code = &EXIT_ESC
      Message_Box( "ESC Hit", "Selection Aborted", " ~Ok ", -1, -1,;
                   &magenta_white, &magenta_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &magenta_yellow )
    CASE exit_code = &EXIT_ERROR
      Message_Box( "Error", "Pulldown Menu Failed to Execute", " ~Ok ", -1, -1,;
                   &red_white, &red_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &red_yellow )
  ENDCASE

  *- modify the pulldown a little for the next go around

  *- change the title of the third menu to 'Tools'
  Edit_Menu( 3, " ~Tools " )

  *- change the sub-menu item of the 'Tools' menu to 'Pack'
  Edit_Menu_Item( 3, 3, " ~Pack " )

  *- disable a menu item
  Edit_Menu_Stat( 2, 2, &STAT_SKIP )

  *- this pulldown menu will start pulled down and be where the
  *  last one ended.
  pulled = .T.
  exit_code = Do_Pulldown( over_id, down_id,;
                           pulled, 0, .F., save_temp, save_temp,;
                           &BLACK_WHITE, &BLACK_LIGHT_CYAN,;
                           &BLUE_WHITE, &BLUE_LIGHT_CYAN,;
                           &BLACK_LIGHT_GREY,;
                           &BLACK_WHITE, &BLACK_LIGHT_CYAN,;
                           &BLUE_WHITE, &BLUE_LIGHT_CYAN,;
                           &BLACK_LIGHT_GREY )

  DO CASE
    CASE exit_code = &EXIT_SELECT
      DO CASE
        CASE over_id = 1
          temp_str = "File | "
          DO CASE
            CASE down_id = 1
              temp_str = temp_str + "Open"
            CASE down_id = 2
              temp_str = temp_str + "Close"
            CASE down_id = 3
              temp_str = temp_str + "Quit"
          ENDCASE

        CASE over_id = 2
          temp_str = "Edit | "
          DO CASE
            CASE down_id = 1
              temp_str = temp_str + "Cut"
            CASE down_id = 2
              temp_str = temp_str + "Copy"
            CASE down_id = 3
              temp_str = temp_str + "Paste"
          ENDCASE

        CASE over_id = 3
          temp_str = "Tools | "
          DO CASE
            CASE down_id = 1
              temp_str = temp_str + "Memory"
            CASE down_id = 2
              temp_str = temp_str + "Shell To Dos"
            CASE down_id = 3
              temp_str = temp_str + "Pack"
            CASE down_id = 4
              temp_str = temp_str + "Give Up"
          ENDCASE
      ENDCASE

      Message_Box( "Selection Made:", temp_str, " ~Ok ", -1, -1,;
                   &blue_white, &blue_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &blue_yellow )

    CASE exit_code = &EXIT_ESC
      Message_Box( "ESC Hit", "Selection Aborted", " ~Ok ", -1, -1,;
                   &magenta_white, &magenta_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &magenta_yellow )
    CASE exit_code = &EXIT_ERROR
      Message_Box( "Error", "Pulldown Menu Failed to Execute", " ~Ok ", -1, -1,;
                   &red_white, &red_light_cyan,;
                   &black_white, &black_light_cyan,;
                   &red_yellow )
  ENDCASE

  Clear_Pulldown()

  Message_Box( "RESTlib Demo", "Demonstration is now finished.", " ~Exit ",;
               -1, -1,;
               &red_white, &red_light_cyan,;
               &black_white, &black_light_cyan,;
               &red_yellow+128 )

  CLEAR
  ?
  IF is_mouse
    _Mouse_Reset()
    _Mouse_Cursor( .F. )
  ENDIF
ENDPRO
