****
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
****

#DEFINE _INTERNAL_
#INCLUDE WARN.HDR
#INCLUDE restlist.hdr
#INCLUDE restedit.hdr
#INCLUDE restmisc.hdr
#INCLUDE STRING.HDR
#INCLUDE IO.HDR
#INCLUDE KEYS.HDR
#include internal.hdr

FUNCTION DBL round PROTOTYPE
    PARAMETERS CONST DBL number, VALUE INT precision

FUNCTION INT VEdit_Call_Handler PROTOTYPE
  PARAMETERS    UNTYPED    handler,;
    VALUE LONG    list_handle,;
    UINT    list_element,;
    UINT    list_column,;
    UINT    mouse_stat,;
    VALUE UINT    mrow,;
    VALUE UINT    mcol,;
    INT    pick_key,;
    UINT    top_element,;
    VALUE UINT    last_element,;
    UINT    ur,;
    UINT    uc,;
    UINT    lr,;
    UINT    lc,;
    UINT    scroll_col,;
    UINT    stat_row,;
    UINT    stat_col,;
    VALUE LOGICAL disp_only,;
    LOGICAL refresh


** returns a code to inform VEdit_Text_Editor what to do
**
**  0 - error
*   1 - do nothing (quit)
**  2 - save and exit
**  3 - save and continue
**  4 - just continue
**  5 - save as new filename
**  6 - save and rename
**

FUNCTION UINT __Internal_Editor
  PARAMETERS VALUE LONG    handle,;
    VALUE LONG    scrap,;
    VALUE LONG    undelete,;
    VALUE INT     up_row,;
    VALUE INT     up_col,;
    VALUE INT     lo_row,;
    VALUE INT     lo_col,;
    VALUE INT     scroll_col,;
    UINT    top_element,;
    UINT    initial_element,;
    UINT    left_col,;
    UINT    initial_col,;
    UINT    right_margin,;   && max 132
    VALUE UINT    hard_margin,;
    LOGICAL word_wrap,;
    LOGICAL sticky_indent,;
    VALUE LOGICAL disp_only,;
    VALUE LOGICAL flash,;
    VALUE LOGICAL scroll_bar,;
    VALUE LOGICAL stat_line,;
    VALUE UINT    stat_row,;
    VALUE UINT    stat_col,;
    VALUE LOGICAL is_mouse,;
    VALUE LOGICAL allow_embedded,;
    VALUE UINT    tab_stop,;
    VALUE UINT    undelete_lines,;
    UNTYPED    key_proc,;
    VALUE BYTE    hi_status,;
    VALUE BYTE    lo_status

  VARDEF
    UINT  ret_val, upper_row, upper_col, lower_row, lower_col

    UINT  last_element                 && last total element
    UINT  height                       && height of pick window
    UINT  temp_mark

    LOGICAL refresh
    LOGICAL mini_refresh
    LOGICAL list_loop, wrap_loop
    LOGICAL resize

    BYTE   old_std, old_enhcd, o_std

    UINT    scroll_top, scroll_bottom, scroll_row
    LOGICAL scroll_refresh

    UINT    current_x
    UINT    current_y
    UINT    old_y, old_x
    UINT    current_wide
    UINT    current_over

    LOGICAL check_wrap, do_it

    INT     pick_key
    LOGICAL first_timer

    UINT    temp_row
    CHAR    temp_str, full_str, temp_str2
    CHAR( 2 ) add_str

    UINT    mouse_stat
    LOGICAL mouse_search
    UINT    mouse_found
    UINT    mouse_last

    INT     user_proc
    UINT    last_displayed

    UINT    old_element, old_ele

    UINT    mrow, mcol
    LOGICAL mouse_set

    LOGICAL ml, mr
    UINT    temp_number
    LOGICAL check_mem
    UINT    check_count

    INT     temp_int1, temp_int4, temp_int5, temp_int2
    DBL     temp_dbl1, temp_dbl2, temp_dbl3, temp_dbl

    UINT    counter
    LOGICAL inner
    LOGICAL changed
    LOGICAL insert

    UINT    saved_stat
    UINT    saved_scroll
  ENDDEF

  IF ( .NOT. disp_only )
    allow_embedded = .F.
  ENDIF

  upper_row = up_row
  upper_col = up_col
  lower_row = lo_row
  lower_col = lo_col
  IF flash
    scroll_bar   = .F.
    stat_line    = .F.
    disp_only    = .T.
  ENDIF

  insert = insert_key()
  mouse_set = .T.

  old_std   = __color_std
  old_enhcd = __color_enhcd

  IF initial_element = 0
    initial_element = 1
    top_element = 1
  ENDIF

  IF top_element = 0
    top_element = 1
  ENDIF

  *- Check for valid picklist

  IF .NOT. Vlist_Is_Init( handle )
    RETURN &edit_error
  ENDIF

  last_element = Vlist_Max( handle )
  IF last_element = 0
    IF .NOT. Vlist_Add( handle, " " )
      RETURN &edit_error
    ENDIF

    last_element = 1
    top_element  = 1
    initial_col  = 1
    left_col     = 1
  ENDIF

  *- check starting conditions

  height = lower_row - upper_row + 1

  IF top_element > initial_element
    top_element = initial_element
  ENDIF

  IF ( ( initial_element - top_element ) + 1 ) > height
    top_element = initial_element - height + 1
  ENDIF

  current_y = upper_row + ( initial_element - top_element )

  * HEY, if we are using a scroll bar, set up its info
  IF scroll_bar
    scroll_refresh = .T.
    scroll_top     = upper_row + 1
    scroll_row     = 0
    scroll_bottom  = lower_row - 1

    __color_std = __color_bar

    IF __gui_active
      saved_scroll = SAVESCRN( scroll_top-1, scroll_col,;
                               scroll_bottom+1, scroll_col+1 )
    ELSE
      saved_scroll = SAVESCRN( scroll_top-1, scroll_col,;
                                 scroll_bottom+1, scroll_col )
    ENDIF

    FOR temp_int1 = scroll_top TO scroll_bottom
      IF __gui_active
        @temp_int1, scroll_col   SAY ""
      ELSE
        @temp_int1, scroll_col SAY ""
      ENDIF
    NEXT

    __color_std = __color_tab
    IF __gui_active
      @scroll_top-1, scroll_col SAY ""
      @scroll_bottom+1, scroll_col SAY ""
    ELSE
      @scroll_top-1, scroll_col SAY CHR( 24 )
      @scroll_bottom+1, scroll_col SAY CHR( 25 )
    ENDIF

    __color_std = old_std

  ENDIF

  current_x       = upper_col
  current_wide    = lower_col - upper_col + 1

  IF initial_col = 0
    initial_col = 1
  ENDIF

  IF initial_col > hard_margin
    initial_col = hard_margin
  ENDIF

  IF left_col = 0
    left_col = 1
  ENDIF

  IF ( ( initial_col - left_col ) + 1 ) > current_wide
    left_col = initial_col - current_wide + 1
  ENDIF

  IF is_mouse
    ml = _mouse_Left_Button()
    mr = _mouse_Right_Button()
    _mouse_Cursor( .T. )
  ENDIF

  *** start the stupid thing!
  refresh   = .T.                      && start by drawing the screen
  list_loop = .T.
  check_wrap = .F.
  check_mem = .F.
  check_count = 0
  first_timer = .T.

  mouse_search = .F.
  mouse_last   = initial_element

  user_proc = 999

  IF stat_line
    saved_stat = SAVESCRN( stat_row, stat_col, stat_row, stat_col + 41 )
    o_std = __color_std
    __color_std = hi_status
    IF .NOT. disp_only
      @stat_row, stat_col SAY " Line:        Col:                       "
    ELSE
      @stat_row, stat_col SAY " Line:        Col:         DISPLAY ONLY! "
    ENDIF

    __color_std = o_std
  ENDIF

  DO WHILE list_loop

    IF check_mem
      IF _memory_left() < 10000
        list_loop = .F.
        ret_val = &edit_low
        LOOP
      ENDIF
      check_mem = .F.
      check_count = 0
    ENDIF

    IF is_mouse
      _mouse_Cursor( .F. )
    ENDIF

    IF refresh
      last_element = Vlist_Max( handle )
      IF last_element <= height
        top_element = 1
      ENDIF

      IF .NOT. Vlist_Goto( handle, top_element )
        list_loop = .F.
        ret_val   = &edit_error
        LOOP
      ENDIF

      mouse_found = 0

      temp_row  = upper_row

      temp_number = Vlist_Number( handle )
      DO WHILE ( temp_row <= lower_row ) .AND.;
                       ( temp_number <= last_element ) .AND.;
                       ( .NOT. Vlist_Bol( handle ) )

        IF temp_number = initial_element
          current_y    = temp_row
        ENDIF

        IF mouse_search .AND. is_mouse
          IF ( temp_row = mrow ) .AND.;
                     ( ( mcol>= current_x ) .AND.;
                     ( mcol<=( current_x+current_wide-1 ) ) )
            initial_element = temp_number
            current_y       = temp_row
            mouse_found     = initial_element
            initial_col     = mcol - upper_col + 1
          ENDIF

        ELSE
          VList_What_Color( handle, old_std )

          full_str = R_PAD( Vlist_Cstr( handle ), hard_margin )
          temp_str = full_str

          IF left_col > 0
            temp_str = SUBSTR( temp_str, left_col, current_wide )
          ELSE
            temp_str = LEFT( temp_str, current_wide )
          ENDIF

          IF allow_embedded
            Embedded_Say( temp_row, current_x, current_wide, temp_str, .F. )
          ELSE
            @temp_row, current_x SAY temp_str:current_wide
          ENDIF

        ENDIF

        last_displayed = temp_number

        Vlist_Skip( handle, &jl_forward )
        temp_row = temp_row + 1
        temp_number = Vlist_Number( handle )
      ENDDO

      IF .NOT. mouse_search
        IF temp_row <= lower_row
          IF ( temp_row = lower_row) .OR. ( temp_row = lower_row - 1)
            @lower_row, upper_col say replicate(" ",lower_col-upper_col+1 )
            IF temp_row = lower_row - 1
              @lower_row-1, upper_col say replicate(" ",lower_col-upper_col+1 )
            ENDIF
          ELSE
            FILL( temp_row, upper_col, lower_row, lower_col,;
                  "        ", " ", __color_std, __color_std, 0 )
          ENDIF
        ENDIF

      ENDIF


      scroll_refresh = .T.
      refresh = .F.

    ENDIF

    IF flash
      IF is_mouse
        _mouse_cursor(.T.)
      ENDIF
      list_loop = .F.
      LOOP
    ENDIF

    IF Vlist_Number( handle ) <> initial_element
      Vlist_Goto( handle, initial_element )
    ENDIF

    IF scroll_refresh .AND. scroll_bar

      *- length of scroll bar
      temp_int4 = scroll_bottom - scroll_top + 1

      *- percentage
      temp_dbl1 = last_element
      temp_dbl2 = initial_element

      IF initial_element >= last_element
        temp_int5 = scroll_bottom
      ELSE
        IF initial_element = 1
          temp_int5 = scroll_top
        ELSE

          temp_dbl3 = temp_int4
          temp_dbl = ( temp_dbl2 / temp_dbl1 ) * temp_dbl3

          *- now figure row offset
          temp_int5 = ROUND( temp_dbl, 0 )

          IF temp_int5 > temp_int4
            temp_int5 = temp_int4
          ENDIF

          temp_int5 = temp_int5 + scroll_top - 1

          IF temp_int5 < scroll_top
            temp_int5 = scroll_top
          ENDIF

        ENDIF

      ENDIF

      IF scroll_row <> temp_int5

        __color_std = __color_bar
        IF scroll_row <> 0
          IF __gui_active
            @scroll_row, scroll_col   SAY ""
          ELSE
            @scroll_row, scroll_col SAY ""
          ENDIF
        ENDIF

        scroll_row = temp_int5
        __color_std = __color_tab
        IF __gui_active
          @scroll_row, scroll_col SAY ""
        ELSE
          @scroll_row, scroll_col SAY ""
        ENDIF
        __color_std = old_std

      ENDIF

      scroll_refresh = .F.
    ENDIF

    full_str = R_PAD( Vlist_Cstr( handle ), hard_margin )
    temp_str = full_str
    IF left_col > 0
      temp_str = SUBSTR( temp_str, left_col, current_wide )
    ELSE
      temp_str = LEFT( temp_str, current_wide )
    ENDIF

    *- if we are not on a special item then highlight the item
    VList_What_Color( handle, old_std )
    IF __color_std = old_std
      __color_std = old_enhcd
    ELSE
      *- can we at least change the background?
      __color_std = VList_Copy_BackGround( __color_std, old_enhcd )
    ENDIF

    current_over = current_x + ( initial_col - left_col )

    IF ( user_proc <> &jl_ignore ) .AND. ( .NOT. disp_only )
      IF allow_embedded
        Embedded_Say( current_y, current_x, current_wide, temp_str, .T. )
      ELSE
        @current_y, current_x SAY temp_str:current_wide
      ENDIF

    ENDIF

    * turn cursor on to current location...

    IF mouse_search .AND. is_mouse
      mouse_search = .F.
      mouse_last = mouse_found
    ENDIF

    inner = .T.
    changed = .F.

    scroll_refresh = .T.

    DO WHILE inner
      IF stat_line
        CURSOR_OFF()
        o_std = __color_std
        __color_std = hi_status
        @stat_row, stat_col+7 SAY initial_element PICTURE "99999"
        @stat_row, stat_col+19 SAY initial_col PICTURE "999"
        __color_std = lo_status
        insert = insert_key()
        IF .NOT. disp_only
          IF insert
            __color_std = hi_status
            @stat_row, stat_col+23 SAY "INSERT"
            __color_std = lo_status
          ELSE
            @stat_row, stat_col+23 SAY "insert"
          ENDIF

          IF Vlist_Max( scrap ) > 0
            __color_std = hi_status
            @stat_row, stat_col+30 SAY "SCRAP"
            __color_std = lo_status
          ELSE
            @stat_row, stat_col+30 SAY "scrap"
          ENDIF

          IF word_wrap
            __color_std = hi_status
            @stat_row, stat_col+36 SAY "WRAP"
          ELSE
            @stat_row, stat_col+36 SAY "wrap"
          ENDIF

        ENDIF

        __color_std = o_std
      ENDIF

      mouse_stat = &jl_mouse_ignore
      mouse_set  = .F.
      IF is_mouse
        _mouse_Cursor( .T. )
      ENDIF

      current_over = current_x + ( initial_col - left_col )
      @ current_y, current_over
      IF .NOT. disp_only
        CURSOR_ON()
      ENDIF

      IF first_timer .AND. mouse_stat = &jl_mouse_ignore
        mouse_stat = &jl_open
        first_timer = .F.
      ENDIF

      DO WHILE IS_KEY() = 0 .AND. mouse_stat = &jl_mouse_ignore
        IF insert_key() <> insert
          insert = insert_key()
          IF stat_line
            o_std = __color_std
            IF insert .AND. ( .NOT. disp_only )
              __color_std = hi_status
              @stat_row, stat_col+23 SAY "INSERT"
            ELSE
              __color_std = lo_status
              @stat_row, stat_col+23 SAY "insert"
            ENDIF

            __color_std = o_std
          ENDIF

        ENDIF

        IF is_mouse
          IF _mouse_Left_Button() .AND. _mouse_Right_Button()
            mrow = _mouse_Row()
            mcol = _mouse_Col()
            mouse_stat = &jl_mouse_both
          ELSE
            IF ml
              IF .NOT. _mouse_Left_Button()   && find release point
                ml = .F.
                mrow = _mouse_Row()
                mcol = _mouse_Col()
                IF ( mcol = scroll_col .OR.;
                   ( mcol = scroll_col+1 .and. __gui_active ) ) .AND.;
                     scroll_bar
                  DO CASE
                    CASE mrow = scroll_top - 1
                      mouse_stat = &jl_mouse_xup
                      mouse_set = .T.
                    CASE mrow = scroll_bottom + 1
                      mouse_stat = &jl_mouse_xdown
                      mouse_set = .T.
                    CASE mrow >= scroll_top .AND. mrow <= scroll_bottom
                      mouse_stat = &jl_mouse_xscroll
                      mouse_set = .T.
                    OTHERWISE              && other location
                      mouse_stat = &jl_mouse_xleft
                  ENDCASE

                ELSE
                  IF ( mrow >= upper_row ) .AND. ( mrow <= lower_row ) .AND.;
                               ( mcol >= upper_col ) .AND. ( mcol <= lower_col )
                    IF ( mrow = current_y ) .AND.;
                                 ( mcol >= current_x ) .AND.;
                                 ( mcol <= current_x + current_wide - 1 )
                      mouse_stat = &jl_mouse_xselect
                    ELSE
                      mouse_stat = &jl_mouse_xnew
                    ENDIF

                  ELSE
                    mouse_stat = &jl_mouse_xleft
                  ENDIF

                ENDIF

              ENDIF

            ENDIF

            IF _mouse_Left_Button()
              ml = .T.
              mrow = _mouse_Row()
              mcol = _mouse_Col()
              IF ( mcol = scroll_col .OR.;
                 ( mcol= scroll_col + 1 .and. __gui_active ) ) .AND.;
                   scroll_bar
                DO CASE
                  CASE mrow = scroll_top - 1
                    mouse_stat = &jl_mouse_up       && scroll up
                    mouse_set = .T.
                  CASE mrow = scroll_bottom + 1
                    mouse_stat = &jl_mouse_down       && scroll down
                    mouse_set = .T.
                  CASE mrow >= scroll_top .AND. mrow <= scroll_bottom
                    mouse_stat = &jl_mouse_scroll
                    mouse_set = .T.
                  OTHERWISE              && other location
                    mouse_stat = &jl_mouse_left
                ENDCASE

              ELSE
                IF ( mrow >= upper_row ) .AND. ( mrow <= lower_row ) .AND.;
                                 ( mcol >= upper_col ) .AND. ( mcol <= lower_col )
                  IF ( mrow = current_y ) .AND.;
                               ( mcol >= current_x ) .AND.;
                               ( mcol <= current_x + current_wide - 1 )
                    mouse_stat = &jl_mouse_select
                  ELSE
                    mouse_stat = &jl_mouse_new
                  ENDIF

                ELSE
                  mouse_stat = &jl_mouse_left
                ENDIF

              ENDIF

            ENDIF

            IF mr
              IF .NOT. _mouse_Right_Button()
                mr = .F.
                mrow = _mouse_Row()
                mcol = _mouse_Col()
                mouse_stat = &jl_mouse_xright
              ENDIF

            ELSE
              IF _mouse_Right_Button()
                mr = .T.
                mrow = _mouse_Row()
                mcol = _mouse_Col()
                mouse_stat = &jl_mouse_right
              ENDIF

            ENDIF

          ENDIF

        ENDIF

      ENDDO

      IF mouse_stat = &jl_mouse_ignore
        pick_key = GET_KEY()
        mouse_last = 0
      ELSE
        IF mouse_stat = &jl_mouse_scroll .OR. mouse_stat = &jl_mouse_xscroll
          DO CASE
            CASE mrow = scroll_bottom
              pick_key = &k_pg_down
            CASE mrow = scroll_top
              pick_key = &k_pg_up
            CASE mrow > scroll_row
              pick_key = &k_pg_down
            CASE mrow < scroll_row
              pick_key = &k_pg_up
            OTHERWISE
              pick_key = 0
          ENDCASE

        ELSE
          pick_key = 0
        ENDIF

      ENDIF

      IF is_mouse
        _mouse_Cursor( .F. )
      ENDIF

      resize = .F.
      old_element = initial_element

      user_proc = VEdit_Call_Handler( key_proc,;
                     handle, initial_element, initial_col,;
                     mouse_stat, mrow, mcol, pick_key,;
                     top_element, last_displayed,;
                     upper_row, upper_col, lower_row, lower_col,;
                     scroll_col,;
                     stat_row, stat_col,;
                     disp_only, resize )

      old_y = current_y
      old_x = current_x
      mini_refresh = .F.

      IF resize
        IF changed .AND. ( .NOT. disp_only )
          ** comit line
          IF .NOT. Vlist_Cedit( handle, RTRIM( full_str ) )
            inner = .F.
            refresh = .F.
            list_loop = .F.
            ret_val = &edit_error
            LOOP
          ENDIF
        ENDIF

        inner = .F.
        refresh = .F.
        list_loop = .F.
        ret_val = &edit_continue
        LOOP
      ELSE
        IF user_proc = &jl_repaint
          IF ( ( initial_element - top_element ) + 1 ) > height
            top_element = initial_element - height + 1
          ENDIF
          last_element = VList_Max( handle )
          refresh = .T.
          inner = .F.
        ELSE
          Vlist_Goto( handle, old_element )
        ENDIF
      ENDIF

      IF is_mouse
        _mouse_Cursor( .T. )
        IF user_proc = &jl_goto_mouse
          mouse_search = .T.
          refresh = .T.
          inner = .F.

          IF changed .AND. ( .NOT. disp_only )
          ** comit line
            IF .NOT. Vlist_Cedit( handle, RTRIM( full_str ) )
              inner = .F.
              refresh = .F.
              list_loop = .F.
              ret_val = &edit_error
              LOOP
            ENDIF
          ENDIF

          LOOP
        ENDIF
      ENDIF

      IF user_proc = &jl_paint_key
        refresh = .T.
        inner = .F.
        user_proc = &jl_continue
      ENDIF

      DO CASE
        CASE user_proc = &jl_ignore
        CASE user_proc = &jl_repaint
        CASE user_proc = &jl_continue    && evaluate keystroke
          DO CASE

            CASE pick_key = &k_up
              IF initial_element > 1
                IF initial_element = top_element
                  top_element = top_element - 1
                  refresh = .T.
                ELSE
                  current_y = current_y - 1
                ENDIF

                initial_element = initial_element - 1
              ENDIF

              inner = .F.

            CASE pick_key = &k_down
              IF initial_element < last_element
                initial_element = initial_element + 1
                IF initial_element > last_displayed
                  top_element = top_element + 1
                  refresh = .T.
                ELSE
                  current_y = current_y + 1
                ENDIF

              ENDIF

              inner = .F.

            CASE pick_key = &k_left
              IF initial_col > 1
                IF initial_col = left_col
                  left_col = left_col - 1
                  refresh = .T.
                  inner   = .F.
                ENDIF

                initial_col = initial_col - 1
              ENDIF

            CASE pick_key = &k_right
              IF initial_col < hard_margin
                initial_col = initial_col + 1
                IF ( initial_col - left_col + 1 ) >= current_wide
                  left_col = initial_col - current_wide + 1
                  refresh = .T.
                  inner = .F.
                ENDIF

              ENDIF

            CASE ( ( pick_key >= 32 .AND. pick_key <= 255 ) .OR.;
                     ( pick_key = 9 ) ) .AND. ( .NOT. disp_only )

              mini_refresh = .T.
              changed = .T.
              IF pick_key = 9
                temp_int1 = tab_stop
                IF insert
                  pick_key = 32
                ENDIF

              ELSE
                temp_int1 = 1
              ENDIF

              FOR temp_int4 = 1 TO temp_int1
                IF insert
                * insert character here
                  temp_str = LEFT( full_str, initial_col - 1 ) +;
                                   CHR( pick_key )
                  temp_str = temp_str + SUBSTR( full_str, initial_col,;
                                   250 )
                  full_str = temp_str
                ELSE
                  IF pick_key <> 9
                    Change_Byte( initial_col, pick_key, full_str )
                  ENDIF

                ENDIF

                * now move right one
                IF initial_col < hard_margin
                  initial_col = initial_col + 1
                  IF ( initial_col - left_col + 1 ) >= current_wide
                    left_col = initial_col - current_wide + 1
                    refresh = .T.
                    inner   = .F.
                  ENDIF

                ELSE
                  EXIT
                ENDIF

              NEXT

              IF word_wrap
                IF LEN( RTRIM( full_str ) ) >= right_margin
                  check_wrap = .T.
                ENDIF

              ENDIF

            CASE pick_key = &k_enter .AND. (.NOT. disp_only)
                changed = .T.
                IF insert .OR. ( initial_element = last_element )
                  IF ( initial_col > LEN( RTRIM( full_str ) ) ) .OR.;
                     ( .NOT. insert )
                    temp_str = ""
                    temp_int1 = Str_Pre_Space( RTRIM( full_str ) )
                  ELSE
                    temp_str = SUBSTR( full_str, initial_col, hard_margin )
                    full_str = RTRIM( LEFT( full_str, initial_col - 1 ) )

                    temp_int1 = Str_Pre_Space( full_str )
                    IF temp_int1 > 0 .AND. sticky_indent
                      temp_str = SPACE( temp_int1 ) + temp_str
                    ENDIF
                  ENDIF

                  **** full_str = old line to commit
                  **** temp_str = new line to create
                  IF initial_element = last_element
                    IF .NOT. Vlist_Add( handle, RTRIM( temp_str ) )
                      list_loop = .F.
                      inner     = .F.
                      ret_val   = &edit_error
                      LOOP
                    ENDIF

                  ELSE
                    IF .NOT. Vlist_Insert( handle, initial_element + 1,;
                                        &jl_normal, &jl_default,;
                                        RTRIM( temp_str ) )
                      list_loop = .F.
                      inner     = .F.
                      ret_val   = &edit_error
                      LOOP
                    ENDIF

                  ENDIF

                  IF check_count >= 10
                    check_mem = .T.
                  ELSE
                    check_count = check_count + 1
                  ENDIF

                  last_element = Vlist_Max( handle )
                  Vlist_Goto( handle, initial_element )
                  * now move down to the beginning of the new line
                  IF initial_element < last_element
                    initial_element = initial_element + 1
                    IF initial_element > last_displayed
                      top_element = top_element + 1
                    ELSE
                      current_y = current_y + 1
                    ENDIF

                  ENDIF

                  IF sticky_indent
                    IF temp_int1 >= 0
                      initial_col = temp_int1 + 1
                    ELSE
                      temp_int2 = VList_Number( handle )
                      DO WHILE ( .NOT. VList_BOF( handle ) ) .AND.;
                               ( temp_int1 < 0 )
                        temp_str = RTRIM( VList_Cstr( handle ) )
                        temp_int1 = Str_Pre_Space( temp_str )
                        VList_Skip( handle, &SKIP_BACKWARD )
                      ENDDO
                      VList_GOTO( handle, temp_int2 )

                      IF temp_int1 >= 0
                        initial_col = temp_int1 + 1
                      ELSE
                        initial_col = 1
                      ENDIF
                    ENDIF

                    IF initial_col > current_wide
                      left_col = initial_col - current_wide + 1
                    ELSE
                      left_col = 1
                    ENDIF
                  ENDIF

                  inner = .F.
                  refresh = .T.

                ELSE
                  refresh = .F.
                  IF initial_element < last_element
                    initial_element = initial_element + 1
                    IF initial_element > last_displayed
                      top_element = top_element + 1
                      refresh = .T.
                    ELSE
                      current_y = current_y + 1
                    ENDIF

                  ENDIF

                  IF left_col > 1
                    refresh = .T.
                  ENDIF

                  left_col = 1
                  initial_col = 1
                  inner = .F.
                ENDIF

            CASE pick_key = &k_pg_up
              counter = initial_element - top_element

              IF initial_element > height
                initial_element = initial_element - height
                IF initial_element > counter
                  top_element     = initial_element - counter
                ELSE
                  top_element = 1
                ENDIF

              ELSE
                initial_element = 1
                top_element = 1
              ENDIF

              refresh = .T.
              inner = .F.

            CASE pick_key = &k_pg_down
              counter = initial_element - top_element

              IF ( initial_element + height ) <= last_element
                initial_element = initial_element + height
                IF initial_element > counter
                  top_element     = initial_element - counter
                ELSE
                  top_element = 1
                ENDIF

              ELSE
                initial_element = last_element
                IF initial_element <= height
                  top_element = 1
                ELSE
                  top_element = initial_element - height + 1
                ENDIF

              ENDIF

              refresh = .T.
              inner = .F.

            CASE pick_key = &k_home .OR.;
                 pick_key = &k_c_home
              IF left_col > 1
                refresh = .T.
                inner = .F.
              ELSE
                refresh = .F.
              ENDIF

              left_col = 1
              initial_col = 1

            CASE pick_key = &k_end
              initial_col = LEN( RTRIM( full_str ) ) + 1
              IF initial_col = 0
                initial_col = 1
              ENDIF

              IF initial_col > current_wide
                left_col = initial_col - current_wide + 1
              ELSE
                left_col = 1
              ENDIF

              refresh = .T.
              inner   = .F.

            CASE pick_key = &k_c_pg_down
              initial_element = last_element
              IF initial_element > height
                top_element = initial_element - height + 1
              ELSE
                top_element = 1
              ENDIF

              refresh = .T.
              inner   = .F.

            CASE pick_key = &k_c_pg_up
              top_element = 1
              initial_element = 1
              refresh = .T.
              inner = .F.

            CASE pick_key = &k_c_right
              old_ele  = initial_element
              temp_str = RTRIM( full_str )
              do_it    = .T.
              DO WHILE do_it
                IF initial_col >= LEN( temp_str )
                * move to next line
                  IF initial_element = last_element
                  * we are done
                    do_it = .F.
                    LOOP
                  ELSE
                    IF initial_element = top_element + height - 1
                      top_element = top_element + 1
                    ENDIF

                    initial_element = initial_element + 1
                    Vlist_Skip( handle, &jl_forward )
                    temp_str = RTRIM( Vlist_Cstr( handle ) )
                    initial_col = 1
                    left_col = 1
                    * now we are on the next line
                    IF LEN( temp_str ) > 0 .AND. LEFT( temp_str, 1 ) <> " "
                    * we are done.
                      do_it = .F.
                      LOOP
                    ENDIF

                  ENDIF

                ELSE
                * move to next word on this line
                  IF Str_Next_Space( temp_str, initial_col ) <> 0
                    do_it = .F.
                    LOOP
                  ENDIF

                ENDIF

              ENDDO

              Vlist_Goto( handle, old_ele )
              IF initial_element = old_ele
                mini_refresh = .T.
              ELSE
                IF .NOT. Vlist_Cedit( handle, RTRIM( full_str ) )
                  inner = .F.
                  refresh = .F.
                  list_loop = .F.
                  ret_val = &edit_error
                  LOOP
                ENDIF

                changed = .F.
                Vlist_Goto( handle, initial_element )
                refresh = .T.
                inner   = .F.
              ENDIF

            CASE pick_key = &k_c_left
              old_ele  = initial_element
              temp_str = RTRIM( full_str )
              do_it    = .T.
              DO WHILE do_it
                IF initial_col = 1 .OR. LEN( temp_str ) = 0
                * move to previous line
                  IF initial_element = 1
                  * we are done
                    do_it = .F.
                    LOOP
                  ELSE
                    IF initial_element = top_element
                      top_element = top_element - 1
                    ENDIF

                    initial_element = initial_element - 1
                    Vlist_Skip( handle, &jl_backward )
                    temp_str = RTRIM( Vlist_Cstr( handle ) )
                    initial_col = LEN( temp_str ) + 1
                    IF initial_col > current_wide
                      left_col = initial_col - current_wide + 1
                    ELSE
                      left_col = 1
                    ENDIF

                    * now we are on the previous line
                    * we are done.
                    do_it = .F.
                    LOOP
                  ENDIF

                ELSE
                * move to previous word on this line
                  IF Str_Prev_Space( temp_str, initial_col ) <> 0
                    do_it = .F.
                    LOOP
                  ENDIF

                ENDIF

              ENDDO

              Vlist_Goto( handle, old_ele )
              IF initial_element = old_ele
                mini_refresh = .T.
              ELSE
                IF .NOT. Vlist_Cedit( handle, RTRIM( full_str ) )
                  inner = .F.
                  refresh = .F.
                  list_loop = .F.
                  ret_val = &edit_error
                  LOOP
                ENDIF

                changed = .F.
                Vlist_Goto( handle, initial_element )
                refresh = .T.
                inner   = .F.
              ENDIF

            CASE pick_key = &k_esc
              list_loop = .F.
              inner     = .F.
              ret_val   = &edit_none
              LOOP

            CASE pick_key = &k_c_end
              IF word_wrap
                initial_col = right_margin
              ELSE
                initial_col = hard_margin
              ENDIF

              IF initial_col > current_wide
                left_col = initial_col - current_wide + 1
              ELSE
                left_col = 1
              ENDIF

              refresh  = .T.
              inner    = .F.

            CASE pick_key = 32913 && k_c_down
              IF last_displayed < last_element
                top_element = top_element + 1
                initial_element = initial_element + 1
                refresh = .T.
              ENDIF

              inner = .F.

            CASE pick_key = 32909 && k_c_up
              IF top_element > 1
                top_element     = top_element - 1
                initial_element = initial_element - 1
                refresh = .T.
              ENDIF

              inner = .F.

            CASE pick_key = 32851 .AND. (.NOT. disp_only) && del
              changed = .T.
              IF initial_col = hard_margin
              ELSE
                IF initial_col > LEN( RTRIM( full_str ) )
                  IF initial_element < last_element

                    temp_str = full_str
                    Vlist_Skip( handle, &jl_forward )
                    temp_str2 = RTRIM( Vlist_Cstr( handle ) )
                    IF ( initial_col + LEN( temp_str2 ) ) > hard_margin
                      * bring up as many words as will fit (if word
                      * wrap is on) or just what we can
                      IF word_wrap
                        * bring up just the words that will fit!

                        IF LEFT( temp_str2, 1 ) = " "
                          * remove the first white-space character!
                          temp_str2 = SUBSTR( temp_str2, 2, 280 )
                        ELSE
                          * bring up as many words as we can!
                          wrap_loop = .T.
                          temp_int4 = hard_margin - initial_col
                          add_str = ""

                          DO WHILE wrap_loop
                            temp_int5 = AT( " ", temp_str2 )
                            IF temp_int5 = 0
                              wrap_loop = .F.
                            ELSE
                              IF ( ( temp_int5 - 1 ) +;
                                   LEN( add_str ) ) <;
                                  temp_int4
                                temp_str = LEFT( temp_str,;
                                                 ( hard_margin -;
                                                 temp_int4 ) ) +;
                                           add_str +;
                                           LEFT( temp_str2,;
                                                 temp_int5 - 1 )
                                temp_str2 = SUBSTR( temp_str2,;
                                                    temp_int5 + 1,;
                                                    280 )
                                temp_int4 = temp_int4 -;
                                            ( ( temp_int5 - 1 ) +;
                                              LEN( add_str ) )
                              ELSE
                                wrap_loop = .F.
                              ENDIF
                            ENDIF
                            add_str = " "
                          ENDDO

                          temp_str2 = ltrim( temp_str2 )
                        ENDIF

                      ELSE
                        * break the darn line?
                        temp_str = LEFT( temp_str, initial_col ) +;
                                   LEFT( temp_str2,;
                                   hard_margin-initial_col )
                        temp_str2 = SUBSTR( temp_str2,;
                                   hard_margin-initial_col+1,;
                                   hard_margin )
                      ENDIF
                      IF .NOT. Vlist_Cedit( handle, RTRIM( temp_str2 ) )
                        inner = .F.
                        refresh = .F.
                        list_loop = .F.
                        ret_val = &edit_error
                        LOOP
                      ENDIF
                    ELSE
                      * bring the whole next line up!
                      temp_str = LEFT( temp_str, initial_col ) +;
                                 temp_str2
                      IF VList_Max( handle ) = 1
                        VList_Cedit( handle, "  " )
                      ELSE
                        Vlist_cdelete( handle )
                      ENDIF
                    ENDIF

                    Vlist_Goto( handle, initial_element )
                    full_str = temp_str
                    * check word wrap
                    last_element = Vlist_Max( handle )
                    IF word_wrap
                      check_wrap = .T.
                    ENDIF

                    refresh    = .T.
                    changed    = .T.
                    inner      = .F.
                  ENDIF

                ELSE
                * delete a normal character
                  temp_str = LEFT( full_str, initial_col - 1 )
                  temp_str = temp_str + SUBSTR( full_str, initial_col +;
                                                1, 250 )
                  full_str = temp_str
                  mini_refresh = .T.
                ENDIF

              ENDIF

            CASE pick_key = 8 .AND. ( .NOT. disp_only )
              changed = .T.
              IF initial_col = 1
                IF initial_element > 1
                * bring this line up to the end of the previous
                  temp_str2 = RTRIM( full_str )
                  Vlist_Skip( handle, &jl_backward )
                  temp_str  = RTRIM( Vlist_Cstr( handle ) )
                  initial_element = VList_Number( handle )
                  Vlist_Skip( handle, &jl_forward )
                  initial_col = LEN( temp_str ) + 1
                  IF initial_col > current_wide
                    left_col = initial_col - current_wide + 1
                  ELSE
                    left_col = 1
                  ENDIF

                  temp_int1 = LEN( temp_str )
                  IF temp_int1 + LEN( temp_str2 ) > hard_margin
                    IF word_wrap
                        * bring up as many words as we can!
                        wrap_loop = .T.
                        temp_int4 = hard_margin - temp_int1
                        add_str = ""

                        DO WHILE wrap_loop
                          temp_int5 = AT( " ", temp_str2 )
                          IF temp_int5 = 0
                            wrap_loop = .F.
                          ELSE
                            IF ( ( temp_int5 - 1 ) +;
                                 LEN( add_str ) ) <;
                                temp_int4
                              temp_str = LEFT( temp_str,;
                                               ( hard_margin -;
                                               temp_int4 ) ) +;
                                         add_str +;
                                         LEFT( temp_str2,;
                                               temp_int5 - 1 )
                              temp_str2 = SUBSTR( temp_str2,;
                                                  temp_int5 + 1,;
                                                  280 )
                              temp_int4 = temp_int4 -;
                                          ( ( temp_int5 - 1 ) +;
                                            LEN( add_str ) )
                            ELSE
                              wrap_loop = .F.
                            ENDIF
                          ENDIF
                          add_str = " "
                        ENDDO

                        temp_str2 = ltrim( temp_str2 )

                    ELSE
                      temp_str = temp_str +;
                                 LEFT( temp_str2,;
                                 hard_margin-temp_int1 )
                      temp_str2 = SUBSTR( temp_str2,;
                                  hard_margin-temp_int1+1,;
                                  hard_margin )
                    ENDIF
                    IF .NOT. Vlist_Cedit( handle, RTRIM( temp_str2 ) )
                      inner = .F.
                      refresh = .F.
                      list_loop = .F.
                      ret_val = &edit_error
                      LOOP
                    ENDIF
                  ELSE
                    temp_str = temp_str + temp_str2
                    IF Vlist_max( handle ) = 1
                      vlist_cedit( handle, "    " )
                    ELSE
                      Vlist_Cdelete( handle )
                    ENDIF
                  ENDIF

                  VList_Goto( handle, initial_element )
                  IF .NOT. Vlist_Cedit( handle, RTRIM( temp_str ) )
                    inner = .F.
                    refresh = .F.
                    list_loop = .F.
                    ret_val = &edit_error
                    LOOP
                  ENDIF

                  IF initial_element < top_element
                    top_element = initial_element
                  ENDIF

                  full_str = temp_str
                  * check word wrap
                  last_element = Vlist_Max( handle )
                  IF word_wrap
                    check_wrap = .T.
                  ENDIF

                  refresh    = .T.
                  changed    = .F.
                  inner      = .F.
                ENDIF

              ELSE
                IF initial_col = 2
                  temp_str = SUBSTR( full_str, initial_col, 250 )
                ELSE
                  temp_str = LEFT( full_str, initial_col - 2 )
                  temp_str = temp_str + SUBSTR( full_str, initial_col,;
                                                250 )
                ENDIF

                full_str = temp_str
                mini_refresh = .T.
                * now move left one
                IF initial_col > 1
                  IF initial_col = left_col
                    left_col = left_col - 1
                    refresh = .T.
                    inner   = .F.
                  ENDIF

                  initial_col = initial_col - 1
                ENDIF

              ENDIF


          ENDCASE

        CASE user_proc = &jl_delete_line .OR.;
             user_proc = &jl_delete_to_scrap
          IF .NOT. disp_only
            temp_str = full_str
            IF initial_element = 1 .AND. last_element = 1
              IF .NOT. Vlist_Cedit( handle, "" )
                inner = .F.
                refresh = .F.
                list_loop = .F.
                ret_val = &edit_error
                LOOP
              ENDIF
            ELSE
              Vlist_Cdelete( handle )
              last_element = Vlist_Max( handle )
              IF initial_element > last_element
                initial_element = last_element
              ENDIF

              Vlist_Goto( handle, initial_element )
            ENDIF

            refresh = .T.
            inner   = .F.
            changed = .F.

            IF (user_proc = &jl_delete_to_scrap) 
              temp_str = left( temp_str, hard_margin )
              IF .NOT. Vlist_Add( scrap, RTRIM( temp_str ) )
                list_loop = .F.
                inner     = .F.
                ret_val   = &edit_error
                LOOP
              ELSE
                check_mem = .T.
              ENDIF
            ELSE
              IF undelete_lines > 0
                temp_str = left( temp_str, hard_margin )
                IF vlist_max( undelete ) >= undelete_lines
                  vlist_top( undelete )
                  vlist_cdelete( undelete )
                ENDIF
                IF .NOT. VList_Add( undelete, RTRIM( temp_str ) )
                  list_loop = .F.
                  inner     = .F.
                  ret_val   = &edit_error
                  LOOP
                ELSE
                  check_mem = .T.
                ENDIF

              ENDIF
            ENDIF

          ENDIF

        CASE user_proc = &jl_toggle_wrap
          word_wrap = .NOT. word_wrap
        CASE user_proc = &jl_delete_scrap
          IF .NOT. disp_only
            DO WHILE Vlist_Max( scrap ) > 0
              Vlist_Top( scrap )
              Vlist_Cdelete( scrap )
            ENDDO

          ENDIF
 
        CASE user_proc = &jl_copy_bottom_scrap .OR.;
             user_proc = &jl_copy_all_scrap .OR.;
             user_proc = &jl_copy_all_scrap_delete .OR.;
             user_proc = &jl_copy_top_scrap
          IF .NOT. disp_only
            IF Vlist_Max( scrap ) > 0
            * commit current line
              IF .NOT. Vlist_Cedit( handle, RTRIM( full_str ) )
                inner = .F.
                refresh = .F.
                list_loop = .F.
                ret_val = &edit_error
                LOOP
              ENDIF

              changed = .F.
              refresh = .T.
              inner   = .F.
              IF user_proc = &jl_copy_all_scrap .OR.;
                       user_proc = &jl_copy_all_scrap_delete
                Vlist_Bottom( scrap )
                do_it = .T.
                DO WHILE do_it
                  IF .NOT. Vlist_Cinsert( handle, &jl_normal, &jl_default,;
                                       Vlist_Cstr( scrap ) )
                    list_loop = .F.
                    inner     = .F.
                    do_it     = .F.
                    ret_val   = &edit_error
                    LOOP
                  ELSE
                    check_mem = .T.
                  ENDIF

                  IF user_proc = &jl_copy_all_scrap
                    IF Vlist_Number( scrap ) = 1
                      do_it = .F.
                      LOOP
                    ELSE
                      Vlist_Skip( scrap, &jl_backward )
                    ENDIF

                  ELSE
                    Vlist_Cdelete( scrap )
                    IF Vlist_Max( scrap ) = 0
                      do_it = .F.
                      LOOP
                    ELSE
                      Vlist_Bottom( scrap )
                    ENDIF

                  ENDIF

                ENDDO

              ELSE
                IF user_proc = &jl_copy_top_scrap
                  Vlist_Top( scrap )
                ELSE
                  Vlist_Bottom( scrap )
                ENDIF
                temp_str = VList_CStr( scrap )

                IF .NOT. Vlist_Cinsert( handle, &jl_normal, &jl_default,;
                                     temp_str )
                  list_loop = .F.
                  inner     = .F.
                  ret_val   = &edit_error
                  LOOP
                ELSE
                  check_mem = .T.
                ENDIF

                Vlist_Cdelete( scrap )
              ENDIF

              initial_element = Vlist_Number( handle )
              last_element = Vlist_Max( handle )
              IF initial_element > ( top_element + height - 1 )
                top_element = initial_element - height + 1
              ENDIF

            ENDIF

          ENDIF
        CASE user_proc = &jl_undelete_line .and.;
             ( .not. disp_only ) .and.;
             ( undelete_lines > 0 )
            IF vlist_max( undelete ) > 0
              *- commit line
              IF .NOT. Vlist_Cedit( handle, RTRIM( full_str ) )
                inner = .F.
                refresh = .F.
                list_loop = .F.
                ret_val = &edit_error
                LOOP
              ENDIF

              changed = .F.

              Vlist_Bottom( undelete )
              temp_str = VList_Cstr( undelete )
              VList_Cdelete( undelete )

              IF .NOT. Vlist_Cinsert( handle, &jl_normal, &jl_default,;
                                      temp_str )
                list_loop = .F.
                inner     = .F.
                ret_val   = &edit_error
                LOOP
              ELSE
                check_mem = .T.
              ENDIF

              initial_element = Vlist_Number( handle )
              last_element = Vlist_Max( handle )
              IF initial_element > ( top_element + height - 1 )
                top_element = initial_element - height + 1
              ENDIF
              refresh = .T.
              inner = .F.

            ENDIF

        CASE user_proc = &jl_save_continue .OR.;
               user_proc = &jl_save_as_new .OR.;
               user_proc = &jl_save_rename .OR.;
               user_proc = &jl_save_scrap .OR.;
               user_proc = &jl_read_scrap

          IF .NOT. disp_only
          * commit line
            IF .NOT. Vlist_Cedit( handle, RTRIM( full_str ) )
              inner = .F.
              refresh = .F.
              list_loop = .F.
              ret_val = &edit_error
              LOOP
            ENDIF

            list_loop = .F.
            inner     = .F.
            ret_val = user_proc
            LOOP
          ENDIF

        CASE user_proc = &jl_save_exit

          * commit line
          IF .NOT. disp_only
            IF .NOT. Vlist_Cedit( handle, RTRIM( full_str ) )
              inner = .F.
              refresh = .F.
              list_loop = .F.
              ret_val = &edit_error
              LOOP
            ENDIF
          ENDIF

          list_loop = .F.
          inner     = .F.
          IF disp_only
            ret_val = &edit_none
          ELSE
            ret_val = &edit_save_exit
          ENDIF

          LOOP
        CASE user_proc = &jl_abort
          IF .not. disp_only
            IF .NOT. vlist_cedit( handle, RTRIM( full_str ) )
              inner = .F.
              refresh = .F.
              list_loop = .F.
              ret_val = &edit_error
              LOOP
            ENDIF
          ENDIF
          list_loop = .F.
          inner     = .F.
          ret_val   = &edit_none
          LOOP
      ENDCASE

      IF ( .NOT. inner ) .OR. ( check_wrap )
        IF ( changed .AND. ( .NOT. disp_only ) ) .OR. check_wrap
          IF .NOT. Vlist_Cedit( handle, RTRIM( full_str ) )
            inner = .F.
            refresh = .F.
            list_loop = .F.
            ret_val = &edit_error
            LOOP
          ENDIF
        ENDIF

        IF check_wrap
          check_wrap = .F.
          inner = .F.
          old_ele = initial_element
          Do_Word_Wrap( handle, initial_element,;
                           .T., right_margin, hard_margin,;
                           initial_element, initial_col )
          IF initial_element <> old_ele
            left_col = 1
          ENDIF

          IF initial_col > current_wide
            left_col = initial_col - current_wide + 1
          ENDIF

          IF ( initial_element - top_element + 1 ) > height
            top_element = initial_element - height + 1
          ENDIF

          Vlist_Goto( handle, initial_element )
          last_element = Vlist_Max( handle )

          refresh = .T.
        ENDIF

      ELSE
        IF mini_refresh
          temp_str = full_str
          IF left_col > 0
            temp_str = SUBSTR( temp_str, left_col, current_wide )
          ELSE
            temp_str = LEFT( temp_str, current_wide )
          ENDIF

          IF .NOT. disp_only
            IF is_mouse
              _mouse_Cursor( .F. )
            ENDIF

            CURSOR_OFF()

            IF allow_embedded
              Embedded_Say( current_y, current_x, current_wide, temp_str, .F. )
            ELSE
              @current_y, current_x SAY temp_str:current_wide
            ENDIF

            IF is_mouse
              _mouse_Cursor( .T. )
            ENDIF
          ENDIF

          mini_refresh = .F.

        ENDIF

      ENDIF

    ENDDO     && innner loop

    CURSOR_OFF()

    ** leave element
    IF ( .NOT. refresh ) .OR. ( mouse_search )
      Vlist_What_Color( handle, old_std )

      temp_str = full_str
      IF left_col > 0
        temp_str = SUBSTR( temp_str, left_col, current_wide )
      ELSE
        temp_str = LEFT( temp_str, current_wide )
      ENDIF

      IF ( user_proc <> &jl_ignore ) .AND. ( .NOT. disp_only )

        IF is_mouse
          _mouse_Cursor( .F. )
        ENDIF

        IF allow_embedded
          Embedded_Say( old_y, old_x, current_wide, temp_str, .F. )
        ELSE
          @old_y, old_x SAY temp_str:current_wide
        ENDIF

        IF is_mouse
          _mouse_Cursor( .T. )
        ENDIF

      ENDIF

    ENDIF

    IF mouse_set .AND. is_mouse
      mouse_set = .F.
      mouse_last = initial_element
    ENDIF

  ENDDO

  IF ret_val = &edit_none .OR. ret_val = &edit_save_exit .OR.;
     ret_val = &edit_error

    IF ret_val = &edit_error
      mouse_stat = &jl_close_error
    ELSE
      mouse_stat = &jl_close
    ENDIF
    pick_key = 0
    mrow = 0
    mcol = 0

    user_proc = VEdit_Call_Handler( key_proc,;
                   handle, initial_element, initial_col,;
                   mouse_stat, mrow, mcol, pick_key,;
                   top_element, last_displayed,;
                   upper_row, upper_col, lower_row, lower_col,;
                   scroll_col,;
                   stat_row, stat_col,;
                   disp_only, resize )
  ENDIF

  IF is_mouse
    _mouse_Cursor( .F. )
    *    _mouse_restore( _mouse_buffer[] )
  ENDIF

  IF stat_line
    RESTORESCRN( saved_stat )
  ENDIF

  IF scroll_bar
    RESTORESCRN( saved_scroll )
  ENDIF

  __color_std   = old_std
  __color_enhcd = old_enhcd

  RETURN ret_val
ENDPRO

FUNCTION UINT _Internal_Editor
  PARAMETERS VALUE LONG    handle,;
   VALUE LONG scrap,;
   VALUE LONG undelete,;
   VALUE INT  up_row,;
   VALUE INT  up_col,;
   VALUE INT  lo_row,;
   VALUE INT  lo_col,;
   VALUE INT  scroll_col,;
   UINT top_element,;
   UINT initial_element,;
   UINT left_col,;
   UINT initial_col,;
   UINT right_margin,;   && max 132
   VALUE UINT hard_margin,;
   LOGICAL word_wrap,;
   VALUE LOGICAL sticky_indent,;
   VALUE LOGICAL disp_only,;
   VALUE LOGICAL flash,;
   VALUE LOGICAL scroll_bar,;
   VALUE LOGICAL stat_line,;
   VALUE UINT    stat_row,;
   VALUE UINT    stat_col,;
   VALUE LOGICAL is_mouse,;
   VALUE LOGICAL allow_embedded,;
   VALUE UINT tab_stop,;
   VALUE UINT undelete_lines,;
   UNTYPED    key_proc,;
   VALUE BYTE std_color,;
   VALUE BYTE hi_std_color,;
   VALUE BYTE enhcd_color,;
   VALUE BYTE hi_enhcd_color,;
   VALUE BYTE skip_color,;
   VALUE BYTE hit_color,;
   VALUE BYTE bar_color,;
   VALUE BYTE tab_color,;
   VALUE BYTE hi_status,;
   VALUE BYTE lo_status

  VARDEF
    BYTE old_s, old_hs, old_e, old_he, old_skip, old_hit, old_bar, old_tab
    BYTE old_hi_stat, old_lo_stat
    UINT ret_val
  ENDDEF

  __Swap_Std( old_s, old_hs, old_e, old_he, ;
              std_color, hi_std_color, enhcd_color, hi_enhcd_color )
  __Swap_Other( old_skip, old_hit, old_bar, old_tab,;
                skip_color, hit_color, bar_color, tab_color )

  ret_val = __Internal_Editor( handle, scrap, undelete,;
                     up_row, up_col, lo_row, lo_col,;
                     scroll_col, top_element, initial_element,;
                     left_col, initial_col, right_margin, hard_margin,;
                     word_wrap, sticky_indent, disp_only, flash,;
                     scroll_bar, stat_line, stat_row, stat_col,;
                     is_mouse, allow_embedded, tab_stop, undelete_lines,;
                     key_proc, hi_status, lo_status )

  __Set_Std( old_s, old_hs, old_e, old_he )
  __Set_Other( old_skip, old_hit, old_bar, old_tab )

  return ret_val

ENDPRO
