****
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
****

#INCLUDE KEYS.HDR
#INCLUDE RESTLIST.hdr
#INCLUDE RESTMISC.hdr
#INCLUDE RESTEDIT.hdr
#INCLUDE STRING.HDR

FUNCTION INT Default_Edit_Handler
  PARAMETERS VALUE LONG    list_handle,;
                   UINT    list_element,;
                   UINT    list_column,;
                   UINT    mouse_stat,;
             VALUE UINT    mrow,;
             VALUE UINT    mcol,;
                    INT    pick_key,;
                   UINT    top_element,;
             VALUE UINT    last_element,;
                   UINT    ur,;
                   UINT    uc,;
                   UINT    lr,;
                   UINT    lc,;
                   UINT    scroll_col,;
                   UINT    stat_row,;
                   UINT    stat_col,;
             VALUE LOGICAL display_only,;
                   LOGICAL refresh

  VARDEF
    INT  list_return
  ENDDEF

  list_return = &jl_continue

  IF mouse_stat <> &jl_mouse_ignore
    DO CASE
      CASE mouse_stat = &jl_mouse_ignore
      CASE mouse_stat = &jl_mouse_right    && right button pressed
        list_return = &jl_ignore
      CASE mouse_stat = &jl_mouse_xright   && right button released
        list_return = &jl_save_exit

      CASE mouse_stat = &jl_mouse_up       && left button + top scroll-bar tab
        pick_key = &k_up
      CASE mouse_stat = &jl_mouse_xup      && left button release "     "
        list_return = &jl_ignore
      CASE mouse_stat = &jl_mouse_down     && left button + bottom scroll tab
        pick_key = &k_down
      CASE mouse_stat = &jl_mouse_xdown    && left button release "     "
        list_return = &jl_ignore
      CASE mouse_stat = &jl_mouse_xscroll
        list_return = &jl_ignore
      CASE mouse_stat = &jl_mouse_scroll
      *- the values of 'pick_key' are set based upon the position of the
        *  mouse cursor relative to the scroll bar marker.
        *
        DO CASE
          CASE pick_key = &k_pg_down     && mouse below current position
          CASE pick_key = &k_pg_up       && mouse above current position
          CASE pick_key = &k_c_pg_down   && mouse at bottom  on scroll bar
            pick_key = &k_pg_down
          CASE pick_key = &k_c_pg_up     && mouse at top  on scroll bar
            pick_key = &k_pg_up
        ENDCASE

      CASE mouse_stat = &jl_mouse_xnew   && left released + mouse on new
        list_return = &jl_goto_mouse
      CASE mouse_stat = &jl_mouse_new    && left + mouse on new element
        list_return = &jl_ignore

      CASE mouse_stat = &jl_mouse_select  && left + mouse on current element
        list_return = &jl_ignore
      CASE mouse_stat = &jl_mouse_xselect && left released + mouse on current
        list_return = &jl_goto_mouse

      CASE mouse_stat = &jl_mouse_left    && left + mouse outside of pick area
        list_return = &jl_continue
        IF mrow=ur-1
          pick_key = &k_up
        ELSE
          IF mrow=lr+1
            pick_key = &k_down
          ELSE
            list_return = &jl_ignore
          ENDIF

        ENDIF

      CASE mouse_stat = &jl_mouse_xleft   && left released + "         "
        list_return = &jl_ignore

      CASE mouse_stat = &jl_mouse_both    && left & right button hit
        list_return = &jl_ignore
    ENDCASE
  ENDIF

  IF pick_key <> 0
    DO CASE
      CASE pick_key = &k_esc .OR.;
           pick_key = &k_alt_x
        list_return = &jl_save_exit
      CASE pick_key = &k_alt_w   && save
        list_return = &jl_save_continue
      CASE pick_key = &k_alt_s   && save as new filename
        list_return = &jl_save_as_new
      CASE pick_key = &k_alt_n   && save and rename
        list_return = &jl_save_rename
      CASE pick_key = 18         && read scrap ctrl-r
        list_return = &jl_read_scrap
      CASE pick_key = 23         && write scrap ctrl-w
        list_return = &jl_save_scrap
      CASE pick_key = 25 .OR.;   && ctrl-y
                 pick_key = &k_alt_d
        list_return = &jl_delete_line
      CASE pick_key = &k_alt_u
        list_return = &jl_undelete_line
      CASE pick_key = 32842  .OR.;
           pick_key = 32898          && ALT- delete line to scrap
        list_return = &jl_delete_to_scrap

      CASE pick_key = 32846  .OR.;
           pick_key = 32899          && ALT+ insert last line from scrap
        list_return = &jl_copy_bottom_scrap

      CASE pick_key = 32823  .OR.;
           pick_key = 32895          && ALT* insert all of scrap
        list_return = &jl_copy_all_scrap

      CASE pick_key = 32932  .OR.;
           pick_key = 32821  .OR.;
           pick_key = 32818        && ALT/ insert all of scrap and delete scrap
        list_return = &jl_copy_all_scrap_delete

      CASE pick_key = 32931  .OR.;
           pick_key = 32805          && ALT-DEL clear scrap
        list_return = &jl_delete_scrap
      CASE pick_key = &k_alt_t   && ALT-T toggle word wrap
        list_return = &jl_toggle_wrap
      CASE pick_key = &k_down .AND. display_only
        pick_key = 32913   &&  k_c_down
      CASE pick_key = &k_up .AND. display_only
        pick_key = 32909   &&  k_c_up
    ENDCASE
  ENDIF

  **** NOTE!!
  *
  *  If you change any of the following, then set REFRESH=.T.
  *
  *    list_element
  *    list_column
  *    top_element
  *    ur
  *    uc
  *    lr
  *    lc
  *    stat_row
  *    stat_col
  *
  ****

  RETURN list_return
ENDPRO
