****
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
****

#define _internal_
#INCLUDE STRING.HDR
#INCLUDE MEMO.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE IO.HDR
#INCLUDE diff.hdr
#include restedit.hdr
#include restlist.hdr
#include restmisc.hdr
#include restmenu.hdr

#INCLUDE FILEIO.HDR

*******************************************************************************
* return codes                                                                *
*   0 - no errors                                                             *
*   2 - memo doesn't exist                                                    *
*   3 - error reading memo                                                    *
*   4 - error editting memo                                                   *
*   5 - error allocating memory                                               *
*   6 - cannot open memo to save                                              *
*******************************************************************************

FUNCTION UINT Memo_Editor
  PARAMETERS  MEMO      memoname,;
  VALUE INT upper_row,;
  VALUE INT upper_col,;
  VALUE INT lower_row,;
  VALUE INT lower_col,;
  VALUE INT scroll_col,;
  VALUE UINT start_line,;
  VALUE UINT start_col,;
  VALUE UINT right_margin,;
  VALUE UINT hard_margin,;
  VALUE LOGICAL fixed_length,;
  VALUE LOGICAL word_wrap,;
  VALUE LOGICAL sticky_indent,;
  VALUE LOGICAL disp_only,;
  VALUE LOGICAL scroll_bar,;
  VALUE LOGICAL stat_line,;
  VALUE UINT stat_row,;
  VALUE UINT stat_col,;
  VALUE LOGICAL is_mouse,;
  VALUE UINT tab_width,;
  VALUE UINT undelete_lines,;
  UNTYPED key_handler,;
  VALUE BYTE std_color,;
  VALUE BYTE hi_std_color,;
  VALUE BYTE enhcd_color,;
  VALUE BYTE hi_enhcd_color,;
  VALUE BYTE skip_color,;
  VALUE BYTE bar_color,;
  VALUE BYTE tab_color,;
  VALUE BYTE hi_status,;
  VALUE BYTE lo_status,;
  VALUE BYTE prompt_std,;
  VALUE BYTE prompt_enhcd,;
  VALUE BYTE prompt_border

  VARDEF
    LONG    handle,;
            scrap,;
            undelete
    CHAR    temp_str
    CHAR( 128 )  temp_filename
    UINT    ret_val
    UINT    top_element,;
            left_col,;
            temp_loc
    LOGICAL going
    LOGICAL need_wrap
    LOGICAL go_ahead, stop_read
    UINT    dum
    BYTE    old_std
    FILE    input_file
    INT     open_type
    CHAR( 8 )    box_chars
    BYTE         bfill_color, btext_color, text_color, hit_color
    LONG         memleft
    CHAR( 10 )   memstring
  ENDDEF

  hit_color = skip_color

  IF __gui_active
    box_chars = __gui_box
    bfill_color = prompt_border
    btext_color = prompt_std
    text_color = prompt_std
  ELSE
    box_chars = &double_box
    bfill_color = bar_color
    btext_color = tab_color
    text_color  = tab_color
  ENDIF

  need_wrap = .F.
  go_ahead  = .F.
  temp_filename = "MEMOTEMP.TXT" + SPACE( 110 )

  dum = right_margin * 2
  IF dum > 254
    dum = 254
  ENDIF

  IF dum < ( hard_margin + 2 )
    dum = ( hard_margin + 2 )
  ENDIF

  IF fixed_length
    handle = VList_Init( dum )
  ELSE
    handle = Vlist_Var_Init()
  ENDIF

  IF handle = 0
    RETURN 5
  ENDIF

  *- initialize scrap text buffers
  IF fixed_length
    scrap = VList_Init( dum )
  ELSE
    scrap = Vlist_Var_Init()
  ENDIF

  IF scrap = 0
    VList_Clear( handle )
    RETURN 5
  ENDIF

  *- initialize undelete text buffers
  IF fixed_length
    undelete = VList_Init( dum )
  ELSE
    undelete = Vlist_Var_Init()
  ENDIF

  IF undelete = 0
    Vlist_Clear( handle )
    vlist_clear( scrap )
    RETURN 5
  ENDIF

  *- open file
  IF .NOT. M_EXIST( memoname )
  ELSE

    M_OPEN( memoname, &mo_read )

    SAVE_AREA( upper_row, upper_col, upper_row+3, upper_col+14 )
    FILL( upper_row, upper_col, upper_row+3, upper_col+14,;
          box_chars, " ", bfill_color, btext_color, 6 )
    old_std     = __color_std
    __color_std = text_color
    CURSOR_ON()
    @upper_row+1, upper_col+2 SAY "Reading..."

    *- read file
    DO WHILE .NOT. M_EOF( memoname )
      M_GETLN( memoname, temp_str )

      temp_str = LEFT( RTRIM( temp_str ), hard_margin )

      temp_loc = AT( CHR( 9 ), temp_str )
      DO WHILE temp_loc > 0
        temp_str = LEFT( temp_str, temp_loc - 1 ) + SPACE( tab_width ) +;
                   SUBSTR( temp_str, temp_loc + 1, 250 )
        temp_loc = AT( CHR( 9 ), temp_str )
      ENDDO

      IF LEN( temp_str ) > right_margin
        need_wrap = .T.
      ENDIF

      *- pad the string out to the far right margin
*      temp_str = temp_str + SPACE( hard_margin - LEN( temp_str ) )

      *- add one line of text to VLIST
      IF .NOT. Vlist_Add( handle, temp_str )
        __color_std = old_std
        RESTORE_AREA()
        Vlist_Clear( handle )
        Vlist_Clear( scrap )
        vlist_clear( undelete )
        M_CLOSE( memoname )
        RETURN 5
      ENDIF

    ENDDO

    *- close file
    M_CLOSE( memoname )
    __color_std = old_std
    RESTORE_AREA()
  ENDIF

  *- lets check the parameters to make sure they are valid
  IF start_line > Vlist_Max( handle )
    start_line = Vlist_Max( handle )
  ENDIF

  IF start_col = 0
    start_col = 1
  ENDIF

  IF start_col > hard_margin
    start_col = hard_margin
  ENDIF

  IF start_line = 0
    start_line = 1
  ENDIF

  IF right_margin < 10
    right_margin = 10
  ENDIF

  IF right_margin > hard_margin
    right_margin = hard_margin
  ENDIF

  top_element = 0
  left_col    = 0
  going       = .T.

  *- if word wrap on, and at least one line in the file was longer than
  *  the right margin, then word wrap the whole file.
  IF need_wrap
    IF word_wrap
      Do_Word_Wrap( handle, 1, .F., right_margin, hard_margin,;
         dum, dum )
    ENDIF

  ENDIF

  DO WHILE going

    *- call internal editor, NOTE:  this is the same thing the MEMO editor
    *  calls since it just edits text in a VLIST, it does not care where
    *  it came from.

    ret_val = _Internal_Editor( handle, scrap, undelete,;
               upper_row, upper_col,;
               lower_row, lower_col, scroll_col,;
               top_element, start_line, left_col, start_col,;
               right_margin, hard_margin, word_wrap, sticky_indent,;
               disp_only, .F., scroll_bar, stat_line, stat_row, stat_col,;
               is_mouse, .F.,;
               tab_width, undelete_lines,;
               key_handler,;
               std_color, hi_std_color,;
               enhcd_color, hi_enhcd_color, skip_color,;
               hit_color, bar_color, tab_color, hi_status, lo_status )

    *- check our return cases
    DO CASE
      CASE ret_val = &edit_continue && continue with edit, I guess we must
        && have resized or something!
        LOOP
      CASE ret_val = &edit_none     && exit after doing NOTHING
        ret_val = 0
        going = .F.

      CASE ret_val = &edit_low   && LOW ON MEMORY!
        DELAY( 1 )
        DO WHILE INKEY() <> 0
          SOUND( 262, 2 )
          SOUND( 392, 2 )
        ENDDO

        memleft = _memory_left()
        memstring = I_STR( memleft )

        Message_Box( "Warning!  Editor Memory is low (" + memstring + " bytes)",;
                     "You may want to save and exit!", " ~Ok ", -1, -1,;
                     prompt_std, prompt_std,;
                     prompt_enhcd, prompt_enhcd, prompt_border )
        LOOP

      CASE ret_val = &edit_save_scrap .OR.;
             ret_val = &edit_read_scrap
        IF ret_val = &edit_save_scrap .AND. Vlist_Max( scrap ) = 0
          LOOP
        ENDIF
 
        SAVE_AREA( upper_row, upper_col, upper_row+3, upper_col+38 )
        FILL( upper_row, upper_col, upper_row+3, upper_col+38,;
              box_chars, " ", bfill_color, btext_color, 6 )
        old_std = __color_std
        __color_std = text_color
        CURSOR_ON()
        temp_filename = LEFT( ALLTRIM( temp_filename ), 128 )
        temp_filename = temp_filename + SPACE( 128 - LEN( temp_filename ) )
        SAVE_GETS()
        @upper_row+1, upper_col+2 SAY "Enter SCRAP filename:";
                                  GET temp_filename PICTURE "@K@S12"
        READ
        RESTORE_GETS()
        __color_std = old_std
        RESTORE_AREA()
        IF LASTKEY() = 27
          LOOP
        ELSE
          temp_filename = ALLTRIM( temp_filename )
        ENDIF

        SAVE_AREA( upper_row, upper_col, upper_row+3, upper_col+14 )
        FILL( upper_row, upper_col, upper_row+3, upper_col+14,;
              box_chars, " ", bfill_color, btext_color, 6 )
        old_std = __color_std
        __color_std = text_color
        CURSOR_ON()
        IF ret_val = &edit_save_scrap
          @upper_row+1, upper_col+2 SAY "Saving..."
          open_type = &f_create
        ELSE
          @upper_row+1, upper_col+2 SAY "Reading..."
          open_type = &f_read
        ENDIF

        IF .NOT. X_Open( input_file, temp_filename, open_type, &x_text )
          ret_val = 0
          DO WHILE INKEY() <> 0
            SOUND( 262, 2 )
            SOUND( 392, 2 )
          ENDDO

          Message_Box( "Warning!  Error Reading/Saving File",;
                       "Cannot complete this action!", " ~Ok ", -1, -1,;
                       prompt_std, prompt_std,;
                       prompt_enhcd, prompt_enhcd, prompt_border )
          LOOP
        ELSE
          IF ret_val = &edit_save_scrap
            VLIST_Top( scrap )
            DO WHILE .NOT. VLIST_BOL( scrap )
              temp_str = RTRIM( Vlist_Cstr( scrap ) )
              F_PUT( input_file, temp_str + CHR( 13 ) + CHR( 10 ) )
              Vlist_Skip( scrap, &jl_forward )
            ENDDO
 
          ELSE
          * read scrap

            stop_read = .F.
            DO WHILE ( .NOT. F_EOF( input_file ) ) .AND. ;
                     ( .NOT. stop_read )
              IF .NOT. F_GETLN( input_file, temp_str )
                DO WHILE INKEY() <> 0
                  SOUND( 262, 2 )
                  SOUND( 392, 2 )
                ENDDO

                Message_Box( "Warning!  Error Reading File",;
                             "Cannot complete reading file into scrap!", " ~Ok ", -1, -1,;
                             prompt_std, prompt_std,;
                             prompt_enhcd, prompt_enhcd, prompt_border )

                stop_read = .T.
                LOOP
              ENDIF

              temp_str = LEFT( RTRIM( temp_str ), hard_margin )

              temp_loc = AT( CHR( 9 ), temp_str )
              DO WHILE temp_loc > 0
                temp_str = LEFT( temp_str, temp_loc - 1 ) + SPACE( tab_width ) +;
                           SUBSTR( temp_str, temp_loc + 1, 250 )
                temp_loc = AT( CHR( 9 ), temp_str )
              ENDDO

              IF .NOT. Vlist_Add( scrap, temp_str )
                DO WHILE INKEY() <> 0
                  SOUND( 262, 2 )
                  SOUND( 392, 2 )
                ENDDO

                VList_Delete_All( scrap )
                VList_Delete_All( undelete )

                memleft = _memory_left()
                memstring = I_STR( memleft )

                Message_Box( "Warning!  Memory is low (" + memstring + " bytes)",;
                             "Reading file into scrap Aborted!", " ~Ok ", -1, -1,;
                             prompt_std, prompt_std,;
                             prompt_enhcd, prompt_enhcd, prompt_border )

                stop_read = .T.
              ENDIF
 
            ENDDO
 
          ENDIF

          F_CLOSE( input_file )
        ENDIF

        __color_std = old_std
        RESTORE_AREA()

      CASE  ret_val = &edit_save_as_new .OR.;
              ret_val = &edit_save_rename

        SAVE_AREA( upper_row, upper_col, upper_row+3, upper_col+38 )
        FILL( upper_row, upper_col, upper_row+3, upper_col+38,;
              box_chars, " ", bfill_color, btext_color, 6 )
        old_std = __color_std
        __color_std = text_color
        CURSOR_ON()
        temp_filename = LEFT( ALLTRIM( temp_filename ), 128 )
        temp_filename = temp_filename + SPACE( 128 - LEN( temp_filename ) )
        SAVE_GETS()
        @upper_row+1, upper_col+2 SAY "Enter TEXT filename:";
                                  GET temp_filename PICTURE "@K@S12"
        READ
        RESTORE_GETS()
        __color_std = old_std
        RESTORE_AREA()
        IF LASTKEY() = 27
          LOOP
        ENDIF
 
        temp_filename = ALLTRIM( temp_filename )

        SAVE_AREA( upper_row, upper_col, upper_row+3, upper_col+13 )
        FILL( upper_row, upper_col, upper_row+3, upper_col+13,;
              box_chars, " ", bfill_color, btext_color, 6 )
        old_std = __color_std
        __color_std = text_color
        CURSOR_ON()
        @upper_row+1, upper_col+2 SAY "Saving..."

        * save the sucker!

        IF .NOT. X_Open( input_file, temp_filename, &f_create, &x_text )
          ret_val = 0
          DO WHILE INKEY() <> 0
            SOUND( 262, 2 )
            SOUND( 392, 2 )
          ENDDO

          Message_Box( "Warning!  Error Reading/Saving File",;
                       "Cannot complete this action!", " ~Ok ", -1, -1,;
                       prompt_std, prompt_std,;
                       prompt_enhcd, prompt_enhcd, prompt_border )
          LOOP
        ELSE
          VLIST_Top( handle )
          DO WHILE .NOT. VList_BOL( handle )
            temp_str = RTRIM( Vlist_Cstr( handle ) )
            F_PUT( input_file, temp_str + CHR( 13 ) + CHR( 10 ) )
            Vlist_Skip( handle, &jl_forward )
          ENDDO

          F_CLOSE( input_file )
        ENDIF

        __color_std = old_std
        RESTORE_AREA()

      CASE ret_val = &edit_save_exit .OR.;
                   ret_val = &edit_save_continue .OR.;
                   ret_val = &edit_error                && save

        IF ret_val = &edit_save_exit .OR.;
                 ret_val = &edit_error

          * do they really want to exit without saving?
           VList_Delete_All( scrap )
           VList_Delete_All( undelete )

           IF ret_val = &edit_error

             DO WHILE INKEY() <> 0
               SOUND( 262, 2 )
               SOUND( 392, 2 )
             ENDDO
             dum = confirm_box( "ERROR!", "Save text now?", " ~Yes ", " ~No ",;
                                -1, -1, prompt_std, prompt_std,;
                                prompt_enhcd, prompt_enhcd, prompt_border )
           ELSE
             dum = confirm_box( "Exit", "Save text now?", " ~Yes ", " ~No ",;
                                -1, -1, prompt_std, prompt_std,;
                                prompt_enhcd, prompt_enhcd, prompt_border )
           ENDIF

           IF dum = 0
             LOOP
           ELSE
             IF dum = 1
               go_ahead = .T.
             ELSE
               go_ahead = .F.
             ENDIF
           ENDIF

        ELSE
          go_ahead = .T.
        ENDIF

        IF go_ahead
          SAVE_AREA( upper_row, upper_col, upper_row+3, upper_col+13 )
          FILL( upper_row, upper_col, upper_row+3, upper_col+13,;
                box_chars, " ", bfill_color, btext_color, 6 )
          old_std = __color_std
          __color_std = text_color
          CURSOR_ON()
          @upper_row+1, upper_col+2 SAY "Saving..."

          * save the sucker!

          M_OPEN( memoname, &mo_create )
          VLIST_Top( handle )
          DO WHILE .NOT. VList_BOL( handle )
            temp_str = RTRIM( Vlist_Cstr( handle ) )
            M_PUT( memoname, temp_str + CHR( 13 ) + CHR( 10 ) )
            Vlist_Skip( handle, &jl_forward )
          ENDDO

          M_CLOSE( memoname )

          __color_std = old_std
          RESTORE_AREA()
        ENDIF

        IF ret_val = &edit_save_exit
          going = .F.
          ret_val = 0
        ELSE
          IF ret_val = &edit_error
            ret_val = 4
            going = .F.
          ELSE
            going = .T.
          ENDIF

        ENDIF

    ENDCASE

  ENDDO

  *- clean up memory
  Vlist_Clear( handle )
  Vlist_Clear( scrap )
  VList_Clear( undelete )

  RETURN ret_val
ENDPRO
