/***
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
***/


#define UINT unsigned int
#define ULONG unsigned long
#define BYTE unsigned char
#define INT int
#define LONG long
#define CHAR char
#define LOGICAL int
#define NULL (void *) 0

/* structures for RESTlib virtual lists (VLIST) */

/* -------------------------------------------------------------------------
 * BLOCK - a block contains the actual data and pointers to other blocks.
 * ------------------------------------------------------------------------- */
typedef struct
{
  int   my_size;
  void  *next;
  void  *prev;
  char  data_start;
} BLOCK;

/* -------------------------------------------------------------------------
 * LIST_FIELD -  each field has an element in an array appended to the end
 *               of the LIST_HEADER.  These fields specify a type and a
 *               length.
 * ------------------------------------------------------------------------- */
typedef struct
{
  BYTE        field_type;
  BYTE        field_size;
} LIST_FIELD;

/* defines for field_type */
#define FTYPE_UNTYPED   0x00
#define FTYPE_BYTE      0x01
#define FTYPE_LOGICAL   0x02
#define FTYPE_INT       0x03
#define FTYPE_UINT      0x04
#define FTYPE_LONG      0x05
#define FTYPE_ULONG     0x06
#define FTYPE_DBL       0x07
#define FTYPE_DATE      0x08
#define FTYPE_CHAR      0x09

/* sizes for each type */
#define FSIZE_UNTYPED   0x00
#define FSIZE_BYTE      0x01
#define FSIZE_LOGICAL   0x01
#define FSIZE_INT       0x02
#define FSIZE_UINT      0x02
#define FSIZE_LONG      0x04
#define FSIZE_ULONG     0x04
#define FSIZE_DBL       0x08
#define FSIZE_DATE      0x04
#define FSIZE_CHAR      0x00

/* -------------------------------------------------------------------------
 * LIST_HEADER - the control structure for a list.  The pointer returned
 *               as a LONG to the Force user points to one of these
 *               structures.
 * ------------------------------------------------------------------------- */
typedef struct
{
  void         *back_ptr;     /* points back to this same structure */
  int          check;         /* make sure this is a valid list! */
  int          list_type;     /* what type of list is this? */
  UINT         elements;      /* number of elements in list */
  UINT         current;       /* current element number */
  BLOCK        *list_first;   /* first element in list */
  BLOCK        *list_current; /* current element in list */
  BLOCK        *list_last;    /* last element in list */
  int          rec_size;      /* size in bytes of one list element */
  int          num_fields;    /* if this has fields, how many? */
  int          keyed;         /* field that we are keyed on */
  char         field_start;   /* start of fields! */
} LIST_HEADER;

#define CHECK_VALUE    0x2DEA

/* defines for a list_type */
#define  LIST_FIXLEN   0x2F      /* fixed length with color, status, and string */
#define  LIST_VARLEN   0xA3      /* variable length with color, status, and string */
#define  LIST_FIELDS   0xD1      /* fixed length with user defined fields */

/* global variables */
extern int _color_skip,
           _color_hit,
           _color_bar,
           _color_tab,
           _color_hi_std,
           _color_hi_enhcd,
           _color_hi_stat,
           _color_lo_stat,
           _color_enhcd2,
           _color_hi_head_std,
           _color_head_std,
           _color_hi_head_enhcd,
           _color_head_enhcd,
           _color_menu_border,
           _color_hi_menu_std,
           _color_menu_std,
           _color_hi_menu_enhcd,
           _color_menu_enhcd,
           _color_prompt_border,
           _color_prompt_std,
           _color_hi_prompt_std,
           _color_prompt_enhcd,
           _color_hi_prompt_enhcd,
           _gui_active,
           _mouse_active,
           _embed_char,
           _menu_width;

extern int _vlist_error;

extern char _gui_box[ 9 ],
            _gui_bbox[ 9 ],
            _gui_pbox[ 9 ],
            _gui_copy[ 3 ];

extern LIST_HEADER *_prompt_ptr,
                   *_pulldown_ptr,
                   *_popup_ptr,
                   *_help_ptr;

#define use_mine
#ifdef use_mine
  void *_memory_alloc( unsigned int );
  void _memory_free( void * );
#else
  void *malloc( unsigned int );
  void free( void * );
  #define _memory_alloc malloc
  #define _memory_free free
#endif

int  len( char * );

void memcpy( char *dst, char *src, int cnt );

int __verify( LIST_HEADER *handle,
              int         setlist );

LIST_HEADER *vlist_full_init( BYTE list_type,
                              int  num_fields,
                              LIST_FIELD *field_list );

LIST_HEADER *vlist_init( UINT str_len );

LIST_HEADER *vlist_var_init();

int vlist_rec_append( LIST_HEADER *handle );

int vlist_append( LIST_HEADER *handle,
                  UINT        status,
                  int         color,
                  char        *tstr );

int vlist_add( LIST_HEADER *handle,
               char        *tstr );

UINT vlist_max( LIST_HEADER *handle );

int vlist_bottom( LIST_HEADER *handle );

int vlist_top( LIST_HEADER *handle );

UINT vlist_number( LIST_HEADER *handle );

int _vlist_skip( LIST_HEADER *handle,
                 UINT        which_way );

int vlist_skip( LIST_HEADER *handle,
                UINT        which_way );

UINT vlist_n_skip( LIST_HEADER *handle,
                   UINT        which_way,
                   UINT        how_many );

int vlist_tol( LIST_HEADER *handle );

int vlist_bof( LIST_HEADER *handle );

int vlist_bol( LIST_HEADER *handle );

int vlist_eof( LIST_HEADER *handle );

int vlist_goto( LIST_HEADER *handle,
                int         where );

void vlist_str( char *return_buf, LIST_HEADER *handle, int where );

void vlist_cstr( char *return_buf, LIST_HEADER *handle );

void _vlist_cset_status( LIST_HEADER *handle,
                         UINT        new_status );

void _vlist_cset_color( LIST_HEADER *handle,
                        INT         new_color );

int vlist_set_status( LIST_HEADER *handle,
                      UINT        where,
                      UINT        new_status );

int vlist_set_color( LIST_HEADER *handle,
                     UINT        where,
                     UINT        new_color );

int vlist_cset_color( LIST_HEADER *handle,
                      UINT        new_color );

int vlist_cset_status( LIST_HEADER *handle,
                       UINT        new_status );

UINT _vlist_cget_status( LIST_HEADER *handle );

int _vlist_cget_color( LIST_HEADER *handle );

UINT vlist_get_status( LIST_HEADER *handle,
                       UINT        where );

int vlist_get_color( LIST_HEADER *handle,
                     UINT        where );

int vlist_cget_color( LIST_HEADER *handle );

UINT vlist_cget_status( LIST_HEADER *handle );

int vlist_is_init( LIST_HEADER *handle );

UINT vlist_get_strlen( LIST_HEADER *handle );

UINT vlist_get_reclen( LIST_HEADER *handle );

int _vlist_cdelete( LIST_HEADER *handle );

int vlist_delete( LIST_HEADER *handle,
                  UINT        where  );

int vlist_cdelete( LIST_HEADER *handle );

int vlist_rec_insert( LIST_HEADER *handle );

int vlist_cinsert( LIST_HEADER *handle,
                   UINT        new_status,
                   int         new_color,
                   char        *new_str );

int vlist_insert( LIST_HEADER *handle,
                  UINT        where,
                  UINT        new_status,
                  int         new_color,
                  char        *new_str );

int vlist_cedit( LIST_HEADER *handle, char *new_str );

int vlist_edit( LIST_HEADER *handle, int where, char *new_str );

int vlist_creplace( LIST_HEADER *handle,
                           UINT new_status,
                            int new_color,
                           char *new_str );

int vlist_replace( LIST_HEADER *handle, int where,
                   UINT new_status, int new_color, char *new_str );

int vlist_creplace( LIST_HEADER *handle, UINT new_status, int new_color,
                 char *new_str );

int vlist_rec_edit( LIST_HEADER *handle,
                    UINT        field_number,
                    void        *replace_data );

int vlist_rec_grab( LIST_HEADER *handle,
                    UINT        field_number,
                    void        *replace_data );

void vlist_clear( LIST_HEADER *handle );

int vlist_type( LIST_HEADER *handle );

UINT vlist_num_fields( LIST_HEADER *handle );

#define BAD_HANDLE  -1
#define NO_MEMORY   -2
#define BAD_TYPE    -3
#define EMPTY_LIST  -4
#define BAD_DIRECTION -5
#define BAD_ELEMENT   -6
#define BAD_FIELD     -7
#define SUCCESS      0
#define TRUE         1
#define FALSE        0

#define stat_normal         1
#define stat_skip           2
#define stat_hit            3
#define stat_hide           4
#define color_default      -1
#define color_error        -3
#define skip_forward        1
#define skip_backward       0
#define jl_normal           1
#define jl_skip             2
#define jl_hit              3
#define jl_hide             4
#define jl_default         -1
#define jl_error           -3
#define jl_forward          1
#define jl_backward         0
