/***
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
***/

#include "vlist.h"

int vlist_copy_background( int std_color, int enhcd_color )
{
  int ret_val;

  std_color = std_color & 0x0F;
  enhcd_color = enhcd_color & 0xF0;

  ret_val = std_color | enhcd_color;

  return ret_val;
}

LIST_HEADER *vlist_init( UINT str_len )
{
  return ( vlist_full_init( LIST_FIXLEN, str_len, NULL ) );
}

LIST_HEADER *vlist_var_init()
{
  return ( vlist_full_init( LIST_VARLEN, 0, NULL ) );
}

LIST_HEADER *vlist_full_init( BYTE list_type,
                              int  num_fields,
                              LIST_FIELD *field_list )
{
  LIST_HEADER *temp_ptr;
  UINT        block_size;
  LIST_FIELD  *dest_list;
  UINT        rec_size;
  int         i;

  switch ( list_type )
  {
    case LIST_FIXLEN:
      rec_size = 5 + num_fields;
      num_fields = 0;
      break;

    case LIST_VARLEN:
      num_fields = 0;
      rec_size = 5;
      break;

    case LIST_FIELDS:
      rec_size = 0;
      for ( i = 0; i < num_fields; i++ )
      {
        switch( field_list[ i ].field_type )
        {
          case FTYPE_UNTYPED:
            rec_size += field_list[ i ].field_size + 1;
            if ( field_list[ i ].field_size == 0 ||
                 field_list[ i ].field_size > 254 )
              return NULL;
            break;

          case FTYPE_BYTE:
            rec_size += FSIZE_BYTE;
            break;

          case FTYPE_LOGICAL:
            rec_size += FSIZE_LOGICAL;
            break;

          case FTYPE_INT:
          case FTYPE_UINT:
            rec_size += FSIZE_INT;
            break;

          case FTYPE_LONG:
          case FTYPE_ULONG:
            rec_size += FSIZE_LONG;
            break;

          case FTYPE_DBL:
            rec_size += FSIZE_DBL;
            break;

          case FTYPE_DATE:
            rec_size += FSIZE_DATE;
            break;

          case FTYPE_CHAR:
            rec_size += field_list[ i ].field_size + 1;
            if ( field_list[ i ].field_size == 0 ||
                 field_list[ i ].field_size > 254 )
              return NULL;
            break;

          default:
            return NULL;
        }
      }

      break;

    default:
      return NULL;
  }

  if ( rec_size > 64000 )
    return NULL;

  block_size = sizeof( LIST_HEADER ) +
               ( num_fields * sizeof( LIST_FIELD ) );

  if ( block_size > 64000 )
    return NULL;

  temp_ptr = (LIST_HEADER *) _memory_alloc( block_size );

  if ( temp_ptr )
  {
    temp_ptr->back_ptr   = temp_ptr;
    temp_ptr->check      = CHECK_VALUE;
    temp_ptr->list_type  = list_type;
    temp_ptr->elements   = 0;
    temp_ptr->current    = 0;
    temp_ptr->list_first = NULL;
    temp_ptr->list_current = NULL;
    temp_ptr->list_last  = NULL;
    temp_ptr->num_fields = num_fields;
    temp_ptr->rec_size   = rec_size;

    if ( num_fields )
    {
      dest_list = (LIST_FIELD *) ( &temp_ptr->field_start );
      memcpy( (void *) dest_list, (void *) field_list,
              ( num_fields * sizeof( LIST_FIELD ) ) );
    }
  }

  return temp_ptr;
}


