/***
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
***/

#include "vlist.h"


int _vlist_skip( LIST_HEADER *handle,
                 UINT        which_way )
{
  if ( which_way == skip_forward )
  {
    if ( handle->current == 0 )
    {
      handle->current = 1;
      handle->list_current = handle->list_first;
    }
    else
      if ( handle->current < handle->elements )
      {
        handle->current++;
        handle->list_current = handle->list_current->next;
      }
      else
      {
        handle->current = handle->elements + 1;
        handle->list_current = NULL;
      }
  }
  else
  {
      if ( handle->current > handle->elements )
      {
        handle->current = handle->elements;
        handle->list_current = handle->list_last;
      }
      else
        if ( handle->current > 0 )
        {
          handle->current--;
          handle->list_current = handle->list_current->prev;
        }
        else
        {
          handle->current = 0;
          handle->list_current = NULL;
        }
  }

}

int vlist_skip( LIST_HEADER *handle,
                UINT        which_way )
{

  if ( !__verify( handle, 0 ) )
    return FALSE;

  if ( !handle->elements )
  {
    _vlist_error = EMPTY_LIST;
    return FALSE;
  }

  if ( which_way == skip_forward )
  {
    if ( handle->current <= handle->elements )
      _vlist_skip( handle, which_way );
    else
      return FALSE;
  }
  else
    if ( which_way == skip_backward )
    {
      if ( handle->current > 0 )
        _vlist_skip( handle, which_way );
      else
        return FALSE;
    }
    else
    {
      _vlist_error = BAD_DIRECTION;
      return FALSE;
    }

  return TRUE;
}
