****
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
****

#include internal.hdr
#include string.hdr
#include math.hdr
#include io.hdr
#include system.hdr
#INCLUDE restlist.hdr
#include restmisc.hdr
#include restmenu.hdr

PROCEDURE Message_Box
  PARAMETERS CONST CHAR line1,;
             CONST CHAR line2,;
             CONST CHAR button,;
             VALUE INT  row,;
             VALUE INT  col,;
             VALUE BYTE std_color,;
             VALUE BYTE hi_std_color,;
             VALUE BYTE enhcd_color,;
             VALUE BYTE hi_enhcd_color,;
             VALUE BYTE border_color

  VARDEF
    INT  lrow, lcol
    INT  max_row, old_hi_cs, old_cs
    INT  maxwide
    INT  ur, uc, lr, lc
    UINT first
    LONG saved_prompt
    CHAR( 8 ) box_char
  ENDDEF

  old_cs = __color_std
  __color_std = std_color

  maxwide = __EMBED_LEN( line1 )
  IF __EMBED_LEN( line2 ) > maxwide
    maxwide = __EMBED_LEN( line2 )
  ENDIF

  IF __EMBED_LEN( button ) > maxwide
    maxwide = __EMBED_LEN( button )
  ENDIF

  max_row = 0
  IF __EMBED_LEN( line1 ) > 0
    max_row = max_row + 1
  ENDIF

  IF __EMBED_LEN( line2 ) > 0
    max_row = max_row + 1
  ENDIF

  IF max_row = 2
    max_row = 7
  ELSE
    IF max_row = 1
      max_row = 5
    ELSE
      max_row = 3
    ENDIF
  ENDIF

  maxwide = maxwide + 4

  IF row = -1
    row = ( 12 - TRUNC( max_row / 2 ) )
  ELSE
    DO WHILE (  row + max_row ) > 24 .AND. row > 1
      row = row - 1
    ENDDO
  ENDIF

  IF col = -1
    col = ( 40 - TRUNC( maxwide / 2 ) )
  ELSE
    DO WHILE ( col + maxwide ) > 79 .AND. col > 1
      col = col - 1
    ENDDO
  ENDIF

  IF row < 1
    row = 1
  ENDIF

  IF col < 1
    col = 1
  ENDIF

  saved_prompt = Save_Prompts()

  ur = row - 1
  uc = col - 1
  lr = row + max_row + 1
  lc = col + maxwide + 1

  SAVE_AREA( ur, uc, lr, lc )

  IF __gui_active
    box_char = __gui_box
  ELSE
    box_char = &double_box
  ENDIF

  FILL( ur, uc, lr, lc, box_char, " ", border_color, std_color, 6 )

  row = ur + 2
  IF ( __EMBED_LEN( line1 ) > 0 )
    col = uc + TRUNC( ( lc - uc ) / 2 ) - TRUNC( __EMBED_LEN( line1 ) / 2 )
    old_hi_cs = __color_hi_std
    __color_hi_std = hi_std_color
    Embedded_Say( row, col, __EMBED_LEN( line1 ), line1, .F. )
    __color_hi_std = old_hi_cs
    row = row + 2
  ENDIF

  IF ( __EMBED_LEN( line2 ) > 0 )
    col = uc + TRUNC( ( lc - uc ) / 2 ) - TRUNC( __EMBED_LEN( line2 ) / 2 )
    old_hi_cs = __color_hi_std
    __color_hi_std = hi_std_color
    Embedded_Say( row, col, __EMBED_LEN( line2 ), line2, .F. )
    __color_hi_std = old_hi_cs
    row = row + 2
  ENDIF

  col = uc + TRUNC( ( lc - uc ) / 2 ) - TRUNC( __EMBED_LEN( button ) / 2 )
  At_Prompt( row, col, button )

  first = 1
  Menu_To( first, std_color, hi_std_color, enhcd_color, hi_enhcd_color, std_color )

  RESTORE_AREA()

  Restore_Prompts( saved_prompt )

  __color_std = old_cs


ENDPRO
