/***
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
***/

#include "vlist.h"


int vlist_goto( LIST_HEADER *handle,
                int         where )
{
  int  bdelta, edelta, cdelta;
  int  which_way;
  UINT how_many;

  if ( !__verify( handle, 0 ) )
    return FALSE;

  if ( !handle->elements )
  {
    _vlist_error = EMPTY_LIST;
    return FALSE;
  }

  if ( where == handle->current )
    return TRUE;

  if ( where <= 1 )
  {
    vlist_top( handle );
    if ( where < 1 )
      vlist_skip( handle, skip_backward );

    return TRUE;
  }
  else
    if ( where >= handle->elements )
    {
      vlist_bottom( handle );
      if ( where > handle->elements )
        vlist_skip( handle, skip_forward );

      return TRUE;
    }

  bdelta = where - 1;
  edelta = handle->elements - where;
  if ( handle->current > where )
    cdelta = handle->current - where;
  else
    cdelta = where - handle->current;

  which_way = -1;      /* from current */

  if ( edelta < bdelta )
    if ( edelta < cdelta )
    {
      which_way = skip_backward;  /* from end */
      how_many = edelta;
      vlist_bottom( handle );
    }
  else
    if ( bdelta < cdelta )
    {
      which_way = skip_forward;  /* from beginning */
      how_many = bdelta;
      vlist_top( handle );
    }

  if ( which_way == -1 )
  {
    if ( where > handle->current )
      which_way = skip_forward;
    else
      which_way = skip_backward;

    how_many = cdelta;
  }

  if ( which_way == skip_forward )
  {
    while ( how_many-- )
      _vlist_skip( handle, which_way );
  }
  else
    if ( which_way == skip_backward )
    {
       while ( how_many-- )
         _vlist_skip( handle, which_way );
    }

  if ( handle->current == where )
    return TRUE;

  return FALSE;
}
