/***
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
***/

#include "vlist.h"

void vlist_rec_sort_char( LIST_HEADER *handle, UINT, UINT, UINT );
void vlist_rec_sort_byte( LIST_HEADER *handle, UINT, UINT, UINT );
void vlist_rec_sort_logical( LIST_HEADER *handle, UINT, UINT, UINT );
void vlist_rec_sort_int( LIST_HEADER *handle, UINT, UINT, UINT );
void vlist_rec_sort_uint( LIST_HEADER *handle, UINT, UINT, UINT );
void vlist_rec_sort_long( LIST_HEADER *handle, UINT, UINT, UINT );
void vlist_rec_sort_ulong( LIST_HEADER *handle, UINT, UINT, UINT );
void vlist_rec_sort_dbl( LIST_HEADER *handle, UINT, UINT, UINT );
void vlist_rec_sort_date( LIST_HEADER *handle, UINT, UINT, UINT );

void vlist_rec_sortstart( LIST_HEADER *handle,
                          UINT field_num,
                          UINT low,
                          UINT high )
{
  LIST_FIELD *field_list ;

  if ( handle->list_type != LIST_FIELDS )
    return ;

  if ( handle->num_fields < field_num )
    return ;

  field_list = (LIST_FIELD *) ( &handle->field_start );

  switch( field_list[ field_num ].field_type )
  {
    case FTYPE_UNTYPED:
    case FTYPE_CHAR:
      vlist_rec_sort_char( handle, field_num, low, high );
      break;

    case FTYPE_BYTE:
      vlist_rec_sort_byte( handle, field_num, low, high );
      break;

    case FTYPE_LOGICAL:
      vlist_rec_sort_logical( handle, field_num, low, high );
      break;

    case FTYPE_INT:
      vlist_rec_sort_int( handle, field_num, low, high );
      break;

    case FTYPE_UINT:
      vlist_rec_sort_uint( handle, field_num, low, high );
      break;

    case FTYPE_LONG:
      vlist_rec_sort_long( handle, field_num, low, high );
      break;

    case FTYPE_ULONG:
      vlist_rec_sort_ulong( handle, field_num, low, high );
      break;

    case FTYPE_DBL:
      vlist_rec_sort_dbl( handle, field_num, low, high );
      break;

    case FTYPE_DATE:
      vlist_rec_sort_date( handle, field_num, low, high );
      break;

    default:
      return ;
  }

}

