/***
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
***/

#include "vlist.h"

int vlist_rec_copy( LIST_HEADER *handle,
                    UINT         src_rec,
                    UINT         dst_rec )
{
  void  *temp_buf, *src;
  BLOCK *current;


  if ( !__verify( handle, 0 ) )
    return FALSE;

  if ( handle->list_type != LIST_FIELDS )
  {
    _vlist_error = BAD_TYPE;
    return FALSE;
  }

  if ( !handle->elements ||
        handle->current < 1 ||
        handle->current > handle->elements )
  {
    _vlist_error = BAD_ELEMENT;
    return FALSE;
  }

  if ( vlist_goto( handle, src_rec ) )
  {

    temp_buf = (void *) _memory_alloc( handle->rec_size + 1 );

    if ( temp_buf == NULL )
    {
      _vlist_error = NO_MEMORY;
      return FALSE;
    }

    current = handle->list_current ;
    src = (void *) &current->data_start;
    memcpy( temp_buf, src, handle->rec_size );

    if ( vlist_goto( handle, dst_rec ) )
    {
      current = handle->list_current ;
      src = (void *) &current->data_start;
      memcpy( src, temp_buf, handle->rec_size );
    }
    else
    {
      _memory_free( temp_buf );
      _vlist_error = BAD_ELEMENT ;
      return FALSE;
    }

    _memory_free( temp_buf );
  }
  else
  {
    _vlist_error = BAD_ELEMENT;
    return FALSE ;
  }

  return TRUE;
}

