;***
;*** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
;***
;*** ---- --- These comments may not be removed! --- ----
;***
;*** original RESTlib (c) 1993-95 Jayson R. Minard
;***                          CIS 72124,2343
;***                         iNET jayson@jerm.com
;***
;***
;*** This code may be used for any purpose as long as credit for the
;*** originating code is given back to Jayson Minard within the resulting
;*** product or its documentation.
;***

;
; This file is a FORCE internal include file given by SOPHCO Inc.
; for use within VList (now RESTlib)
;

                extrn   __color_std:byte

include jaylib.inc
include vlist.inc

$s_function_seg	segment	public
		assume	cs:$s_function_seg


;------------------------------------------------------------------------------
;
;   procedure:	SCROLL( row, col, row1, col1, up )
; description:	scroll the screen up or down line.  Actually all this 
;		function does is load the registers based on the BIOS
;		INT 10 function 6 and 7.  
;		
;       entry:	[bp+6] = row
;		[bp+8] = col
;		[bp+10] = row
;		[bp+12] = row1
;		[bp+14] = up
;
;        exit:	???
;
;
;------------------------------------------------------------------------------
stk_row		equ	6
stk_col		equ	8
stk_row1	equ	10
stk_col1	equ	12
stk_up		equ	14

		public	_scroll_
_scroll_	proc	far

		push	bp
		mov	bp,sp		;set up our standard stack frame.
		push	ds

	;---get the standard attribute into BH

		mov	ax,seg __color_std
		mov	ds,ax
		mov	bh,ds:__color_std

	;---CH,CL is the uppper left coordinates of the position to scroll

		mov	ch,[bp].stk_row
		mov	cl,[bp].stk_col
	
	;---DH,DL is the lower right

		mov	dh,[bp].stk_row1
		mov	dl,[bp].stk_col1

	;---if up is TRUE, then we want to scroll up else scroll down

		mov	ax,601h		;assume scroll up
		cmp	word ptr [bp].stk_up,1
		 je	is_up
		mov	ax,701h

	;---scroll the screen

is_up:		int	10h


		pop	ds
		pop	bp
		ret
_scroll_	endp

$s_function_seg	ends
end
