****
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
****

#include restmisc.hdr
#include restlist.hdr

#include string.hdr
#include io.hdr
#include fileio.hdr
#include system.hdr
#include diff.hdr

***- Text based INI FILE routines!

FUNCTION LONG Get_INI_Number
  PARAMETERS LONG section_list,;
             LONG value_list,;
             CONST CHAR find_what,;
             VALUE LONG default_value

  VARDEF
    LONG ret_val
    INT  item
    CHAR temp_str
  ENDDEF

  IF VList_Locate( section_list, UPPER( find_what ), .T., .F. )
    item = VList_Number( section_list )
    VList_GOTO( value_list, item )
    temp_str = UPPER( VList_Cstr( value_list ) )
    ret_val = VAL( temp_str )
  ELSE
    ret_val = default_value
  ENDIF

  RETURN ret_val
ENDPRO

FUNCTION CHAR Get_INI_String
  PARAMETERS LONG section_list,;
             LONG value_list,;
             CONST CHAR find_what,;
             CONST CHAR default_value

  VARDEF
    CHAR temp_str
    INT  item
  ENDDEF

  IF VList_Locate( section_list, UPPER( find_what ), .T., .F. )
    item = VList_Number( section_list )
    VList_GOTO( value_list, item )
    temp_str = VList_Cstr( value_list )
  ELSE
    temp_str = default_value
  ENDIF

  RETURN temp_str
ENDPRO

FUNCTION LOGICAL Get_INI_Boolean
  PARAMETERS LONG section_list,;
             LONG value_list,;
             CONST CHAR find_what,;
             VALUE LOGICAL default_value

  VARDEF
    LOGICAL   ret_val
    CHAR      temp_str
    INT       item
  ENDDEF

  IF VList_Locate( section_list, UPPER( find_what ), .T., .F. )
    item = VList_Number( section_list )
    VList_GOTO( value_list, item )
    temp_str = UPPER( VList_Cstr( value_list ) )
    IF temp_str = "1" .OR. temp_str = "YES" .OR. temp_str = "T" .OR.;
       temp_str = ".T." .OR. temp_str = "TRUE"
      ret_val = .T.
    ELSE
      ret_val = .F.
    ENDIF

  ELSE
    ret_val = default_value
  ENDIF

  RETURN ret_val
ENDPRO

FUNCTION LOGICAL Read_INI_File
  PARAMETERS LONG section_list,;
             LONG value_list,;
             CONST CHAR( 128 ) ini_filename,;
             VALUE LONG which_sections

  VARDEF
    FILE ini_file
    CHAR temp_str, last_section, left_str, right_str
    INT  loaded_count, equal_pos
    LOGICAL load_this
  ENDDEF

  IF VList_Is_Init( section_list )
    VList_Clear( section_list )
  ENDIF

  IF VList_Is_Init( value_list )
    VList_Clear( value_list )
  ENDIF

  IF which_sections <> 0
    IF .NOT. VList_Is_Init( which_sections )
      RETURN .F.
    ENDIF
  ENDIF


  last_section = ""
  loaded_count = 0
  load_this = .F.

  IF .NOT. EXIST( ini_filename )
    RETURN .F.
  ELSE
    IF X_OPEN( ini_file, ini_filename, &F_READ, &X_TEXT )

      section_list = VList_Init( 200 )
      IF section_list = 0
        F_CLOSE( ini_file )
        RETURN .F.
      ENDIF

      value_list = VList_Init( 200 )
      IF value_list = 0
        F_CLOSE( ini_file )
        VList_Clear( section_list )
        RETURN .F.
      ENDIF

      DO WHILE .NOT. F_EOF( ini_file )
        IF .NOT. F_GETLN( ini_file, temp_str )
          Vlist_Clear( section_list )
          Vlist_Clear( value_list )
          F_CLOSE( ini_file )
          RETURN .F.
        ENDIF

        temp_str = ALLTrim( temp_str )
        IF LEN( temp_str ) > 0 .AND. LEFT( temp_str, 1 ) <> ";"
          IF LEFT( temp_str, 1 ) = "[" .AND. RIGHT( temp_str, 1 ) = "]"
            last_section = SUBSTR( temp_str, 2, 254 )
            last_section = UPPER( ALLTRIM( LEFT( last_section, LEN( last_section ) - 1 ) ) )

            IF which_sections = 0
              load_this = .T.
            ELSE
              IF loaded_count = VList_Max( which_sections )
                F_CLOSE( ini_file )
                RETURN .T.
              ELSE
                IF VList_Locate( which_sections, last_section, .T., .F. )
                  load_this = .T.
                  loaded_count = loaded_count + 1
                ELSE
                  load_this = .F.
                ENDIF
              ENDIF
            ENDIF
          ELSE
            IF LEN( last_section ) > 0 .AND. load_this
              equal_pos = AT( "=", temp_str )
              IF equal_pos > 0

                left_str = UPPER( ALLTRIM( LEFT( temp_str, equal_pos - 1 ) ) )
                right_str = ALLTRIM( SUBSTR( temp_str, equal_pos + 1, 254 ) )

                IF .NOT. VList_Add( section_list, last_section + "." + left_str )
                  VList_Clear( section_list )
                  VList_Clear( value_list )
                  F_CLOSE( ini_file )
                  RETURN .F.
                ENDIF

                IF .NOT. VList_Add( value_list, right_str )
                  VList_Clear( section_list )
                  VList_Clear( value_list )
                  F_CLOSE( ini_file )
                  RETURN .F.
                ENDIF

              ENDIF
            ENDIF
          ENDIF
        ENDIF

      ENDDO

      F_CLOSE( ini_file )

    ELSE
      RETURN .F.
    ENDIF
  ENDIF

  RETURN .T.
ENDPRO

