/***
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
***/

#include "vlist.h"


int _vlist_cdelete( LIST_HEADER *handle )
{
  BLOCK *tb1, *tb2, *tb3;

  if ( !handle->elements )
    return FALSE;

  tb2 = handle->list_current;
  if ( handle->elements == 1 )
  {
    _memory_free( tb2 );
    handle->list_first = NULL;
    handle->list_last = NULL;
    handle->list_current = NULL;
    handle->elements = 0;
    handle->current = 0;
    return TRUE;
  }

  if ( handle->current == 1 )
  {
    /*  pull the element out of the chain by pointing the first pointer to
     *  the next element and cutting of the next element's prev pointer.
     */

    tb3 = tb2->next;
    handle->list_first = tb3;
    tb3->prev = NULL;
    _memory_free( tb2 );
    handle->list_current = handle->list_first;
    handle->current = 1;
    handle->elements--;
  }
  else
    if ( handle->current == handle->elements )
    {
       /*  pull the element out of the chain by pointing the last pointer to
        *  the prev element and cutting of the prev element's next pointer.
        */

       tb1 = tb2->prev;
       handle->list_last = tb1;
       tb1->next = NULL;
       _memory_free ( tb2 );
       handle->list_current = NULL;
       /* handle->list_last; */
       handle->elements--;
       handle->current = handle->elements + 1;
    }
    else
    {
      /* remove the current node out of the middle of two others.  THen make
       * the current one the next one that used to be after it.  The current
       * number should stay the same but number of elements should decrease.
       */
      tb1 = tb2->prev;
      tb3 = tb2->next;

      tb1->next = tb3;
      tb3->prev = tb1;

      _memory_free( tb2 );
      handle->list_current = tb3;
      handle->elements--;
    }

  return TRUE;
}

int vlist_delete( LIST_HEADER *handle,
                  UINT        where  )
{
  UINT  old_current;
  BLOCK *old_lcurrent;
  int   ret_val;

  if ( !__verify( handle, 0 ) )
    return FALSE;

  if ( where < 1 || where > handle->elements || !handle->elements )
  {
    _vlist_error = BAD_ELEMENT;
    return FALSE;
  }

  if ( where == handle->current )
    ret_val = _vlist_cdelete( handle );
  else
  {
    old_current  = handle->current;
    old_lcurrent = handle->list_current;

    ret_val = TRUE;

    if ( vlist_goto( handle, where ) )
    {
      ret_val = _vlist_cdelete( handle );
      if ( ret_val )
      {
        if ( where < old_current )
          old_current--;
      }
    }
    else
      ret_val = FALSE;

    handle->current      = old_current;
    handle->list_current = old_lcurrent;
  }

  return ret_val;

}

int vlist_cdelete( LIST_HEADER *handle )
{
  if ( !__verify( handle, 0 ) )
    return FALSE;

  if ( handle->current < 1 ||
       handle->current > handle->elements ||
       !handle->elements )
  {
    _vlist_error = BAD_ELEMENT;
    return FALSE;
  }

  return _vlist_cdelete( handle );
}
