/***
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
***/

#include "vlist.h"

int vlist_rec_insert( LIST_HEADER *handle )
{
  BLOCK *old_lcurrent, *new_block;
  UINT  old_current;
  int   ret_val;

  if ( !__verify( handle, 0 ) )
    return FALSE;

  if ( !handle->current )
  {
    _vlist_error = BAD_ELEMENT;
    return FALSE;
  }

  old_lcurrent = handle->list_current;
  old_current  = handle->current;

  if ( vlist_rec_append( handle ) )
  {
    if ( handle->elements > 1 &&
         old_current <= handle->elements )
    {
      new_block = handle->list_last;

      handle->list_last       = new_block->prev;
      handle->list_last->next = NULL;

      if ( old_current == 1 )
      {
        new_block->next = old_lcurrent;
        new_block->prev = NULL;
        old_lcurrent->prev = new_block;
        handle->list_first = new_block;
      }
      else
      {
        new_block->next = old_lcurrent;
        new_block->prev = old_lcurrent->prev;
        old_lcurrent->prev = new_block;
        ( (BLOCK *) new_block->prev)->next = new_block;
      }

      handle->list_current = new_block;
      handle->current = old_current;
    }
    ret_val = TRUE;
  }
  else
    ret_val = FALSE;

  return ret_val;
}
