/***
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
***/

#include "vlist.h"


int vlist_cedit( LIST_HEADER *handle, char *new_str )
{
  char *temp_ptr;
  int  *idst, slen;
  UINT old_status;
  int  old_color;
  BLOCK *new_block, *prev_block, *next_block;

  if ( !__verify( handle, 1 ) )
    return FALSE;

  if ( !handle->elements ||
       handle->current < 1 ||
       handle->current > handle->elements )
  {
    _vlist_error = BAD_ELEMENT;
    return FALSE;
  }

  new_block = handle->list_current;

  slen = len( new_str );

  if ( handle->list_type == LIST_FIXLEN || slen == new_block->my_size )
  {
    if ( handle->list_type == LIST_FIXLEN )
      if ( slen > ( handle->rec_size - 5 ) )
        slen = handle->rec_size - 5;

    idst = (int *) &new_block->data_start;
    idst += 2;                             /* go forward two INT sizes */
    temp_ptr = (char *) idst;
    memcpy( (void *) temp_ptr, (void *) new_str, slen );

    new_block->my_size = slen;
  }
  else
  {
    idst = (int *) &new_block->data_start;
    old_status = *idst++;
    old_color  = *idst;

    vlist_cdelete( handle );
    if ( handle->current > handle->elements || handle->elements == 0 )
    {
      return vlist_append( handle, old_status, old_color, new_str );
    }
    else
    {
      return vlist_cinsert( handle, old_status, old_color, new_str );
    }
  }

  return TRUE;
}
