****
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
****

#INCLUDE WARN.HDR
#INCLUDE vlist.hdr
#INCLUDE vmouse.hdr
#INCLUDE STRING.HDR
#INCLUDE IO.HDR
#INCLUDE KEYS.HDR
#INCLUDE MATH.HDR
#include restmisc.hdr

PROCEDURE Scroll_ PROTOTYPE
  PARAMETERS VALUE INT, VALUE INT, VALUE INT, VALUE INT, VALUE LOGICAL


FUNCTION UINT Vlist_Simple
  PARAMETERS ;
   VALUE LONG plist, ;
   VALUE UINT r,;
   VALUE UINT c,;
   VALUE UINT r1,;
   VALUE UINT c1, ;
   VALUE UINT idx, ;
   VALUE UINT first_allowed,;
   VALUE UINT last_allowed,;
   VALUE LOGICAL disp_only,;
   VALUE LOGICAL ret

  VARDEF
    BYTE    old_std, old_enhcd
    UINT  wid
    INT      height
    UINT  i
    UINT  k
    LOGICAL  redraw
    INT     __tops_, temp_idx
    UINT    final
    CHAR    temp_str
  ENDDEF

  __tops_ = 1

  IF .NOT. vlist_is_init( plist )
    RETURN 0
  ENDIF

  IF first_allowed = 0
    first_allowed = 1
  ENDIF

  IF last_allowed = 0
    last_allowed = vlist_max( plist )
    IF last_allowed = 0
      RETURN 0
    ENDIF

  ENDIF

  IF idx < first_allowed
    idx = first_allowed
  ENDIF

  IF last_allowed > vlist_max( plist )
    idx = vlist_max( plist )
  ENDIF

  IF idx > last_allowed
    idx = last_allowed
  ENDIF

  old_std = __color_std
  old_enhcd = __color_enhcd
  height = r1 - r

  IF __tops_ < idx-height
    __tops_ = idx-height
  ENDIF

  IF idx = 1
    __tops_ = 1
  ENDIF

  IF idx<1
    idx = 1
  ENDIF

  wid = c1 - c + 1

  IF idx-__tops_ > height
    __tops_ = idx-height
  ENDIF

  IF ( last_allowed - first_allowed + 1 ) < height
    height = ( last_allowed - first_allowed + 1 )
  ENDIF

  IF __tops_ < first_allowed
    __tops_ = first_allowed
  ENDIF

  *--- do the intial display

  redraw = .T.

  REPEAT
    IF redraw
    *      FILL( r, c, r1, c1, "        ", " ", old_std, old_std, 0 )
      FOR i = 0 TO height
        IF __tops_+i > last_allowed
          EXIT
        ENDIF

        vlist_goto( plist, __tops_+i )
        vlist_what_color( plist, old_std )
        temp_str = vlist_cstr( plist )
        IF AT( "...", temp_str ) = 2 .AND. LEN( temp_str ) = 4
          temp_str = REPLICATE( LEFT( temp_str, 1 ), wid )
        ELSE
          temp_str = LEFT( temp_str, wid )
        ENDIF

        @ r+i, c SAY temp_str:wid
      NEXT

    ENDIF

    vlist_goto( plist, idx )
    temp_str = vlist_cstr( plist )
    IF AT( "...", temp_str ) = 2 .AND. LEN( temp_str ) = 4
      temp_str = REPLICATE( LEFT( temp_str, 1 ), wid )
    ELSE
      temp_str = LEFT( temp_str, wid )
    ENDIF

    *- if we are not on a special item then highlight the item
    VList_What_Color( plist, old_std )
    IF __color_std = old_std
      __color_std = old_enhcd
    ELSE
      *- can we at least change the background?
      __color_std = VList_Copy_BackGround( __color_std, old_enhcd )
    ENDIF

    @ r+idx-__tops_, c SAY temp_str:wid
    __color_std = old_std
    IF disp_only
      final = 0
      RETURN final
    ENDIF

    k = GET_KEY()

    IF k = &k_esc
      idx = 0
      EXIT
    ENDIF

    IF k = &k_enter
      EXIT
    ENDIF

    vlist_what_color( plist, old_std )
    @ r+idx-__tops_, c SAY temp_str:wid

    redraw = .F.

    DO CASE
      CASE k = &k_down
        IF idx < last_allowed
          idx = idx + 1
        ENDIF

        IF idx - __tops_ > height
          Scroll_( r, c, r1, c1, .T. )
          __tops_ = __tops_ + 1
        ENDIF

      CASE k = &k_up
        IF idx > first_allowed
          idx = idx - 1
        ENDIF

        IF idx - __tops_ < 0
          Scroll_( r, c, r1, c1, .F. )
          __tops_ = __tops_ - 1
        ENDIF

      CASE k = &k_pg_down
        __tops_ = MyMIN( __tops_ + height + 1, MyMAX( last_allowed - height, first_allowed )  )
        idx = MyMIN( idx + height + 1, last_allowed )

        redraw = .T.

      CASE k = &k_pg_up
        __tops_ = MyMAX( __tops_ - height - 1, first_allowed )
        idx = MyMAX( idx - height - 1, first_allowed )

        redraw = .T.

      CASE k = &k_home
        idx = first_allowed
        __tops_ = first_allowed
        redraw = .T.

      CASE k = &k_end
        idx = last_allowed
        __tops_ = idx - height
        IF __tops_ < first_allowed
          __tops_ = first_allowed
        ENDIF

        redraw = .T.

      OTHERWISE
        IF ret
          EXIT
        ENDIF

    ENDCASE

  UNTIL k = &k_esc

  final = idx
  __color_std = old_std
  __color_enhcd = old_enhcd

  RETURN final
ENDPRO
