/***
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
***/

#include "vlist.h"


int vlist_rec_grab( LIST_HEADER *handle,
                    UINT        field_number,
                    void        *replace_data )
{
  BLOCK  *new_block;
  UINT   offset;
  UINT   rec_size, fld_len;
  int    i;
  LIST_FIELD *field_list;
  char   *dst, *rep;

  if ( !__verify( handle, 0 ) )
    return FALSE;

  if ( handle->list_type != LIST_FIELDS )
  {
    _vlist_error = BAD_TYPE;
    return FALSE;
  }

  if ( !handle->elements ||
        handle->current < 1 ||
        handle->current > handle->elements )
  {
    _vlist_error = BAD_ELEMENT;
    return FALSE;
  }

  if ( field_number > handle->num_fields || field_number < 1 )
  {
    _vlist_error = BAD_FIELD;
    return FALSE;
  }

  /* ok, lets find the offset of the field to edit! */
  rec_size = 0;
  field_number--;

  field_list = (LIST_FIELD *) ( &handle->field_start );

  for ( i = 0; i < field_number; i++ )
  {
    switch( field_list[ i ].field_type )
    {
          case FTYPE_UNTYPED:
          case FTYPE_CHAR:
            rec_size += field_list[ i ].field_size + 1;
            break;

          case FTYPE_BYTE:
            rec_size += FSIZE_BYTE;
            break;

          case FTYPE_LOGICAL:
            rec_size += FSIZE_LOGICAL;
            break;

          case FTYPE_INT:
          case FTYPE_UINT:
            rec_size += FSIZE_INT;
            break;

          case FTYPE_LONG:
          case FTYPE_ULONG:
            rec_size += FSIZE_LONG;
            break;

          case FTYPE_DBL:
            rec_size += FSIZE_DBL;
            break;

          case FTYPE_DATE:
            rec_size += FSIZE_DATE;
            break;

          default:
            return FALSE;
    }
  }

  offset = rec_size;

  switch( field_list[ field_number ].field_type )
  {
    case  FTYPE_UNTYPED:
    case  FTYPE_CHAR:
      /* includes the NULL terminator! */
      fld_len = field_list[ field_number ].field_size;
      break;
    case  FTYPE_BYTE:
      fld_len = FSIZE_BYTE;
      break;
    case  FTYPE_LOGICAL:
      fld_len = FSIZE_LOGICAL;
      break;
    case  FTYPE_UINT:
    case  FTYPE_INT:
      fld_len = FSIZE_INT;
      break;
    case  FTYPE_ULONG:
    case  FTYPE_LONG:
      fld_len = FSIZE_LONG;
      break;
    case  FTYPE_DBL:
      fld_len = FSIZE_DBL;
      break;
    case  FTYPE_DATE:
      fld_len = FSIZE_DATE;
      break;
    default:
      _vlist_error = BAD_TYPE;
      return FALSE;
  }

  new_block = handle->list_current;
  dst = (char *) &new_block->data_start;
  dst += offset;

  if ( field_list[ field_number ].field_type != FTYPE_CHAR )
    memcpy( replace_data, (void *) dst, fld_len );
  else
  {
    rep = (char *) replace_data;

    while( *dst && fld_len )
    {
      *rep++ = *dst++;
      fld_len--;
    }

    if ( !fld_len )
      rep--;

    if ( *rep )
      *rep = 0;
  }

  return TRUE;
}
