/***
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
***/

#include "vlist.h"

int vlist_rec_append( LIST_HEADER *handle )
{
  BLOCK *new_block;
  UINT  reclen;
  LIST_FIELD *field_list;

  if ( !__verify( handle, 0 ) )
    return FALSE;

  reclen = handle->rec_size;

  new_block = (BLOCK *) _memory_alloc( sizeof( BLOCK ) + reclen );

  if ( new_block == NULL )
  {
    _vlist_error = NO_MEMORY;
    return FALSE;
  }

  new_block->next   = NULL;
  new_block->prev   = handle->list_last;

  if ( new_block->prev != NULL )
  ( (BLOCK *) new_block->prev )->next = new_block;

  handle->list_last = new_block;
  handle->list_current = new_block;

  if ( handle->list_first == NULL || handle->elements == 0 )
    handle->list_first = new_block;

  handle->elements++;
  handle->current = handle->elements;

  /* for this type of list this is = to the string size! */
  new_block->my_size = handle->rec_size;

  return TRUE;
}
