****
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
****

**-- Pop-Up menu for VList

#DEFINE _INTERNAL_

#INCLUDE WARN.HDR
#INCLUDE restlist.hdr
#INCLUDE STRING.HDR
#INCLUDE IO.HDR
#INCLUDE KEYS.HDR
#INCLUDE SYSTEM.HDR
#include restmisc.hdr
#include internal.hdr

FUNCTION INT VList_PopTart
  PARAMETERS VALUE LONG      handle,;
                   UINT      selected_element,;
             VALUE UINT      system,;
             VALUE INT       s_row,;
             VALUE INT       s_col,;
             VALUE UINT      max_row,;
             VALUE UINT      first,;
             CONST CHAR( 8 ) border_chars,;
             VALUE BYTE      border_color,;
             VALUE BYTE      title_color,;
             VALUE LOGICAL   shadow,;
             VALUE LOGICAL   save_under,;
                   UINT      save_var,;
             VALUE LOGICAL   restore_under,;
             VALUE LOGICAL   scroll_bar,;
             VALUE LOGICAL   mouse,;
             VALUE UINT      left_start,;
             VALUE UINT      start_element,;
             VALUE LOGICAL   return_left_right,;
                   UINT      top_element,;
                   UNTYPED   menu_key_proc,;
             VALUE LOGICAL   allow_embedded

  VARDEF
    LOGICAL cont
    INT   ret_val, temp_len, temp_len2
    UINT  old_row, old_col, old_std
    UINT  sel
    CHAR( 128 )  temp_str, title, temp_str2
    UINT  temp1, temp2, temp3, temp4
    UINT  ur, uc, lr, lc, wid, real_wid, left_sub
    UINT  border_offset
    LOGICAL center_row, center_col
    UINT  fudge, old_first
  ENDDEF

  IF first = 0
    first = 1
  ENDIF

  center_row = .F.
  center_col = .F.

  IF s_row = -1
    s_row = 0
    center_row = .T.
  ENDIF
 
  IF s_col = -1
    s_col = 0
    center_col = .T.
  ENDIF

  IF .NOT. vlist_is_init( handle )
    RETURN &EXIT_ERROR
  ENDIF

  IF vlist_max( handle ) = 0
    RETURN &EXIT_ERROR
  ENDIF

  border_offset = 0

  old_row = ROW()
  old_col = COL()

  temp_str = I_STR( system )+"."
  temp1 = start_element

  vlist_goto( handle, temp1 )

  cont = .T.

  temp2 = temp1 + 1

  old_first = first
  first = 0
  temp_len = LEN( temp_str )
  DO WHILE cont .AND. .NOT. vlist_bol( handle )
    temp_str2 = vlist_cstr( handle )
    IF SUBSTR( temp_str2, left_start, temp_len ) <> temp_str
      cont =.F.
      LOOP
    ENDIF

    temp2 = vlist_number( handle )

    temp_str2 = SUBSTR( temp_str2, 1, left_sub )
    temp_str2 = SUBSTR( temp_str2, left_start, left_sub )
    temp_str2 = SUBSTR( temp_str2, AT( ".", temp_str2 )+1, 128 )
    IF VAL( temp_str2 ) = old_first
      first = temp2
    ENDIF

    vlist_skip( handle, &jl_forward )
  ENDDO

  * for debugging:
  * GET_KEY()

  vlist_goto( handle, temp1 )

  temp3 = temp2
  temp2 = temp1+1

  IF first = 0
    first = temp2
  ENDIF

  * temp1 = title
  * temp2 = first menu item
  * temp3 = last menu item

  ur = s_row
  uc = s_col

  title = vlist_cstr( handle )
  left_sub = AT( "|", title )+1

  IF allow_embedded
    wid = __Embed_Len( title ) - left_sub + 3
    real_wid = LEN( title ) - left_sub + 3
  ELSE
    wid = LEN( title ) - left_sub + 3
    real_wid = wid
  ENDIF

  FOR lc = temp2 TO temp3
    vlist_goto( handle, lc )
    temp_str = SUBSTR( vlist_cstr( handle ), left_sub, 128 )
    IF allow_embedded
      temp_len = __Embed_Len( temp_str )
      temp_len2 = LEN( temp_str )
    ELSE
      temp_len = LEN( temp_str )
      temp_len2 = temp_len
    ENDIF

    IF temp_len > wid
      wid = temp_len
    ENDIF

    IF temp_len2 > real_wid
      real_wid = temp_len2
    ENDIF

  NEXT

  IF center_row
    fudge = 12 - ( ( temp3 - temp2  + 1 ) / 2 )
    ur = fudge
  ENDIF
 
  IF center_col
    uc = 40 - ( wid / 2 )
  ENDIF

  lc = uc + 1 + wid + border_offset
  lr = ur + 2 + ( temp3 - temp2 )
  IF shadow
    lc = lc + 1
    lr = lr + 1
    temp4 = 6
  ELSE
    temp4 = 0
  ENDIF

  IF lr > max_row
    lr = max_row
  ENDIF

  DO WHILE lc > 79
    lc = lc - 1
    IF uc > 0
      uc = uc - 1
    ENDIF

  ENDDO

  IF save_under
    save_var = SAVESCRN( ur, uc, lr, lc )
  ENDIF

  FILL( ur, uc, lr, lc, border_chars, " ", border_color, __color_std, temp4 )
  old_std  = __color_std
  __color_std = title_color

  IF LEN( SUBSTR( title, left_sub, 128 ) ) > 0
    IF allow_embedded
      Embedded_Say( ur, uc+2, 0,;
                 SUBSTR( title, left_sub, LEN( title ) ), .F. )
    ELSE
      @ ur, uc+2 SAY SUBSTR( title, left_sub, LEN( title ) )
    ENDIF
 
  ENDIF

  __color_std = old_std

  IF shadow
    lc = lc - 1
    lr = lr - 1
  ENDIF

  temp4 = temp2

  sel = first
  ret_val =  _Vlist_Pick( handle, ;
                     ur+1, uc+1+border_offset,;
                     lr-1, lc-1-border_offset, lc,;
                     top_element, sel, temp2, temp3,;
                     left_sub, left_sub+real_wid,;
                     1, 0,;
                     menu_key_proc,;
                     .F., scroll_bar, return_left_right, mouse,;
                     allow_embedded )

  IF restore_under
    RESTORESCRN( save_var )
  ENDIF

  IF ret_val <> &EXIT_ERROR
    IF ( vlist_goto( handle, sel ) ) .AND.;
         ( sel > 0 ) .AND.;
         ( sel <= vlist_max( handle ) )
      temp_str = vlist_cstr( handle )
      temp_str = SUBSTR( temp_str, 1, left_sub )
      temp_str = SUBSTR( temp_str, left_start, left_sub )
      temp_str = SUBSTR( temp_str, AT( ".", temp_str )+1, 128 )
      sel = VAL( temp_str )
    ELSE
      sel = 0
    ENDIF
 
  ELSE
    sel = 0
  ENDIF

  selected_element = sel

  @old_row, old_col
  RETURN ret_val
ENDPRO
