/***
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
***/

#include "vlist.h"


int vlist_append( LIST_HEADER *handle,
                  UINT        status,
                  int         color,
                  char        *tstr )
{
  int   slen;
  int   reclen;
  BLOCK *new_block;
  char  *dst;
  int   *idst;

  if ( !__verify( handle, 1 ) )
    return FALSE;

  slen = len( tstr );

  if ( handle->list_type == LIST_VARLEN )
    reclen = 5 + slen;
  else
  {
    reclen = handle->rec_size;
    if ( slen > ( reclen - 5 ) )
      slen = reclen - 5;
  }

  new_block = (BLOCK *) _memory_alloc( sizeof( BLOCK ) + reclen );

  if ( new_block == NULL )
  {
    _vlist_error = NO_MEMORY;
    return FALSE;
  }

  new_block->next   = NULL;
  new_block->prev   = handle->list_last;

  if ( new_block->prev != NULL )
    ( (BLOCK *) new_block->prev )->next = new_block;

  handle->list_last = new_block;
  handle->list_current = new_block;

  if ( handle->list_first == NULL || handle->elements == 0 )
    handle->list_first = new_block;

  handle->elements++;
  handle->current = handle->elements;

  /* for this type of list this is = to the string size! */
  new_block->my_size = slen;

  idst = (int *) &new_block->data_start;
  *idst++ = status;
  *idst++ = color;
  dst = (char *) idst;
  memcpy( (void *) dst, (void *) tstr, slen );
  dst[ slen ] = 0;

  return TRUE;
}

int vlist_add( LIST_HEADER *handle,
               char        *tstr )
{
  return ( vlist_append( handle, stat_normal, color_default, tstr ) );
}
