****
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
****

#define _INTERNAL_

**-- Pulldown menu for VList
#INCLUDE WARN.HDR
#INCLUDE restlist.hdr
#INCLUDE restmisc.hdr
#INCLUDE STRING.HDR
#INCLUDE IO.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE KEYS.HDR
#include internal.hdr

FUNCTION UINT VList_Call_Pulldown PROTOTYPE
  PARAMETERS UNTYPED proc_to_call,;
             VALUE LONG handle,;
             VALUE UINT system,;
             VALUE UINT over,;
             VALUE UINT down



FUNCTION INT _Manual_Pulldown
  PARAMETERS VALUE LONG      handle,;
       VALUE UINT      system,;
             UINT      over,;
             UINT      down,;
             LOGICAL   pulled,;
             UNTYPED   menu_key_proc,;
       VALUE UINT      header_row,;
       VALUE UINT      menu_row,;
       VALUE INT       col_offset,;
       CONST CHAR( 8 ) border_chars,;
       VALUE LOGICAL   mouse,;
       VALUE LOGICAL   always_down,;
       VALUE LOGICAL   keep_saved,;
             UINT      save_var,;
             UINT      header_var,;
       VALUE BYTE      std_color,;
       VALUE BYTE      hi_std_color,;
       VALUE BYTE      enhcd_color,;
       VALUE BYTE      hi_enhcd_color,;
       VALUE BYTE      skip_color,;
       VALUE BYTE      hdr_std_color,;
       VALUE BYTE      hi_hdr_std_color,;
       VALUE BYTE      hdr_enhcd_color,;
       VALUE BYTE      hi_hdr_enhcd_color,;
       VALUE BYTE      border_color

  VARDEF
    CHAR       temp_str, temp_str2
    CHAR( 40 ) temp_str3
    UINT       temp1, temp2, temp3, old_over
    BYTE       h_col[ 15 ]
    BYTE       h_last[ 15 ]
    UINT       h_start[ 15 ]
    UINT       h_end[ 15 ]
    UINT       h_top[ 15 ]
    CHAR( 40 ) h_title[ 15 ]
    INT        h_max, max_row
    INT        ret_val
    LOGICAL    menu_loop, cont, refresh_title, allow_embedded
    LOGICAL    scroll_bar, shadow
    UINT       left_mark
    BYTE       old_std, old_hi, old_enhcd, old_hi_std, old_hi_enhcd
    BYTE       old_skip, old_hit
    UINT       return_status
    UINT       cap_search, cap_find, tu1, tu2
    LOGICAL    check_mouse
    UINT       mrow, mcol
    BYTE hit_color
  ENDDEF

  hit_color = skip_color
  check_mouse = .F.
  allow_embedded = .T.
  scroll_bar = .F.
  shadow = .T.

  save_var = 0
  header_var = 0

  old_std = __color_std
  old_enhcd = __color_enhcd
  old_hi_std = __color_hi_std
  old_hi_enhcd = __color_hi_enhcd
  old_skip = __color_skip
  old_hit = __color_hit

  max_row = 21

  IF over = 0
    over = 1
  ENDIF

  IF down = 0
    down = 1
  ENDIF

  over = over - 1

  h_max = -1
  IF .NOT. vlist_is_init( handle )
    RETURN &EXIT_ERROR
  ENDIF

  temp_str = I_STR( system )+"."
  left_mark = LEN( temp_str )
  temp_str = temp_str +"1 @"

  IF vlist_locate_substr( handle, temp_str, 1, LEN( temp_str ), .T., .F. )
    temp1 = vlist_number( handle )

    ** we have the start of the menu system in temp1
    *   ?.? @?

    temp_str  = I_STR( system )+"."

    cont = .T.
    temp3 = temp1

    DO WHILE cont
      IF vlist_bol( handle )
        h_end[ h_max ] = temp3
        cont = .F.
        LOOP
      ENDIF

      temp_str2 = vlist_cstr( handle )
      IF SUBSTR( temp_str2, 1, left_mark ) <> temp_str
        h_end[ h_max ] = temp3
        cont =.F.
        LOOP
      ENDIF

      temp2 = AT( "@", temp_str2 )
      IF temp2 > 0
        IF h_max > 13
          cont = .F.
          LOOP
        ENDIF

        IF h_max > -1
          h_end[ h_max ] = vlist_number( handle ) - 1
        ENDIF

        h_max = h_max + 1
        temp_str3 = LTRIM( SUBSTR( temp_str2, temp2+1, 128 ) )
        temp_str2 = LEFT( temp_str3, AT( " ", temp_str3 )-1 )
        h_col[ h_max ] = VAL( temp_str3 )

        IF over = h_max
          h_last[ h_max ] = down
        ELSE
          h_last[ h_max ] = 1
        ENDIF

        h_start[ h_max ] = vlist_number( handle ) + 1
        temp_str2 = SUBSTR( temp_str3, AT( "|", temp_str3 )+1, 128 )
        h_title[ h_max ] = temp_str2
        h_top[ h_max ] = h_start[ h_max ]+1

      ENDIF

      temp3 = vlist_number( handle )
      vlist_skip( handle, &jl_forward )

    ENDDO

    IF h_max = -1
      menu_loop = .F.
    ELSE
      menu_loop = .T.
    ENDIF

    IF always_down
      pulled = .T.
    ENDIF

    IF over > h_max
      over = h_max
    ENDIF

    header_var = SAVESCRN( header_row, 0, header_row, 79 )

    ret_val = &EXIT_SELECT
    refresh_title = .T.

    DO WHILE menu_loop
      IF refresh_title
        refresh_title = .F.
        __color_std = hdr_std_color

        @ header_row, 0 CLEAR TO header_row, 79

        FOR temp1 = 0 TO h_max
          IF allow_embedded
            IF pulled
              __color_hi_std = hdr_std_color
            ELSE
              __color_hi_std = hi_hdr_std_color
            ENDIF
            Embedded_Say( header_row, h_col[ temp1 ],;
                       0, h_title[ temp1 ], .F. )
          ELSE
            @header_row, h_col[ temp1 ] SAY h_title[ temp1 ]
          ENDIF
 
        NEXT
      ENDIF
    * highlight title

      __color_std = hdr_enhcd_color
      __color_enhcd = hdr_enhcd_color
      IF allow_embedded
        IF pulled
          __color_hi_enhcd = hdr_enhcd_color
        ELSE
          __color_hi_enhcd = hi_hdr_enhcd_color
        ENDIF
        Embedded_Say( header_row, h_col[ over ],;
                   0, h_title[ over ], .T. )
      ELSE
        @header_row, h_col[ over ] SAY h_title[ over ]
      ENDIF

      IF mouse
        _mouse_cursor( .T. )
      ENDIF

      old_over = over
      IF pulled
        temp2 = h_last[ over ]
        temp3 = ( h_end[ over ] - h_start[ over ] + 1 )

        IF temp2 > temp3
          temp2 = temp3
        ENDIF

        down = temp2

        tu1 = h_start[ over ]

        IF ( tu1 < 1 ) .OR.;
           ( tu1 > vlist_max( handle ) )

          h_start[ over ] = 1
        ENDIF

        vlist_goto( handle, h_start[ over ] )

        temp_str = SUBSTR( vlist_cstr( handle ), left_mark+1, 20 )
        temp_str = LEFT( temp_str, AT( ".", temp_str ) - 1 )
        temp3 = VAL( ALLTRIM( temp_str ) )

        IF mouse
          _mouse_cursor( .F. )
          DO WHILE _mouse_left_button() .AND. _mouse_row() = header_row
          ENDDO
 
        ENDIF

        __color_std = std_color
        __color_enhcd = enhcd_color
        __color_hi_std = hi_std_color
        __color_hi_enhcd = hi_enhcd_color
        __color_skip = skip_color
        __color_hit = hit_color

        save_var = 0
        ret_val = Vlist_Poptart( handle, temp1, temp3,;
                               menu_row, h_col[ over ] + col_offset,;
                               max_row,;
                               temp2,;
                               border_chars,;
                               border_color,;
                               hdr_std_color,;
                               shadow, .T., save_var,.F.,;
                               scroll_bar, mouse, left_mark+1,;
                               h_start[ over ], .T.,;
                               h_top[ over ],;
                               menu_key_proc,;
                               allow_embedded )

        h_last[ over ] = temp1

        DO CASE
          CASE ret_val = &EXIT_ESC .AND. always_down
            * down = temp1
            menu_loop = .F.
          CASE ret_val = &EXIT_ESC
            pulled = .F.
            refresh_title = .T.

          CASE ret_val = &EXIT_ABORT
            menu_loop = .F.

          CASE ret_val = &EXIT_SELECT
            down = temp1
            menu_loop = .F.

          CASE ret_val = &EXIT_RIGHT
            IF over < h_max
              over = over + 1
            ELSE
              over = 0
            ENDIF

          CASE ret_val = &EXIT_LEFT
            IF over > 0
              over = over - 1
            ELSE
              over = h_max
            ENDIF

          CASE ret_val = &EXIT_SCAN_MENU    && check mouse position
            check_mouse = .T.
        ENDCASE

        IF ( menu_loop = .F. ) .AND. ( keep_saved )
          * what?
        ELSE
          IF save_var <> 0
            RESTORESCRN( save_var )
          ENDIF
        ENDIF

        IF mouse
          _mouse_cursor( .T. )
        ENDIF

      ELSE
        temp3 = 0
        DO WHILE temp3 = 0
          temp3 = INKEY()
          IF mouse
            IF _mouse_left_button()
              temp3 = 10
            ENDIF

            IF _mouse_right_button()
              DO WHILE _mouse_right_button()
              ENDDO

              temp3 = 27
            ENDIF
 
          ENDIF

        ENDDO

        DO CASE
          CASE temp3 = &k_end
            over = h_max
          CASE temp3 = &k_home
            over = 0
          CASE temp3 = &k_esc
            ret_val = &EXIT_ESC
            menu_loop = .F.
          CASE temp3 = &k_enter .OR. temp3 = &k_down .OR.;
              temp3 = &k_pg_down
            pulled = .T.
            refresh_title = .T.
          CASE temp3 = &k_right
            IF over < h_max
              over = over + 1
            ELSE
              over = 0
            ENDIF

          CASE temp3 = &k_left
            IF over > 0
              over = over - 1
            ELSE
              over = h_max
            ENDIF

          CASE temp3 = 10
            check_mouse = .T.

          CASE ( temp3 >= 65 .AND. temp3 <=  90 ) .OR.;
                 ( temp3 >= 97 .AND. temp3 <= 122 )

            cap_find = over
            FOR cap_search = 0 TO h_max
              IF allow_embedded
                IF AT( __embed_char, h_title[ cap_search ] ) > 0
                  IF UPPER( SUBSTR( h_title[ cap_search ],;
                               AT( __embed_char, h_title[ cap_search ] ) + 1,;
                               1 ) ) = UPPER( CHR( temp3 ) )
                    cap_find = cap_search
                    pulled = .T.
                    refresh_title = .T.
                    EXIT
                  ENDIF
 
                ENDIF
 
              ELSE
                IF AT( UPPER( CHR( temp3 ) ), h_title[ cap_search ] ) > 0
                  cap_find = cap_search
                  pulled   = .T.
                  refresh_title = .T.
                  EXIT
                ENDIF
 
              ENDIF
 
            NEXT
 
            over = cap_find

        ENDCASE

      ENDIF

      IF check_mouse
        mrow = _mouse_row()
        mcol = _mouse_col()

        DO WHILE INKEY() <> 0
        ENDDO

        IF mrow = header_row
          FOR temp3 = 0 TO h_max
            temp2 = h_col[ temp3 ]
            temp1 = temp2 + LEN( h_title[ temp3 ] ) - 1
            IF mcol >= temp2 .AND.;
                mcol <= temp1
              over = temp3
            ENDIF

          NEXT

        ENDIF

        check_mouse = .F.
        pulled = .T.
        refresh_title = .T.
      ENDIF

      IF mouse
        _mouse_cursor( .F. )
      ENDIF

      __color_std = hdr_std_color
      IF allow_embedded
        IF pulled
          __color_hi_std = hdr_std_color
        ELSE
          __color_hi_std = hi_hdr_std_color
        ENDIF
        Embedded_Say( header_row, h_col[ old_over ], 0,;
                   h_title[ old_over ], .F. )
      ELSE
        @header_row, h_col[ old_over ] SAY h_title[ old_over ]
      ENDIF

    ENDDO

    IF ( keep_saved = .F. )
      RESTORESCRN( header_var )
    ENDIF
  ELSE

    ret_val = &EXIT_ERROR
  ENDIF

  over = over + 1
  __color_std = old_std
  __color_enhcd = old_enhcd
  __color_hi_std = old_hi_std
  __color_hi_enhcd = old_hi_enhcd
  __color_hit = old_hit
  __color_skip = old_skip

  RETURN ret_val
ENDPRO
