****
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
****

#define _INTERNAL_

#INCLUDE STRING.HDR
#INCLUDE KEYS.HDR
#INCLUDE WARN.HDR
#INCLUDE IO.HDR
#INCLUDE SYSTEM.HDR
#include internal.hdr
#include restmisc.hdr
#include restlist.hdr


FUNCTION INT VLIST_Call_Prompt_Handler PROTOTYPE
  PARAMETERS UNTYPED user_function,;
             VALUE LONG list_handle,;
             VALUE UINT list_element,;
                   UINT mouse_stat,;
             VALUE UINT mrow,;
             VALUE UINT mcol,;
                    INT pick_key,;
             VALUE UINT top_element,;
             VALUE UINT last_element


FUNCTION INT __Manual_Prompts
  PARAMETERS VALUE LONG    plist,;
             VALUE UINT    system,;
                   UINT    first,;
                   UNTYPED handler_proc,;
             VALUE LOGICAL is_mouse,;
             VALUE LOGICAL display_only

  VARDEF
    LOGICAL     ml, mr, allow_embeded
    UINT        current_element, first_element, last_element
    CHAR( 10 )  syst
    CHAR        temp_str
    LOGICAL     prompt_loop
    LOGICAL     rescan, mouse_scan
    UINT        mrow, mcol, temp_count, temp_loop, temp_stat
    UINT        current_row, current_col, temp_row, temp_col
    INT         ret_val
    BYTE        old_std, old_enhcd, old_hs, old_hi_std, old_hi_enhcd
    UINT        mouse_stat
    INT         user_proc, pick_key
    LOGICAL     check_element, go_forward
    LOGICAL     move_marker
  ENDDEF

  allow_embeded = .T.

  old_std   =   __color_std
  old_enhcd =   __color_enhcd
  old_hi_std = __color_hi_std
  old_hi_enhcd = __color_hi_enhcd

  ret_val = &EXIT_SELECT

  IF .NOT. vlist_is_init( plist )
    RETURN &EXIT_ERROR
  ENDIF

  IF is_mouse
    ml = _mouse_Left_Button()
    mr = _mouse_Right_Button()
    _mouse_Cursor( .T. )
  ENDIF

  syst = I_STR( system ) + "."
  IF .NOT.  vlist_locate_substr( plist, syst, 1, LEN( syst ), .T., .F. )
    RETURN &EXIT_ERROR
  ENDIF

  REPEAT
    first_element = vlist_number( plist )
    vlist_skip( plist, &jl_backward )

    IF vlist_tol( plist )
      EXIT
    ENDIF
 
  UNTIL LEFT( vlist_cstr( plist ), LEN( syst ) ) <> syst

  vlist_goto( plist, first_element )

  REPEAT
    last_element = vlist_number( plist )
    vlist_skip( plist, &jl_forward )

    IF vlist_bol( plist )
      EXIT
    ENDIF
 
  UNTIL LEFT( vlist_cstr( plist ), LEN( syst ) ) <> syst

  temp_count = 0

  vlist_goto( plist, first_element )

  current_element = first_element

  syst = syst + I_STR( first ) + " "

  FOR temp_loop = first_element TO last_element
    temp_stat = vlist_cget_status( plist )

    IF temp_stat <> &jl_hide .AND. temp_stat <> &jl_skip
      temp_count = temp_count + 1
    ENDIF

    IF LEFT( VLIST_CSTR( plist ), LEN( syst ) ) = syst
      current_element = vlist_number( plist )
    ENDIF

    vlist_skip( plist, &jl_forward )
 
  NEXT

  IF temp_count = 0
    RETURN &EXIT_ERROR
  ENDIF

  vlist_goto( plist, current_element )
  temp_stat = vlist_cget_status( plist )
  IF temp_stat = &jl_hide .OR. temp_stat = &jl_skip
    DO WHILE temp_stat = &jl_hide .OR. temp_stat = &jl_skip
      vlist_skip( plist, &jl_forward )
      IF vlist_number( plist ) > last_element
        vlist_goto( plist, first_element )
      ENDIF
 
      temp_stat = vlist_cget_status( plist )
    ENDDO
 
    current_element = vlist_number( plist )
  ENDIF

  prompt_loop = .T.
  mouse_scan  = .F.
  rescan = .T.  && draw all prompts again
  move_marker = .F.

  IF display_only
    * __color_hi_std = __color_std
    * __color_hi_enhcd = __color_enhcd
  ENDIF

  DO WHILE prompt_loop
    pick_key = 0

    IF is_mouse
      _mouse_Cursor( .F. )
    ENDIF

    IF rescan
      FOR temp_loop = first_element TO last_element
        vlist_goto( plist, temp_loop )
        temp_stat = vlist_cget_status( plist )
        IF temp_stat = &jl_hide
          LOOP
        ENDIF

        temp_str = vlist_cstr( plist )

        temp_count = AT( "@", temp_str )
        temp_str = LTRIM( SUBSTR( temp_str, temp_count+1, 254 ) )

        temp_row = VAL( ALLTRIM( LEFT( temp_str, AT( ",", temp_str ) - 1 ) ) )
        temp_str = LTRIM( SUBSTR( temp_str, AT( ",", temp_str ) + 1, 254 ) )
        temp_col = VAL( ALLTRIM( LEFT( temp_str, AT( " ", temp_str ) - 1 ) ) )

        temp_str = SUBSTR( temp_str, AT( "|", temp_str ) + 1, 254 )

        IF mouse_scan .AND. is_mouse
          IF ( mrow = temp_row ) .AND.;
               ( ( mcol >= temp_col ) .AND.;
               ( mcol < ( temp_col + LEN( temp_str ) ) ) ) .AND.;
               ( temp_stat <> &jl_skip )

            current_element = vlist_number( plist )
            current_row     = temp_row
            current_col     = temp_col

            mouse_scan = .F.
          ENDIF
 
        ELSE
          IF current_element = vlist_number( plist )
            current_row = temp_row
            current_col = temp_col
          ENDIF

          IF .NOT. move_marker

            vlist_what_color( plist, old_std )

            IF allow_embeded
              IF temp_stat <> &jl_normal
                old_hs = __color_hi_std
                __color_hi_std = __color_std
              ENDIF
              Embedded_say( temp_row, temp_col, 0, temp_str, .F. )
              IF temp_stat <> &jl_normal
                __color_hi_std = old_hs
              ENDIF
            ELSE
              @temp_row, temp_col SAY temp_str
            ENDIF

          ENDIF
 
        ENDIF

      NEXT

      rescan = .F.
    ENDIF

    IF move_marker
      move_marker = .F.
    ENDIF

     IF .NOT. display_only

      __color_std = old_enhcd
      vlist_goto( plist, current_element )
      temp_stat = vlist_cget_status( plist )
      temp_str = vlist_cstr( plist )
      temp_str = SUBSTR( temp_str, AT( "|", temp_str )+1, 254 )

      IF allow_embeded .AND. temp_stat = &jl_normal
        IF temp_stat <> &jl_normal
          old_hs = __color_hi_std
          __color_hi_std = __color_std
        ENDIF
        Embedded_say( current_row, current_col, 0, temp_str, .T. )
        IF temp_stat <> &jl_normal
          __color_hi_std = old_hs
        ENDIF
      ELSE
        @current_row, current_col SAY temp_str
      ENDIF

      IF is_mouse
        _mouse_Cursor( .T. )
      ENDIF

      IF mouse_scan = .T.  .AND. is_mouse && scanned, yet no element found
        IF mouse_stat = &jl_mouse_new
          mouse_stat = &jl_mouse_left && or whatever
        ELSE
          mouse_stat = &jl_mouse_xleft
        ENDIF

        mouse_scan = .F.
      ELSE
        mouse_stat = &jl_mouse_ignore
      ENDIF

      DO WHILE IS_KEY() = 0 .AND. mouse_stat = &jl_mouse_ignore
        IF is_mouse
          IF _mouse_Left_Button() .AND. _mouse_Right_Button()
            mrow = _mouse_Row()
            mcol = _mouse_Col()
            mouse_stat = &jl_mouse_both
          ELSE
            IF ml
              IF .NOT. _mouse_Left_Button()   && find release point
                ml = .F.
                mrow = _mouse_Row()
                mcol = _mouse_Col()
                IF mrow = current_row .AND.;
                    ( ( mcol >= current_col ) .AND.;
                    ( mcol < ( current_col+LEN( temp_str ) ) ) )
                  mouse_stat = &jl_mouse_xselect
                ELSE
                  mouse_stat = &jl_mouse_xnew
                ENDIF
 
              ENDIF
 
            ENDIF

            IF _mouse_Left_Button()
              ml = .T.
              mrow = _mouse_Row()
              mcol = _mouse_Col()
              IF mrow = current_row .AND.;
                  ( ( mcol >= current_col ) .AND.;
                    ( mcol < ( current_col+LEN( temp_str ) ) ) )
                mouse_stat = &jl_mouse_select
              ELSE
                mouse_stat = &jl_mouse_new
              ENDIF
 
            ENDIF

            IF mr
              IF .NOT. _mouse_Right_Button()
                mr = .F.
                mrow = _mouse_Row()
                mcol = _mouse_Col()
                mouse_stat = &jl_mouse_xright
              ENDIF
 
            ELSE
              IF _mouse_Right_Button()
                mr = .T.
                mrow = _mouse_Row()
                mcol = _mouse_Col()
                mouse_stat = &jl_mouse_right
              ENDIF
 
            ENDIF

          ENDIF

        ENDIF

      ENDDO


      IF mouse_stat = &jl_mouse_ignore
        pick_key = GET_KEY()
      ENDIF

      IF is_mouse
        _mouse_Cursor( .F. )
      ENDIF

     ENDIF



    check_element = .F.
    go_forward    = .T.

    IF display_only
      ret_val = &EXIT_DISPLAY_ONLY
      prompt_loop = .F.
      LOOP
    ELSE
      user_proc = Vlist_Call_Prompt_Handler( handler_proc,;
                                        plist,;
                                        current_element,;
                                        mouse_stat,;
                                        mrow,;
                                        mcol,;
                                        pick_key,;
                                        first_element,;
                                        last_element )
    ENDIF

    IF is_mouse
      IF user_proc = &jl_goto_mouse
        IF ( mrow = current_row ) .AND.;
             ( ( mcol >= current_col ) .AND.;
               ( mcol < ( current_col+LEN( temp_str ) ) ) )
          user_proc = &jl_ignore
        ENDIF
 
      ENDIF
 
    ENDIF

    vlist_what_color( plist, old_std )

    IF user_proc = &jl_repaint_element .OR.;
             user_proc = &jl_repaint_ignore

      temp_str = vlist_cstr( plist )
      temp_str = SUBSTR( temp_str, AT( "|", temp_str )+1, 254 )

      IF user_proc = &jl_repaint_ignore
        user_proc = &jl_ignore
      ELSE
        user_proc = &jl_continue
      ENDIF

    ENDIF

    IF user_proc <> &jl_ignore .AND. user_proc <> &jl_select


      temp_stat = vlist_cget_status( plist )
      IF allow_embeded .AND. temp_stat = &jl_normal
        IF temp_stat <> &jl_normal
          old_hs = __color_hi_std
          __color_hi_std = __color_std
        ENDIF
        Embedded_say( current_row, current_col, 0, temp_str, .F. )
        IF temp_stat <> &jl_normal
          __color_hi_std = old_hs
        ENDIF
      ELSE
        @current_row, current_col SAY temp_str
      ENDIF
 
    ENDIF

    IF is_mouse
      _mouse_Cursor( .T. )
      IF user_proc = &jl_goto_mouse
        mouse_scan = .T.
        rescan = .T.
        LOOP
      ENDIF

    ENDIF


    IF user_proc = &jl_paint_key
      rescan = .T.
      user_proc = &jl_continue
    ENDIF

    DO CASE
      CASE user_proc = &jl_continue    && evaluate keystroke
        DO CASE
          CASE pick_key = &k_esc
            ret_val = &EXIT_ESC
            prompt_loop = .F.
            LOOP

          CASE pick_key = &k_enter
            IF vlist_cget_status( plist ) <> &jl_hit
              ret_val = &EXIT_SELECT
              prompt_loop = .F.
              LOOP
            ENDIF

          CASE pick_key = &k_home .OR. pick_key = &k_pg_up .OR.;
                 pick_key = &k_c_pg_up
            current_element = first_element
            check_element = .T.
            go_forward    = .T.

          CASE pick_key = &k_end .OR. pick_key = &k_pg_down .OR.;
                 pick_key = &k_c_pg_down
            current_element = last_element
            check_element = .T.
            go_forward    = .F.

          CASE pick_key = &k_down  .OR. pick_key = &k_right
            IF current_element = last_element
              current_element = first_element
            ELSE
              current_element = current_element + 1
            ENDIF
 
            check_element = .T.
            go_forward    = .T.

          CASE pick_key = &k_up .OR. pick_key = &k_left
            IF current_element = first_element
              current_element = last_element
            ELSE
              current_element = current_element - 1
            ENDIF
 
            check_element = .T.
            go_forward    = .F.

        ENDCASE

        IF check_element
          check_element = .F.
          move_marker = .T.
          rescan = .T.

          vlist_goto( plist, current_element )

          temp_stat = vlist_cget_status( plist )
          IF temp_stat = &jl_skip .OR. temp_stat = &jl_hide
            IF go_forward
              temp_loop = current_element

              REPEAT
                vlist_skip( plist, &jl_forward )
                IF ( vlist_number( plist ) > last_element ) .OR.;
                     ( vlist_bol( plist ) )
                  vlist_goto( plist, first_element )
                ENDIF
 
                temp_stat = vlist_cget_status( plist )
                IF temp_stat = &jl_skip .OR. temp_stat = &jl_hide
                  LOOP
                ELSE
                  EXIT
                ENDIF
 
              UNTIL temp_loop = vlist_number( plist )

              current_element = vlist_number( plist )

            ELSE
              temp_loop = current_element

              REPEAT
                vlist_skip( plist, &jl_backward )
                IF ( vlist_number( plist ) < first_element ) .OR.;
                     ( vlist_tol( plist ) )
                  vlist_goto( plist, last_element )
                ENDIF
 
                temp_stat = vlist_cget_status( plist )
                IF temp_stat = &jl_skip .OR. temp_stat = &jl_hide
                  LOOP
                ELSE
                  EXIT
                ENDIF
 
              UNTIL temp_loop = vlist_number( plist )

              current_element = vlist_number( plist )


            ENDIF
 
          ENDIF

        ENDIF

      CASE user_proc = &jl_ignore
      CASE user_proc = &jl_repaint
        rescan = .T.
      CASE user_proc = &jl_select
        temp_stat = vlist_cget_status( plist )
        IF temp_stat <> &jl_hit .AND.;
                 temp_stat <> &jl_skip .AND.;
                 temp_stat <> &jl_hide
          ret_val = &EXIT_SELECT
          prompt_loop = .F.
          LOOP
        ENDIF

      CASE user_proc = &jl_abort

        ret_val = &EXIT_ABORT
        prompt_loop = .F.
        LOOP
    ENDCASE

  ENDDO

  IF is_mouse .AND. ( .NOT. display_only )
    _mouse_Cursor( .F. )
  ENDIF

  __color_std   = old_std
  __color_enhcd = old_enhcd
  __color_hi_std = old_hi_std
  __color_hi_enhcd = old_hi_enhcd

  temp_str = vlist_cstr( plist )
  temp_str = SUBSTR( temp_str, AT( ".", temp_str )+1, 254 )
  temp_str = LEFT( temp_str, AT( "@", temp_str ) - 1 )
  first  = VAL( ALLTRIM( temp_str ) )

  RETURN ret_val
ENDPRO

FUNCTION INT _Manual_Prompts
  PARAMETERS VALUE LONG    plist,;
             VALUE UINT    system,;
                   UINT    first,;
                   UNTYPED handler_proc,;
             VALUE LOGICAL is_mouse,;
             VALUE LOGICAL display_only,;
             VALUE BYTE    std_color,;
             VALUE BYTE    hi_std_color,;
             VALUE BYTE    enhcd_color,;
             VALUE BYTE    hi_enhcd_color,;
             VALUE BYTE    skip_color

  VARDEF
    BYTE old_s, old_hs, old_e, old_he, old_skip, old_hit, old_tab, old_bar,;
         hit_color
    INT ret_val
  ENDDEF

  hit_color = skip_color

  __Swap_Std( old_s, old_hs, old_e, old_he, std_color, hi_std_color,;
              enhcd_color, hi_enhcd_color )
  __Swap_Other( old_skip, old_hit, old_bar, old_tab,;
               skip_color, hit_color, __color_bar, __color_tab )

  ret_val = __Manual_Prompts( plist, system, first, handler_proc,;
                              is_mouse, display_only )

  __Set_Std( old_s, old_hs, old_e, old_he )
  __Set_Other( old_skip, old_hit, old_bar, old_tab )

  RETURN ret_val
ENDPRO
