****
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
****

#include warn.hdr
#include string.hdr
#include system.hdr
#include io.hdr
#include diff.hdr

FUNCTION CHAR( 128 ) Fixpath
  PARAMETERS CONST CHAR( 128 ) filespec

  VARDEF
    CHAR( 128 )      final_spec
    CHAR( 128 )      other_spec
    int back_pos
  ENDDEF

  final_spec = ALLTRIM( filespec )

  IF LEN( final_spec ) = 0
    final_spec = CHR( CURDRIVE() + 'A' ) + ":" + CURDIR( 0 )
  ELSE
    IF LEFT( final_spec, 2 ) = ".\"
      final_spec = Fixpath( "" ) + SUBSTR( final_spec, 3, LEN( final_spec )-2 )
    ELSE
      IF LEFT( final_spec, 3 )="..\"
        other_spec = ALLTRIM( Fixpath( "" ) )
        DO WHILE LEFT( final_spec, 3 ) = "..\"
          final_spec = ALLTRIM( SUBSTR( final_spec, 4, LEN( final_spec )-3 ) )
          IF LEN( other_spec )>2
            IF RIGHT( other_spec, 1 ) = "\"
              other_spec = LEFT( other_spec, LEN( other_spec )-1 )
            ENDIF

            IF RAT( "\", other_spec )>0
              other_spec = LEFT( other_spec, RAT( "\", other_spec )-1 )
            ENDIF

          ENDIF

        ENDDO

        IF RIGHT( other_spec, 1 ) <> "\"
          other_spec = other_spec + "\"
          final_spec = other_spec + final_spec
        ENDIF

      ENDIF

    ENDIF

  ENDIF

  IF .NOT. ( SUBSTR( final_spec, 2, 1 ) = ":" )
    IF SUBSTR( final_spec, 1, 1 ) = "\"
      final_spec = CHR( CURDRIVE() + 'A' ) + ":" + final_spec
    ELSE
      final_spec = CHR( CURDRIVE() + 'A' ) + ":\" + final_spec
    ENDIF

  ELSE
    IF LEN( final_spec ) = 2
      final_spec = final_spec + "\"
    ENDIF

  ENDIF

  IF .NOT. ( SUBSTR( final_spec, LEN( final_spec ), 1 ) = "\" )
    final_spec = final_spec + "\"
  ENDIF

  * now check for trailing ..\ which may occur in the case where a user runs
  * a program using ..
  back_pos = RAT( "\..", final_spec )
  DO WHILE back_pos > 0
    other_spec = LEFT( final_spec, back_pos - 1 )
    final_spec = SUBSTR( final_spec, back_pos + 3, 128 )
    IF LEN( other_spec ) > 2
      other_spec = LEFT( other_spec, RAT( "\", other_spec ) - 1 )
    ENDIF
    final_spec = other_spec + final_spec
    back_pos = RAT( "\..", final_spec )
  ENDDO

  back_pos = RAT( "\.\", final_spec )
  DO WHILE back_pos > 0
    other_spec = LEFT( final_spec, back_pos - 1 )
    final_spec = SUBSTR( final_spec, back_pos + 2, 128 )
    final_spec = other_spec + final_spec
    back_pos = RAT( "\.\", final_spec )
  ENDDO

  final_spec = ALLTRIM( final_spec )

  RETURN final_spec
ENDPRO
