****
**** RESTlib public domain release March 1, 1995 (Jayson R. Minard)
****
**** ---- --- These comments may not be removed! --- ----
****
**** original RESTlib (c) 1993-95 Jayson R. Minard
****                          CIS 72124,2343
****                         iNET jayson@jerm.com
****
****
**** This code may be used for any purpose as long as credit for the
**** originating code is given back to Jayson Minard within the resulting
**** product or its documentation.
****

#INCLUDE WARN.HDR
#INCLUDE STRING.HDR
#INCLUDE SYSTEM.HDR
#INCLUDE IO.HDR
#INCLUDE FILEIO.HDR
#INCLUDE COLORS.HDR
#DEFINE _INTERNAL_
#include restmisc.hdr
#include restlist.hdr


FUNCTION CHAR One_Fpick
  PARAMETERS VALUE UINT ur,;
             VALUE UINT uc,;
             VALUE UINT lr,;
             VALUE UINT lc,;
             VALUE UINT scroll_col,;
             VALUE UINT status_row,;
             VALUE UINT status_col,;
             VALUE UINT status_width,;
             VALUE BYTE dir_color,;
             CONST CHAR start_path,;
             CONST CHAR start_mask,;
             VALUE LOGICAL leave_dir,;
             VALUE LOGICAL is_mouse,;
             VALUE LOGICAL display_dirname,;
             VALUE BYTE std_color,;
             VALUE BYTE enhcd_color,;
             VALUE BYTE skip_color,;
             VALUE BYTE bar_color,;
             VALUE BYTE tab_color,;
             VALUE BYTE status_color

  VARDEF
    CHAR( 128 )    dir_path
    CHAR( 80 )     show_path
    CHAR( 40 )     dir_mask
    UINT           columns, marker, topp
    LOGICAL        keep_going, is_dir
    LONG           dir_list
    CHAR           ret
    CHAR( 20 )     temp_name
    BYTE           old_cs, hit_color
    INT            ret_val
  ENDDEF

  hit_color = skip_color

  columns = ( lc - uc + 1 + 2 ) / 16
  IF columns = 0
    columns = 1
  ENDIF
 
  dir_mask = ALLTRIM( start_mask )

  keep_going = .T.
  ret = "*"

  dir_path = start_path

  SAVE_AREA( status_row, status_col, status_row, ( status_col + status_width - 1 ) )

  DO WHILE keep_going
    dir_path  = FixPath( dir_path )
    show_path = ALLTRIM( ShortPath( status_width - 3, dir_path ) ) + "\"
    show_path = LEFT( show_path, status_width - 2 )

    old_cs = __color_std
    __color_std = status_color

    RESTORE_AREA()
    SAVE_AREA( status_row, status_col, status_row, ( status_col + status_width - 1 ) )
    @ status_row, status_col SAY " reading... "
    __color_std = old_cs

    dir_list = VLIST_INIT( 18 )
    IF dir_list = 0
      RESTORE_AREA()
      RETURN "-"
    ENDIF

    IF .NOT. FIND_FIRST( dir_path + start_mask, 0x30 )
      keep_going = .F.
      Vlist_Clear( dir_list )
      LOOP
    ENDIF

    REPEAT
      temp_name = ALLTRIM( FIND_FSTR() )
      IF temp_name = ".\"
        LOOP
      ENDIF

      IF AT( "\", temp_name ) > 0
        temp_name = LEFT( temp_name, RAT( "\", temp_name ) - 1 )
        is_dir = .T.
      ELSE
        is_dir = .F.
      ENDIF

      marker = AT( ".", temp_name )
      IF marker = 0 .OR. temp_name = ".."
        temp_name = temp_name + SPACE( 12 - LEN( temp_name ) )
      ELSE
        temp_name = LEFT( temp_name, marker - 1 ) +;
                    SPACE( 9 - marker + 1 ) +;
                    SUBSTR( temp_name, marker + 1, 3 )
        temp_name = temp_name + SPACE( 12 - LEN( temp_name ) )
      ENDIF

      IF is_dir
        temp_name = "  " + temp_name + " "
        IF leave_dir
          IF .NOT. VList_Append( dir_list, &jl_normal, dir_color, temp_name )
            Vlist_Clear( dir_list )
            RESTORE_AREA()
            RETURN "-"
          ENDIF
 
        ELSE
          IF .NOT. VList_Append( dir_list, &jl_skip, dir_color, temp_name )
            Vlist_Clear( dir_list )
            RESTORE_AREA()
            RETURN "-"
          ENDIF

        ENDIF
 
      ELSE
        temp_name = "A " + temp_name + "  "
        IF .NOT. VList_Add( dir_list, temp_name )
          Vlist_Clear( dir_list )
          RESTORE_AREA()
          RETURN "-"
        ENDIF
 
      ENDIF

    UNTIL .NOT. FIND_NEXT()

    old_cs = __color_std
    __color_std = status_color

    RESTORE_AREA()
    SAVE_AREA( status_row, status_col, status_row, ( status_col + status_width - 1 ) )

    @ status_row, status_col SAY " sorting... "
    Vlist_Sort( dir_list, 0, 0 )

    RESTORE_AREA()
    SAVE_AREA( status_row, status_col, status_row, ( status_col + status_width - 1 ) )
    __color_std = old_cs

    IF display_dirname
      old_cs = __color_std
      __color_std = status_color
      @ status_row, status_col SAY " " + show_path + " "
      __color_std = old_cs
    ENDIF

    marker = 1
    topp   = 1

    @ ur, uc CLEAR TO lr, lc
    ret_val = Vlist_Pick( dir_list, ur, uc, lr, lc, scroll_col, topp, marker,;
                         0, 0, 2, 15, columns, 2,;
                         Default_Key_Handler,;
                         .F., .T., .F., is_mouse, .F.,;
                         std_color, std_color,;
                         enhcd_color, enhcd_color,;
                         skip_color, hit_color, bar_color, tab_color )

    IF ret_val = &EXIT_ESC
      ret = "*"
      keep_going = .F.
      Vlist_Clear( dir_list )
      LOOP
    ELSE
      IF ret_val = &EXIT_ERROR
        ret = "-"
        keep_going = .F.
        VList_Clear( dir_List )
        LOOP
      ENDIF
    ENDIF

    temp_name = VList_CStr( dir_list )
    temp_name = SUBSTR( temp_name, 2, 25 )

    IF AT( "", temp_name ) = 0
      ret = temp_name
      keep_going = .F.
      Vlist_Clear( dir_list )
      LOOP
    ELSE
      Vlist_Clear( dir_list )
      IF ALLTRIM( LEFT( temp_name, 13 ) ) = ".."
        dir_path = LEFT( dir_path, LEN( dir_path ) - 1 )
        dir_path = LEFT( dir_path, RAT( "\", dir_path ) )
      ELSE
        dir_path = dir_path + ALLTRIM( LEFT( temp_name, 9 ) ) + "." +;
                              ALLTRIM( SUBSTR( temp_name, 11, 3 ) )
        IF RIGHT( dir_path,  1 ) = "."
          dir_path = LEFT( dir_path, LEN( dir_path ) - 1 )
        ENDIF
 
      ENDIF
 
    ENDIF
 
  ENDDO

  IF ret <> "*"
    ret = dir_path + ALLTRIM( LEFT( ret, 9 ) ) + "." +;
                     ALLTRIM( SUBSTR( ret, 11, 3 ) )
  ENDIF

  ret = ALLTRIM( ret )

  RESTORE_AREA()
  RETURN ret
ENDPRO
